
use strict;
use warnings;
use Text::Template;

my $string = <<'END';
#!perl -w
# This file was automatically generated by Dist::Zilla::Plugin::AuthorSignatureTest

use strict;
use warnings;
use Test::More;

unless (eval { require Test::Signature; 1 }) {
    plan skip_all => 'Test::Signature is required for this test';
}

Test::Signature::signature_{{ $force }}ok();
done_testing;
END


my $value;
my %vars = (
  force =>  $value ? q{force_} : q{},
);

my $tmpl = Text::Template->new(
    TYPE       => 'STRING',
    SOURCE     => $string,
    DELIMITERS => [ qw( {{ }} ) ],
);

my $content = $tmpl->fill_in(HASH => \%vars);

print $content;


