package Shipment::UPS::WSDL::TrackTypes::ShipmentAddressType;
$Shipment::UPS::WSDL::TrackTypes::ShipmentAddressType::VERSION = '3.11';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Type_of    : ATTR(:get<Type>);
    my %Address_of : ATTR(:get<Address>);

    __PACKAGE__->_factory(
        [   qw(        Type
              Address

            )
        ],
        {   'Type'    => \%Type_of,
            'Address' => \%Address_of,
        },
        {   'Type' =>
              'Shipment::UPS::WSDL::TrackTypes::CommonCodeDescriptionType',
            'Address' => 'Shipment::UPS::WSDL::TrackTypes::AddressType',
        },
        {

            'Type'    => 'Type',
            'Address' => 'Address',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::ShipmentAddressType

=head1 VERSION

version 3.11

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ShipmentAddressType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type

=item * Address

=back

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::ShipmentAddressType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::TrackTypes::ShipmentAddressType
   Type =>  { # Shipment::UPS::WSDL::TrackTypes::CommonCodeDescriptionType
     Code =>  $some_value, # string
     Description =>  $some_value, # string
   },
   Address =>  { # Shipment::UPS::WSDL::TrackTypes::AddressType
     AddressLine =>  $some_value, # string
     City =>  $some_value, # string
     StateProvinceCode =>  $some_value, # string
     PostalCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
