/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* string.c
**/

#include <string.h>
#include <stdio.h>

#include "pfile.h"
#include "range.h"

static void *Int2String (int *value, char *copy);
static void *Bool2String (int *value, char *copy);
static void *Real2String (real * value, char *copy);

static Converter Converters[] = {
  {ModeType, StringType, (ConverterType) Mode2String},
  {IntegerType, StringType, (ConverterType) Int2String},
  {RealType, StringType, (ConverterType) Real2String},
  {BooleanType, StringType, (ConverterType) Bool2String},
  {StringType, StringType, (ConverterType) StringCopy},
  {PSetType, StringType, (ConverterType) StringCopy},
  {RangeType, StringType, (ConverterType) Range2String},
  {StructType, StringType, (ConverterType) StringCopy},
  {FileType, StringType, (ConverterType) StringCopy},
  {GType, StringType, (ConverterType) StringCopy},
  {0, 0, 0}
};

vtype stringRec = {
  "s", Converters, SSSize, VXAcce, (vtype_compar_func) SSComp
};

void *
Mode2String (int *value, char *copy)
{
  char *m = copy;

  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  if (*value & AMODE)
    *m++ = 'a';
  if (*value & HMODE)
    *m++ = 'h';
  if (*value & QMODE)
    *m++ = 'q';
  if (*value & LMODE)
    *m++ = 'l';

  *m = '\0';

  return copy;
}


static void *
Int2String (int *value, char *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  if (*value == INDEFI)
    strcpy (copy, "INDEF");
  else
    sprintf (copy, "%d", *value);

  return copy;
}



static void *
Real2String (real * value, char *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  if (*value == INDEFD)
    strcpy (copy, "INDEF");
  else
    sprintf (copy, "%.16g", *value);

  return copy;
}



static void *
Bool2String (int *value, char *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  strcpy (copy, *value ? "yes" : "no");

  return copy;
}


void *
StringCopy (char *value, char *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  strcpy (copy, value);

  return copy;
}

int
SSSize (void *str)
{
  return strlen ((char *) str) + 1;
}


int
SSComp (char *value1, char *value2, int type)
{
  int compare;

  while (*value1 == ' ')
    value1++;
  while (*value2 == ' ')
    value2++;

  compare = strcmp ((char *) value1, (char *) value2);

  if (value2 && !*((char *) value2))
    return 1;

  switch (type)
    {
    case PRange_EQ:
      return compare == 0;
    case PRange_NE:
      return compare != 0;
    case PRange_GT:
      return compare > 0;
    case PRange_GE:
      return compare == 0 || compare > 0;
    case PRange_LT:
      return compare < 0;
    case PRange_LE:
      return compare == 0 || compare < 0;
    default:
      return 0;
    }
}
