# Generated by default/object.tt
package Paws::CognitoIdp::TokenValidityUnitsType;
  use Moose;
  has AccessToken => (is => 'ro', isa => 'Str');
  has IdToken => (is => 'ro', isa => 'Str');
  has RefreshToken => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CognitoIdp::TokenValidityUnitsType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CognitoIdp::TokenValidityUnitsType object:

  $service_obj->Method(Att1 => { AccessToken => $value, ..., RefreshToken => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CognitoIdp::TokenValidityUnitsType object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessToken

=head1 DESCRIPTION

The data type for TokenValidityUnits that specifics the time
measurements for token validity.

=head1 ATTRIBUTES


=head2 AccessToken => Str

A time unit in E<ldquo>secondsE<rdquo>, E<ldquo>minutesE<rdquo>,
E<ldquo>hoursE<rdquo> or E<ldquo>daysE<rdquo> for the value in
AccessTokenValidity, defaults to hours.


=head2 IdToken => Str

A time unit in E<ldquo>secondsE<rdquo>, E<ldquo>minutesE<rdquo>,
E<ldquo>hoursE<rdquo> or E<ldquo>daysE<rdquo> for the value in
IdTokenValidity, defaults to hours.


=head2 RefreshToken => Str

A time unit in E<ldquo>secondsE<rdquo>, E<ldquo>minutesE<rdquo>,
E<ldquo>hoursE<rdquo> or E<ldquo>daysE<rdquo> for the value in
RefreshTokenValidity, defaults to days.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CognitoIdp>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

