# Generated by default/object.tt
package Paws::EMR::OnDemandCapacityReservationOptions;
  use Moose;
  has CapacityReservationPreference => (is => 'ro', isa => 'Str');
  has CapacityReservationResourceGroupArn => (is => 'ro', isa => 'Str');
  has UsageStrategy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::OnDemandCapacityReservationOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::OnDemandCapacityReservationOptions object:

  $service_obj->Method(Att1 => { CapacityReservationPreference => $value, ..., UsageStrategy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::OnDemandCapacityReservationOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->CapacityReservationPreference

=head1 DESCRIPTION

Describes the strategy for using unused Capacity Reservations for
fulfilling On-Demand capacity.

=head1 ATTRIBUTES


=head2 CapacityReservationPreference => Str

Indicates the instance's Capacity Reservation preferences. Possible
preferences include:

=over

=item *

C<open> - The instance can run in any open Capacity Reservation that
has matching attributes (instance type, platform, Availability Zone).

=item *

C<none> - The instance avoids running in a Capacity Reservation even if
one is available. The instance runs as an On-Demand Instance.

=back



=head2 CapacityReservationResourceGroupArn => Str

The ARN of the Capacity Reservation resource group in which to run the
instance.


=head2 UsageStrategy => Str

Indicates whether to use unused Capacity Reservations for fulfilling
On-Demand capacity.

If you specify C<use-capacity-reservations-first>, the fleet uses
unused Capacity Reservations to fulfill On-Demand capacity up to the
target On-Demand capacity. If multiple instance pools have unused
Capacity Reservations, the On-Demand allocation strategy
(C<lowest-price>) is applied. If the number of unused Capacity
Reservations is less than the On-Demand target capacity, the remaining
On-Demand target capacity is launched according to the On-Demand
allocation strategy (C<lowest-price>).

If you do not specify a value, the fleet fulfils the On-Demand capacity
according to the chosen On-Demand allocation strategy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

