######################################################################
#
# 1269_utf8_by_utf8jp.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x80\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\xF3\xB0\x80\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\xF3\xB0\x80\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\xF3\xB0\x80\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\xF3\xB0\x80\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\xF3\xB0\x80\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\xF3\xB0\x80\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\xF3\xB0\x80\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\xF3\xB0\x80\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\xF3\xB0\x80\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\xF3\xB0\x80\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\xF3\xB0\x80\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\xF3\xB0\x80\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\xF3\xB0\x80\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\xF3\xB0\x80\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\xF3\xB0\x80\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\xF3\xB0\x80\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\xF3\xB0\x80\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\xF3\xB0\x80\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\xF3\xB0\x80\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\xF3\xB0\x80\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\xF3\xB0\x80\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\xF3\xB0\x80\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\xF3\xB0\x80\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\xF3\xB0\x80\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\xF3\xB0\x80\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\xF3\xB0\x80\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\xF3\xB0\x80\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\xF3\xB0\x80\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\xF3\xB0\x80\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\xF3\xB0\x80\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\xF3\xB0\x80\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\xF3\xB0\x80\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\xF3\xB0\x80\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\xF3\xB0\x80\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\xF3\xB0\x80\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\xF3\xB0\x80\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\xF3\xB0\x80\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\xF3\xB0\x80\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\xF3\xB0\x80\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\xF3\xB0\x80\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\xF3\xB0\x80\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\xF3\xB0\x80\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\xF3\xB0\x80\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\xF3\xB0\x80\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\xF3\xB0\x80\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\xF3\xB0\x80\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\xF3\xB0\x80\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\xF3\xB0\x80\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\xF3\xB0\x80\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\xF3\xB0\x80\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\xF3\xB0\x80\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\xF3\xB0\x80\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\xF3\xB0\x80\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\xF3\xB0\x80\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\xF3\xB0\x80\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\xF3\xB0\x80\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\xF3\xB0\x80\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\xF3\xB0\x80\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\xF3\xB0\x80\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\xF3\xB0\x80\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\xF3\xB0\x80\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\xF3\xB0\x80\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\xF3\xB0\x80\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\xF3\xB0\x81\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\xF3\xB0\x81\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xF3\xB0\x81\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xF3\xB0\x81\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xF3\xB0\x81\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xF3\xB0\x81\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xF3\xB0\x81\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xF3\xB0\x81\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xF3\xB0\x81\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xF3\xB0\x81\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xF3\xB0\x81\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\xF3\xB0\x81\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\xF3\xB0\x81\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\xF3\xB0\x81\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\xF3\xB0\x81\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\xF3\xB0\x81\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\xF3\xB0\x81\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\xF3\xB0\x81\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xF3\xB0\x81\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xF3\xB0\x81\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xF3\xB0\x81\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xF3\xB0\x81\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xF3\xB0\x81\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xF3\xB0\x81\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\xF3\xB0\x81\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xF3\xB0\x81\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\xF3\xB0\x81\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\xF3\xB0\x81\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\xF3\xB0\x81\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\xF3\xB0\x81\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\xF3\xB0\x81\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\xF3\xB0\x81\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\xF3\xB0\x81\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\xF3\xB0\x81\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\xF3\xB0\x81\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\xF3\xB0\x81\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\xF3\xB0\x81\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\xF3\xB0\x81\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\xF3\xB0\x81\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\xF3\xB0\x81\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\xF3\xB0\x81\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\xF3\xB0\x81\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\xF3\xB0\x81\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\xF3\xB0\x81\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\xF3\xB0\x81\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\xF3\xB0\x81\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\xF3\xB0\x81\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\xF3\xB0\x81\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\xF3\xB0\x81\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\xF3\xB0\x81\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\xF3\xB0\x81\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\xF3\xB0\x81\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\xF3\xB0\x81\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\xF3\xB0\x81\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\xF3\xB0\x81\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\xF3\xB0\x81\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\xF3\xB0\x81\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\xF3\xB0\x81\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\xF3\xB0\x81\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\xF3\xB0\x81\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\xF3\xB0\x81\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\xF3\xB0\x81\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\xF3\xB0\x81\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\xF3\xB0\x81\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F"],
        ["\xF3\xB0\x82\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x82\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA1"],
        ["\xF3\xB0\x82\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA2"],
        ["\xF3\xB0\x82\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA3"],
        ["\xF3\xB0\x82\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA4"],
        ["\xF3\xB0\x82\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA5"],
        ["\xF3\xB0\x82\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA6"],
        ["\xF3\xB0\x82\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA7"],
        ["\xF3\xB0\x82\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA8"],
        ["\xF3\xB0\x82\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA9"],
        ["\xF3\xB0\x82\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xAA"],
        ["\xF3\xB0\x82\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xAB"],
        ["\xF3\xB0\x82\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xAC"],
        ["\xF3\xB0\x82\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xAD"],
        ["\xF3\xB0\x82\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xAE"],
        ["\xF3\xB0\x82\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xAF"],
        ["\xF3\xB0\x82\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB0"],
        ["\xF3\xB0\x82\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB1"],
        ["\xF3\xB0\x82\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB2"],
        ["\xF3\xB0\x82\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB3"],
        ["\xF3\xB0\x82\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB4"],
        ["\xF3\xB0\x82\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB5"],
        ["\xF3\xB0\x82\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB6"],
        ["\xF3\xB0\x82\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB7"],
        ["\xF3\xB0\x82\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB8"],
        ["\xF3\xB0\x82\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xB9"],
        ["\xF3\xB0\x82\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xBA"],
        ["\xF3\xB0\x82\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xBB"],
        ["\xF3\xB0\x82\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xBC"],
        ["\xF3\xB0\x82\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xBD"],
        ["\xF3\xB0\x82\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xBE"],
        ["\xF3\xB0\x82\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xBF"],
        ["\xF3\xB0\x83\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x80"],
        ["\xF3\xB0\x83\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x81"],
        ["\xF3\xB0\x83\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x82"],
        ["\xF3\xB0\x83\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x83"],
        ["\xF3\xB0\x83\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x84"],
        ["\xF3\xB0\x83\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x85"],
        ["\xF3\xB0\x83\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x86"],
        ["\xF3\xB0\x83\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x87"],
        ["\xF3\xB0\x83\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x88"],
        ["\xF3\xB0\x83\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x89"],
        ["\xF3\xB0\x83\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x8A"],
        ["\xF3\xB0\x83\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x8B"],
        ["\xF3\xB0\x83\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x8C"],
        ["\xF3\xB0\x83\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x8D"],
        ["\xF3\xB0\x83\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x8E"],
        ["\xF3\xB0\x83\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x8F"],
        ["\xF3\xB0\x83\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x90"],
        ["\xF3\xB0\x83\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x91"],
        ["\xF3\xB0\x83\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x92"],
        ["\xF3\xB0\x83\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x93"],
        ["\xF3\xB0\x83\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x94"],
        ["\xF3\xB0\x83\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x95"],
        ["\xF3\xB0\x83\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x96"],
        ["\xF3\xB0\x83\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x97"],
        ["\xF3\xB0\x83\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x98"],
        ["\xF3\xB0\x83\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x99"],
        ["\xF3\xB0\x83\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x9A"],
        ["\xF3\xB0\x83\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x9B"],
        ["\xF3\xB0\x83\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x9C"],
        ["\xF3\xB0\x83\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x9D"],
        ["\xF3\xB0\x83\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x9E"],
        ["\xF3\xB0\x83\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE\x9F"],
        ["\xF3\xB0\x83\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x83\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x84\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],
        ["\xF3\xB0\x84\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],
        ["\xF3\xB0\x84\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],
        ["\xF3\xB0\x84\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],
        ["\xF3\xB0\x84\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],
        ["\xF3\xB0\x84\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],
        ["\xF3\xB0\x84\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],
        ["\xF3\xB0\x84\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],
        ["\xF3\xB0\x84\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],
        ["\xF3\xB0\x84\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],
        ["\xF3\xB0\x84\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],
        ["\xF3\xB0\x84\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],
        ["\xF3\xB0\x84\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xF3\xB0\x84\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],
        ["\xF3\xB0\x84\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xF3\xB0\x84\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],
        ["\xF3\xB0\x84\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],
        ["\xF3\xB0\x84\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],
        ["\xF3\xB0\x84\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],
        ["\xF3\xB0\x84\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],
        ["\xF3\xB0\x84\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],
        ["\xF3\xB0\x84\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],
        ["\xF3\xB0\x84\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],
        ["\xF3\xB0\x84\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],
        ["\xF3\xB0\x84\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],
        ["\xF3\xB0\x84\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],
        ["\xF3\xB0\x84\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],
        ["\xF3\xB0\x84\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],
        ["\xF3\xB0\x84\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],
        ["\xF3\xB0\x84\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],
        ["\xF3\xB0\x84\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],
        ["\xF3\xB0\x84\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],
        ["\xF3\xB0\x84\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],
        ["\xF3\xB0\x84\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],
        ["\xF3\xB0\x84\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],
        ["\xF3\xB0\x84\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],
        ["\xF3\xB0\x84\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],
        ["\xF3\xB0\x84\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],
        ["\xF3\xB0\x84\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],
        ["\xF3\xB0\x84\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],
        ["\xF3\xB0\x84\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],
        ["\xF3\xB0\x84\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],
        ["\xF3\xB0\x84\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],
        ["\xF3\xB0\x84\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],
        ["\xF3\xB0\x84\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],
        ["\xF3\xB0\x84\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],
        ["\xF3\xB0\x84\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],
        ["\xF3\xB0\x84\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],
        ["\xF3\xB0\x84\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],
        ["\xF3\xB0\x84\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],
        ["\xF3\xB0\x84\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],
        ["\xF3\xB0\x84\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],
        ["\xF3\xB0\x84\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],
        ["\xF3\xB0\x84\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],
        ["\xF3\xB0\x84\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],
        ["\xF3\xB0\x84\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],
        ["\xF3\xB0\x84\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],
        ["\xF3\xB0\x84\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],
        ["\xF3\xB0\x84\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],
        ["\xF3\xB0\x84\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],
        ["\xF3\xB0\x84\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],
        ["\xF3\xB0\x84\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xF3\xB0\x84\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],
        ["\xF3\xB0\x84\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xF3\xB0\x85\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],
        ["\xF3\xB0\x85\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],
        ["\xF3\xB0\x85\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],
        ["\xF3\xB0\x85\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],
        ["\xF3\xB0\x85\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],
        ["\xF3\xB0\x85\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],
        ["\xF3\xB0\x85\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],
        ["\xF3\xB0\x85\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],
        ["\xF3\xB0\x85\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],
        ["\xF3\xB0\x85\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],
        ["\xF3\xB0\x85\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xF3\xB0\x85\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],
        ["\xF3\xB0\x85\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],
        ["\xF3\xB0\x85\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],
        ["\xF3\xB0\x85\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],
        ["\xF3\xB0\x85\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],
        ["\xF3\xB0\x85\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],
        ["\xF3\xB0\x85\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],
        ["\xF3\xB0\x85\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],
        ["\xF3\xB0\x85\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],
        ["\xF3\xB0\x85\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],
        ["\xF3\xB0\x85\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],
        ["\xF3\xB0\x85\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],
        ["\xF3\xB0\x85\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xF3\xB0\x85\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],
        ["\xF3\xB0\x85\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],
        ["\xF3\xB0\x85\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],
        ["\xF3\xB0\x85\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],
        ["\xF3\xB0\x85\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],
        ["\xF3\xB0\x85\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],
        ["\xF3\xB0\x85\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],
        ["\xF3\xB0\x85\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],
        ["\xF3\xB0\x85\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],
        ["\xF3\xB0\x85\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],
        ["\xF3\xB0\x85\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],
        ["\xF3\xB0\x85\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],
        ["\xF3\xB0\x85\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],
        ["\xF3\xB0\x85\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],
        ["\xF3\xB0\x85\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],
        ["\xF3\xB0\x85\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],
        ["\xF3\xB0\x85\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],
        ["\xF3\xB0\x85\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],
        ["\xF3\xB0\x85\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],
        ["\xF3\xB0\x85\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xF3\xB0\x85\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],
        ["\xF3\xB0\x85\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],
        ["\xF3\xB0\x85\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],
        ["\xF3\xB0\x85\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],
        ["\xF3\xB0\x85\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],
        ["\xF3\xB0\x85\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],
        ["\xF3\xB0\x85\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],
        ["\xF3\xB0\x85\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],
        ["\xF3\xB0\x86\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],
        ["\xF3\xB0\x86\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],
        ["\xF3\xB0\x86\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],
        ["\xF3\xB0\x86\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],
        ["\xF3\xB0\x86\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],
        ["\xF3\xB0\x86\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],
        ["\xF3\xB0\x86\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],
        ["\xF3\xB0\x86\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],
        ["\xF3\xB0\x86\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],
        ["\xF3\xB0\x86\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],
        ["\xF3\xB0\x86\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],
        ["\xF3\xB0\x86\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],
        ["\xF3\xB0\x86\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],
        ["\xF3\xB0\x86\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],
        ["\xF3\xB0\x86\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],
        ["\xF3\xB0\x86\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],
        ["\xF3\xB0\x86\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],
        ["\xF3\xB0\x86\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],
        ["\xF3\xB0\x86\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],
        ["\xF3\xB0\x86\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],
        ["\xF3\xB0\x86\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],
        ["\xF3\xB0\x86\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],
        ["\xF3\xB0\x86\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],
        ["\xF3\xB0\x86\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],
        ["\xF3\xB0\x86\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],
        ["\xF3\xB0\x86\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],
        ["\xF3\xB0\x86\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],
        ["\xF3\xB0\x86\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],
        ["\xF3\xB0\x86\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],
        ["\xF3\xB0\x86\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xF3\xB0\x86\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],
        ["\xF3\xB0\x87\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],
        ["\xF3\xB0\x87\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],
        ["\xF3\xB0\x87\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],
        ["\xF3\xB0\x87\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],
        ["\xF3\xB0\x87\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],
        ["\xF3\xB0\x87\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],
        ["\xF3\xB0\x87\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],
        ["\xF3\xB0\x87\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],
        ["\xF3\xB0\x87\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],
        ["\xF3\xB0\x87\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],
        ["\xF3\xB0\x87\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],
        ["\xF3\xB0\x87\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],
        ["\xF3\xB0\x87\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],
        ["\xF3\xB0\x87\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],
        ["\xF3\xB0\x87\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],
        ["\xF3\xB0\x87\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],
        ["\xF3\xB0\x87\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],
        ["\xF3\xB0\x87\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],
        ["\xF3\xB0\x87\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],
        ["\xF3\xB0\x87\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],
        ["\xF3\xB0\x87\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],
        ["\xF3\xB0\x87\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],
        ["\xF3\xB0\x87\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],
        ["\xF3\xB0\x87\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],
        ["\xF3\xB0\x87\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],
        ["\xF3\xB0\x87\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],
        ["\xF3\xB0\x87\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],
        ["\xF3\xB0\x87\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],
        ["\xF3\xB0\x87\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],
        ["\xF3\xB0\x87\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],
        ["\xF3\xB0\x87\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],
        ["\xF3\xB0\x87\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],
        ["\xF3\xB0\x87\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],
        ["\xF3\xB0\x87\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],
        ["\xF3\xB0\x87\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],
        ["\xF3\xB0\x87\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],
        ["\xF3\xB0\x87\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],
        ["\xF3\xB0\x87\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],
        ["\xF3\xB0\x87\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],
        ["\xF3\xB0\x87\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],
        ["\xF3\xB0\x88\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],
        ["\xF3\xB0\x88\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],
        ["\xF3\xB0\x88\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],
        ["\xF3\xB0\x88\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],
        ["\xF3\xB0\x88\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],
        ["\xF3\xB0\x88\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],
        ["\xF3\xB0\x88\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],
        ["\xF3\xB0\x88\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],
        ["\xF3\xB0\x88\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],
        ["\xF3\xB0\x88\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],
        ["\xF3\xB0\x88\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],
        ["\xF3\xB0\x88\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],
        ["\xF3\xB0\x88\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],
        ["\xF3\xB0\x88\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],
        ["\xF3\xB0\x88\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],
        ["\xF3\xB0\x88\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],
        ["\xF3\xB0\x88\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],
        ["\xF3\xB0\x88\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],
        ["\xF3\xB0\x88\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],
        ["\xF3\xB0\x88\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],
        ["\xF3\xB0\x88\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],
        ["\xF3\xB0\x88\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],
        ["\xF3\xB0\x88\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],
        ["\xF3\xB0\x88\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],
        ["\xF3\xB0\x88\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],
        ["\xF3\xB0\x88\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],
        ["\xF3\xB0\x88\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],
        ["\xF3\xB0\x88\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],
        ["\xF3\xB0\x88\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],
        ["\xF3\xB0\x88\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],
        ["\xF3\xB0\x88\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],
        ["\xF3\xB0\x88\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],
        ["\xF3\xB0\x88\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],
        ["\xF3\xB0\x88\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],
        ["\xF3\xB0\x88\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],
        ["\xF3\xB0\x88\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],
        ["\xF3\xB0\x88\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],
        ["\xF3\xB0\x88\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],
        ["\xF3\xB0\x88\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],
        ["\xF3\xB0\x88\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],
        ["\xF3\xB0\x88\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],
        ["\xF3\xB0\x88\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],
        ["\xF3\xB0\x88\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],
        ["\xF3\xB0\x88\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],
        ["\xF3\xB0\x88\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],
        ["\xF3\xB0\x88\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],
        ["\xF3\xB0\x88\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],
        ["\xF3\xB0\x88\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],
        ["\xF3\xB0\x88\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],
        ["\xF3\xB0\x88\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],
        ["\xF3\xB0\x88\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],
        ["\xF3\xB0\x88\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],
        ["\xF3\xB0\x88\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],
        ["\xF3\xB0\x88\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],
        ["\xF3\xB0\x88\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],
        ["\xF3\xB0\x88\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],
        ["\xF3\xB0\x88\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],
        ["\xF3\xB0\x88\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],
        ["\xF3\xB0\x88\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],
        ["\xF3\xB0\x88\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],
        ["\xF3\xB0\x89\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],
        ["\xF3\xB0\x89\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],
        ["\xF3\xB0\x89\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],
        ["\xF3\xB0\x89\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],
        ["\xF3\xB0\x89\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],
        ["\xF3\xB0\x89\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],
        ["\xF3\xB0\x89\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],
        ["\xF3\xB0\x89\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],
        ["\xF3\xB0\x89\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],
        ["\xF3\xB0\x89\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],
        ["\xF3\xB0\x89\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],
        ["\xF3\xB0\x89\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],
        ["\xF3\xB0\x89\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],
        ["\xF3\xB0\x89\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],
        ["\xF3\xB0\x89\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],
        ["\xF3\xB0\x89\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],
        ["\xF3\xB0\x89\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],
        ["\xF3\xB0\x89\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],
        ["\xF3\xB0\x89\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],
        ["\xF3\xB0\x89\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],
        ["\xF3\xB0\x89\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],
        ["\xF3\xB0\x89\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],
        ["\xF3\xB0\x89\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],
        ["\xF3\xB0\x89\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],
        ["\xF3\xB0\x89\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],
        ["\xF3\xB0\x89\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],
        ["\xF3\xB0\x89\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],
        ["\xF3\xB0\x89\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],
        ["\xF3\xB0\x89\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],
        ["\xF3\xB0\x89\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],
        ["\xF3\xB0\x89\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],
        ["\xF3\xB0\x89\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],
        ["\xF3\xB0\x89\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],
        ["\xF3\xB0\x89\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],
        ["\xF3\xB0\x89\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],
        ["\xF3\xB0\x89\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],
        ["\xF3\xB0\x89\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],
        ["\xF3\xB0\x89\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],
        ["\xF3\xB0\x89\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],
        ["\xF3\xB0\x89\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],
        ["\xF3\xB0\x89\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],
        ["\xF3\xB0\x89\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],
        ["\xF3\xB0\x89\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],
        ["\xF3\xB0\x89\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],
        ["\xF3\xB0\x89\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],
        ["\xF3\xB0\x89\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],
        ["\xF3\xB0\x89\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],
        ["\xF3\xB0\x89\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],
        ["\xF3\xB0\x89\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],
        ["\xF3\xB0\x89\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],
        ["\xF3\xB0\x89\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],
        ["\xF3\xB0\x89\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],
        ["\xF3\xB0\x89\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],
        ["\xF3\xB0\x8A\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],
        ["\xF3\xB0\x8A\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],
        ["\xF3\xB0\x8A\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],
        ["\xF3\xB0\x8A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],
        ["\xF3\xB0\x8A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],
        ["\xF3\xB0\x8A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],
        ["\xF3\xB0\x8A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],
        ["\xF3\xB0\x8A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],
        ["\xF3\xB0\x8A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],
        ["\xF3\xB0\x8A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],
        ["\xF3\xB0\x8A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],
        ["\xF3\xB0\x8A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],
        ["\xF3\xB0\x8A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],
        ["\xF3\xB0\x8A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],
        ["\xF3\xB0\x8A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],
        ["\xF3\xB0\x8A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],
        ["\xF3\xB0\x8A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],
        ["\xF3\xB0\x8A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],
        ["\xF3\xB0\x8A\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],
        ["\xF3\xB0\x8A\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],
        ["\xF3\xB0\x8A\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],
        ["\xF3\xB0\x8A\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],
        ["\xF3\xB0\x8A\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],
        ["\xF3\xB0\x8A\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],
        ["\xF3\xB0\x8A\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],
        ["\xF3\xB0\x8A\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],
        ["\xF3\xB0\x8A\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],
        ["\xF3\xB0\x8A\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],
        ["\xF3\xB0\x8A\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],
        ["\xF3\xB0\x8A\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],
        ["\xF3\xB0\x8A\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],
        ["\xF3\xB0\x8A\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],
        ["\xF3\xB0\x8A\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],
        ["\xF3\xB0\x8A\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],
        ["\xF3\xB0\x8A\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],
        ["\xF3\xB0\x8A\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],
        ["\xF3\xB0\x8A\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],
        ["\xF3\xB0\x8A\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],
        ["\xF3\xB0\x8A\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],
        ["\xF3\xB0\x8A\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],
        ["\xF3\xB0\x8A\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],
        ["\xF3\xB0\x8A\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],
        ["\xF3\xB0\x8A\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],
        ["\xF3\xB0\x8A\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],
        ["\xF3\xB0\x8A\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],
        ["\xF3\xB0\x8A\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],
        ["\xF3\xB0\x8A\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],
        ["\xF3\xB0\x8A\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],
        ["\xF3\xB0\x8A\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],
        ["\xF3\xB0\x8A\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],
        ["\xF3\xB0\x8A\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],
        ["\xF3\xB0\x8A\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],
        ["\xF3\xB0\x8A\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],
        ["\xF3\xB0\x8A\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],
        ["\xF3\xB0\x8A\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],
        ["\xF3\xB0\x8A\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],
        ["\xF3\xB0\x8A\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],
        ["\xF3\xB0\x8A\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],
        ["\xF3\xB0\x8A\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],
        ["\xF3\xB0\x8A\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],
        ["\xF3\xB0\x8A\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],
        ["\xF3\xB0\x8A\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],
        ["\xF3\xB0\x8A\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],
        ["\xF3\xB0\x8A\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],
        ["\xF3\xB0\x8B\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],
        ["\xF3\xB0\x8B\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],
        ["\xF3\xB0\x8B\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],
        ["\xF3\xB0\x8B\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],
        ["\xF3\xB0\x8B\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],
        ["\xF3\xB0\x8B\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],
        ["\xF3\xB0\x8B\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],
        ["\xF3\xB0\x8B\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],
        ["\xF3\xB0\x8B\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],
        ["\xF3\xB0\x8B\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],
        ["\xF3\xB0\x8B\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],
        ["\xF3\xB0\x8B\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],
        ["\xF3\xB0\x8B\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],
        ["\xF3\xB0\x8B\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],
        ["\xF3\xB0\x8B\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],
        ["\xF3\xB0\x8B\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\xF3\xB0\x8B\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],
        ["\xF3\xB0\x8B\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],
        ["\xF3\xB0\x8B\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\xF3\xB0\x8B\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],
        ["\xF3\xB0\x8B\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],
        ["\xF3\xB0\x8B\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],
        ["\xF3\xB0\x8B\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],
        ["\xF3\xB0\x8B\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],
        ["\xF3\xB0\x8B\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],
        ["\xF3\xB0\x8B\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],
        ["\xF3\xB0\x8B\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],
        ["\xF3\xB0\x8B\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\xF3\xB0\x8B\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],
        ["\xF3\xB0\x8B\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\xF3\xB0\x8B\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xF3\xB0\x8B\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xF3\xB0\x8B\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xF3\xB0\x8B\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xF3\xB0\x8B\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xF3\xB0\x8B\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xF3\xB0\x8B\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xF3\xB0\x8B\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xF3\xB0\x8B\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xF3\xB0\x8B\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xF3\xB0\x8B\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xF3\xB0\x8B\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xF3\xB0\x8B\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xF3\xB0\x8B\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xF3\xB0\x8B\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xF3\xB0\x8B\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xF3\xB0\x8B\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xF3\xB0\x8B\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xF3\xB0\x8C\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xF3\xB0\x8C\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xF3\xB0\x8C\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xF3\xB0\x8C\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xF3\xB0\x8C\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xF3\xB0\x8C\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],
        ["\xF3\xB0\x8C\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],
        ["\xF3\xB0\x8C\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],
        ["\xF3\xB0\x8C\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],
        ["\xF3\xB0\x8C\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],
        ["\xF3\xB0\x8C\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],
        ["\xF3\xB0\x8C\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\xF3\xB0\x8C\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],
        ["\xF3\xB0\x8C\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],
        ["\xF3\xB0\x8C\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],
        ["\xF3\xB0\x8C\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],
        ["\xF3\xB0\x8C\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],
        ["\xF3\xB0\x8C\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],
        ["\xF3\xB0\x8C\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],
        ["\xF3\xB0\x8C\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],
        ["\xF3\xB0\x8C\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],
        ["\xF3\xB0\x8C\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],
        ["\xF3\xB0\x8C\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],
        ["\xF3\xB0\x8C\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],
        ["\xF3\xB0\x8C\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],
        ["\xF3\xB0\x8C\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\xF3\xB0\x8D\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],
        ["\xF3\xB0\x8D\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],
        ["\xF3\xB0\x8D\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],
        ["\xF3\xB0\x8D\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],
        ["\xF3\xB0\x8D\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\xF3\xB0\x8D\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],
        ["\xF3\xB0\x8D\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xF3\xB0\x8D\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xF3\xB0\x8D\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xF3\xB0\x8D\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xF3\xB0\x8D\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xF3\xB0\x8D\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xF3\xB0\x8D\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xF3\xB0\x8D\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xF3\xB0\x8D\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xF3\xB0\x8D\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xF3\xB0\x8D\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xF3\xB0\x8D\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xF3\xB0\x8D\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xF3\xB0\x8D\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xF3\xB0\x8D\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xF3\xB0\x8D\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xF3\xB0\x8D\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xF3\xB0\x8D\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xF3\xB0\x8D\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xF3\xB0\x8D\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xF3\xB0\x8D\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xF3\xB0\x8D\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\xF3\xB0\x8D\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xF3\xB0\x8D\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xF3\xB0\x8D\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xF3\xB0\x8D\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xF3\xB0\x8D\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xF3\xB0\x8D\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xF3\xB0\x8D\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xF3\xB0\x8D\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xF3\xB0\x8D\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xF3\xB0\x8D\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xF3\xB0\x8D\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\xF3\xB0\x8D\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],
        ["\xF3\xB0\x8D\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],
        ["\xF3\xB0\x8D\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],
        ["\xF3\xB0\x8D\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],
        ["\xF3\xB0\x8D\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],
        ["\xF3\xB0\x8D\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],
        ["\xF3\xB0\x8D\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],
        ["\xF3\xB0\x8D\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\xF3\xB0\x8D\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\xF3\xB0\x8D\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],
        ["\xF3\xB0\x8E\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\xF3\xB0\x8E\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\xF3\xB0\x8E\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],
        ["\xF3\xB0\x8E\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\xF3\xB0\x8E\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\xF3\xB0\x8E\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],
        ["\xF3\xB0\x8E\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],
        ["\xF3\xB0\x8E\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],
        ["\xF3\xB0\x8E\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],
        ["\xF3\xB0\x8E\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],
        ["\xF3\xB0\x8E\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],
        ["\xF3\xB0\x8E\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],
        ["\xF3\xB0\x8E\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],
        ["\xF3\xB0\x8E\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],
        ["\xF3\xB0\x8E\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],
        ["\xF3\xB0\x8E\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],
        ["\xF3\xB0\x8E\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],
        ["\xF3\xB0\x8E\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],
        ["\xF3\xB0\x8E\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],
        ["\xF3\xB0\x8E\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],
        ["\xF3\xB0\x8E\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],
        ["\xF3\xB0\x8E\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],
        ["\xF3\xB0\x8E\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],
        ["\xF3\xB0\x8E\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],
        ["\xF3\xB0\x8E\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],
        ["\xF3\xB0\x8E\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],
        ["\xF3\xB0\x8E\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],
        ["\xF3\xB0\x8E\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],
        ["\xF3\xB0\x8E\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],
        ["\xF3\xB0\x8E\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],
        ["\xF3\xB0\x8E\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],
        ["\xF3\xB0\x8E\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],
        ["\xF3\xB0\x8E\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],
        ["\xF3\xB0\x8E\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],
        ["\xF3\xB0\x8E\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],
        ["\xF3\xB0\x8E\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],
        ["\xF3\xB0\x8E\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],
        ["\xF3\xB0\x95\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],
        ["\xF3\xB0\x95\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],
        ["\xF3\xB0\x95\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],
        ["\xF3\xB0\x95\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],
        ["\xF3\xB0\x95\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],
        ["\xF3\xB0\x95\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],
        ["\xF3\xB0\x95\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],
        ["\xF3\xB0\x95\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],
        ["\xF3\xB0\x95\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],
        ["\xF3\xB0\x95\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],
        ["\xF3\xB0\x95\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],
        ["\xF3\xB0\x95\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],
        ["\xF3\xB0\x95\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],
        ["\xF3\xB0\x95\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],
        ["\xF3\xB0\x95\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],
        ["\xF3\xB0\x95\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],
        ["\xF3\xB0\x95\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],
        ["\xF3\xB0\x95\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],
        ["\xF3\xB0\x95\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],
        ["\xF3\xB0\x95\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],
        ["\xF3\xB0\x95\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],
        ["\xF3\xB0\x95\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],
        ["\xF3\xB0\x95\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],
        ["\xF3\xB0\x95\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],
        ["\xF3\xB0\x96\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],
        ["\xF3\xB0\x96\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],
        ["\xF3\xB0\x96\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],
        ["\xF3\xB0\x96\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],
        ["\xF3\xB0\x96\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],
        ["\xF3\xB0\x96\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],
        ["\xF3\xB0\x96\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],
        ["\xF3\xB0\x96\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],
        ["\xF3\xB0\x96\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],
        ["\xF3\xB0\x96\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],
        ["\xF3\xB0\x96\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],
        ["\xF3\xB0\x96\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],
        ["\xF3\xB0\x96\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],
        ["\xF3\xB0\x96\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],
        ["\xF3\xB0\x96\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x91"],
        ["\xF3\xB0\x96\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],
        ["\xF3\xB0\x96\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],
        ["\xF3\xB0\x96\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],
        ["\xF3\xB0\x96\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],
        ["\xF3\xB0\x96\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],
        ["\xF3\xB0\x96\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],
        ["\xF3\xB0\x96\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],
        ["\xF3\xB0\x96\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],
        ["\xF3\xB0\x96\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],
        ["\xF3\xB0\x96\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],
        ["\xF3\xB0\x96\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],
        ["\xF3\xB0\x96\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],
        ["\xF3\xB0\x96\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],
        ["\xF3\xB0\x96\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],
        ["\xF3\xB0\x96\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],
        ["\xF3\xB0\x96\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9D"],
        ["\xF3\xB0\x96\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9F"],
        ["\xF3\xB0\x96\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],
        ["\xF3\xB0\x96\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],
        ["\xF3\xB0\x96\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],
        ["\xF3\xB0\x96\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],
        ["\xF3\xB0\x96\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],
        ["\xF3\xB0\x96\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],
        ["\xF3\xB0\x96\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],
        ["\xF3\xB0\x96\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],
        ["\xF3\xB0\x96\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],
        ["\xF3\xB0\x96\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],
        ["\xF3\xB0\x96\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],
        ["\xF3\xB0\x96\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],
        ["\xF3\xB0\x96\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],
        ["\xF3\xB0\x96\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],
        ["\xF3\xB0\x96\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],
        ["\xF3\xB0\x96\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],
        ["\xF3\xB0\x96\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],
        ["\xF3\xB0\x97\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],
        ["\xF3\xB0\x9A\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],
        ["\xF3\xB0\x9A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],
        ["\xF3\xB0\x9A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],
        ["\xF3\xB0\x9A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],
        ["\xF3\xB0\x9A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],
        ["\xF3\xB0\x9A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],
        ["\xF3\xB0\x9A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],
        ["\xF3\xB0\x9A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],
        ["\xF3\xB0\x9A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],
        ["\xF3\xB0\x9A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],
        ["\xF3\xB0\x9A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],
        ["\xF3\xB0\x9A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],
        ["\xF3\xB0\x9A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],
        ["\xF3\xB0\x9A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],
        ["\xF3\xB0\x9A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],
        ["\xF3\xB0\x9A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],
        ["\xF3\xB0\x9A\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],
        ["\xF3\xB0\x9A\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],
        ["\xF3\xB0\x9A\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],
        ["\xF3\xB0\x9A\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],
        ["\xF3\xB0\x9A\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],
        ["\xF3\xB0\x9A\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],
        ["\xF3\xB0\x9A\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],
        ["\xF3\xB0\x9A\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],
        ["\xF3\xB0\x9A\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],
        ["\xF3\xB0\x9A\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],
        ["\xF3\xB0\x9A\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],
        ["\xF3\xB0\x9A\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],
        ["\xF3\xB0\x9A\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],
        ["\xF3\xB0\x9A\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],
        ["\xF3\xB0\x9A\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],
        ["\xF3\xB0\x9A\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],
        ["\xF3\xB0\x9A\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],
        ["\xF3\xB0\x9A\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],
        ["\xF3\xB0\x9A\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],
        ["\xF3\xB0\x9A\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],
        ["\xF3\xB0\x9A\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],
        ["\xF3\xB0\x9A\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],
        ["\xF3\xB0\x9A\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],
        ["\xF3\xB0\x9A\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],
        ["\xF3\xB0\x9A\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],
        ["\xF3\xB0\x9A\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],
        ["\xF3\xB0\x9A\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],
        ["\xF3\xB0\x9A\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],
        ["\xF3\xB0\x9A\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],
        ["\xF3\xB0\x9A\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],
        ["\xF3\xB0\x9A\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],
        ["\xF3\xB0\x9A\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],
        ["\xF3\xB0\x9A\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],
        ["\xF3\xB0\x9A\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],
        ["\xF3\xB0\x9A\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],
        ["\xF3\xB0\x9A\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],
        ["\xF3\xB0\x9A\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],
        ["\xF3\xB0\x9A\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],
        ["\xF3\xB0\x9A\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],
        ["\xF3\xB0\x9A\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],
        ["\xF3\xB0\x9A\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],
        ["\xF3\xB0\x9A\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],
        ["\xF3\xB0\x9A\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],
        ["\xF3\xB0\x9A\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],
        ["\xF3\xB0\x9A\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],
        ["\xF3\xB0\x9A\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],
        ["\xF3\xB0\x9B\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],
        ["\xF3\xB0\x9B\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],
        ["\xF3\xB0\x9B\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],
        ["\xF3\xB0\x9B\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],
        ["\xF3\xB0\x9B\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],
        ["\xF3\xB0\x9B\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],
        ["\xF3\xB0\x9B\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],
        ["\xF3\xB0\x9B\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],
        ["\xF3\xB0\x9B\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],
        ["\xF3\xB0\x9B\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],
        ["\xF3\xB0\x9B\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],
        ["\xF3\xB0\x9B\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],
        ["\xF3\xB0\x9B\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],
        ["\xF3\xB0\x9B\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],
        ["\xF3\xB0\x9B\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],
        ["\xF3\xB0\x9B\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],
        ["\xF3\xB0\x9B\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],
        ["\xF3\xB0\x9B\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],
        ["\xF3\xB0\x9B\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],
        ["\xF3\xB0\x9B\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],
        ["\xF3\xB0\x9B\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],
        ["\xF3\xB0\x9B\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],
        ["\xF3\xB0\x9B\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],
        ["\xF3\xB0\x9B\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],
        ["\xF3\xB0\x9B\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],
        ["\xF3\xB0\x9B\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],
        ["\xF3\xB0\x9B\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],
        ["\xF3\xB0\x9B\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],
        ["\xF3\xB0\x9B\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],
        ["\xF3\xB0\x9B\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],
        ["\xF3\xB0\x9B\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],
        ["\xF3\xB0\x9B\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],
        ["\xF3\xB0\x9B\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],
        ["\xF3\xB0\x9B\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],
        ["\xF3\xB0\x9B\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],
        ["\xF3\xB0\x9B\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],
        ["\xF3\xB0\x9B\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],
        ["\xF3\xB0\x9B\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],
        ["\xF3\xB0\x9B\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],
        ["\xF3\xB0\x9B\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],
        ["\xF3\xB0\x9B\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],
        ["\xF3\xB0\x9B\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],
        ["\xF3\xB0\x9B\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],
        ["\xF3\xB0\x9B\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],
        ["\xF3\xB0\x9B\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],
        ["\xF3\xB0\x9B\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],
        ["\xF3\xB0\x9B\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],
        ["\xF3\xB0\x9B\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],
        ["\xF3\xB0\x9B\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],
        ["\xF3\xB0\x9B\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],
        ["\xF3\xB0\x9B\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],
        ["\xF3\xB0\x9B\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],
        ["\xF3\xB0\x9B\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],
        ["\xF3\xB0\x9B\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],
        ["\xF3\xB0\x9B\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],
        ["\xF3\xB0\x9B\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],
        ["\xF3\xB0\x9B\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],
        ["\xF3\xB0\x9B\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],
        ["\xF3\xB0\x9B\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],
        ["\xF3\xB0\x9B\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],
        ["\xF3\xB0\x9B\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],
        ["\xF3\xB0\x9B\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],
        ["\xF3\xB0\x9B\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],
        ["\xF3\xB0\x9B\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],
        ["\xF3\xB0\x9C\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],
        ["\xF3\xB0\x9C\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],
        ["\xF3\xB0\x9C\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],
        ["\xF3\xB0\x9C\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],
        ["\xF3\xB0\x9C\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],
        ["\xF3\xB0\x9C\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],
        ["\xF3\xB0\x9C\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],
        ["\xF3\xB0\x9C\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],
        ["\xF3\xB0\x9C\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],
        ["\xF3\xB0\x9C\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],
        ["\xF3\xB0\x9C\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],
        ["\xF3\xB0\x9C\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],
        ["\xF3\xB0\x9C\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],
        ["\xF3\xB0\x9C\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],
        ["\xF3\xB0\x9C\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],
        ["\xF3\xB0\x9C\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],
        ["\xF3\xB0\x9C\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],
        ["\xF3\xB0\x9C\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],
        ["\xF3\xB0\x9C\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],
        ["\xF3\xB0\x9C\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],
        ["\xF3\xB0\x9C\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],
        ["\xF3\xB0\x9C\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],
        ["\xF3\xB0\x9C\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],
        ["\xF3\xB0\x9C\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],
        ["\xF3\xB0\x9C\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],
        ["\xF3\xB0\x9C\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],
        ["\xF3\xB0\x9C\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],
        ["\xF3\xB0\x9C\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],
        ["\xF3\xB0\x9C\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],
        ["\xF3\xB0\x9C\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],
        ["\xF3\xB0\x9C\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],
        ["\xF3\xB0\x9C\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],
        ["\xF3\xB0\x9C\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],
        ["\xF3\xB0\x9C\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],
        ["\xF3\xB0\x9C\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],
        ["\xF3\xB0\x9C\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],
        ["\xF3\xB0\x9C\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],
        ["\xF3\xB0\x9C\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],
        ["\xF3\xB0\x9C\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],
        ["\xF3\xB0\x9C\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],
        ["\xF3\xB0\x9C\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],
        ["\xF3\xB0\x9C\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],
        ["\xF3\xB0\x9C\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],
        ["\xF3\xB0\x9C\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],
        ["\xF3\xB0\x9C\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],
        ["\xF3\xB0\x9C\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],
        ["\xF3\xB0\x9C\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],
        ["\xF3\xB0\x9C\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],
        ["\xF3\xB0\x9C\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],
        ["\xF3\xB0\x9C\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],
        ["\xF3\xB0\x9C\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],
        ["\xF3\xB0\x9C\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],
        ["\xF3\xB0\x9C\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],
        ["\xF3\xB0\x9C\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],
        ["\xF3\xB0\x9C\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],
        ["\xF3\xB0\x9C\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],
        ["\xF3\xB0\x9C\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],
        ["\xF3\xB0\x9C\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],
        ["\xF3\xB0\x9C\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],
        ["\xF3\xB0\x9C\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],
        ["\xF3\xB0\x9C\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],
        ["\xF3\xB0\x9C\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],
        ["\xF3\xB0\x9C\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],
        ["\xF3\xB0\x9C\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],
        ["\xF3\xB0\x9D\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],
        ["\xF3\xB0\x9D\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],
        ["\xF3\xB0\x9D\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],
        ["\xF3\xB0\x9D\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],
        ["\xF3\xB0\x9D\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],
        ["\xF3\xB0\x9D\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],
        ["\xF3\xB0\x9D\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],
        ["\xF3\xB0\x9D\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],
        ["\xF3\xB0\x9D\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],
        ["\xF3\xB0\x9D\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],
        ["\xF3\xB0\x9D\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],
        ["\xF3\xB0\x9D\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],
        ["\xF3\xB0\x9D\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],
        ["\xF3\xB0\x9D\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],
        ["\xF3\xB0\x9D\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],
        ["\xF3\xB0\x9D\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],
        ["\xF3\xB0\x9D\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],
        ["\xF3\xB0\x9D\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],
        ["\xF3\xB0\x9D\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],
        ["\xF3\xB0\x9D\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],
        ["\xF3\xB0\x9D\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],
        ["\xF3\xB0\x9D\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],
        ["\xF3\xB0\x9D\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],
        ["\xF3\xB0\x9D\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],
        ["\xF3\xB0\x9D\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],
        ["\xF3\xB0\x9D\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],
        ["\xF3\xB0\x9D\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],
        ["\xF3\xB0\x9D\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],
        ["\xF3\xB0\x9D\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],
        ["\xF3\xB0\x9D\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],
        ["\xF3\xB0\x9D\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],
        ["\xF3\xB0\x9D\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],
        ["\xF3\xB0\x9D\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],
        ["\xF3\xB0\x9D\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],
        ["\xF3\xB0\x9D\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],
        ["\xF3\xB0\x9D\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],
        ["\xF3\xB0\x9D\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],
        ["\xF3\xB0\x9D\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],
        ["\xF3\xB0\x9D\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],
        ["\xF3\xB0\x9D\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],
        ["\xF3\xB0\x9D\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],
        ["\xF3\xB0\x9D\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],
        ["\xF3\xB0\x9D\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],
        ["\xF3\xB0\x9D\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],
        ["\xF3\xB0\x9D\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],
        ["\xF3\xB0\x9D\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],
        ["\xF3\xB0\x9D\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],
        ["\xF3\xB0\x9D\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],
        ["\xF3\xB0\x9D\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],
        ["\xF3\xB0\x9D\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],
        ["\xF3\xB0\x9D\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],
        ["\xF3\xB0\x9D\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],
        ["\xF3\xB0\x9D\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],
        ["\xF3\xB0\x9D\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],
        ["\xF3\xB0\x9D\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],
        ["\xF3\xB0\x9D\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],
        ["\xF3\xB0\x9D\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],
        ["\xF3\xB0\x9D\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],
        ["\xF3\xB0\x9D\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],
        ["\xF3\xB0\x9D\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],
        ["\xF3\xB0\x9D\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],
        ["\xF3\xB0\x9D\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],
        ["\xF3\xB0\x9D\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],
        ["\xF3\xB0\x9D\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],
        ["\xF3\xB0\x9E\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],
        ["\xF3\xB0\x9E\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],
        ["\xF3\xB0\x9E\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],
        ["\xF3\xB0\x9E\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],
        ["\xF3\xB0\x9E\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],
        ["\xF3\xB0\x9E\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],
        ["\xF3\xB0\x9E\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],
        ["\xF3\xB0\x9E\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],
        ["\xF3\xB0\x9E\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],
        ["\xF3\xB0\x9E\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],
        ["\xF3\xB0\x9E\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],
        ["\xF3\xB0\x9E\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],
        ["\xF3\xB0\x9E\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],
        ["\xF3\xB0\x9E\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],
        ["\xF3\xB0\x9E\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],
        ["\xF3\xB0\x9E\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],
        ["\xF3\xB0\x9E\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],
        ["\xF3\xB0\x9E\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],
        ["\xF3\xB0\x9E\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],
        ["\xF3\xB0\x9E\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],
        ["\xF3\xB0\x9E\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],
        ["\xF3\xB0\x9E\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],
        ["\xF3\xB0\x9E\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],
        ["\xF3\xB0\x9E\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],
        ["\xF3\xB0\x9E\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],
        ["\xF3\xB0\x9E\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],
        ["\xF3\xB0\x9E\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],
        ["\xF3\xB0\x9E\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],
        ["\xF3\xB0\x9E\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],
        ["\xF3\xB0\x9E\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],
        ["\xF3\xB0\x9E\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],
        ["\xF3\xB0\x9E\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],
        ["\xF3\xB0\x9E\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],
        ["\xF3\xB0\x9E\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],
        ["\xF3\xB0\x9E\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],
        ["\xF3\xB0\x9E\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],
        ["\xF3\xB0\x9E\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],
        ["\xF3\xB0\x9E\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],
        ["\xF3\xB0\x9E\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],
        ["\xF3\xB0\x9E\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],
        ["\xF3\xB0\x9E\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],
        ["\xF3\xB0\x9E\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],
        ["\xF3\xB0\x9E\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],
        ["\xF3\xB0\x9E\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],
        ["\xF3\xB0\x9E\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],
        ["\xF3\xB0\x9E\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],
        ["\xF3\xB0\x9E\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],
        ["\xF3\xB0\x9E\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],
        ["\xF3\xB0\x9E\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],
        ["\xF3\xB0\x9E\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],
        ["\xF3\xB0\x9E\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],
        ["\xF3\xB0\x9E\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],
        ["\xF3\xB0\x9E\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],
        ["\xF3\xB0\x9E\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],
        ["\xF3\xB0\x9E\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],
        ["\xF3\xB0\x9E\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],
        ["\xF3\xB0\x9E\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],
        ["\xF3\xB0\x9E\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],
        ["\xF3\xB0\x9E\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],
        ["\xF3\xB0\x9E\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],
        ["\xF3\xB0\x9E\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],
        ["\xF3\xB0\x9E\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],
        ["\xF3\xB0\x9E\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],
        ["\xF3\xB0\x9E\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],
        ["\xF3\xB0\x9F\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],
        ["\xF3\xB0\x9F\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],
        ["\xF3\xB0\x9F\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],
        ["\xF3\xB0\x9F\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],
        ["\xF3\xB0\x9F\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],
        ["\xF3\xB0\x9F\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],
        ["\xF3\xB0\x9F\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],
        ["\xF3\xB0\x9F\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],
        ["\xF3\xB0\x9F\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],
        ["\xF3\xB0\x9F\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],
        ["\xF3\xB0\x9F\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],
        ["\xF3\xB0\x9F\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],
        ["\xF3\xB0\x9F\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],
        ["\xF3\xB0\x9F\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],
        ["\xF3\xB0\x9F\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],
        ["\xF3\xB0\x9F\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],
        ["\xF3\xB0\x9F\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],
        ["\xF3\xB0\x9F\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],
        ["\xF3\xB0\x9F\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],
        ["\xF3\xB0\x9F\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],
        ["\xF3\xB0\x9F\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],
        ["\xF3\xB0\x9F\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],
        ["\xF3\xB0\x9F\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],
        ["\xF3\xB0\x9F\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],
        ["\xF3\xB0\x9F\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],
        ["\xF3\xB0\x9F\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],
        ["\xF3\xB0\x9F\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],
        ["\xF3\xB0\x9F\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],
        ["\xF3\xB0\x9F\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],
        ["\xF3\xB0\x9F\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],
        ["\xF3\xB0\x9F\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],
        ["\xF3\xB0\x9F\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],
        ["\xF3\xB0\x9F\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],
        ["\xF3\xB0\x9F\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],
        ["\xF3\xB0\x9F\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],
        ["\xF3\xB0\x9F\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],
        ["\xF3\xB0\x9F\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],
        ["\xF3\xB0\x9F\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],
        ["\xF3\xB0\x9F\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],
        ["\xF3\xB0\x9F\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],
        ["\xF3\xB0\x9F\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],
        ["\xF3\xB0\x9F\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],
        ["\xF3\xB0\x9F\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],
        ["\xF3\xB0\x9F\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],
        ["\xF3\xB0\x9F\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],
        ["\xF3\xB0\x9F\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],
        ["\xF3\xB0\x9F\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],
        ["\xF3\xB0\x9F\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],
        ["\xF3\xB0\x9F\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],
        ["\xF3\xB0\x9F\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],
        ["\xF3\xB0\x9F\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],
        ["\xF3\xB0\x9F\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],
        ["\xF3\xB0\x9F\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],
        ["\xF3\xB0\x9F\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],
        ["\xF3\xB0\x9F\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],
        ["\xF3\xB0\x9F\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],
        ["\xF3\xB0\x9F\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],
        ["\xF3\xB0\x9F\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],
        ["\xF3\xB0\x9F\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],
        ["\xF3\xB0\x9F\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],
        ["\xF3\xB0\x9F\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],
        ["\xF3\xB0\x9F\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],
        ["\xF3\xB0\x9F\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],
        ["\xF3\xB0\x9F\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],
        ["\xF3\xB0\xA0\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],
        ["\xF3\xB0\xA0\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],
        ["\xF3\xB0\xA0\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],
        ["\xF3\xB0\xA0\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],
        ["\xF3\xB0\xA0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],
        ["\xF3\xB0\xA0\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],
        ["\xF3\xB0\xA0\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],
        ["\xF3\xB0\xA0\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],
        ["\xF3\xB0\xA0\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],
        ["\xF3\xB0\xA0\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],
        ["\xF3\xB0\xA0\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],
        ["\xF3\xB0\xA0\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],
        ["\xF3\xB0\xA0\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],
        ["\xF3\xB0\xA0\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],
        ["\xF3\xB0\xA0\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],
        ["\xF3\xB0\xA0\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],
        ["\xF3\xB0\xA0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],
        ["\xF3\xB0\xA0\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],
        ["\xF3\xB0\xA0\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],
        ["\xF3\xB0\xA0\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],
        ["\xF3\xB0\xA0\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],
        ["\xF3\xB0\xA0\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],
        ["\xF3\xB0\xA0\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],
        ["\xF3\xB0\xA0\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],
        ["\xF3\xB0\xA0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],
        ["\xF3\xB0\xA0\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],
        ["\xF3\xB0\xA0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],
        ["\xF3\xB0\xA0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],
        ["\xF3\xB0\xA0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],
        ["\xF3\xB0\xA0\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],
        ["\xF3\xB0\xA0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],
        ["\xF3\xB0\xA0\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],
        ["\xF3\xB0\xA0\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],
        ["\xF3\xB0\xA0\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],
        ["\xF3\xB0\xA0\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],
        ["\xF3\xB0\xA0\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],
        ["\xF3\xB0\xA0\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],
        ["\xF3\xB0\xA0\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],
        ["\xF3\xB0\xA0\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],
        ["\xF3\xB0\xA0\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],
        ["\xF3\xB0\xA0\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],
        ["\xF3\xB0\xA0\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],
        ["\xF3\xB0\xA0\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],
        ["\xF3\xB0\xA0\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],
        ["\xF3\xB0\xA0\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],
        ["\xF3\xB0\xA0\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],
        ["\xF3\xB0\xA0\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],
        ["\xF3\xB0\xA0\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],
        ["\xF3\xB0\xA0\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],
        ["\xF3\xB0\xA0\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],
        ["\xF3\xB0\xA0\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],
        ["\xF3\xB0\xA0\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],
        ["\xF3\xB0\xA0\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],
        ["\xF3\xB0\xA0\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],
        ["\xF3\xB0\xA0\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],
        ["\xF3\xB0\xA0\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],
        ["\xF3\xB0\xA0\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],
        ["\xF3\xB0\xA0\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],
        ["\xF3\xB0\xA0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],
        ["\xF3\xB0\xA0\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],
        ["\xF3\xB0\xA0\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],
        ["\xF3\xB0\xA0\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],
        ["\xF3\xB0\xA0\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],
        ["\xF3\xB0\xA0\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],
        ["\xF3\xB0\xA1\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],
        ["\xF3\xB0\xA1\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],
        ["\xF3\xB0\xA1\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],
        ["\xF3\xB0\xA1\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],
        ["\xF3\xB0\xA1\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],
        ["\xF3\xB0\xA1\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],
        ["\xF3\xB0\xA1\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],
        ["\xF3\xB0\xA1\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],
        ["\xF3\xB0\xA1\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],
        ["\xF3\xB0\xA1\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],
        ["\xF3\xB0\xA1\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],
        ["\xF3\xB0\xA1\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],
        ["\xF3\xB0\xA1\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],
        ["\xF3\xB0\xA1\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],
        ["\xF3\xB0\xA1\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],
        ["\xF3\xB0\xA1\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],
        ["\xF3\xB0\xA1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],
        ["\xF3\xB0\xA1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],
        ["\xF3\xB0\xA1\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],
        ["\xF3\xB0\xA1\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],
        ["\xF3\xB0\xA1\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],
        ["\xF3\xB0\xA1\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],
        ["\xF3\xB0\xA1\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],
        ["\xF3\xB0\xA1\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],
        ["\xF3\xB0\xA1\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],
        ["\xF3\xB0\xA1\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],
        ["\xF3\xB0\xA1\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],
        ["\xF3\xB0\xA1\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],
        ["\xF3\xB0\xA1\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],
        ["\xF3\xB0\xA1\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],
        ["\xF3\xB0\xA1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],
        ["\xF3\xB0\xA1\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],
        ["\xF3\xB0\xA1\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],
        ["\xF3\xB0\xA1\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],
        ["\xF3\xB0\xA1\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],
        ["\xF3\xB0\xA1\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],
        ["\xF3\xB0\xA1\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],
        ["\xF3\xB0\xA1\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],
        ["\xF3\xB0\xA1\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],
        ["\xF3\xB0\xA1\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],
        ["\xF3\xB0\xA1\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],
        ["\xF3\xB0\xA1\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],
        ["\xF3\xB0\xA1\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],
        ["\xF3\xB0\xA1\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],
        ["\xF3\xB0\xA1\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],
        ["\xF3\xB0\xA1\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],
        ["\xF3\xB0\xA1\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],
        ["\xF3\xB0\xA1\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],
        ["\xF3\xB0\xA1\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],
        ["\xF3\xB0\xA1\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],
        ["\xF3\xB0\xA1\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],
        ["\xF3\xB0\xA1\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],
        ["\xF3\xB0\xA1\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],
        ["\xF3\xB0\xA1\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],
        ["\xF3\xB0\xA1\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],
        ["\xF3\xB0\xA1\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],
        ["\xF3\xB0\xA1\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],
        ["\xF3\xB0\xA1\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],
        ["\xF3\xB0\xA1\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],
        ["\xF3\xB0\xA1\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],
        ["\xF3\xB0\xA1\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],
        ["\xF3\xB0\xA1\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],
        ["\xF3\xB0\xA1\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],
        ["\xF3\xB0\xA1\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],
        ["\xF3\xB0\xA2\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],
        ["\xF3\xB0\xA2\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],
        ["\xF3\xB0\xA2\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],
        ["\xF3\xB0\xA2\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],
        ["\xF3\xB0\xA2\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],
        ["\xF3\xB0\xA2\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],
        ["\xF3\xB0\xA2\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],
        ["\xF3\xB0\xA2\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],
        ["\xF3\xB0\xA2\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],
        ["\xF3\xB0\xA2\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],
        ["\xF3\xB0\xA2\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],
        ["\xF3\xB0\xA2\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],
        ["\xF3\xB0\xA2\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],
        ["\xF3\xB0\xA2\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],
        ["\xF3\xB0\xA2\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],
        ["\xF3\xB0\xA2\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],
        ["\xF3\xB0\xA2\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],
        ["\xF3\xB0\xA2\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],
        ["\xF3\xB0\xA2\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],
        ["\xF3\xB0\xA2\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],
        ["\xF3\xB0\xA2\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],
        ["\xF3\xB0\xA2\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],
        ["\xF3\xB0\xA2\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],
        ["\xF3\xB0\xA2\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],
        ["\xF3\xB0\xA2\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],
        ["\xF3\xB0\xA2\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],
        ["\xF3\xB0\xA2\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],
        ["\xF3\xB0\xA2\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],
        ["\xF3\xB0\xA2\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],
        ["\xF3\xB0\xA2\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],
        ["\xF3\xB0\xA2\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],
        ["\xF3\xB0\xA2\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],
        ["\xF3\xB0\xA2\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],
        ["\xF3\xB0\xA2\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],
        ["\xF3\xB0\xA2\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],
        ["\xF3\xB0\xA2\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],
        ["\xF3\xB0\xA2\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],
        ["\xF3\xB0\xA2\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],
        ["\xF3\xB0\xA2\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],
        ["\xF3\xB0\xA2\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],
        ["\xF3\xB0\xA2\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],
        ["\xF3\xB0\xA2\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],
        ["\xF3\xB0\xA2\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],
        ["\xF3\xB0\xA2\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],
        ["\xF3\xB0\xA2\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],
        ["\xF3\xB0\xA2\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],
        ["\xF3\xB0\xA2\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],
        ["\xF3\xB0\xA2\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],
        ["\xF3\xB0\xA2\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],
        ["\xF3\xB0\xA2\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],
        ["\xF3\xB0\xA2\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],
        ["\xF3\xB0\xA2\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],
        ["\xF3\xB0\xA2\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],
        ["\xF3\xB0\xA2\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],
        ["\xF3\xB0\xA2\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],
        ["\xF3\xB0\xA2\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],
        ["\xF3\xB0\xA2\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],
        ["\xF3\xB0\xA2\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],
        ["\xF3\xB0\xA2\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],
        ["\xF3\xB0\xA2\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],
        ["\xF3\xB0\xA2\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],
        ["\xF3\xB0\xA2\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],
        ["\xF3\xB0\xA2\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],
        ["\xF3\xB0\xA2\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],
        ["\xF3\xB0\xA3\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],
        ["\xF3\xB0\xA3\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],
        ["\xF3\xB0\xA3\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],
        ["\xF3\xB0\xA3\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],
        ["\xF3\xB0\xA3\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],
        ["\xF3\xB0\xA3\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],
        ["\xF3\xB0\xA3\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],
        ["\xF3\xB0\xA3\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],
        ["\xF3\xB0\xA3\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],
        ["\xF3\xB0\xA3\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],
        ["\xF3\xB0\xA3\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],
        ["\xF3\xB0\xA3\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],
        ["\xF3\xB0\xA3\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],
        ["\xF3\xB0\xA3\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],
        ["\xF3\xB0\xA3\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],
        ["\xF3\xB0\xA3\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],
        ["\xF3\xB0\xA3\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],
        ["\xF3\xB0\xA3\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],
        ["\xF3\xB0\xA3\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],
        ["\xF3\xB0\xA3\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],
        ["\xF3\xB0\xA3\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],
        ["\xF3\xB0\xA3\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],
        ["\xF3\xB0\xA3\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],
        ["\xF3\xB0\xA3\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],
        ["\xF3\xB0\xA3\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],
        ["\xF3\xB0\xA3\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],
        ["\xF3\xB0\xA3\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],
        ["\xF3\xB0\xA3\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],
        ["\xF3\xB0\xA3\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],
        ["\xF3\xB0\xA3\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],
        ["\xF3\xB0\xA3\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],
        ["\xF3\xB0\xA3\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],
        ["\xF3\xB0\xA3\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],
        ["\xF3\xB0\xA3\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],
        ["\xF3\xB0\xA3\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],
        ["\xF3\xB0\xA3\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],
        ["\xF3\xB0\xA3\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],
        ["\xF3\xB0\xA3\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],
        ["\xF3\xB0\xA3\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],
        ["\xF3\xB0\xA3\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],
        ["\xF3\xB0\xA3\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],
        ["\xF3\xB0\xA3\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],
        ["\xF3\xB0\xA3\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],
        ["\xF3\xB0\xA3\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],
        ["\xF3\xB0\xA3\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],
        ["\xF3\xB0\xA3\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],
        ["\xF3\xB0\xA3\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],
        ["\xF3\xB0\xA3\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],
        ["\xF3\xB0\xA3\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],
        ["\xF3\xB0\xA3\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],
        ["\xF3\xB0\xA3\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],
        ["\xF3\xB0\xA3\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],
        ["\xF3\xB0\xA3\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],
        ["\xF3\xB0\xA3\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],
        ["\xF3\xB0\xA3\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],
        ["\xF3\xB0\xA3\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],
        ["\xF3\xB0\xA3\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],
        ["\xF3\xB0\xA3\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],
        ["\xF3\xB0\xA3\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],
        ["\xF3\xB0\xA3\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],
        ["\xF3\xB0\xA3\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],
        ["\xF3\xB0\xA3\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],
        ["\xF3\xB0\xA3\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],
        ["\xF3\xB0\xA3\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],
        ["\xF3\xB0\xA4\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],
        ["\xF3\xB0\xA4\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],
        ["\xF3\xB0\xA4\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],
        ["\xF3\xB0\xA4\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],
        ["\xF3\xB0\xA4\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],
        ["\xF3\xB0\xA4\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],
        ["\xF3\xB0\xA4\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],
        ["\xF3\xB0\xA4\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],
        ["\xF3\xB0\xA4\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],
        ["\xF3\xB0\xA4\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],
        ["\xF3\xB0\xA4\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],
        ["\xF3\xB0\xA4\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],
        ["\xF3\xB0\xA4\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],
        ["\xF3\xB0\xA4\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],
        ["\xF3\xB0\xA4\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],
        ["\xF3\xB0\xA4\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],
        ["\xF3\xB0\xA4\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],
        ["\xF3\xB0\xA4\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],
        ["\xF3\xB0\xA4\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],
        ["\xF3\xB0\xA4\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],
        ["\xF3\xB0\xA4\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],
        ["\xF3\xB0\xA4\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],
        ["\xF3\xB0\xA4\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],
        ["\xF3\xB0\xA4\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],
        ["\xF3\xB0\xA4\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],
        ["\xF3\xB0\xA4\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],
        ["\xF3\xB0\xA4\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],
        ["\xF3\xB0\xA4\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],
        ["\xF3\xB0\xA4\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],
        ["\xF3\xB0\xA4\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],
        ["\xF3\xB0\xA4\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],
        ["\xF3\xB0\xA4\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],
        ["\xF3\xB0\xA4\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],
        ["\xF3\xB0\xA4\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],
        ["\xF3\xB0\xA4\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],
        ["\xF3\xB0\xA4\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],
        ["\xF3\xB0\xA4\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],
        ["\xF3\xB0\xA4\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],
        ["\xF3\xB0\xA4\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],
        ["\xF3\xB0\xA4\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],
        ["\xF3\xB0\xA4\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],
        ["\xF3\xB0\xA4\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],
        ["\xF3\xB0\xA4\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],
        ["\xF3\xB0\xA4\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],
        ["\xF3\xB0\xA4\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],
        ["\xF3\xB0\xA4\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],
        ["\xF3\xB0\xA4\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],
        ["\xF3\xB0\xA4\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],
        ["\xF3\xB0\xA4\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],
        ["\xF3\xB0\xA4\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],
        ["\xF3\xB0\xA4\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],
        ["\xF3\xB0\xA4\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],
        ["\xF3\xB0\xA4\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],
        ["\xF3\xB0\xA4\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],
        ["\xF3\xB0\xA4\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],
        ["\xF3\xB0\xA4\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],
        ["\xF3\xB0\xA4\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],
        ["\xF3\xB0\xA4\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],
        ["\xF3\xB0\xA4\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],
        ["\xF3\xB0\xA4\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],
        ["\xF3\xB0\xA4\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],
        ["\xF3\xB0\xA4\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],
        ["\xF3\xB0\xA4\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],
        ["\xF3\xB0\xA4\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],
        ["\xF3\xB0\xA5\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],
        ["\xF3\xB0\xA5\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],
        ["\xF3\xB0\xA5\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],
        ["\xF3\xB0\xA5\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],
        ["\xF3\xB0\xA5\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],
        ["\xF3\xB0\xA5\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],
        ["\xF3\xB0\xA5\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],
        ["\xF3\xB0\xA5\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],
        ["\xF3\xB0\xA5\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],
        ["\xF3\xB0\xA5\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],
        ["\xF3\xB0\xA5\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],
        ["\xF3\xB0\xA5\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],
        ["\xF3\xB0\xA5\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],
        ["\xF3\xB0\xA5\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],
        ["\xF3\xB0\xA5\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],
        ["\xF3\xB0\xA5\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],
        ["\xF3\xB0\xA5\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],
        ["\xF3\xB0\xA5\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],
        ["\xF3\xB0\xA5\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],
        ["\xF3\xB0\xA5\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],
        ["\xF3\xB0\xA5\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],
        ["\xF3\xB0\xA5\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],
        ["\xF3\xB0\xA5\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],
        ["\xF3\xB0\xA5\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],
        ["\xF3\xB0\xA5\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],
        ["\xF3\xB0\xA5\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],
        ["\xF3\xB0\xA5\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],
        ["\xF3\xB0\xA5\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],
        ["\xF3\xB0\xA5\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],
        ["\xF3\xB0\xA5\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],
        ["\xF3\xB0\xA5\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],
        ["\xF3\xB0\xA5\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],
        ["\xF3\xB0\xA5\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],
        ["\xF3\xB0\xA5\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],
        ["\xF3\xB0\xA5\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],
        ["\xF3\xB0\xA5\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],
        ["\xF3\xB0\xA5\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],
        ["\xF3\xB0\xA5\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],
        ["\xF3\xB0\xA5\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],
        ["\xF3\xB0\xA5\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],
        ["\xF3\xB0\xA5\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],
        ["\xF3\xB0\xA5\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],
        ["\xF3\xB0\xA5\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],
        ["\xF3\xB0\xA5\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],
        ["\xF3\xB0\xA5\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],
        ["\xF3\xB0\xA5\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],
        ["\xF3\xB0\xA5\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],
        ["\xF3\xB0\xA5\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],
        ["\xF3\xB0\xA5\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],
        ["\xF3\xB0\xA5\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],
        ["\xF3\xB0\xA5\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],
        ["\xF3\xB0\xA5\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],
        ["\xF3\xB0\xA5\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],
        ["\xF3\xB0\xA5\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],
        ["\xF3\xB0\xA5\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],
        ["\xF3\xB0\xA5\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],
        ["\xF3\xB0\xA5\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],
        ["\xF3\xB0\xA5\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],
        ["\xF3\xB0\xA5\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],
        ["\xF3\xB0\xA5\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],
        ["\xF3\xB0\xA5\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],
        ["\xF3\xB0\xA5\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],
        ["\xF3\xB0\xA5\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],
        ["\xF3\xB0\xA5\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],
        ["\xF3\xB0\xA6\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],
        ["\xF3\xB0\xA6\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],
        ["\xF3\xB0\xA6\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],
        ["\xF3\xB0\xA6\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],
        ["\xF3\xB0\xA6\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],
        ["\xF3\xB0\xA6\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],
        ["\xF3\xB0\xA6\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],
        ["\xF3\xB0\xA6\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],
        ["\xF3\xB0\xA6\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],
        ["\xF3\xB0\xA6\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],
        ["\xF3\xB0\xA6\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],
        ["\xF3\xB0\xA6\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],
        ["\xF3\xB0\xA6\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],
        ["\xF3\xB0\xA6\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],
        ["\xF3\xB0\xA6\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],
        ["\xF3\xB0\xA6\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],
        ["\xF3\xB0\xA6\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],
        ["\xF3\xB0\xA6\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],
        ["\xF3\xB0\xA6\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],
        ["\xF3\xB0\xA6\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],
        ["\xF3\xB0\xA6\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],
        ["\xF3\xB0\xA6\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],
        ["\xF3\xB0\xA6\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],
        ["\xF3\xB0\xA6\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],
        ["\xF3\xB0\xA6\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],
        ["\xF3\xB0\xA6\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],
        ["\xF3\xB0\xA6\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],
        ["\xF3\xB0\xA6\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],
        ["\xF3\xB0\xA6\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],
        ["\xF3\xB0\xA6\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],
        ["\xF3\xB0\xA6\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],
        ["\xF3\xB0\xA6\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],
        ["\xF3\xB0\xA6\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],
        ["\xF3\xB0\xA6\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],
        ["\xF3\xB0\xA6\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],
        ["\xF3\xB0\xA6\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],
        ["\xF3\xB0\xA6\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],
        ["\xF3\xB0\xA6\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],
        ["\xF3\xB0\xA6\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],
        ["\xF3\xB0\xA6\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],
        ["\xF3\xB0\xA6\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],
        ["\xF3\xB0\xA6\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],
        ["\xF3\xB0\xA6\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],
        ["\xF3\xB0\xA6\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],
        ["\xF3\xB0\xA6\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],
        ["\xF3\xB0\xA6\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],
        ["\xF3\xB0\xA6\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],
        ["\xF3\xB0\xA6\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],
        ["\xF3\xB0\xA6\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],
        ["\xF3\xB0\xA6\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],
        ["\xF3\xB0\xA6\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],
        ["\xF3\xB0\xA6\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],
        ["\xF3\xB0\xA6\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],
        ["\xF3\xB0\xA6\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],
        ["\xF3\xB0\xA6\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],
        ["\xF3\xB0\xA6\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],
        ["\xF3\xB0\xA6\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],
        ["\xF3\xB0\xA6\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],
        ["\xF3\xB0\xA6\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],
        ["\xF3\xB0\xA6\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],
        ["\xF3\xB0\xA6\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],
        ["\xF3\xB0\xA6\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],
        ["\xF3\xB0\xA6\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],
        ["\xF3\xB0\xA6\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],
        ["\xF3\xB0\xA7\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],
        ["\xF3\xB0\xA7\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],
        ["\xF3\xB0\xA7\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],
        ["\xF3\xB0\xA7\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],
        ["\xF3\xB0\xA7\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],
        ["\xF3\xB0\xA7\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],
        ["\xF3\xB0\xA7\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],
        ["\xF3\xB0\xA7\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],
        ["\xF3\xB0\xA7\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],
        ["\xF3\xB0\xA7\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],
        ["\xF3\xB0\xA7\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],
        ["\xF3\xB0\xA7\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],
        ["\xF3\xB0\xA7\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],
        ["\xF3\xB0\xA7\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],
        ["\xF3\xB0\xA7\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],
        ["\xF3\xB0\xA7\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],
        ["\xF3\xB0\xA7\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],
        ["\xF3\xB0\xA7\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],
        ["\xF3\xB0\xA7\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],
        ["\xF3\xB0\xA7\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],
        ["\xF3\xB0\xA7\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],
        ["\xF3\xB0\xA7\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],
        ["\xF3\xB0\xA7\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],
        ["\xF3\xB0\xA7\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],
        ["\xF3\xB0\xA7\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],
        ["\xF3\xB0\xA7\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],
        ["\xF3\xB0\xA7\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],
        ["\xF3\xB0\xA7\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],
        ["\xF3\xB0\xA7\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],
        ["\xF3\xB0\xA7\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],
        ["\xF3\xB0\xA7\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],
        ["\xF3\xB0\xA7\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],
        ["\xF3\xB0\xA7\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],
        ["\xF3\xB0\xA7\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],
        ["\xF3\xB0\xA7\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],
        ["\xF3\xB0\xA7\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],
        ["\xF3\xB0\xA7\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],
        ["\xF3\xB0\xA7\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],
        ["\xF3\xB0\xA7\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],
        ["\xF3\xB0\xA7\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],
        ["\xF3\xB0\xA7\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],
        ["\xF3\xB0\xA7\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],
        ["\xF3\xB0\xA7\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],
        ["\xF3\xB0\xA7\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],
        ["\xF3\xB0\xA7\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],
        ["\xF3\xB0\xA7\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],
        ["\xF3\xB0\xA7\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],
        ["\xF3\xB0\xA7\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],
        ["\xF3\xB0\xA7\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],
        ["\xF3\xB0\xA7\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],
        ["\xF3\xB0\xA7\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],
        ["\xF3\xB0\xA7\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],
        ["\xF3\xB0\xA7\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],
        ["\xF3\xB0\xA7\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],
        ["\xF3\xB0\xA7\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],
        ["\xF3\xB0\xA7\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],
        ["\xF3\xB0\xA7\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],
        ["\xF3\xB0\xA7\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],
        ["\xF3\xB0\xA7\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],
        ["\xF3\xB0\xA7\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],
        ["\xF3\xB0\xA7\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],
        ["\xF3\xB0\xA7\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],
        ["\xF3\xB0\xA7\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],
        ["\xF3\xB0\xA7\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],
        ["\xF3\xB0\xA8\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],
        ["\xF3\xB0\xA8\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],
        ["\xF3\xB0\xA8\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],
        ["\xF3\xB0\xA8\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],
        ["\xF3\xB0\xA8\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],
        ["\xF3\xB0\xA8\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],
        ["\xF3\xB0\xA8\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],
        ["\xF3\xB0\xA8\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],
        ["\xF3\xB0\xA8\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],
        ["\xF3\xB0\xA8\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],
        ["\xF3\xB0\xA8\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],
        ["\xF3\xB0\xA8\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],
        ["\xF3\xB0\xA8\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],
        ["\xF3\xB0\xA8\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],
        ["\xF3\xB0\xA8\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],
        ["\xF3\xB0\xA8\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],
        ["\xF3\xB0\xA8\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],
        ["\xF3\xB0\xA8\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],
        ["\xF3\xB0\xA8\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],
        ["\xF3\xB0\xA8\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],
        ["\xF3\xB0\xA8\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],
        ["\xF3\xB0\xA8\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],
        ["\xF3\xB0\xA8\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],
        ["\xF3\xB0\xA8\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],
        ["\xF3\xB0\xA8\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],
        ["\xF3\xB0\xA8\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],
        ["\xF3\xB0\xA8\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],
        ["\xF3\xB0\xA8\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],
        ["\xF3\xB0\xA8\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],
        ["\xF3\xB0\xA8\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],
        ["\xF3\xB0\xA8\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],
        ["\xF3\xB0\xA8\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],
        ["\xF3\xB0\xA8\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],
        ["\xF3\xB0\xA8\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],
        ["\xF3\xB0\xA8\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],
        ["\xF3\xB0\xA8\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],
        ["\xF3\xB0\xA8\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],
        ["\xF3\xB0\xA8\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],
        ["\xF3\xB0\xA8\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],
        ["\xF3\xB0\xA8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],
        ["\xF3\xB0\xA8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],
        ["\xF3\xB0\xA8\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],
        ["\xF3\xB0\xA8\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],
        ["\xF3\xB0\xA8\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],
        ["\xF3\xB0\xA8\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],
        ["\xF3\xB0\xA8\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],
        ["\xF3\xB0\xA8\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],
        ["\xF3\xB0\xA8\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],
        ["\xF3\xB0\xA8\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],
        ["\xF3\xB0\xA8\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],
        ["\xF3\xB0\xA8\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],
        ["\xF3\xB0\xA8\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],
        ["\xF3\xB0\xA8\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],
        ["\xF3\xB0\xA8\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],
        ["\xF3\xB0\xA8\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],
        ["\xF3\xB0\xA8\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],
        ["\xF3\xB0\xA8\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],
        ["\xF3\xB0\xA8\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],
        ["\xF3\xB0\xA8\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],
        ["\xF3\xB0\xA8\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],
        ["\xF3\xB0\xA8\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],
        ["\xF3\xB0\xA8\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],
        ["\xF3\xB0\xA8\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],
        ["\xF3\xB0\xA8\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],
        ["\xF3\xB0\xA9\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],
        ["\xF3\xB0\xA9\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],
        ["\xF3\xB0\xA9\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],
        ["\xF3\xB0\xA9\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],
        ["\xF3\xB0\xA9\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],
        ["\xF3\xB0\xA9\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],
        ["\xF3\xB0\xA9\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],
        ["\xF3\xB0\xA9\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],
        ["\xF3\xB0\xA9\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],
        ["\xF3\xB0\xA9\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],
        ["\xF3\xB0\xA9\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],
        ["\xF3\xB0\xA9\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],
        ["\xF3\xB0\xA9\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],
        ["\xF3\xB0\xA9\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],
        ["\xF3\xB0\xA9\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],
        ["\xF3\xB0\xA9\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],
        ["\xF3\xB0\xA9\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],
        ["\xF3\xB0\xA9\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],
        ["\xF3\xB0\xA9\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],
        ["\xF3\xB0\xA9\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],
        ["\xF3\xB0\xA9\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],
        ["\xF3\xB0\xA9\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],
        ["\xF3\xB0\xA9\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],
        ["\xF3\xB0\xA9\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],
        ["\xF3\xB0\xA9\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],
        ["\xF3\xB0\xA9\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],
        ["\xF3\xB0\xA9\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],
        ["\xF3\xB0\xA9\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],
        ["\xF3\xB0\xA9\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],
        ["\xF3\xB0\xA9\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],
        ["\xF3\xB0\xA9\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],
        ["\xF3\xB0\xA9\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],
        ["\xF3\xB0\xA9\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],
        ["\xF3\xB0\xA9\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],
        ["\xF3\xB0\xA9\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],
        ["\xF3\xB0\xA9\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],
        ["\xF3\xB0\xA9\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],
        ["\xF3\xB0\xA9\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],
        ["\xF3\xB0\xA9\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],
        ["\xF3\xB0\xA9\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],
        ["\xF3\xB0\xA9\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],
        ["\xF3\xB0\xA9\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],
        ["\xF3\xB0\xA9\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],
        ["\xF3\xB0\xA9\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],
        ["\xF3\xB0\xA9\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],
        ["\xF3\xB0\xA9\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],
        ["\xF3\xB0\xA9\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],
        ["\xF3\xB0\xA9\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],
        ["\xF3\xB0\xA9\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],
        ["\xF3\xB0\xA9\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],
        ["\xF3\xB0\xA9\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],
        ["\xF3\xB0\xA9\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],
        ["\xF3\xB0\xA9\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],
        ["\xF3\xB0\xA9\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],
        ["\xF3\xB0\xA9\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],
        ["\xF3\xB0\xA9\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],
        ["\xF3\xB0\xA9\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],
        ["\xF3\xB0\xA9\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],
        ["\xF3\xB0\xA9\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],
        ["\xF3\xB0\xA9\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],
        ["\xF3\xB0\xA9\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],
        ["\xF3\xB0\xA9\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],
        ["\xF3\xB0\xA9\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],
        ["\xF3\xB0\xA9\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],
        ["\xF3\xB0\xAA\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],
        ["\xF3\xB0\xAA\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],
        ["\xF3\xB0\xAA\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],
        ["\xF3\xB0\xAA\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],
        ["\xF3\xB0\xAA\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],
        ["\xF3\xB0\xAA\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],
        ["\xF3\xB0\xAA\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],
        ["\xF3\xB0\xAA\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],
        ["\xF3\xB0\xAA\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],
        ["\xF3\xB0\xAA\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],
        ["\xF3\xB0\xAA\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],
        ["\xF3\xB0\xAA\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],
        ["\xF3\xB0\xAA\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],
        ["\xF3\xB0\xAA\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],
        ["\xF3\xB0\xAA\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],
        ["\xF3\xB0\xAA\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],
        ["\xF3\xB0\xAA\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],
        ["\xF3\xB0\xAA\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],
        ["\xF3\xB0\xAA\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],
        ["\xF3\xB0\xAA\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],
        ["\xF3\xB0\xAA\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],
        ["\xF3\xB0\xAA\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],
        ["\xF3\xB0\xAA\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],
        ["\xF3\xB0\xAA\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],
        ["\xF3\xB0\xAA\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],
        ["\xF3\xB0\xAA\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],
        ["\xF3\xB0\xAA\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],
        ["\xF3\xB0\xAA\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],
        ["\xF3\xB0\xAA\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],
        ["\xF3\xB0\xAA\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],
        ["\xF3\xB0\xAA\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],
        ["\xF3\xB0\xAA\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],
        ["\xF3\xB0\xAA\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],
        ["\xF3\xB0\xAA\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],
        ["\xF3\xB0\xAA\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],
        ["\xF3\xB0\xAA\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],
        ["\xF3\xB0\xAA\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],
        ["\xF3\xB0\xAA\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],
        ["\xF3\xB0\xAA\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],
        ["\xF3\xB0\xAA\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],
        ["\xF3\xB0\xAA\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],
        ["\xF3\xB0\xAA\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],
        ["\xF3\xB0\xAA\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],
        ["\xF3\xB0\xAA\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],
        ["\xF3\xB0\xAA\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],
        ["\xF3\xB0\xAA\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],
        ["\xF3\xB0\xAA\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],
        ["\xF3\xB0\xAA\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],
        ["\xF3\xB0\xAA\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],
        ["\xF3\xB0\xAA\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],
        ["\xF3\xB0\xAA\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],
        ["\xF3\xB0\xAA\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],
        ["\xF3\xB0\xAA\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],
        ["\xF3\xB0\xAA\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],
        ["\xF3\xB0\xAA\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],
        ["\xF3\xB0\xAA\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],
        ["\xF3\xB0\xAA\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],
        ["\xF3\xB0\xAA\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],
        ["\xF3\xB0\xAA\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],
        ["\xF3\xB0\xAA\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],
        ["\xF3\xB0\xAA\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],
        ["\xF3\xB0\xAA\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],
        ["\xF3\xB0\xAA\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],
        ["\xF3\xB0\xAA\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],
        ["\xF3\xB0\xAB\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],
        ["\xF3\xB0\xAB\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],
        ["\xF3\xB0\xAB\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],
        ["\xF3\xB0\xAB\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],
        ["\xF3\xB0\xAB\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],
        ["\xF3\xB0\xAB\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],
        ["\xF3\xB0\xAB\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],
        ["\xF3\xB0\xAB\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],
        ["\xF3\xB0\xAB\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],
        ["\xF3\xB0\xAB\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],
        ["\xF3\xB0\xAB\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],
        ["\xF3\xB0\xAB\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],
        ["\xF3\xB0\xAB\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],
        ["\xF3\xB0\xAB\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],
        ["\xF3\xB0\xAB\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],
        ["\xF3\xB0\xAB\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],
        ["\xF3\xB0\xAB\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],
        ["\xF3\xB0\xAB\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],
        ["\xF3\xB0\xAB\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],
        ["\xF3\xB0\xAB\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],
        ["\xF3\xB0\xAB\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],
        ["\xF3\xB0\xAB\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],
        ["\xF3\xB0\xAB\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],
        ["\xF3\xB0\xAB\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],
        ["\xF3\xB0\xAB\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],
        ["\xF3\xB0\xAB\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],
        ["\xF3\xB0\xAB\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],
        ["\xF3\xB0\xAB\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],
        ["\xF3\xB0\xAB\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],
        ["\xF3\xB0\xAB\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],
        ["\xF3\xB0\xAB\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],
        ["\xF3\xB0\xAB\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],
        ["\xF3\xB0\xAB\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],
        ["\xF3\xB0\xAB\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],
        ["\xF3\xB0\xAB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],
        ["\xF3\xB0\xAB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],
        ["\xF3\xB0\xAB\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],
        ["\xF3\xB0\xAB\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],
        ["\xF3\xB0\xAB\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],
        ["\xF3\xB0\xAB\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],
        ["\xF3\xB0\xAB\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],
        ["\xF3\xB0\xAB\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],
        ["\xF3\xB0\xAB\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],
        ["\xF3\xB0\xAB\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],
        ["\xF3\xB0\xAB\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],
        ["\xF3\xB0\xAB\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],
        ["\xF3\xB0\xAB\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],
        ["\xF3\xB0\xAB\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],
        ["\xF3\xB0\xAB\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],
        ["\xF3\xB0\xAB\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],
        ["\xF3\xB0\xAB\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],
        ["\xF3\xB0\xAB\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],
        ["\xF3\xB0\xAB\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],
        ["\xF3\xB0\xAB\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],
        ["\xF3\xB0\xAB\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],
        ["\xF3\xB0\xAB\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],
        ["\xF3\xB0\xAB\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],
        ["\xF3\xB0\xAB\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],
        ["\xF3\xB0\xAB\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],
        ["\xF3\xB0\xAB\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],
        ["\xF3\xB0\xAB\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],
        ["\xF3\xB0\xAB\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],
        ["\xF3\xB0\xAB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],
        ["\xF3\xB0\xAB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],
        ["\xF3\xB0\xAC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],
        ["\xF3\xB0\xAC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],
        ["\xF3\xB0\xAC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],
        ["\xF3\xB0\xAC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],
        ["\xF3\xB0\xAC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],
        ["\xF3\xB0\xAC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],
        ["\xF3\xB0\xAC\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],
        ["\xF3\xB0\xAC\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],
        ["\xF3\xB0\xAC\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],
        ["\xF3\xB0\xAC\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],
        ["\xF3\xB0\xAC\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],
        ["\xF3\xB0\xAC\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],
        ["\xF3\xB0\xAC\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],
        ["\xF3\xB0\xAC\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],
        ["\xF3\xB0\xAC\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],
        ["\xF3\xB0\xAC\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],
        ["\xF3\xB0\xAC\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],
        ["\xF3\xB0\xAC\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],
        ["\xF3\xB0\xAC\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],
        ["\xF3\xB0\xAC\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],
        ["\xF3\xB0\xAC\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],
        ["\xF3\xB0\xAC\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],
        ["\xF3\xB0\xAC\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],
        ["\xF3\xB0\xAC\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],
        ["\xF3\xB0\xAC\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],
        ["\xF3\xB0\xAC\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],
        ["\xF3\xB0\xAC\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],
        ["\xF3\xB0\xAC\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],
        ["\xF3\xB0\xAC\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],
        ["\xF3\xB0\xAC\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],
        ["\xF3\xB0\xAC\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],
        ["\xF3\xB0\xAC\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],
        ["\xF3\xB0\xAC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],
        ["\xF3\xB0\xAC\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],
        ["\xF3\xB0\xAC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],
        ["\xF3\xB0\xAC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],
        ["\xF3\xB0\xAC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],
        ["\xF3\xB0\xAC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],
        ["\xF3\xB0\xAC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],
        ["\xF3\xB0\xAC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],
        ["\xF3\xB0\xAC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],
        ["\xF3\xB0\xAC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],
        ["\xF3\xB0\xAC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],
        ["\xF3\xB0\xAC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],
        ["\xF3\xB0\xAC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],
        ["\xF3\xB0\xAC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],
        ["\xF3\xB0\xAC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],
        ["\xF3\xB0\xAC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],
        ["\xF3\xB0\xAC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],
        ["\xF3\xB0\xAC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],
        ["\xF3\xB0\xAC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],
        ["\xF3\xB0\xAC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],
        ["\xF3\xB0\xAC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],
        ["\xF3\xB0\xAC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],
        ["\xF3\xB0\xAC\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],
        ["\xF3\xB0\xAC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],
        ["\xF3\xB0\xAC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],
        ["\xF3\xB0\xAC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],
        ["\xF3\xB0\xAC\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],
        ["\xF3\xB0\xAC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],
        ["\xF3\xB0\xAC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],
        ["\xF3\xB0\xAC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],
        ["\xF3\xB0\xAC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],
        ["\xF3\xB0\xAC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],
        ["\xF3\xB0\xAD\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],
        ["\xF3\xB0\xAD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],
        ["\xF3\xB0\xAD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],
        ["\xF3\xB0\xAD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],
        ["\xF3\xB0\xAD\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],
        ["\xF3\xB0\xAD\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],
        ["\xF3\xB0\xAD\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],
        ["\xF3\xB0\xAD\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],
        ["\xF3\xB0\xAD\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],
        ["\xF3\xB0\xAD\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],
        ["\xF3\xB0\xAD\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],
        ["\xF3\xB0\xAD\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],
        ["\xF3\xB0\xAD\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],
        ["\xF3\xB0\xAD\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],
        ["\xF3\xB0\xAD\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],
        ["\xF3\xB0\xAD\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],
        ["\xF3\xB0\xAD\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],
        ["\xF3\xB0\xAD\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],
        ["\xF3\xB0\xAD\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],
        ["\xF3\xB0\xAD\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],
        ["\xF3\xB0\xAD\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],
        ["\xF3\xB0\xAD\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],
        ["\xF3\xB0\xAD\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],
        ["\xF3\xB0\xAD\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],
        ["\xF3\xB0\xAD\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],
        ["\xF3\xB0\xAD\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],
        ["\xF3\xB0\xAD\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],
        ["\xF3\xB0\xAD\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],
        ["\xF3\xB0\xAD\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],
        ["\xF3\xB0\xAD\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],
        ["\xF3\xB0\xAD\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],
        ["\xF3\xB0\xAD\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],
        ["\xF3\xB0\xAD\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],
        ["\xF3\xB0\xAD\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],
        ["\xF3\xB0\xAD\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],
        ["\xF3\xB0\xAD\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],
        ["\xF3\xB0\xAD\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],
        ["\xF3\xB0\xAD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],
        ["\xF3\xB0\xAD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],
        ["\xF3\xB0\xAD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],
        ["\xF3\xB0\xAD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],
        ["\xF3\xB0\xAD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],
        ["\xF3\xB0\xAD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],
        ["\xF3\xB0\xAD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],
        ["\xF3\xB0\xAD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],
        ["\xF3\xB0\xAD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],
        ["\xF3\xB0\xAD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],
        ["\xF3\xB0\xAD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],
        ["\xF3\xB0\xAD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],
        ["\xF3\xB0\xAD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],
        ["\xF3\xB0\xAD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],
        ["\xF3\xB0\xAD\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],
        ["\xF3\xB0\xAD\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],
        ["\xF3\xB0\xAD\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],
        ["\xF3\xB0\xAD\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],
        ["\xF3\xB0\xAD\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],
        ["\xF3\xB0\xAD\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],
        ["\xF3\xB0\xAD\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],
        ["\xF3\xB0\xAD\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],
        ["\xF3\xB0\xAD\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],
        ["\xF3\xB0\xAD\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],
        ["\xF3\xB0\xAD\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],
        ["\xF3\xB0\xAD\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],
        ["\xF3\xB0\xAD\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],
        ["\xF3\xB0\xAE\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],
        ["\xF3\xB0\xAE\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],
        ["\xF3\xB0\xAE\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],
        ["\xF3\xB0\xAE\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],
        ["\xF3\xB0\xAE\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],
        ["\xF3\xB0\xAE\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],
        ["\xF3\xB0\xAE\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],
        ["\xF3\xB0\xAE\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],
        ["\xF3\xB0\xAE\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],
        ["\xF3\xB0\xAE\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],
        ["\xF3\xB0\xAE\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],
        ["\xF3\xB0\xAE\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],
        ["\xF3\xB0\xAE\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],
        ["\xF3\xB0\xAE\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],
        ["\xF3\xB0\xAE\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],
        ["\xF3\xB0\xAE\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],
        ["\xF3\xB0\xAE\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],
        ["\xF3\xB0\xAE\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],
        ["\xF3\xB0\xAE\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],
        ["\xF3\xB0\xAE\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],
        ["\xF3\xB0\xAE\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],
        ["\xF3\xB0\xAE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],
        ["\xF3\xB0\xAE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],
        ["\xF3\xB0\xAE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],
        ["\xF3\xB0\xAE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],
        ["\xF3\xB0\xAE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],
        ["\xF3\xB0\xAE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],
        ["\xF3\xB0\xAE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],
        ["\xF3\xB0\xAE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],
        ["\xF3\xB0\xAE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],
        ["\xF3\xB0\xAE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],
        ["\xF3\xB0\xAE\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],
        ["\xF3\xB0\xAE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],
        ["\xF3\xB0\xAE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],
        ["\xF3\xB0\xAE\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],
        ["\xF3\xB0\xAE\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],
        ["\xF3\xB0\xAE\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],
        ["\xF3\xB0\xAE\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],
        ["\xF3\xB0\xAE\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],
        ["\xF3\xB0\xAE\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],
        ["\xF3\xB0\xAE\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],
        ["\xF3\xB0\xAE\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],
        ["\xF3\xB0\xAE\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],
        ["\xF3\xB0\xAE\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],
        ["\xF3\xB0\xAE\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],
        ["\xF3\xB0\xAE\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],
        ["\xF3\xB0\xAE\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],
        ["\xF3\xB0\xAE\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],
        ["\xF3\xB0\xAE\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],
        ["\xF3\xB0\xAE\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],
        ["\xF3\xB0\xAE\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],
        ["\xF3\xB0\xAE\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],
        ["\xF3\xB0\xAE\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],
        ["\xF3\xB0\xAE\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],
        ["\xF3\xB0\xAE\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],
        ["\xF3\xB0\xAE\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],
        ["\xF3\xB0\xAE\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],
        ["\xF3\xB0\xAE\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],
        ["\xF3\xB0\xAE\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],
        ["\xF3\xB0\xAE\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],
        ["\xF3\xB0\xAE\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],
        ["\xF3\xB0\xAE\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],
        ["\xF3\xB0\xAE\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],
        ["\xF3\xB0\xAE\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],
        ["\xF3\xB0\xAF\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],
        ["\xF3\xB0\xAF\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],
        ["\xF3\xB0\xAF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],
        ["\xF3\xB0\xAF\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],
        ["\xF3\xB0\xAF\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],
        ["\xF3\xB0\xAF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],
        ["\xF3\xB0\xAF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],
        ["\xF3\xB0\xAF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],
        ["\xF3\xB0\xAF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],
        ["\xF3\xB0\xAF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],
        ["\xF3\xB0\xAF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],
        ["\xF3\xB0\xAF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],
        ["\xF3\xB0\xAF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],
        ["\xF3\xB0\xAF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],
        ["\xF3\xB0\xAF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],
        ["\xF3\xB0\xAF\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],
        ["\xF3\xB0\xAF\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],
        ["\xF3\xB0\xAF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],
        ["\xF3\xB0\xAF\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],
        ["\xF3\xB0\xAF\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],
        ["\xF3\xB0\xAF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],
        ["\xF3\xB0\xAF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],
        ["\xF3\xB0\xAF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],
        ["\xF3\xB0\xAF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],
        ["\xF3\xB0\xAF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],
        ["\xF3\xB0\xAF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],
        ["\xF3\xB0\xAF\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],
        ["\xF3\xB0\xAF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],
        ["\xF3\xB0\xAF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],
        ["\xF3\xB0\xAF\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],
        ["\xF3\xB0\xAF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],
        ["\xF3\xB0\xAF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],
        ["\xF3\xB0\xAF\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],
        ["\xF3\xB0\xAF\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],
        ["\xF3\xB0\xAF\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],
        ["\xF3\xB0\xAF\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],
        ["\xF3\xB0\xAF\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],
        ["\xF3\xB0\xAF\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],
        ["\xF3\xB0\xAF\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],
        ["\xF3\xB0\xAF\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],
        ["\xF3\xB0\xAF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],
        ["\xF3\xB0\xAF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],
        ["\xF3\xB0\xAF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],
        ["\xF3\xB0\xAF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],
        ["\xF3\xB0\xAF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],
        ["\xF3\xB0\xAF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],
        ["\xF3\xB0\xAF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],
        ["\xF3\xB0\xAF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],
        ["\xF3\xB0\xAF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],
        ["\xF3\xB0\xAF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],
        ["\xF3\xB0\xAF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],
        ["\xF3\xB0\xAF\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],
        ["\xF3\xB0\xAF\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],
        ["\xF3\xB0\xAF\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],
        ["\xF3\xB0\xAF\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],
        ["\xF3\xB0\xAF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],
        ["\xF3\xB0\xAF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],
        ["\xF3\xB0\xAF\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],
        ["\xF3\xB0\xAF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],
        ["\xF3\xB0\xAF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],
        ["\xF3\xB0\xAF\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],
        ["\xF3\xB0\xAF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],
        ["\xF3\xB0\xAF\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],
        ["\xF3\xB0\xAF\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],
        ["\xF3\xB0\xB0\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],
        ["\xF3\xB0\xB0\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],
        ["\xF3\xB0\xB0\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],
        ["\xF3\xB0\xB0\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],
        ["\xF3\xB0\xB0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],
        ["\xF3\xB0\xB0\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],
        ["\xF3\xB0\xB0\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],
        ["\xF3\xB0\xB0\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],
        ["\xF3\xB0\xB0\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],
        ["\xF3\xB0\xB0\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],
        ["\xF3\xB0\xB0\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],
        ["\xF3\xB0\xB0\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],
        ["\xF3\xB0\xB0\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],
        ["\xF3\xB0\xB0\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],
        ["\xF3\xB0\xB0\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],
        ["\xF3\xB0\xB0\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],
        ["\xF3\xB0\xB0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],
        ["\xF3\xB0\xB0\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],
        ["\xF3\xB0\xB0\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],
        ["\xF3\xB0\xB0\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],
        ["\xF3\xB0\xB0\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],
        ["\xF3\xB0\xB0\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],
        ["\xF3\xB0\xB0\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],
        ["\xF3\xB0\xB0\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],
        ["\xF3\xB0\xB0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],
        ["\xF3\xB0\xB0\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],
        ["\xF3\xB0\xB0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],
        ["\xF3\xB0\xB0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],
        ["\xF3\xB0\xB0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],
        ["\xF3\xB0\xB0\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],
        ["\xF3\xB0\xB0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],
        ["\xF3\xB0\xB0\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],
        ["\xF3\xB0\xB0\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],
        ["\xF3\xB0\xB0\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],
        ["\xF3\xB0\xB0\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],
        ["\xF3\xB0\xB0\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],
        ["\xF3\xB0\xB0\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],
        ["\xF3\xB0\xB0\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],
        ["\xF3\xB0\xB0\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],
        ["\xF3\xB0\xB0\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],
        ["\xF3\xB0\xB0\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],
        ["\xF3\xB0\xB0\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],
        ["\xF3\xB0\xB0\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],
        ["\xF3\xB0\xB0\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],
        ["\xF3\xB0\xB0\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],
        ["\xF3\xB0\xB0\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],
        ["\xF3\xB0\xB0\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],
        ["\xF3\xB0\xB0\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],
        ["\xF3\xB0\xB0\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],
        ["\xF3\xB0\xB0\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],
        ["\xF3\xB0\xB0\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],
        ["\xF3\xB0\xB0\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],
        ["\xF3\xB0\xB0\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],
        ["\xF3\xB0\xB0\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],
        ["\xF3\xB0\xB0\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],
        ["\xF3\xB0\xB0\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],
        ["\xF3\xB0\xB0\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],
        ["\xF3\xB0\xB0\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],
        ["\xF3\xB0\xB0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],
        ["\xF3\xB0\xB0\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],
        ["\xF3\xB0\xB0\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],
        ["\xF3\xB0\xB0\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],
        ["\xF3\xB0\xB0\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],
        ["\xF3\xB0\xB0\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],
        ["\xF3\xB0\xB1\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],
        ["\xF3\xB0\xB1\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],
        ["\xF3\xB0\xB1\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],
        ["\xF3\xB0\xB1\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],
        ["\xF3\xB0\xB1\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],
        ["\xF3\xB0\xB1\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],
        ["\xF3\xB0\xB1\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],
        ["\xF3\xB0\xB1\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],
        ["\xF3\xB0\xB1\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],
        ["\xF3\xB0\xB1\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],
        ["\xF3\xB0\xB1\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],
        ["\xF3\xB0\xB1\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],
        ["\xF3\xB0\xB1\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],
        ["\xF3\xB0\xB1\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],
        ["\xF3\xB0\xB1\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],
        ["\xF3\xB0\xB1\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],
        ["\xF3\xB0\xB1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],
        ["\xF3\xB0\xB1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],
        ["\xF3\xB0\xB1\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],
        ["\xF3\xB0\xB1\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],
        ["\xF3\xB0\xB1\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],
        ["\xF3\xB0\xB1\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],
        ["\xF3\xB0\xB1\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],
        ["\xF3\xB0\xB1\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],
        ["\xF3\xB0\xB1\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],
        ["\xF3\xB0\xB1\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],
        ["\xF3\xB0\xB1\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],
        ["\xF3\xB0\xB1\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],
        ["\xF3\xB0\xB1\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],
        ["\xF3\xB0\xB1\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],
        ["\xF3\xB0\xB1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],
        ["\xF3\xB0\xB1\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],
        ["\xF3\xB0\xB1\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],
        ["\xF3\xB0\xB1\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],
        ["\xF3\xB0\xB1\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],
        ["\xF3\xB0\xB1\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],
        ["\xF3\xB0\xB1\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],
        ["\xF3\xB0\xB1\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],
        ["\xF3\xB0\xB1\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],
        ["\xF3\xB0\xB1\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],
        ["\xF3\xB0\xB1\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],
        ["\xF3\xB0\xB1\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],
        ["\xF3\xB0\xB1\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],
        ["\xF3\xB0\xB1\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],
        ["\xF3\xB0\xB1\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],
        ["\xF3\xB0\xB1\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],
        ["\xF3\xB0\xB1\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],
        ["\xF3\xB0\xB1\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],
        ["\xF3\xB0\xB1\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],
        ["\xF3\xB0\xB1\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],
        ["\xF3\xB0\xB1\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],
        ["\xF3\xB0\xB1\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],
        ["\xF3\xB0\xB1\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],
        ["\xF3\xB0\xB1\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],
        ["\xF3\xB0\xB1\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],
        ["\xF3\xB0\xB1\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],
        ["\xF3\xB0\xB1\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],
        ["\xF3\xB0\xB1\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],
        ["\xF3\xB0\xB1\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],
        ["\xF3\xB0\xB1\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],
        ["\xF3\xB0\xB1\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],
        ["\xF3\xB0\xB1\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],
        ["\xF3\xB0\xB1\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],
        ["\xF3\xB0\xB1\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],
        ["\xF3\xB0\xB2\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],
        ["\xF3\xB0\xB2\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],
        ["\xF3\xB0\xB2\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],
        ["\xF3\xB0\xB2\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],
        ["\xF3\xB0\xB2\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],
        ["\xF3\xB0\xB2\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],
        ["\xF3\xB0\xB2\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],
        ["\xF3\xB0\xB2\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],
        ["\xF3\xB0\xB2\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],
        ["\xF3\xB0\xB2\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],
        ["\xF3\xB0\xB2\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],
        ["\xF3\xB0\xB2\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],
        ["\xF3\xB0\xB2\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],
        ["\xF3\xB0\xB2\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],
        ["\xF3\xB0\xB2\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],
        ["\xF3\xB0\xB2\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],
        ["\xF3\xB0\xB2\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],
        ["\xF3\xB0\xB2\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],
        ["\xF3\xB0\xB2\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],
        ["\xF3\xB0\xB2\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],
        ["\xF3\xB0\xB2\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],
        ["\xF3\xB0\xB2\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],
        ["\xF3\xB0\xB2\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],
        ["\xF3\xB0\xB2\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],
        ["\xF3\xB0\xB2\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],
        ["\xF3\xB0\xB2\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],
        ["\xF3\xB0\xB2\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],
        ["\xF3\xB0\xB2\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],
        ["\xF3\xB0\xB2\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],
        ["\xF3\xB0\xB2\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],
        ["\xF3\xB0\xB2\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],
        ["\xF3\xB0\xB2\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],
        ["\xF3\xB0\xB2\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],
        ["\xF3\xB0\xB2\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],
        ["\xF3\xB0\xB2\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],
        ["\xF3\xB0\xB2\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],
        ["\xF3\xB0\xB2\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],
        ["\xF3\xB0\xB2\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],
        ["\xF3\xB0\xB2\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],
        ["\xF3\xB0\xB2\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],
        ["\xF3\xB0\xB2\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],
        ["\xF3\xB0\xB2\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],
        ["\xF3\xB0\xB2\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],
        ["\xF3\xB0\xB2\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],
        ["\xF3\xB0\xB2\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],
        ["\xF3\xB0\xB2\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],
        ["\xF3\xB0\xB2\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],
        ["\xF3\xB0\xB2\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],
        ["\xF3\xB0\xB2\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],
        ["\xF3\xB0\xB2\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],
        ["\xF3\xB0\xB2\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],
        ["\xF3\xB0\xB2\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],
        ["\xF3\xB0\xB2\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],
        ["\xF3\xB0\xB2\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],
        ["\xF3\xB0\xB2\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],
        ["\xF3\xB0\xB2\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],
        ["\xF3\xB0\xB2\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],
        ["\xF3\xB0\xB2\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],
        ["\xF3\xB0\xB2\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],
        ["\xF3\xB0\xB2\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],
        ["\xF3\xB0\xB2\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],
        ["\xF3\xB0\xB2\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],
        ["\xF3\xB0\xB2\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],
        ["\xF3\xB0\xB2\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],
        ["\xF3\xB0\xB3\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],
        ["\xF3\xB0\xB3\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],
        ["\xF3\xB0\xB3\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],
        ["\xF3\xB0\xB3\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],
        ["\xF3\xB0\xB3\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],
        ["\xF3\xB0\xB3\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],
        ["\xF3\xB0\xB3\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],
        ["\xF3\xB0\xB3\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],
        ["\xF3\xB0\xB3\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],
        ["\xF3\xB0\xB3\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],
        ["\xF3\xB0\xB3\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],
        ["\xF3\xB0\xB3\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],
        ["\xF3\xB0\xB3\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],
        ["\xF3\xB0\xB3\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],
        ["\xF3\xB0\xB3\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],
        ["\xF3\xB0\xB3\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],
        ["\xF3\xB0\xB3\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],
        ["\xF3\xB0\xB3\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],
        ["\xF3\xB0\xB3\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],
        ["\xF3\xB0\xB3\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],
        ["\xF3\xB0\xB3\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],
        ["\xF3\xB0\xB3\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],
        ["\xF3\xB0\xB3\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],
        ["\xF3\xB0\xB3\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],
        ["\xF3\xB0\xB3\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],
        ["\xF3\xB0\xB3\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],
        ["\xF3\xB0\xB3\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],
        ["\xF3\xB0\xB3\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],
        ["\xF3\xB0\xB3\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],
        ["\xF3\xB0\xB3\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],
        ["\xF3\xB0\xB3\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],
        ["\xF3\xB0\xB3\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],
        ["\xF3\xB0\xB3\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],
        ["\xF3\xB0\xB3\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],
        ["\xF3\xB0\xB3\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],
        ["\xF3\xB0\xB3\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],
        ["\xF3\xB0\xB3\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],
        ["\xF3\xB0\xB3\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],
        ["\xF3\xB0\xB3\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],
        ["\xF3\xB0\xB3\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],
        ["\xF3\xB0\xB3\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],
        ["\xF3\xB0\xB3\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],
        ["\xF3\xB0\xB3\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],
        ["\xF3\xB0\xB3\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],
        ["\xF3\xB0\xB3\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],
        ["\xF3\xB0\xB3\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],
        ["\xF3\xB0\xB3\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],
        ["\xF3\xB0\xB3\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],
        ["\xF3\xB0\xB3\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],
        ["\xF3\xB0\xB3\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],
        ["\xF3\xB0\xB3\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],
        ["\xF3\xB0\xB3\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],
        ["\xF3\xB0\xB3\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],
        ["\xF3\xB0\xB3\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],
        ["\xF3\xB0\xB3\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],
        ["\xF3\xB0\xB3\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],
        ["\xF3\xB0\xB3\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],
        ["\xF3\xB0\xB3\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],
        ["\xF3\xB0\xB3\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],
        ["\xF3\xB0\xB3\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],
        ["\xF3\xB0\xB3\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],
        ["\xF3\xB0\xB3\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],
        ["\xF3\xB0\xB3\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],
        ["\xF3\xB0\xB3\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],
        ["\xF3\xB0\xB4\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],
        ["\xF3\xB0\xB4\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],
        ["\xF3\xB0\xB4\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],
        ["\xF3\xB0\xB4\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],
        ["\xF3\xB0\xB4\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],
        ["\xF3\xB0\xB4\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],
        ["\xF3\xB0\xB4\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],
        ["\xF3\xB0\xB4\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],
        ["\xF3\xB0\xB4\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],
        ["\xF3\xB0\xB4\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],
        ["\xF3\xB0\xB4\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],
        ["\xF3\xB0\xB4\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],
        ["\xF3\xB0\xB4\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],
        ["\xF3\xB0\xB4\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],
        ["\xF3\xB0\xB4\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],
        ["\xF3\xB0\xB4\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],
        ["\xF3\xB0\xB4\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],
        ["\xF3\xB0\xB4\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],
        ["\xF3\xB0\xB4\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],
        ["\xF3\xB0\xB4\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],
        ["\xF3\xB0\xB4\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],
        ["\xF3\xB0\xB4\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],
        ["\xF3\xB0\xB4\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],
        ["\xF3\xB0\xB4\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],
        ["\xF3\xB0\xB4\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],
        ["\xF3\xB0\xB4\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],
        ["\xF3\xB0\xB4\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],
        ["\xF3\xB0\xB4\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],
        ["\xF3\xB0\xB4\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],
        ["\xF3\xB0\xB4\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],
        ["\xF3\xB0\xB4\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],
        ["\xF3\xB0\xB4\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],
        ["\xF3\xB0\xB4\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],
        ["\xF3\xB0\xB4\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],
        ["\xF3\xB0\xB4\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],
        ["\xF3\xB0\xB4\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],
        ["\xF3\xB0\xB4\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],
        ["\xF3\xB0\xB4\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],
        ["\xF3\xB0\xB4\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],
        ["\xF3\xB0\xB4\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],
        ["\xF3\xB0\xB4\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],
        ["\xF3\xB0\xB4\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],
        ["\xF3\xB0\xB4\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],
        ["\xF3\xB0\xB4\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],
        ["\xF3\xB0\xB4\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],
        ["\xF3\xB0\xB4\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],
        ["\xF3\xB0\xB4\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],
        ["\xF3\xB0\xB4\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],
        ["\xF3\xB0\xB4\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],
        ["\xF3\xB0\xB4\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],
        ["\xF3\xB0\xB4\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],
        ["\xF3\xB0\xB4\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],
        ["\xF3\xB0\xB4\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],
        ["\xF3\xB0\xB4\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],
        ["\xF3\xB0\xB4\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],
        ["\xF3\xB0\xB4\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],
        ["\xF3\xB0\xB4\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],
        ["\xF3\xB0\xB4\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],
        ["\xF3\xB0\xB4\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],
        ["\xF3\xB0\xB4\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],
        ["\xF3\xB0\xB4\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],
        ["\xF3\xB0\xB4\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],
        ["\xF3\xB0\xB4\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],
        ["\xF3\xB0\xB4\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],
        ["\xF3\xB0\xB5\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],
        ["\xF3\xB0\xB5\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],
        ["\xF3\xB0\xB5\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],
        ["\xF3\xB0\xB5\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],
        ["\xF3\xB0\xB5\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],
        ["\xF3\xB0\xB5\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],
        ["\xF3\xB0\xB5\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],
        ["\xF3\xB0\xB5\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],
        ["\xF3\xB0\xB5\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],
        ["\xF3\xB0\xB5\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],
        ["\xF3\xB0\xB5\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],
        ["\xF3\xB0\xB5\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],
        ["\xF3\xB0\xB5\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],
        ["\xF3\xB0\xB5\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],
        ["\xF3\xB0\xB5\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],
        ["\xF3\xB0\xB5\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],
        ["\xF3\xB0\xB5\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],
        ["\xF3\xB0\xB5\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],
        ["\xF3\xB0\xB5\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],
        ["\xF3\xB0\xB5\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],
        ["\xF3\xB0\xB5\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],
        ["\xF3\xB0\xB5\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],
        ["\xF3\xB0\xB5\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],
        ["\xF3\xB0\xB5\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],
        ["\xF3\xB0\xB5\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],
        ["\xF3\xB0\xB5\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],
        ["\xF3\xB0\xB5\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],
        ["\xF3\xB0\xB5\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],
        ["\xF3\xB0\xB5\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],
        ["\xF3\xB0\xB5\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],
        ["\xF3\xB0\xB5\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],
        ["\xF3\xB0\xB5\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],
        ["\xF3\xB0\xB5\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],
        ["\xF3\xB0\xB5\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],
        ["\xF3\xB0\xB5\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],
        ["\xF3\xB0\xB5\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],
        ["\xF3\xB0\xB5\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],
        ["\xF3\xB0\xB5\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],
        ["\xF3\xB0\xB5\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],
        ["\xF3\xB0\xB5\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],
        ["\xF3\xB0\xB5\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],
        ["\xF3\xB0\xB5\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],
        ["\xF3\xB0\xB5\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],
        ["\xF3\xB0\xB5\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],
        ["\xF3\xB0\xB5\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],
        ["\xF3\xB0\xB5\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],
        ["\xF3\xB0\xB5\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],
        ["\xF3\xB0\xB5\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],
        ["\xF3\xB0\xB5\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],
        ["\xF3\xB0\xB5\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],
        ["\xF3\xB0\xB5\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],
        ["\xF3\xB0\xB5\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],
        ["\xF3\xB0\xB5\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],
        ["\xF3\xB0\xB5\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],
        ["\xF3\xB0\xB5\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],
        ["\xF3\xB0\xB5\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],
        ["\xF3\xB0\xB5\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],
        ["\xF3\xB0\xB5\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],
        ["\xF3\xB0\xB5\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],
        ["\xF3\xB0\xB5\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],
        ["\xF3\xB0\xB5\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],
        ["\xF3\xB0\xB5\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],
        ["\xF3\xB0\xB5\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],
        ["\xF3\xB0\xB5\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],
        ["\xF3\xB0\xB6\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],
        ["\xF3\xB0\xB6\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],
        ["\xF3\xB0\xB6\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],
        ["\xF3\xB0\xB6\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],
        ["\xF3\xB0\xB6\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],
        ["\xF3\xB0\xB6\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],
        ["\xF3\xB0\xB6\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],
        ["\xF3\xB0\xB6\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],
        ["\xF3\xB0\xB6\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],
        ["\xF3\xB0\xB6\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],
        ["\xF3\xB0\xB6\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],
        ["\xF3\xB0\xB6\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],
        ["\xF3\xB0\xB6\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],
        ["\xF3\xB0\xB6\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],
        ["\xF3\xB0\xB6\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],
        ["\xF3\xB0\xB6\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],
        ["\xF3\xB0\xB6\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],
        ["\xF3\xB0\xB6\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],
        ["\xF3\xB0\xB6\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],
        ["\xF3\xB0\xB6\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],
        ["\xF3\xB0\xB6\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],
        ["\xF3\xB0\xB6\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],
        ["\xF3\xB0\xB6\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],
        ["\xF3\xB0\xB6\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],
        ["\xF3\xB0\xB6\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],
        ["\xF3\xB0\xB6\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],
        ["\xF3\xB0\xB6\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],
        ["\xF3\xB0\xB6\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],
        ["\xF3\xB0\xB6\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],
        ["\xF3\xB0\xB6\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],
        ["\xF3\xB0\xB6\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],
        ["\xF3\xB0\xB6\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],
        ["\xF3\xB0\xB6\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],
        ["\xF3\xB0\xB6\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],
        ["\xF3\xB0\xB6\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],
        ["\xF3\xB0\xB6\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],
        ["\xF3\xB0\xB6\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],
        ["\xF3\xB0\xB6\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],
        ["\xF3\xB0\xB6\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],
        ["\xF3\xB0\xB6\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],
        ["\xF3\xB0\xB6\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],
        ["\xF3\xB0\xB6\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],
        ["\xF3\xB0\xB6\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],
        ["\xF3\xB0\xB6\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],
        ["\xF3\xB0\xB6\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],
        ["\xF3\xB0\xB6\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],
        ["\xF3\xB0\xB6\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],
        ["\xF3\xB0\xB6\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],
        ["\xF3\xB0\xB6\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],
        ["\xF3\xB0\xB6\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],
        ["\xF3\xB0\xB6\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],
        ["\xF3\xB0\xB6\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],
        ["\xF3\xB0\xB6\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],
        ["\xF3\xB0\xB6\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],
        ["\xF3\xB0\xB6\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],
        ["\xF3\xB0\xB6\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],
        ["\xF3\xB0\xB6\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],
        ["\xF3\xB0\xB6\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],
        ["\xF3\xB0\xB6\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],
        ["\xF3\xB0\xB6\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],
        ["\xF3\xB0\xB6\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],
        ["\xF3\xB0\xB6\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],
        ["\xF3\xB0\xB6\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],
        ["\xF3\xB0\xB6\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],
        ["\xF3\xB0\xB7\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],
        ["\xF3\xB0\xB7\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],
        ["\xF3\xB0\xB7\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],
        ["\xF3\xB0\xB7\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],
        ["\xF3\xB0\xB7\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],
        ["\xF3\xB0\xB7\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],
        ["\xF3\xB0\xB7\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],
        ["\xF3\xB0\xB7\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],
        ["\xF3\xB0\xB7\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],
        ["\xF3\xB0\xB7\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],
        ["\xF3\xB0\xB7\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],
        ["\xF3\xB0\xB7\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],
        ["\xF3\xB0\xB7\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],
        ["\xF3\xB0\xB7\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],
        ["\xF3\xB0\xB7\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],
        ["\xF3\xB0\xB7\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],
        ["\xF3\xB0\xB7\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],
        ["\xF3\xB0\xB7\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],
        ["\xF3\xB0\xB7\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],
        ["\xF3\xB0\xB7\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],
        ["\xF3\xB0\xB7\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],
        ["\xF3\xB0\xB7\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],
        ["\xF3\xB0\xB7\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],
        ["\xF3\xB0\xB7\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],
        ["\xF3\xB0\xB7\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],
        ["\xF3\xB0\xB7\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],
        ["\xF3\xB0\xB7\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],
        ["\xF3\xB0\xB7\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],
        ["\xF3\xB0\xB7\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],
        ["\xF3\xB0\xB7\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],
        ["\xF3\xB0\xB7\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],
        ["\xF3\xB0\xB7\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],
        ["\xF3\xB0\xB7\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],
        ["\xF3\xB0\xB7\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],
        ["\xF3\xB0\xB7\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],
        ["\xF3\xB0\xB7\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],
        ["\xF3\xB0\xB7\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],
        ["\xF3\xB0\xB7\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],
        ["\xF3\xB0\xB7\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],
        ["\xF3\xB0\xB7\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],
        ["\xF3\xB0\xB7\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],
        ["\xF3\xB0\xB7\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],
        ["\xF3\xB0\xB7\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],
        ["\xF3\xB0\xB7\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],
        ["\xF3\xB0\xB7\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],
        ["\xF3\xB0\xB7\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],
        ["\xF3\xB0\xB7\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],
        ["\xF3\xB0\xB7\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],
        ["\xF3\xB0\xB7\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],
        ["\xF3\xB0\xB7\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],
        ["\xF3\xB0\xB7\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],
        ["\xF3\xB0\xB7\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],
        ["\xF3\xB0\xB7\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],
        ["\xF3\xB0\xB7\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],
        ["\xF3\xB0\xB7\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],
        ["\xF3\xB0\xB7\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],
        ["\xF3\xB0\xB7\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],
        ["\xF3\xB0\xB7\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],
        ["\xF3\xB0\xB7\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],
        ["\xF3\xB0\xB7\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],
        ["\xF3\xB0\xB7\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],
        ["\xF3\xB0\xB7\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],
        ["\xF3\xB0\xB7\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],
        ["\xF3\xB0\xB7\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],
        ["\xF3\xB0\xB8\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],
        ["\xF3\xB0\xB8\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],
        ["\xF3\xB0\xB8\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],
        ["\xF3\xB0\xB8\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],
        ["\xF3\xB0\xB8\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],
        ["\xF3\xB0\xB8\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],
        ["\xF3\xB0\xB8\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],
        ["\xF3\xB0\xB8\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],
        ["\xF3\xB0\xB8\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],
        ["\xF3\xB0\xB8\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],
        ["\xF3\xB0\xB8\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],
        ["\xF3\xB0\xB8\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],
        ["\xF3\xB0\xB8\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],
        ["\xF3\xB0\xB8\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],
        ["\xF3\xB0\xB8\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],
        ["\xF3\xB0\xB8\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],
        ["\xF3\xB0\xB8\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],
        ["\xF3\xB0\xB8\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],
        ["\xF3\xB0\xB8\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],
        ["\xF3\xB0\xB8\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],
        ["\xF3\xB0\xB8\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],
        ["\xF3\xB0\xB8\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],
        ["\xF3\xB0\xB8\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],
        ["\xF3\xB0\xB8\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],
        ["\xF3\xB0\xB8\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],
        ["\xF3\xB0\xB8\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],
        ["\xF3\xB0\xB8\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],
        ["\xF3\xB0\xB8\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],
        ["\xF3\xB0\xB8\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],
        ["\xF3\xB0\xB8\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],
        ["\xF3\xB0\xB8\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],
        ["\xF3\xB0\xB8\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],
        ["\xF3\xB0\xB8\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],
        ["\xF3\xB0\xB8\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],
        ["\xF3\xB0\xB8\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],
        ["\xF3\xB0\xB8\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],
        ["\xF3\xB0\xB8\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],
        ["\xF3\xB0\xB8\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],
        ["\xF3\xB0\xB8\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],
        ["\xF3\xB0\xB8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],
        ["\xF3\xB0\xB8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],
        ["\xF3\xB0\xB8\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],
        ["\xF3\xB0\xB8\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],
        ["\xF3\xB0\xB8\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],
        ["\xF3\xB0\xB8\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],
        ["\xF3\xB0\xB8\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],
        ["\xF3\xB0\xB8\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],
        ["\xF3\xB0\xB8\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],
        ["\xF3\xB0\xB8\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],
        ["\xF3\xB0\xB8\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],
        ["\xF3\xB0\xB8\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],
        ["\xF3\xB0\xB8\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],
        ["\xF3\xB0\xB8\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],
        ["\xF3\xB0\xB8\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],
        ["\xF3\xB0\xB8\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],
        ["\xF3\xB0\xB8\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],
        ["\xF3\xB0\xB8\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],
        ["\xF3\xB0\xB8\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],
        ["\xF3\xB0\xB8\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],
        ["\xF3\xB0\xB8\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],
        ["\xF3\xB0\xB8\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],
        ["\xF3\xB0\xB8\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],
        ["\xF3\xB0\xB8\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],
        ["\xF3\xB0\xB8\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],
        ["\xF3\xB0\xB9\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],
        ["\xF3\xB0\xB9\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],
        ["\xF3\xB0\xB9\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],
        ["\xF3\xB0\xB9\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],
        ["\xF3\xB0\xB9\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],
        ["\xF3\xB0\xB9\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],
        ["\xF3\xB0\xB9\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],
        ["\xF3\xB0\xB9\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],
        ["\xF3\xB0\xB9\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],
        ["\xF3\xB0\xB9\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],
        ["\xF3\xB0\xB9\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],
        ["\xF3\xB0\xB9\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],
        ["\xF3\xB0\xB9\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],
        ["\xF3\xB0\xB9\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],
        ["\xF3\xB0\xB9\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],
        ["\xF3\xB0\xB9\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],
        ["\xF3\xB0\xB9\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],
        ["\xF3\xB0\xB9\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],
        ["\xF3\xB0\xB9\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],
        ["\xF3\xB0\xB9\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],
        ["\xF3\xB0\xB9\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],
        ["\xF3\xB0\xB9\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],
        ["\xF3\xB0\xB9\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],
        ["\xF3\xB0\xB9\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],
        ["\xF3\xB0\xB9\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],
        ["\xF3\xB0\xB9\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],
        ["\xF3\xB0\xB9\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],
        ["\xF3\xB0\xB9\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],
        ["\xF3\xB0\xB9\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],
        ["\xF3\xB0\xB9\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],
        ["\xF3\xB0\xB9\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],
        ["\xF3\xB0\xB9\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],
        ["\xF3\xB0\xB9\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],
        ["\xF3\xB0\xB9\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],
        ["\xF3\xB0\xB9\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],
        ["\xF3\xB0\xB9\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],
        ["\xF3\xB0\xB9\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],
        ["\xF3\xB0\xB9\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],
        ["\xF3\xB0\xB9\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],
        ["\xF3\xB0\xB9\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],
        ["\xF3\xB0\xB9\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],
        ["\xF3\xB0\xB9\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],
        ["\xF3\xB0\xB9\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],
        ["\xF3\xB0\xB9\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],
        ["\xF3\xB0\xB9\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],
        ["\xF3\xB0\xB9\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],
        ["\xF3\xB0\xB9\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],
        ["\xF3\xB0\xB9\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],
        ["\xF3\xB0\xB9\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],
        ["\xF3\xB0\xB9\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],
        ["\xF3\xB0\xB9\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],
        ["\xF3\xB0\xB9\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],
        ["\xF3\xB0\xB9\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],
        ["\xF3\xB0\xB9\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],
        ["\xF3\xB0\xB9\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],
        ["\xF3\xB0\xB9\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],
        ["\xF3\xB0\xB9\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],
        ["\xF3\xB0\xB9\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],
        ["\xF3\xB0\xB9\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],
        ["\xF3\xB0\xB9\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],
        ["\xF3\xB0\xB9\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],
        ["\xF3\xB0\xB9\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],
        ["\xF3\xB0\xB9\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],
        ["\xF3\xB0\xB9\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],
        ["\xF3\xB0\xBA\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],
        ["\xF3\xB0\xBA\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],
        ["\xF3\xB0\xBA\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],
        ["\xF3\xB0\xBA\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],
        ["\xF3\xB0\xBA\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],
        ["\xF3\xB0\xBA\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],
        ["\xF3\xB0\xBA\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],
        ["\xF3\xB0\xBA\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],
        ["\xF3\xB0\xBA\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],
        ["\xF3\xB0\xBA\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],
        ["\xF3\xB0\xBA\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],
        ["\xF3\xB0\xBA\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],
        ["\xF3\xB0\xBA\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],
        ["\xF3\xB0\xBA\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],
        ["\xF3\xB0\xBA\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],
        ["\xF3\xB0\xBA\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],
        ["\xF3\xB0\xBA\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],
        ["\xF3\xB0\xBA\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],
        ["\xF3\xB0\xBA\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],
        ["\xF3\xB0\xBA\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],
        ["\xF3\xB0\xBA\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],
        ["\xF3\xB0\xBA\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],
        ["\xF3\xB0\xBA\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],
        ["\xF3\xB0\xBA\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],
        ["\xF3\xB0\xBA\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],
        ["\xF3\xB0\xBA\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],
        ["\xF3\xB0\xBA\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],
        ["\xF3\xB0\xBA\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],
        ["\xF3\xB0\xBA\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],
        ["\xF3\xB0\xBA\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],
        ["\xF3\xB0\xBA\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],
        ["\xF3\xB0\xBA\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],
        ["\xF3\xB0\xBA\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],
        ["\xF3\xB0\xBA\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],
        ["\xF3\xB0\xBA\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],
        ["\xF3\xB0\xBA\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],
        ["\xF3\xB0\xBA\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],
        ["\xF3\xB0\xBA\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],
        ["\xF3\xB0\xBA\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],
        ["\xF3\xB0\xBA\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],
        ["\xF3\xB0\xBA\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],
        ["\xF3\xB0\xBA\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],
        ["\xF3\xB0\xBA\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],
        ["\xF3\xB0\xBA\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],
        ["\xF3\xB0\xBA\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],
        ["\xF3\xB0\xBA\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],
        ["\xF3\xB0\xBA\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],
        ["\xF3\xB0\xBA\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],
        ["\xF3\xB0\xBA\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],
        ["\xF3\xB0\xBA\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],
        ["\xF3\xB0\xBA\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],
        ["\xF3\xB0\xBA\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],
        ["\xF3\xB0\xBA\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],
        ["\xF3\xB0\xBA\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],
        ["\xF3\xB0\xBA\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],
        ["\xF3\xB0\xBA\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],
        ["\xF3\xB0\xBA\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],
        ["\xF3\xB0\xBA\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],
        ["\xF3\xB0\xBA\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],
        ["\xF3\xB0\xBA\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],
        ["\xF3\xB0\xBA\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],
        ["\xF3\xB0\xBA\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],
        ["\xF3\xB0\xBA\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],
        ["\xF3\xB0\xBA\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],
        ["\xF3\xB0\xBB\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],
        ["\xF3\xB0\xBB\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],
        ["\xF3\xB0\xBB\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],
        ["\xF3\xB0\xBB\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],
        ["\xF3\xB0\xBB\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],
        ["\xF3\xB0\xBB\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],
        ["\xF3\xB0\xBB\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],
        ["\xF3\xB0\xBB\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],
        ["\xF3\xB0\xBB\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],
        ["\xF3\xB0\xBB\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],
        ["\xF3\xB0\xBB\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],
        ["\xF3\xB0\xBB\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],
        ["\xF3\xB0\xBB\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],
        ["\xF3\xB0\xBB\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],
        ["\xF3\xB0\xBB\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],
        ["\xF3\xB0\xBB\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],
        ["\xF3\xB0\xBB\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],
        ["\xF3\xB0\xBB\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],
        ["\xF3\xB0\xBB\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],
        ["\xF3\xB0\xBB\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],
        ["\xF3\xB0\xBB\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],
        ["\xF3\xB0\xBB\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],
        ["\xF3\xB0\xBB\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],
        ["\xF3\xB0\xBB\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],
        ["\xF3\xB0\xBB\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],
        ["\xF3\xB0\xBB\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],
        ["\xF3\xB0\xBB\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],
        ["\xF3\xB0\xBB\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],
        ["\xF3\xB0\xBB\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],
        ["\xF3\xB0\xBB\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],
        ["\xF3\xB0\xBB\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],
        ["\xF3\xB0\xBB\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],
        ["\xF3\xB0\xBB\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],
        ["\xF3\xB0\xBB\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],
        ["\xF3\xB0\xBB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],
        ["\xF3\xB0\xBB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],
        ["\xF3\xB0\xBB\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],
        ["\xF3\xB0\xBB\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],
        ["\xF3\xB0\xBB\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],
        ["\xF3\xB0\xBB\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],
        ["\xF3\xB0\xBB\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],
        ["\xF3\xB0\xBB\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],
        ["\xF3\xB0\xBB\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],
        ["\xF3\xB0\xBB\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],
        ["\xF3\xB0\xBB\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],
        ["\xF3\xB0\xBB\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],
        ["\xF3\xB0\xBB\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],
        ["\xF3\xB0\xBB\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],
        ["\xF3\xB0\xBB\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],
        ["\xF3\xB0\xBB\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],
        ["\xF3\xB0\xBB\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],
        ["\xF3\xB0\xBB\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],
        ["\xF3\xB0\xBB\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],
        ["\xF3\xB0\xBB\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],
        ["\xF3\xB0\xBB\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],
        ["\xF3\xB0\xBB\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],
        ["\xF3\xB0\xBB\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],
        ["\xF3\xB0\xBB\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],
        ["\xF3\xB0\xBB\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],
        ["\xF3\xB0\xBB\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],
        ["\xF3\xB0\xBB\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],
        ["\xF3\xB0\xBB\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],
        ["\xF3\xB0\xBB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],
        ["\xF3\xB0\xBB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],
        ["\xF3\xB0\xBC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],
        ["\xF3\xB0\xBC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],
        ["\xF3\xB0\xBC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],
        ["\xF3\xB0\xBC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],
        ["\xF3\xB0\xBC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],
        ["\xF3\xB0\xBC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],
        ["\xF3\xB0\xBC\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],
        ["\xF3\xB0\xBC\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],
        ["\xF3\xB0\xBC\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],
        ["\xF3\xB0\xBC\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],
        ["\xF3\xB0\xBC\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],
        ["\xF3\xB0\xBC\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],
        ["\xF3\xB0\xBC\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],
        ["\xF3\xB0\xBC\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],
        ["\xF3\xB0\xBC\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],
        ["\xF3\xB0\xBC\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],
        ["\xF3\xB0\xBC\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],
        ["\xF3\xB0\xBC\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],
        ["\xF3\xB0\xBC\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],
        ["\xF3\xB0\xBC\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],
        ["\xF3\xB0\xBC\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],
        ["\xF3\xB0\xBC\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],
        ["\xF3\xB0\xBC\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],
        ["\xF3\xB0\xBC\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],
        ["\xF3\xB0\xBC\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],
        ["\xF3\xB0\xBC\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],
        ["\xF3\xB0\xBC\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],
        ["\xF3\xB0\xBC\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],
        ["\xF3\xB0\xBC\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],
        ["\xF3\xB0\xBC\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],
        ["\xF3\xB0\xBC\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],
        ["\xF3\xB0\xBC\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],
        ["\xF3\xB0\xBC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],
        ["\xF3\xB0\xBC\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],
        ["\xF3\xB0\xBC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],
        ["\xF3\xB0\xBC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],
        ["\xF3\xB0\xBC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],
        ["\xF3\xB0\xBC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],
        ["\xF3\xB0\xBC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],
        ["\xF3\xB0\xBC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],
        ["\xF3\xB0\xBC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],
        ["\xF3\xB0\xBC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],
        ["\xF3\xB0\xBC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],
        ["\xF3\xB0\xBC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],
        ["\xF3\xB0\xBC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],
        ["\xF3\xB0\xBC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],
        ["\xF3\xB0\xBC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],
        ["\xF3\xB0\xBC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],
        ["\xF3\xB0\xBC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],
        ["\xF3\xB0\xBC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],
        ["\xF3\xB0\xBC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],
        ["\xF3\xB0\xBC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],
        ["\xF3\xB0\xBC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],
        ["\xF3\xB0\xBC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],
        ["\xF3\xB0\xBC\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],
        ["\xF3\xB0\xBC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],
        ["\xF3\xB0\xBC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],
        ["\xF3\xB0\xBC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],
        ["\xF3\xB0\xBC\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],
        ["\xF3\xB0\xBC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],
        ["\xF3\xB0\xBC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],
        ["\xF3\xB0\xBC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],
        ["\xF3\xB0\xBC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],
        ["\xF3\xB0\xBC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],
        ["\xF3\xB0\xBD\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],
        ["\xF3\xB0\xBD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],
        ["\xF3\xB0\xBD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],
        ["\xF3\xB0\xBD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],
        ["\xF3\xB0\xBD\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],
        ["\xF3\xB0\xBD\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],
        ["\xF3\xB0\xBD\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],
        ["\xF3\xB0\xBD\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],
        ["\xF3\xB0\xBD\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],
        ["\xF3\xB0\xBD\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],
        ["\xF3\xB0\xBD\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],
        ["\xF3\xB0\xBD\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],
        ["\xF3\xB0\xBD\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],
        ["\xF3\xB0\xBD\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],
        ["\xF3\xB0\xBD\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],
        ["\xF3\xB0\xBD\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],
        ["\xF3\xB0\xBD\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],
        ["\xF3\xB0\xBD\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],
        ["\xF3\xB0\xBD\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],
        ["\xF3\xB0\xBD\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],
        ["\xF3\xB0\xBD\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],
        ["\xF3\xB0\xBD\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],
        ["\xF3\xB0\xBD\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],
        ["\xF3\xB0\xBD\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],
        ["\xF3\xB0\xBD\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],
        ["\xF3\xB0\xBD\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],
        ["\xF3\xB0\xBD\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],
        ["\xF3\xB0\xBD\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],
        ["\xF3\xB0\xBD\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],
        ["\xF3\xB0\xBD\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],
        ["\xF3\xB0\xBD\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],
        ["\xF3\xB0\xBD\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],
        ["\xF3\xB0\xBD\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],
        ["\xF3\xB0\xBD\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],
        ["\xF3\xB0\xBD\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],
        ["\xF3\xB0\xBD\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],
        ["\xF3\xB0\xBD\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],
        ["\xF3\xB0\xBD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],
        ["\xF3\xB0\xBD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],
        ["\xF3\xB0\xBD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],
        ["\xF3\xB0\xBD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],
        ["\xF3\xB0\xBD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],
        ["\xF3\xB0\xBD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],
        ["\xF3\xB0\xBD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],
        ["\xF3\xB0\xBD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],
        ["\xF3\xB0\xBD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],
        ["\xF3\xB0\xBD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],
        ["\xF3\xB0\xBD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],
        ["\xF3\xB0\xBD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],
        ["\xF3\xB0\xBD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],
        ["\xF3\xB0\xBD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],
        ["\xF3\xB0\xBD\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],
        ["\xF3\xB0\xBD\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],
        ["\xF3\xB0\xBD\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],
        ["\xF3\xB0\xBD\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],
        ["\xF3\xB0\xBD\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],
        ["\xF3\xB0\xBD\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],
        ["\xF3\xB0\xBD\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],
        ["\xF3\xB0\xBD\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],
        ["\xF3\xB0\xBD\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],
        ["\xF3\xB0\xBD\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],
        ["\xF3\xB0\xBD\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],
        ["\xF3\xB0\xBD\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],
        ["\xF3\xB0\xBD\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],
        ["\xF3\xB0\xBE\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],
        ["\xF3\xB0\xBE\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],
        ["\xF3\xB0\xBE\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],
        ["\xF3\xB0\xBE\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],
        ["\xF3\xB0\xBE\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],
        ["\xF3\xB0\xBE\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],
        ["\xF3\xB0\xBE\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],
        ["\xF3\xB0\xBE\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],
        ["\xF3\xB0\xBE\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],
        ["\xF3\xB0\xBE\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],
        ["\xF3\xB0\xBE\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],
        ["\xF3\xB0\xBE\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],
        ["\xF3\xB0\xBE\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],
        ["\xF3\xB0\xBE\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],
        ["\xF3\xB0\xBE\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],
        ["\xF3\xB0\xBE\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],
        ["\xF3\xB0\xBE\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],
        ["\xF3\xB0\xBE\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],
        ["\xF3\xB0\xBE\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],
        ["\xF3\xB0\xBE\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],
        ["\xF3\xB0\xBE\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],
        ["\xF3\xB0\xBE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],
        ["\xF3\xB0\xBE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],
        ["\xF3\xB0\xBE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],
        ["\xF3\xB0\xBE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],
        ["\xF3\xB0\xBE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],
        ["\xF3\xB0\xBE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],
        ["\xF3\xB0\xBE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],
        ["\xF3\xB0\xBE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],
        ["\xF3\xB0\xBE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],
        ["\xF3\xB0\xBE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],
        ["\xF3\xB0\xBE\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],
        ["\xF3\xB0\xBE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],
        ["\xF3\xB0\xBE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],
        ["\xF3\xB0\xBE\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],
        ["\xF3\xB0\xBE\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],
        ["\xF3\xB0\xBE\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],
        ["\xF3\xB0\xBE\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],
        ["\xF3\xB0\xBE\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],
        ["\xF3\xB0\xBE\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],
        ["\xF3\xB0\xBE\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],
        ["\xF3\xB0\xBE\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],
        ["\xF3\xB0\xBE\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],
        ["\xF3\xB0\xBE\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],
        ["\xF3\xB0\xBE\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],
        ["\xF3\xB0\xBE\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],
        ["\xF3\xB0\xBE\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],
        ["\xF3\xB0\xBE\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],
        ["\xF3\xB0\xBE\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],
        ["\xF3\xB0\xBE\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],
        ["\xF3\xB0\xBE\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],
        ["\xF3\xB0\xBE\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],
        ["\xF3\xB0\xBE\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],
        ["\xF3\xB0\xBE\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],
        ["\xF3\xB0\xBE\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],
        ["\xF3\xB0\xBE\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],
        ["\xF3\xB0\xBE\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],
        ["\xF3\xB0\xBE\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],
        ["\xF3\xB0\xBE\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],
        ["\xF3\xB0\xBE\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],
        ["\xF3\xB0\xBE\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],
        ["\xF3\xB0\xBE\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],
        ["\xF3\xB0\xBE\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],
        ["\xF3\xB0\xBE\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],
        ["\xF3\xB0\xBF\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],
        ["\xF3\xB0\xBF\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],
        ["\xF3\xB0\xBF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],
        ["\xF3\xB0\xBF\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],
        ["\xF3\xB0\xBF\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],
        ["\xF3\xB0\xBF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],
        ["\xF3\xB0\xBF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],
        ["\xF3\xB0\xBF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],
        ["\xF3\xB0\xBF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],
        ["\xF3\xB0\xBF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],
        ["\xF3\xB0\xBF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],
        ["\xF3\xB0\xBF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],
        ["\xF3\xB0\xBF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],
        ["\xF3\xB0\xBF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],
        ["\xF3\xB0\xBF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],
        ["\xF3\xB0\xBF\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],
        ["\xF3\xB0\xBF\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],
        ["\xF3\xB0\xBF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],
        ["\xF3\xB0\xBF\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],
        ["\xF3\xB0\xBF\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],
        ["\xF3\xB0\xBF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],
        ["\xF3\xB0\xBF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],
        ["\xF3\xB0\xBF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],
        ["\xF3\xB0\xBF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],
        ["\xF3\xB0\xBF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],
        ["\xF3\xB0\xBF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],
        ["\xF3\xB0\xBF\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],
        ["\xF3\xB0\xBF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],
        ["\xF3\xB0\xBF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],
        ["\xF3\xB0\xBF\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],
        ["\xF3\xB0\xBF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],
        ["\xF3\xB0\xBF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],
        ["\xF3\xB0\xBF\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],
        ["\xF3\xB0\xBF\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],
        ["\xF3\xB0\xBF\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],
        ["\xF3\xB0\xBF\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],
        ["\xF3\xB0\xBF\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],
        ["\xF3\xB0\xBF\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],
        ["\xF3\xB0\xBF\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],
        ["\xF3\xB0\xBF\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],
        ["\xF3\xB0\xBF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],
        ["\xF3\xB0\xBF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],
        ["\xF3\xB0\xBF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],
        ["\xF3\xB0\xBF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],
        ["\xF3\xB0\xBF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],
        ["\xF3\xB0\xBF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],
        ["\xF3\xB0\xBF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],
        ["\xF3\xB0\xBF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],
        ["\xF3\xB0\xBF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],
        ["\xF3\xB0\xBF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],
        ["\xF3\xB0\xBF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],
        ["\xF3\xB0\xBF\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],
        ["\xF3\xB0\xBF\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],
        ["\xF3\xB0\xBF\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],
        ["\xF3\xB0\xBF\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],
        ["\xF3\xB0\xBF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],
        ["\xF3\xB0\xBF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],
        ["\xF3\xB0\xBF\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],
        ["\xF3\xB0\xBF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],
        ["\xF3\xB0\xBF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],
        ["\xF3\xB0\xBF\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],
        ["\xF3\xB0\xBF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],
        ["\xF3\xB0\xBF\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],
        ["\xF3\xB0\xBF\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],
        ["\xF3\xB1\x80\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],
        ["\xF3\xB1\x80\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],
        ["\xF3\xB1\x80\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],
        ["\xF3\xB1\x80\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],
        ["\xF3\xB1\x80\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],
        ["\xF3\xB1\x80\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],
        ["\xF3\xB1\x80\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],
        ["\xF3\xB1\x80\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],
        ["\xF3\xB1\x80\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],
        ["\xF3\xB1\x80\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],
        ["\xF3\xB1\x80\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],
        ["\xF3\xB1\x80\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],
        ["\xF3\xB1\x80\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],
        ["\xF3\xB1\x80\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],
        ["\xF3\xB1\x80\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],
        ["\xF3\xB1\x80\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],
        ["\xF3\xB1\x80\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],
        ["\xF3\xB1\x80\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],
        ["\xF3\xB1\x80\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],
        ["\xF3\xB1\x80\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],
        ["\xF3\xB1\x80\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],
        ["\xF3\xB1\x80\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],
        ["\xF3\xB1\x80\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],
        ["\xF3\xB1\x80\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],
        ["\xF3\xB1\x80\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],
        ["\xF3\xB1\x80\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],
        ["\xF3\xB1\x80\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],
        ["\xF3\xB1\x80\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],
        ["\xF3\xB1\x80\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],
        ["\xF3\xB1\x80\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],
        ["\xF3\xB1\x80\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],
        ["\xF3\xB1\x80\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],
        ["\xF3\xB1\x80\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],
        ["\xF3\xB1\x80\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],
        ["\xF3\xB1\x80\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],
        ["\xF3\xB1\x80\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],
        ["\xF3\xB1\x80\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],
        ["\xF3\xB1\x80\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],
        ["\xF3\xB1\x80\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],
        ["\xF3\xB1\x80\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],
        ["\xF3\xB1\x80\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],
        ["\xF3\xB1\x80\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],
        ["\xF3\xB1\x80\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],
        ["\xF3\xB1\x80\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],
        ["\xF3\xB1\x80\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],
        ["\xF3\xB1\x80\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],
        ["\xF3\xB1\x80\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],
        ["\xF3\xB1\x80\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],
        ["\xF3\xB1\x80\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],
        ["\xF3\xB1\x80\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],
        ["\xF3\xB1\x80\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],
        ["\xF3\xB1\x80\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],
        ["\xF3\xB1\x80\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],
        ["\xF3\xB1\x80\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],
        ["\xF3\xB1\x80\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],
        ["\xF3\xB1\x80\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],
        ["\xF3\xB1\x80\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],
        ["\xF3\xB1\x80\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],
        ["\xF3\xB1\x80\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],
        ["\xF3\xB1\x80\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],
        ["\xF3\xB1\x80\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],
        ["\xF3\xB1\x80\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],
        ["\xF3\xB1\x80\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],
        ["\xF3\xB1\x80\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],
        ["\xF3\xB1\x81\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],
        ["\xF3\xB1\x81\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],
        ["\xF3\xB1\x81\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],
        ["\xF3\xB1\x81\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],
        ["\xF3\xB1\x81\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],
        ["\xF3\xB1\x81\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],
        ["\xF3\xB1\x81\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],
        ["\xF3\xB1\x81\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],
        ["\xF3\xB1\x81\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],
        ["\xF3\xB1\x81\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],
        ["\xF3\xB1\x81\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],
        ["\xF3\xB1\x81\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],
        ["\xF3\xB1\x81\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],
        ["\xF3\xB1\x81\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],
        ["\xF3\xB1\x81\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],
        ["\xF3\xB1\x81\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],
        ["\xF3\xB1\x81\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],
        ["\xF3\xB1\x81\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],
        ["\xF3\xB1\x81\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],
        ["\xF3\xB1\x81\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],
        ["\xF3\xB1\x81\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],
        ["\xF3\xB1\x81\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],
        ["\xF3\xB1\x81\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],
        ["\xF3\xB1\x81\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],
        ["\xF3\xB1\x81\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],
        ["\xF3\xB1\x81\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],
        ["\xF3\xB1\x81\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],
        ["\xF3\xB1\x81\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],
        ["\xF3\xB1\x81\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],
        ["\xF3\xB1\x81\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],
        ["\xF3\xB1\x81\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],
        ["\xF3\xB1\x81\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],
        ["\xF3\xB1\x81\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],
        ["\xF3\xB1\x81\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],
        ["\xF3\xB1\x81\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],
        ["\xF3\xB1\x81\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],
        ["\xF3\xB1\x81\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],
        ["\xF3\xB1\x81\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],
        ["\xF3\xB1\x81\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],
        ["\xF3\xB1\x81\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],
        ["\xF3\xB1\x81\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],
        ["\xF3\xB1\x81\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],
        ["\xF3\xB1\x81\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],
        ["\xF3\xB1\x81\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],
        ["\xF3\xB1\x81\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],
        ["\xF3\xB1\x81\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],
        ["\xF3\xB1\x81\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],
        ["\xF3\xB1\x81\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],
        ["\xF3\xB1\x81\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],
        ["\xF3\xB1\x81\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],
        ["\xF3\xB1\x81\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],
        ["\xF3\xB1\x81\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],
        ["\xF3\xB1\x81\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],
        ["\xF3\xB1\x81\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],
        ["\xF3\xB1\x81\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],
        ["\xF3\xB1\x81\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],
        ["\xF3\xB1\x81\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],
        ["\xF3\xB1\x81\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],
        ["\xF3\xB1\x81\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],
        ["\xF3\xB1\x81\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],
        ["\xF3\xB1\x81\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],
        ["\xF3\xB1\x81\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],
        ["\xF3\xB1\x81\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],
        ["\xF3\xB1\x81\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],
        ["\xF3\xB1\x82\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],
        ["\xF3\xB1\x82\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],
        ["\xF3\xB1\x82\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],
        ["\xF3\xB1\x82\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],
        ["\xF3\xB1\x82\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],
        ["\xF3\xB1\x82\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],
        ["\xF3\xB1\x82\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],
        ["\xF3\xB1\x82\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],
        ["\xF3\xB1\x82\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],
        ["\xF3\xB1\x82\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],
        ["\xF3\xB1\x82\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],
        ["\xF3\xB1\x82\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],
        ["\xF3\xB1\x82\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],
        ["\xF3\xB1\x82\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],
        ["\xF3\xB1\x82\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],
        ["\xF3\xB1\x82\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],
        ["\xF3\xB1\x82\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],
        ["\xF3\xB1\x82\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],
        ["\xF3\xB1\x82\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],
        ["\xF3\xB1\x82\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],
        ["\xF3\xB1\x82\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],
        ["\xF3\xB1\x82\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],
        ["\xF3\xB1\x82\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],
        ["\xF3\xB1\x82\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],
        ["\xF3\xB1\x82\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],
        ["\xF3\xB1\x82\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],
        ["\xF3\xB1\x82\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],
        ["\xF3\xB1\x82\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],
        ["\xF3\xB1\x82\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],
        ["\xF3\xB1\x82\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],
        ["\xF3\xB1\x82\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],
        ["\xF3\xB1\x82\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],
        ["\xF3\xB1\x82\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],
        ["\xF3\xB1\x82\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],
        ["\xF3\xB1\x82\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],
        ["\xF3\xB1\x82\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],
        ["\xF3\xB1\x82\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],
        ["\xF3\xB1\x82\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],
        ["\xF3\xB1\x82\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],
        ["\xF3\xB1\x82\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],
        ["\xF3\xB1\x82\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],
        ["\xF3\xB1\x82\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],
        ["\xF3\xB1\x82\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],
        ["\xF3\xB1\x82\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],
        ["\xF3\xB1\x82\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],
        ["\xF3\xB1\x82\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],
        ["\xF3\xB1\x82\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],
        ["\xF3\xB1\x82\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],
        ["\xF3\xB1\x82\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],
        ["\xF3\xB1\x82\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],
        ["\xF3\xB1\x82\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],
        ["\xF3\xB1\x82\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],
        ["\xF3\xB1\x82\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],
        ["\xF3\xB1\x82\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],
        ["\xF3\xB1\x82\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],
        ["\xF3\xB1\x82\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],
        ["\xF3\xB1\x82\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],
        ["\xF3\xB1\x82\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],
        ["\xF3\xB1\x82\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],
        ["\xF3\xB1\x82\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],
        ["\xF3\xB1\x82\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],
        ["\xF3\xB1\x82\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],
        ["\xF3\xB1\x82\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],
        ["\xF3\xB1\x82\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],
        ["\xF3\xB1\x83\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],
        ["\xF3\xB1\x83\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],
        ["\xF3\xB1\x83\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],
        ["\xF3\xB1\x83\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],
        ["\xF3\xB1\x83\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],
        ["\xF3\xB1\x83\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],
        ["\xF3\xB1\x83\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],
        ["\xF3\xB1\x83\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],
        ["\xF3\xB1\x83\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],
        ["\xF3\xB1\x83\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],
        ["\xF3\xB1\x83\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],
        ["\xF3\xB1\x83\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],
        ["\xF3\xB1\x83\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],
        ["\xF3\xB1\x83\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],
        ["\xF3\xB1\x83\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],
        ["\xF3\xB1\x83\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],
        ["\xF3\xB1\x83\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],
        ["\xF3\xB1\x83\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],
        ["\xF3\xB1\x83\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],
        ["\xF3\xB1\x83\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],
        ["\xF3\xB1\x83\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],
        ["\xF3\xB1\x83\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],
        ["\xF3\xB1\x83\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],
        ["\xF3\xB1\x83\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],
        ["\xF3\xB1\x83\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],
        ["\xF3\xB1\x83\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],
        ["\xF3\xB1\x83\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],
        ["\xF3\xB1\x83\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],
        ["\xF3\xB1\x83\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],
        ["\xF3\xB1\x83\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],
        ["\xF3\xB1\x83\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],
        ["\xF3\xB1\x83\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],
        ["\xF3\xB1\x83\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],
        ["\xF3\xB1\x83\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],
        ["\xF3\xB1\x83\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],
        ["\xF3\xB1\x83\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],
        ["\xF3\xB1\x83\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],
        ["\xF3\xB1\x83\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],
        ["\xF3\xB1\x83\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],
        ["\xF3\xB1\x83\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],
        ["\xF3\xB1\x83\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],
        ["\xF3\xB1\x83\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],
        ["\xF3\xB1\x83\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],
        ["\xF3\xB1\x83\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],
        ["\xF3\xB1\x83\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],
        ["\xF3\xB1\x83\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],
        ["\xF3\xB1\x83\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],
        ["\xF3\xB1\x83\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],
        ["\xF3\xB1\x83\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],
        ["\xF3\xB1\x83\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],
        ["\xF3\xB1\x83\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],
        ["\xF3\xB1\x83\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],
        ["\xF3\xB1\x83\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],
        ["\xF3\xB1\x83\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],
        ["\xF3\xB1\x83\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],
        ["\xF3\xB1\x83\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],
        ["\xF3\xB1\x83\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],
        ["\xF3\xB1\x83\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],
        ["\xF3\xB1\x83\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],
        ["\xF3\xB1\x83\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],
        ["\xF3\xB1\x83\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],
        ["\xF3\xB1\x83\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],
        ["\xF3\xB1\x83\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],
        ["\xF3\xB1\x83\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],
        ["\xF3\xB1\x84\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],
        ["\xF3\xB1\x84\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],
        ["\xF3\xB1\x84\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],
        ["\xF3\xB1\x84\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],
        ["\xF3\xB1\x84\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],
        ["\xF3\xB1\x84\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],
        ["\xF3\xB1\x84\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],
        ["\xF3\xB1\x84\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],
        ["\xF3\xB1\x84\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],
        ["\xF3\xB1\x84\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],
        ["\xF3\xB1\x84\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],
        ["\xF3\xB1\x84\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],
        ["\xF3\xB1\x84\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],
        ["\xF3\xB1\x84\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],
        ["\xF3\xB1\x84\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],
        ["\xF3\xB1\x84\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],
        ["\xF3\xB1\x84\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],
        ["\xF3\xB1\x84\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],
        ["\xF3\xB1\x84\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],
        ["\xF3\xB1\x84\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],
        ["\xF3\xB1\x84\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],
        ["\xF3\xB1\x84\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],
        ["\xF3\xB1\x84\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],
        ["\xF3\xB1\x84\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],
        ["\xF3\xB1\x84\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],
        ["\xF3\xB1\x84\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],
        ["\xF3\xB1\x84\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],
        ["\xF3\xB1\x84\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],
        ["\xF3\xB1\x84\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],
        ["\xF3\xB1\x84\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],
        ["\xF3\xB1\x84\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],
        ["\xF3\xB1\x84\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],
        ["\xF3\xB1\x84\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],
        ["\xF3\xB1\x84\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],
        ["\xF3\xB1\x84\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],
        ["\xF3\xB1\x84\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],
        ["\xF3\xB1\x84\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],
        ["\xF3\xB1\x84\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],
        ["\xF3\xB1\x84\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],
        ["\xF3\xB1\x84\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],
        ["\xF3\xB1\x84\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],
        ["\xF3\xB1\x84\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],
        ["\xF3\xB1\x84\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],
        ["\xF3\xB1\x84\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],
        ["\xF3\xB1\x84\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],
        ["\xF3\xB1\x84\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],
        ["\xF3\xB1\x84\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],
        ["\xF3\xB1\x84\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],
        ["\xF3\xB1\x84\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],
        ["\xF3\xB1\x84\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],
        ["\xF3\xB1\x84\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],
        ["\xF3\xB1\x84\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],
        ["\xF3\xB1\x84\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],
        ["\xF3\xB1\x84\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],
        ["\xF3\xB1\x84\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],
        ["\xF3\xB1\x84\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],
        ["\xF3\xB1\x84\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],
        ["\xF3\xB1\x84\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],
        ["\xF3\xB1\x84\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],
        ["\xF3\xB1\x84\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],
        ["\xF3\xB1\x84\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],
        ["\xF3\xB1\x84\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],
        ["\xF3\xB1\x84\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],
        ["\xF3\xB1\x84\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],
        ["\xF3\xB1\x85\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],
        ["\xF3\xB1\x85\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],
        ["\xF3\xB1\x85\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],
        ["\xF3\xB1\x85\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],
        ["\xF3\xB1\x85\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],
        ["\xF3\xB1\x85\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],
        ["\xF3\xB1\x85\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],
        ["\xF3\xB1\x85\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],
        ["\xF3\xB1\x85\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],
        ["\xF3\xB1\x85\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],
        ["\xF3\xB1\x85\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],
        ["\xF3\xB1\x85\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],
        ["\xF3\xB1\x85\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],
        ["\xF3\xB1\x85\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],
        ["\xF3\xB1\x85\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],
        ["\xF3\xB1\x85\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],
        ["\xF3\xB1\x85\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],
        ["\xF3\xB1\x85\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],
        ["\xF3\xB1\x85\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],
        ["\xF3\xB1\x85\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],
        ["\xF3\xB1\x85\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],
        ["\xF3\xB1\x85\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],
        ["\xF3\xB1\x85\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],
        ["\xF3\xB1\x85\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],
        ["\xF3\xB1\x85\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],
        ["\xF3\xB1\x85\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],
        ["\xF3\xB1\x85\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],
        ["\xF3\xB1\x85\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],
        ["\xF3\xB1\x85\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],
        ["\xF3\xB1\x85\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],
        ["\xF3\xB1\x85\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],
        ["\xF3\xB1\x85\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],
        ["\xF3\xB1\x85\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],
        ["\xF3\xB1\x85\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],
        ["\xF3\xB1\x85\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],
        ["\xF3\xB1\x85\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],
        ["\xF3\xB1\x85\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],
        ["\xF3\xB1\x85\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],
        ["\xF3\xB1\x85\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],
        ["\xF3\xB1\x85\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],
        ["\xF3\xB1\x85\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],
        ["\xF3\xB1\x85\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],
        ["\xF3\xB1\x85\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],
        ["\xF3\xB1\x85\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],
        ["\xF3\xB1\x85\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],
        ["\xF3\xB1\x85\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],
        ["\xF3\xB1\x85\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],
        ["\xF3\xB1\x85\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],
        ["\xF3\xB1\x85\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],
        ["\xF3\xB1\x85\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],
        ["\xF3\xB1\x85\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],
        ["\xF3\xB1\x85\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],
        ["\xF3\xB1\x85\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],
        ["\xF3\xB1\x85\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],
        ["\xF3\xB1\x85\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],
        ["\xF3\xB1\x85\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],
        ["\xF3\xB1\x85\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],
        ["\xF3\xB1\x85\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],
        ["\xF3\xB1\x85\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],
        ["\xF3\xB1\x85\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],
        ["\xF3\xB1\x85\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],
        ["\xF3\xB1\x85\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],
        ["\xF3\xB1\x85\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],
        ["\xF3\xB1\x85\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],
        ["\xF3\xB1\x86\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],
        ["\xF3\xB1\x86\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],
        ["\xF3\xB1\x86\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],
        ["\xF3\xB1\x86\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],
        ["\xF3\xB1\x86\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],
        ["\xF3\xB1\x86\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],
        ["\xF3\xB1\x86\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],
        ["\xF3\xB1\x86\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],
        ["\xF3\xB1\x86\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],
        ["\xF3\xB1\x86\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],
        ["\xF3\xB1\x86\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],
        ["\xF3\xB1\x86\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],
        ["\xF3\xB1\x86\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],
        ["\xF3\xB1\x86\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],
        ["\xF3\xB1\x86\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],
        ["\xF3\xB1\x86\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],
        ["\xF3\xB1\x86\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],
        ["\xF3\xB1\x86\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],
        ["\xF3\xB1\x86\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],
        ["\xF3\xB1\x86\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],
        ["\xF3\xB1\x86\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],
        ["\xF3\xB1\x86\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],
        ["\xF3\xB1\x86\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],
        ["\xF3\xB1\x86\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],
        ["\xF3\xB1\x86\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],
        ["\xF3\xB1\x86\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],
        ["\xF3\xB1\x86\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],
        ["\xF3\xB1\x86\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],
        ["\xF3\xB1\x86\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],
        ["\xF3\xB1\x86\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],
        ["\xF3\xB1\x86\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],
        ["\xF3\xB1\x86\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],
        ["\xF3\xB1\x86\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],
        ["\xF3\xB1\x86\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],
        ["\xF3\xB1\x86\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],
        ["\xF3\xB1\x86\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],
        ["\xF3\xB1\x86\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],
        ["\xF3\xB1\x86\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],
        ["\xF3\xB1\x86\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],
        ["\xF3\xB1\x86\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],
        ["\xF3\xB1\x86\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],
        ["\xF3\xB1\x86\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],
        ["\xF3\xB1\x86\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],
        ["\xF3\xB1\x86\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],
        ["\xF3\xB1\x86\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],
        ["\xF3\xB1\x86\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],
        ["\xF3\xB1\x86\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],
        ["\xF3\xB1\x86\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],
        ["\xF3\xB1\x86\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],
        ["\xF3\xB1\x86\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],
        ["\xF3\xB1\x86\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],
        ["\xF3\xB1\x86\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],
        ["\xF3\xB1\x86\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],
        ["\xF3\xB1\x86\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],
        ["\xF3\xB1\x86\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],
        ["\xF3\xB1\x86\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],
        ["\xF3\xB1\x86\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],
        ["\xF3\xB1\x86\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],
        ["\xF3\xB1\x86\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],
        ["\xF3\xB1\x86\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],
        ["\xF3\xB1\x86\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],
        ["\xF3\xB1\x86\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],
        ["\xF3\xB1\x86\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],
        ["\xF3\xB1\x86\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],
        ["\xF3\xB1\x87\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],
        ["\xF3\xB1\x87\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],
        ["\xF3\xB1\x87\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],
        ["\xF3\xB1\x87\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],
        ["\xF3\xB1\x87\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],
        ["\xF3\xB1\x87\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],
        ["\xF3\xB1\x87\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],
        ["\xF3\xB1\x87\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],
        ["\xF3\xB1\x87\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],
        ["\xF3\xB1\x87\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],
        ["\xF3\xB1\x87\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],
        ["\xF3\xB1\x87\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],
        ["\xF3\xB1\x87\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],
        ["\xF3\xB1\x87\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],
        ["\xF3\xB1\x87\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],
        ["\xF3\xB1\x87\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],
        ["\xF3\xB1\x87\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],
        ["\xF3\xB1\x87\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],
        ["\xF3\xB1\x87\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],
        ["\xF3\xB1\x87\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],
        ["\xF3\xB1\x87\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],
        ["\xF3\xB1\x87\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],
        ["\xF3\xB1\x87\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],
        ["\xF3\xB1\x87\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],
        ["\xF3\xB1\x87\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],
        ["\xF3\xB1\x87\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],
        ["\xF3\xB1\x87\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],
        ["\xF3\xB1\x87\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],
        ["\xF3\xB1\x87\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],
        ["\xF3\xB1\x87\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],
        ["\xF3\xB1\x87\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],
        ["\xF3\xB1\x87\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],
        ["\xF3\xB1\x87\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],
        ["\xF3\xB1\x87\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],
        ["\xF3\xB1\x87\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],
        ["\xF3\xB1\x87\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],
        ["\xF3\xB1\x87\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],
        ["\xF3\xB1\x87\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],
        ["\xF3\xB1\x87\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],
        ["\xF3\xB1\x87\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],
        ["\xF3\xB1\x87\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],
        ["\xF3\xB1\x87\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],
        ["\xF3\xB1\x87\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],
        ["\xF3\xB1\x87\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],
        ["\xF3\xB1\x87\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],
        ["\xF3\xB1\x87\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],
        ["\xF3\xB1\x87\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],
        ["\xF3\xB1\x87\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],
        ["\xF3\xB1\x87\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],
        ["\xF3\xB1\x87\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],
        ["\xF3\xB1\x87\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],
        ["\xF3\xB1\x87\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],
        ["\xF3\xB1\x87\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],
        ["\xF3\xB1\x87\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],
        ["\xF3\xB1\x87\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],
        ["\xF3\xB1\x87\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],
        ["\xF3\xB1\x87\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],
        ["\xF3\xB1\x87\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],
        ["\xF3\xB1\x87\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],
        ["\xF3\xB1\x87\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],
        ["\xF3\xB1\x87\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],
        ["\xF3\xB1\x87\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],
        ["\xF3\xB1\x87\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],
        ["\xF3\xB1\x87\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],
        ["\xF3\xB1\x88\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],
        ["\xF3\xB1\x88\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],
        ["\xF3\xB1\x88\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],
        ["\xF3\xB1\x88\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],
        ["\xF3\xB1\x88\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],
        ["\xF3\xB1\x88\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],
        ["\xF3\xB1\x88\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],
        ["\xF3\xB1\x88\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],
        ["\xF3\xB1\x88\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],
        ["\xF3\xB1\x88\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],
        ["\xF3\xB1\x88\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],
        ["\xF3\xB1\x88\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],
        ["\xF3\xB1\x88\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],
        ["\xF3\xB1\x88\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],
        ["\xF3\xB1\x88\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],
        ["\xF3\xB1\x88\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],
        ["\xF3\xB1\x88\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],
        ["\xF3\xB1\x88\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],
        ["\xF3\xB1\x88\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],
        ["\xF3\xB1\x88\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],
        ["\xF3\xB1\x88\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],
        ["\xF3\xB1\x88\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],
        ["\xF3\xB1\x88\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],
        ["\xF3\xB1\x89\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],
        ["\xF3\xB1\x89\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],
        ["\xF3\xB1\x89\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],
        ["\xF3\xB1\x89\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],
        ["\xF3\xB1\x89\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],
        ["\xF3\xB1\x89\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],
        ["\xF3\xB1\x89\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],
        ["\xF3\xB1\x89\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],
        ["\xF3\xB1\x89\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],
        ["\xF3\xB1\x89\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],
        ["\xF3\xB1\x89\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],
        ["\xF3\xB1\x89\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],
        ["\xF3\xB1\x89\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],
        ["\xF3\xB1\x89\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],
        ["\xF3\xB1\x89\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],
        ["\xF3\xB1\x89\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],
        ["\xF3\xB1\x89\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],
        ["\xF3\xB1\x89\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],
        ["\xF3\xB1\x89\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],
        ["\xF3\xB1\x89\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],
        ["\xF3\xB1\x89\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],
        ["\xF3\xB1\x89\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],
        ["\xF3\xB1\x89\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],
        ["\xF3\xB1\x89\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],
        ["\xF3\xB1\x89\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],
        ["\xF3\xB1\x89\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],
        ["\xF3\xB1\x89\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],
        ["\xF3\xB1\x89\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],
        ["\xF3\xB1\x89\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],
        ["\xF3\xB1\x89\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],
        ["\xF3\xB1\x89\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],
        ["\xF3\xB1\x89\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],
        ["\xF3\xB1\x89\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],
        ["\xF3\xB1\x89\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],
        ["\xF3\xB1\x89\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],
        ["\xF3\xB1\x89\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],
        ["\xF3\xB1\x89\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],
        ["\xF3\xB1\x89\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],
        ["\xF3\xB1\x89\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],
        ["\xF3\xB1\x89\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],
        ["\xF3\xB1\x89\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],
        ["\xF3\xB1\x89\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],
        ["\xF3\xB1\x89\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],
        ["\xF3\xB1\x89\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],
        ["\xF3\xB1\x89\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],
        ["\xF3\xB1\x89\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],
        ["\xF3\xB1\x89\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],
        ["\xF3\xB1\x89\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],
        ["\xF3\xB1\x89\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],
        ["\xF3\xB1\x89\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],
        ["\xF3\xB1\x89\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],
        ["\xF3\xB1\x89\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],
        ["\xF3\xB1\x89\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],
        ["\xF3\xB1\x89\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],
        ["\xF3\xB1\x89\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],
        ["\xF3\xB1\x89\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],
        ["\xF3\xB1\x89\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],
        ["\xF3\xB1\x89\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],
        ["\xF3\xB1\x89\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],
        ["\xF3\xB1\x89\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],
        ["\xF3\xB1\x89\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],
        ["\xF3\xB1\x89\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],
        ["\xF3\xB1\x8A\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],
        ["\xF3\xB1\x8A\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],
        ["\xF3\xB1\x8A\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],
        ["\xF3\xB1\x8A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],
        ["\xF3\xB1\x8A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],
        ["\xF3\xB1\x8A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],
        ["\xF3\xB1\x8A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],
        ["\xF3\xB1\x8A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],
        ["\xF3\xB1\x8A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],
        ["\xF3\xB1\x8A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],
        ["\xF3\xB1\x8A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],
        ["\xF3\xB1\x8A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],
        ["\xF3\xB1\x8A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],
        ["\xF3\xB1\x8A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],
        ["\xF3\xB1\x8A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],
        ["\xF3\xB1\x8A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],
        ["\xF3\xB1\x8A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],
        ["\xF3\xB1\x8A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],
        ["\xF3\xB1\x8A\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],
        ["\xF3\xB1\x8A\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],
        ["\xF3\xB1\x8A\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],
        ["\xF3\xB1\x8A\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],
        ["\xF3\xB1\x8A\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],
        ["\xF3\xB1\x8A\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],
        ["\xF3\xB1\x8A\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],
        ["\xF3\xB1\x8A\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],
        ["\xF3\xB1\x8A\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],
        ["\xF3\xB1\x8A\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],
        ["\xF3\xB1\x8A\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],
        ["\xF3\xB1\x8A\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],
        ["\xF3\xB1\x8A\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],
        ["\xF3\xB1\x8A\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],
        ["\xF3\xB1\x8A\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],
        ["\xF3\xB1\x8A\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],
        ["\xF3\xB1\x8A\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],
        ["\xF3\xB1\x8A\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],
        ["\xF3\xB1\x8A\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],
        ["\xF3\xB1\x8A\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],
        ["\xF3\xB1\x8A\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],
        ["\xF3\xB1\x8A\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],
        ["\xF3\xB1\x8A\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],
        ["\xF3\xB1\x8A\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],
        ["\xF3\xB1\x8A\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],
        ["\xF3\xB1\x8A\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],
        ["\xF3\xB1\x8A\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],
        ["\xF3\xB1\x8A\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],
        ["\xF3\xB1\x8A\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],
        ["\xF3\xB1\x8A\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],
        ["\xF3\xB1\x8A\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],
        ["\xF3\xB1\x8A\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],
        ["\xF3\xB1\x8A\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],
        ["\xF3\xB1\x8A\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],
        ["\xF3\xB1\x8A\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],
        ["\xF3\xB1\x8A\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],
        ["\xF3\xB1\x8A\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],
        ["\xF3\xB1\x8A\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],
        ["\xF3\xB1\x8A\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],
        ["\xF3\xB1\x8A\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],
        ["\xF3\xB1\x8A\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],
        ["\xF3\xB1\x8A\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],
        ["\xF3\xB1\x8A\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],
        ["\xF3\xB1\x8A\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],
        ["\xF3\xB1\x8A\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],
        ["\xF3\xB1\x8A\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],
        ["\xF3\xB1\x8B\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],
        ["\xF3\xB1\x8B\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],
        ["\xF3\xB1\x8B\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],
        ["\xF3\xB1\x8B\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],
        ["\xF3\xB1\x8B\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],
        ["\xF3\xB1\x8B\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],
        ["\xF3\xB1\x8B\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],
        ["\xF3\xB1\x8B\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],
        ["\xF3\xB1\x8B\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],
        ["\xF3\xB1\x8B\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],
        ["\xF3\xB1\x8B\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],
        ["\xF3\xB1\x8B\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],
        ["\xF3\xB1\x8B\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],
        ["\xF3\xB1\x8B\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],
        ["\xF3\xB1\x8B\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],
        ["\xF3\xB1\x8B\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],
        ["\xF3\xB1\x8B\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],
        ["\xF3\xB1\x8B\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],
        ["\xF3\xB1\x8B\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],
        ["\xF3\xB1\x8B\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],
        ["\xF3\xB1\x8B\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],
        ["\xF3\xB1\x8B\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],
        ["\xF3\xB1\x8B\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],
        ["\xF3\xB1\x8B\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],
        ["\xF3\xB1\x8B\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],
        ["\xF3\xB1\x8B\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],
        ["\xF3\xB1\x8B\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],
        ["\xF3\xB1\x8B\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],
        ["\xF3\xB1\x8B\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],
        ["\xF3\xB1\x8B\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],
        ["\xF3\xB1\x8B\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],
        ["\xF3\xB1\x8B\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],
        ["\xF3\xB1\x8B\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],
        ["\xF3\xB1\x8B\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],
        ["\xF3\xB1\x8B\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],
        ["\xF3\xB1\x8B\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],
        ["\xF3\xB1\x8B\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],
        ["\xF3\xB1\x8B\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],
        ["\xF3\xB1\x8B\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],
        ["\xF3\xB1\x8B\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],
        ["\xF3\xB1\x8B\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],
        ["\xF3\xB1\x8B\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],
        ["\xF3\xB1\x8B\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],
        ["\xF3\xB1\x8B\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],
        ["\xF3\xB1\x8B\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],
        ["\xF3\xB1\x8B\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],
        ["\xF3\xB1\x8B\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],
        ["\xF3\xB1\x8B\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],
        ["\xF3\xB1\x8B\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],
        ["\xF3\xB1\x8B\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],
        ["\xF3\xB1\x8B\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],
        ["\xF3\xB1\x8B\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],
        ["\xF3\xB1\x8B\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],
        ["\xF3\xB1\x8B\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],
        ["\xF3\xB1\x8B\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],
        ["\xF3\xB1\x8B\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],
        ["\xF3\xB1\x8B\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],
        ["\xF3\xB1\x8B\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],
        ["\xF3\xB1\x8B\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],
        ["\xF3\xB1\x8B\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],
        ["\xF3\xB1\x8B\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],
        ["\xF3\xB1\x8B\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],
        ["\xF3\xB1\x8B\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],
        ["\xF3\xB1\x8B\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],
        ["\xF3\xB1\x8C\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],
        ["\xF3\xB1\x8C\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],
        ["\xF3\xB1\x8C\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],
        ["\xF3\xB1\x8C\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],
        ["\xF3\xB1\x8C\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],
        ["\xF3\xB1\x8C\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],
        ["\xF3\xB1\x8C\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],
        ["\xF3\xB1\x8C\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],
        ["\xF3\xB1\x8C\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],
        ["\xF3\xB1\x8C\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],
        ["\xF3\xB1\x8C\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],
        ["\xF3\xB1\x8C\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],
        ["\xF3\xB1\x8C\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],
        ["\xF3\xB1\x8C\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],
        ["\xF3\xB1\x8C\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],
        ["\xF3\xB1\x8C\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],
        ["\xF3\xB1\x8C\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],
        ["\xF3\xB1\x8C\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],
        ["\xF3\xB1\x8C\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],
        ["\xF3\xB1\x8C\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],
        ["\xF3\xB1\x8C\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],
        ["\xF3\xB1\x8C\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],
        ["\xF3\xB1\x8C\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],
        ["\xF3\xB1\x8C\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],
        ["\xF3\xB1\x8C\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],
        ["\xF3\xB1\x8C\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],
        ["\xF3\xB1\x8C\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],
        ["\xF3\xB1\x8C\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],
        ["\xF3\xB1\x8C\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],
        ["\xF3\xB1\x8C\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],
        ["\xF3\xB1\x8C\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],
        ["\xF3\xB1\x8C\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],
        ["\xF3\xB1\x8C\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],
        ["\xF3\xB1\x8C\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],
        ["\xF3\xB1\x8C\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],
        ["\xF3\xB1\x8C\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],
        ["\xF3\xB1\x8C\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],
        ["\xF3\xB1\x8C\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],
        ["\xF3\xB1\x8C\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],
        ["\xF3\xB1\x8C\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],
        ["\xF3\xB1\x8C\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],
        ["\xF3\xB1\x8C\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],
        ["\xF3\xB1\x8C\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],
        ["\xF3\xB1\x8C\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],
        ["\xF3\xB1\x8C\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],
        ["\xF3\xB1\x8C\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],
        ["\xF3\xB1\x8C\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],
        ["\xF3\xB1\x8C\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],
        ["\xF3\xB1\x8C\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],
        ["\xF3\xB1\x8C\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],
        ["\xF3\xB1\x8C\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],
        ["\xF3\xB1\x8C\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],
        ["\xF3\xB1\x8C\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],
        ["\xF3\xB1\x8C\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],
        ["\xF3\xB1\x8C\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],
        ["\xF3\xB1\x8C\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],
        ["\xF3\xB1\x8C\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],
        ["\xF3\xB1\x8C\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],
        ["\xF3\xB1\x8C\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],
        ["\xF3\xB1\x8C\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],
        ["\xF3\xB1\x8C\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],
        ["\xF3\xB1\x8C\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],
        ["\xF3\xB1\x8C\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],
        ["\xF3\xB1\x8C\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],
        ["\xF3\xB1\x8D\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],
        ["\xF3\xB1\x8D\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],
        ["\xF3\xB1\x8D\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],
        ["\xF3\xB1\x8D\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],
        ["\xF3\xB1\x8D\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],
        ["\xF3\xB1\x8D\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],
        ["\xF3\xB1\x8D\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],
        ["\xF3\xB1\x8D\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],
        ["\xF3\xB1\x8D\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],
        ["\xF3\xB1\x8D\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],
        ["\xF3\xB1\x8D\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],
        ["\xF3\xB1\x8D\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],
        ["\xF3\xB1\x8D\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],
        ["\xF3\xB1\x8D\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],
        ["\xF3\xB1\x8D\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],
        ["\xF3\xB1\x8D\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],
        ["\xF3\xB1\x8D\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],
        ["\xF3\xB1\x8D\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],
        ["\xF3\xB1\x8D\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],
        ["\xF3\xB1\x8D\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],
        ["\xF3\xB1\x8D\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],
        ["\xF3\xB1\x8D\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],
        ["\xF3\xB1\x8D\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],
        ["\xF3\xB1\x8D\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],
        ["\xF3\xB1\x8D\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],
        ["\xF3\xB1\x8D\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],
        ["\xF3\xB1\x8D\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],
        ["\xF3\xB1\x8D\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],
        ["\xF3\xB1\x8D\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],
        ["\xF3\xB1\x8D\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],
        ["\xF3\xB1\x8D\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],
        ["\xF3\xB1\x8D\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],
        ["\xF3\xB1\x8D\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],
        ["\xF3\xB1\x8D\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],
        ["\xF3\xB1\x8D\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],
        ["\xF3\xB1\x8D\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],
        ["\xF3\xB1\x8D\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],
        ["\xF3\xB1\x8D\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],
        ["\xF3\xB1\x8D\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],
        ["\xF3\xB1\x8D\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],
        ["\xF3\xB1\x8D\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],
        ["\xF3\xB1\x8D\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],
        ["\xF3\xB1\x8D\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],
        ["\xF3\xB1\x8D\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],
        ["\xF3\xB1\x8D\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],
        ["\xF3\xB1\x8D\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],
        ["\xF3\xB1\x8D\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],
        ["\xF3\xB1\x8D\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],
        ["\xF3\xB1\x8D\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],
        ["\xF3\xB1\x8D\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],
        ["\xF3\xB1\x8D\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],
        ["\xF3\xB1\x8D\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],
        ["\xF3\xB1\x8D\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],
        ["\xF3\xB1\x8D\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],
        ["\xF3\xB1\x8D\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],
        ["\xF3\xB1\x8D\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],
        ["\xF3\xB1\x8D\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],
        ["\xF3\xB1\x8D\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],
        ["\xF3\xB1\x8D\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],
        ["\xF3\xB1\x8D\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],
        ["\xF3\xB1\x8D\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],
        ["\xF3\xB1\x8D\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],
        ["\xF3\xB1\x8D\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],
        ["\xF3\xB1\x8D\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],
        ["\xF3\xB1\x8E\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],
        ["\xF3\xB1\x8E\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],
        ["\xF3\xB1\x8E\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],
        ["\xF3\xB1\x8E\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],
        ["\xF3\xB1\x8E\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],
        ["\xF3\xB1\x8E\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],
        ["\xF3\xB1\x8E\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],
        ["\xF3\xB1\x8E\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],
        ["\xF3\xB1\x8E\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],
        ["\xF3\xB1\x8E\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],
        ["\xF3\xB1\x8E\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],
        ["\xF3\xB1\x8E\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],
        ["\xF3\xB1\x8E\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],
        ["\xF3\xB1\x8E\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],
        ["\xF3\xB1\x8E\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],
        ["\xF3\xB1\x8E\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],
        ["\xF3\xB1\x8E\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],
        ["\xF3\xB1\x8E\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],
        ["\xF3\xB1\x8E\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],
        ["\xF3\xB1\x8E\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],
        ["\xF3\xB1\x8E\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],
        ["\xF3\xB1\x8E\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],
        ["\xF3\xB1\x8E\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],
        ["\xF3\xB1\x8E\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],
        ["\xF3\xB1\x8E\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],
        ["\xF3\xB1\x8E\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],
        ["\xF3\xB1\x8E\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],
        ["\xF3\xB1\x8E\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],
        ["\xF3\xB1\x8E\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],
        ["\xF3\xB1\x8E\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],
        ["\xF3\xB1\x8E\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],
        ["\xF3\xB1\x8E\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],
        ["\xF3\xB1\x8E\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],
        ["\xF3\xB1\x8E\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],
        ["\xF3\xB1\x8E\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],
        ["\xF3\xB1\x8E\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],
        ["\xF3\xB1\x8E\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],
        ["\xF3\xB1\x8E\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],
        ["\xF3\xB1\x8E\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],
        ["\xF3\xB1\x8E\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],
        ["\xF3\xB1\x8E\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],
        ["\xF3\xB1\x8E\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],
        ["\xF3\xB1\x8E\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],
        ["\xF3\xB1\x8E\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],
        ["\xF3\xB1\x8E\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],
        ["\xF3\xB1\x8E\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],
        ["\xF3\xB1\x8E\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],
        ["\xF3\xB1\x8E\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],
        ["\xF3\xB1\x8E\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],
        ["\xF3\xB1\x8E\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],
        ["\xF3\xB1\x8E\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],
        ["\xF3\xB1\x8E\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],
        ["\xF3\xB1\x8E\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],
        ["\xF3\xB1\x8E\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],
        ["\xF3\xB1\x8E\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],
        ["\xF3\xB1\x8E\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],
        ["\xF3\xB1\x8E\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],
        ["\xF3\xB1\x8E\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],
        ["\xF3\xB1\x8E\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],
        ["\xF3\xB1\x8E\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],
        ["\xF3\xB1\x8E\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],
        ["\xF3\xB1\x8E\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],
        ["\xF3\xB1\x8E\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],
        ["\xF3\xB1\x8E\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],
        ["\xF3\xB1\x8F\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],
        ["\xF3\xB1\x8F\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],
        ["\xF3\xB1\x8F\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],
        ["\xF3\xB1\x8F\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],
        ["\xF3\xB1\x8F\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],
        ["\xF3\xB1\x8F\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],
        ["\xF3\xB1\x8F\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],
        ["\xF3\xB1\x8F\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],
        ["\xF3\xB1\x8F\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],
        ["\xF3\xB1\x8F\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],
        ["\xF3\xB1\x8F\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],
        ["\xF3\xB1\x8F\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],
        ["\xF3\xB1\x8F\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],
        ["\xF3\xB1\x8F\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],
        ["\xF3\xB1\x8F\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],
        ["\xF3\xB1\x8F\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],
        ["\xF3\xB1\x8F\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],
        ["\xF3\xB1\x8F\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],
        ["\xF3\xB1\x8F\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],
        ["\xF3\xB1\x8F\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],
        ["\xF3\xB1\x8F\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],
        ["\xF3\xB1\x8F\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],
        ["\xF3\xB1\x8F\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],
        ["\xF3\xB1\x8F\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],
        ["\xF3\xB1\x8F\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],
        ["\xF3\xB1\x8F\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],
        ["\xF3\xB1\x8F\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],
        ["\xF3\xB1\x8F\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],
        ["\xF3\xB1\x8F\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],
        ["\xF3\xB1\x8F\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],
        ["\xF3\xB1\x8F\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],
        ["\xF3\xB1\x8F\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],
        ["\xF3\xB1\x8F\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],
        ["\xF3\xB1\x8F\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],
        ["\xF3\xB1\x8F\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],
        ["\xF3\xB1\x8F\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],
        ["\xF3\xB1\x8F\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],
        ["\xF3\xB1\x8F\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],
        ["\xF3\xB1\x8F\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],
        ["\xF3\xB1\x8F\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],
        ["\xF3\xB1\x8F\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],
        ["\xF3\xB1\x8F\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],
        ["\xF3\xB1\x8F\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],
        ["\xF3\xB1\x8F\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],
        ["\xF3\xB1\x8F\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],
        ["\xF3\xB1\x8F\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],
        ["\xF3\xB1\x8F\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],
        ["\xF3\xB1\x8F\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],
        ["\xF3\xB1\x8F\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],
        ["\xF3\xB1\x8F\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],
        ["\xF3\xB1\x8F\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],
        ["\xF3\xB1\x8F\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],
        ["\xF3\xB1\x8F\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],
        ["\xF3\xB1\x8F\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],
        ["\xF3\xB1\x8F\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],
        ["\xF3\xB1\x8F\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],
        ["\xF3\xB1\x8F\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],
        ["\xF3\xB1\x8F\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],
        ["\xF3\xB1\x8F\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],
        ["\xF3\xB1\x8F\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],
        ["\xF3\xB1\x8F\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],
        ["\xF3\xB1\x8F\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],
        ["\xF3\xB1\x8F\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],
        ["\xF3\xB1\x8F\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],
        ["\xF3\xB1\x90\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],
        ["\xF3\xB1\x90\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],
        ["\xF3\xB1\x90\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],
        ["\xF3\xB1\x90\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],
        ["\xF3\xB1\x90\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],
        ["\xF3\xB1\x90\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],
        ["\xF3\xB1\x90\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],
        ["\xF3\xB1\x90\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],
        ["\xF3\xB1\x90\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],
        ["\xF3\xB1\x90\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],
        ["\xF3\xB1\x90\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],
        ["\xF3\xB1\x90\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],
        ["\xF3\xB1\x90\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],
        ["\xF3\xB1\x90\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],
        ["\xF3\xB1\x90\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],
        ["\xF3\xB1\x90\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],
        ["\xF3\xB1\x90\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],
        ["\xF3\xB1\x90\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],
        ["\xF3\xB1\x90\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],
        ["\xF3\xB1\x90\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],
        ["\xF3\xB1\x90\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],
        ["\xF3\xB1\x90\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],
        ["\xF3\xB1\x90\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],
        ["\xF3\xB1\x90\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],
        ["\xF3\xB1\x90\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],
        ["\xF3\xB1\x90\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],
        ["\xF3\xB1\x90\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],
        ["\xF3\xB1\x90\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],
        ["\xF3\xB1\x90\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],
        ["\xF3\xB1\x90\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],
        ["\xF3\xB1\x90\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],
        ["\xF3\xB1\x90\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],
        ["\xF3\xB1\x90\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],
        ["\xF3\xB1\x90\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],
        ["\xF3\xB1\x90\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],
        ["\xF3\xB1\x90\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],
        ["\xF3\xB1\x90\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],
        ["\xF3\xB1\x90\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],
        ["\xF3\xB1\x90\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],
        ["\xF3\xB1\x90\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],
        ["\xF3\xB1\x90\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],
        ["\xF3\xB1\x90\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],
        ["\xF3\xB1\x90\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],
        ["\xF3\xB1\x90\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],
        ["\xF3\xB1\x90\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],
        ["\xF3\xB1\x90\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],
        ["\xF3\xB1\x90\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],
        ["\xF3\xB1\x90\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],
        ["\xF3\xB1\x90\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],
        ["\xF3\xB1\x90\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],
        ["\xF3\xB1\x90\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],
        ["\xF3\xB1\x90\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],
        ["\xF3\xB1\x90\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],
        ["\xF3\xB1\x90\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],
        ["\xF3\xB1\x90\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],
        ["\xF3\xB1\x90\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],
        ["\xF3\xB1\x90\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],
        ["\xF3\xB1\x90\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],
        ["\xF3\xB1\x90\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],
        ["\xF3\xB1\x90\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],
        ["\xF3\xB1\x90\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],
        ["\xF3\xB1\x90\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],
        ["\xF3\xB1\x90\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],
        ["\xF3\xB1\x90\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],
        ["\xF3\xB1\x91\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],
        ["\xF3\xB1\x91\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],
        ["\xF3\xB1\x91\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],
        ["\xF3\xB1\x91\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],
        ["\xF3\xB1\x91\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],
        ["\xF3\xB1\x91\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],
        ["\xF3\xB1\x91\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],
        ["\xF3\xB1\x91\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],
        ["\xF3\xB1\x91\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],
        ["\xF3\xB1\x91\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],
        ["\xF3\xB1\x91\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],
        ["\xF3\xB1\x91\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],
        ["\xF3\xB1\x91\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],
        ["\xF3\xB1\x91\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],
        ["\xF3\xB1\x91\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],
        ["\xF3\xB1\x91\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],
        ["\xF3\xB1\x91\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],
        ["\xF3\xB1\x91\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],
        ["\xF3\xB1\x91\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],
        ["\xF3\xB1\x91\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],
        ["\xF3\xB1\x91\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],
        ["\xF3\xB1\x91\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],
        ["\xF3\xB1\x91\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],
        ["\xF3\xB1\x91\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],
        ["\xF3\xB1\x91\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],
        ["\xF3\xB1\x91\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],
        ["\xF3\xB1\x91\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],
        ["\xF3\xB1\x91\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],
        ["\xF3\xB1\x91\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],
        ["\xF3\xB1\x91\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],
        ["\xF3\xB1\x91\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],
        ["\xF3\xB1\x91\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],
        ["\xF3\xB1\x91\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],
        ["\xF3\xB1\x91\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],
        ["\xF3\xB1\x91\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],
        ["\xF3\xB1\x91\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],
        ["\xF3\xB1\x91\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],
        ["\xF3\xB1\x91\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],
        ["\xF3\xB1\x91\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],
        ["\xF3\xB1\x91\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],
        ["\xF3\xB1\x91\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],
        ["\xF3\xB1\x91\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],
        ["\xF3\xB1\x91\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],
        ["\xF3\xB1\x91\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],
        ["\xF3\xB1\x91\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],
        ["\xF3\xB1\x91\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],
        ["\xF3\xB1\x91\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],
        ["\xF3\xB1\x91\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],
        ["\xF3\xB1\x91\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],
        ["\xF3\xB1\x91\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],
        ["\xF3\xB1\x91\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],
        ["\xF3\xB1\x91\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],
        ["\xF3\xB1\x91\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],
        ["\xF3\xB1\x91\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],
        ["\xF3\xB1\x91\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],
        ["\xF3\xB1\x91\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],
        ["\xF3\xB1\x91\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],
        ["\xF3\xB1\x91\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],
        ["\xF3\xB1\x91\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],
        ["\xF3\xB1\x91\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],
        ["\xF3\xB1\x91\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],
        ["\xF3\xB1\x91\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],
        ["\xF3\xB1\x91\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],
        ["\xF3\xB1\x91\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],
        ["\xF3\xB1\x92\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],
        ["\xF3\xB1\x92\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],
        ["\xF3\xB1\x92\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],
        ["\xF3\xB1\x92\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],
        ["\xF3\xB1\x92\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],
        ["\xF3\xB1\x92\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],
        ["\xF3\xB1\x92\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],
        ["\xF3\xB1\x92\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],
        ["\xF3\xB1\x92\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],
        ["\xF3\xB1\x92\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],
        ["\xF3\xB1\x92\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],
        ["\xF3\xB1\x92\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],
        ["\xF3\xB1\x92\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],
        ["\xF3\xB1\x92\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],
        ["\xF3\xB1\x92\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],
        ["\xF3\xB1\x92\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],
        ["\xF3\xB1\x92\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],
        ["\xF3\xB1\x92\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],
        ["\xF3\xB1\x92\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],
        ["\xF3\xB1\x92\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],
        ["\xF3\xB1\x92\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],
        ["\xF3\xB1\x92\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],
        ["\xF3\xB1\x92\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],
        ["\xF3\xB1\x92\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],
        ["\xF3\xB1\x92\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],
        ["\xF3\xB1\x92\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],
        ["\xF3\xB1\x92\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],
        ["\xF3\xB1\x92\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],
        ["\xF3\xB1\x92\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],
        ["\xF3\xB1\x92\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],
        ["\xF3\xB1\x92\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],
        ["\xF3\xB1\x92\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],
        ["\xF3\xB1\x92\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],
        ["\xF3\xB1\x92\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],
        ["\xF3\xB1\x92\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],
        ["\xF3\xB1\x92\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],
        ["\xF3\xB1\x92\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],
        ["\xF3\xB1\x92\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],
        ["\xF3\xB1\x92\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],
        ["\xF3\xB1\x92\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],
        ["\xF3\xB1\x92\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],
        ["\xF3\xB1\x92\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],
        ["\xF3\xB1\x92\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],
        ["\xF3\xB1\x92\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],
        ["\xF3\xB1\x92\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],
        ["\xF3\xB1\x92\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],
        ["\xF3\xB1\x92\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],
        ["\xF3\xB1\x92\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],
        ["\xF3\xB1\x92\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],
        ["\xF3\xB1\x92\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],
        ["\xF3\xB1\x92\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],
        ["\xF3\xB1\x92\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],
        ["\xF3\xB1\x92\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],
        ["\xF3\xB1\x92\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],
        ["\xF3\xB1\x92\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],
        ["\xF3\xB1\x92\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],
        ["\xF3\xB1\x92\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],
        ["\xF3\xB1\x92\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],
        ["\xF3\xB1\x92\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],
        ["\xF3\xB1\x92\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],
        ["\xF3\xB1\x92\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],
        ["\xF3\xB1\x92\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],
        ["\xF3\xB1\x92\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],
        ["\xF3\xB1\x92\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],
        ["\xF3\xB1\x93\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],
        ["\xF3\xB1\x93\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],
        ["\xF3\xB1\x93\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],
        ["\xF3\xB1\x93\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],
        ["\xF3\xB1\x93\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],
        ["\xF3\xB1\x93\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],
        ["\xF3\xB1\x93\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],
        ["\xF3\xB1\x93\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],
        ["\xF3\xB1\x93\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],
        ["\xF3\xB1\x93\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],
        ["\xF3\xB1\x93\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],
        ["\xF3\xB1\x93\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],
        ["\xF3\xB1\x93\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],
        ["\xF3\xB1\x93\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],
        ["\xF3\xB1\x93\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],
        ["\xF3\xB1\x93\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],
        ["\xF3\xB1\x93\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],
        ["\xF3\xB1\x93\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],
        ["\xF3\xB1\x93\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],
        ["\xF3\xB1\x93\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],
        ["\xF3\xB1\x93\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],
        ["\xF3\xB1\x93\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],
        ["\xF3\xB1\x93\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],
        ["\xF3\xB1\x93\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],
        ["\xF3\xB1\x93\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],
        ["\xF3\xB1\x93\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],
        ["\xF3\xB1\x93\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],
        ["\xF3\xB1\x93\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],
        ["\xF3\xB1\x93\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],
        ["\xF3\xB1\x93\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],
        ["\xF3\xB1\x93\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],
        ["\xF3\xB1\x93\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],
        ["\xF3\xB1\x93\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],
        ["\xF3\xB1\x93\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],
        ["\xF3\xB1\x93\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],
        ["\xF3\xB1\x93\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],
        ["\xF3\xB1\x93\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],
        ["\xF3\xB1\x93\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],
        ["\xF3\xB1\x93\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],
        ["\xF3\xB1\x93\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],
        ["\xF3\xB1\x93\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],
        ["\xF3\xB1\x93\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],
        ["\xF3\xB1\x93\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],
        ["\xF3\xB1\x93\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],
        ["\xF3\xB1\x93\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],
        ["\xF3\xB1\x93\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],
        ["\xF3\xB1\x93\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],
        ["\xF3\xB1\x93\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],
        ["\xF3\xB1\x93\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],
        ["\xF3\xB1\x93\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],
        ["\xF3\xB1\x93\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],
        ["\xF3\xB1\x93\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],
        ["\xF3\xB1\x93\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],
        ["\xF3\xB1\x93\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],
        ["\xF3\xB1\x93\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],
        ["\xF3\xB1\x93\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],
        ["\xF3\xB1\x93\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],
        ["\xF3\xB1\x93\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],
        ["\xF3\xB1\x93\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],
        ["\xF3\xB1\x93\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],
        ["\xF3\xB1\x93\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],
        ["\xF3\xB1\x93\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],
        ["\xF3\xB1\x93\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],
        ["\xF3\xB1\x94\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],
        ["\xF3\xB1\x94\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],
        ["\xF3\xB1\x94\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],
        ["\xF3\xB1\x94\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],
        ["\xF3\xB1\x94\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],
        ["\xF3\xB1\x94\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],
        ["\xF3\xB1\x94\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],
        ["\xF3\xB1\x94\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],
        ["\xF3\xB1\x94\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],
        ["\xF3\xB1\x94\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],
        ["\xF3\xB1\x94\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],
        ["\xF3\xB1\x94\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],
        ["\xF3\xB1\x94\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],
        ["\xF3\xB1\x94\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],
        ["\xF3\xB1\x94\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],
        ["\xF3\xB1\x94\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],
        ["\xF3\xB1\x94\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],
        ["\xF3\xB1\x94\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],
        ["\xF3\xB1\x94\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],
        ["\xF3\xB1\x94\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],
        ["\xF3\xB1\x94\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],
        ["\xF3\xB1\x94\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],
        ["\xF3\xB1\x94\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],
        ["\xF3\xB1\x94\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],
        ["\xF3\xB1\x94\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],
        ["\xF3\xB1\x94\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],
        ["\xF3\xB1\x94\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],
        ["\xF3\xB1\x94\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],
        ["\xF3\xB1\x94\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],
        ["\xF3\xB1\x94\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],
        ["\xF3\xB1\x94\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],
        ["\xF3\xB1\x94\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],
        ["\xF3\xB1\x94\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],
        ["\xF3\xB1\x94\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],
        ["\xF3\xB1\x94\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],
        ["\xF3\xB1\x94\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],
        ["\xF3\xB1\x94\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],
        ["\xF3\xB1\x94\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],
        ["\xF3\xB1\x94\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],
        ["\xF3\xB1\x94\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],
        ["\xF3\xB1\x94\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],
        ["\xF3\xB1\x94\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],
        ["\xF3\xB1\x94\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],
        ["\xF3\xB1\x94\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],
        ["\xF3\xB1\x94\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],
        ["\xF3\xB1\x94\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],
        ["\xF3\xB1\x94\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],
        ["\xF3\xB1\x94\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],
        ["\xF3\xB1\x94\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],
        ["\xF3\xB1\x94\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],
        ["\xF3\xB1\x94\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],
        ["\xF3\xB1\x94\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],
        ["\xF3\xB1\x94\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],
        ["\xF3\xB1\x94\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],
        ["\xF3\xB1\x94\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],
        ["\xF3\xB1\x94\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],
        ["\xF3\xB1\x94\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],
        ["\xF3\xB1\x94\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],
        ["\xF3\xB1\x94\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],
        ["\xF3\xB1\x94\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],
        ["\xF3\xB1\x94\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],
        ["\xF3\xB1\x94\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],
        ["\xF3\xB1\x94\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],
        ["\xF3\xB1\x94\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],
        ["\xF3\xB1\x95\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],
        ["\xF3\xB1\x95\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],
        ["\xF3\xB1\x95\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],
        ["\xF3\xB1\x95\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],
        ["\xF3\xB1\x95\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],
        ["\xF3\xB1\x95\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],
        ["\xF3\xB1\x95\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],
        ["\xF3\xB1\x95\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],
        ["\xF3\xB1\x95\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],
        ["\xF3\xB1\x95\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],
        ["\xF3\xB1\x95\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],
        ["\xF3\xB1\x95\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],
        ["\xF3\xB1\x95\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],
        ["\xF3\xB1\x95\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],
        ["\xF3\xB1\x95\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],
        ["\xF3\xB1\x95\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],
        ["\xF3\xB1\x95\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],
        ["\xF3\xB1\x95\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],
        ["\xF3\xB1\x95\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],
        ["\xF3\xB1\x95\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],
        ["\xF3\xB1\x95\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],
        ["\xF3\xB1\x95\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],
        ["\xF3\xB1\x95\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],
        ["\xF3\xB1\x95\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],
        ["\xF3\xB1\x95\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],
        ["\xF3\xB1\x95\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],
        ["\xF3\xB1\x95\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],
        ["\xF3\xB1\x95\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],
        ["\xF3\xB1\x95\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],
        ["\xF3\xB1\x95\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],
        ["\xF3\xB1\x95\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],
        ["\xF3\xB1\x95\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],
        ["\xF3\xB1\x95\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],
        ["\xF3\xB1\x95\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],
        ["\xF3\xB1\x95\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],
        ["\xF3\xB1\x95\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],
        ["\xF3\xB1\x95\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],
        ["\xF3\xB1\x95\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],
        ["\xF3\xB1\x95\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],
        ["\xF3\xB1\x95\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],
        ["\xF3\xB1\x95\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],
        ["\xF3\xB1\x95\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],
        ["\xF3\xB1\x95\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],
        ["\xF3\xB1\x95\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],
        ["\xF3\xB1\x95\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],
        ["\xF3\xB1\x95\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],
        ["\xF3\xB1\x95\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],
        ["\xF3\xB1\x95\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],
        ["\xF3\xB1\x95\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],
        ["\xF3\xB1\x95\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],
        ["\xF3\xB1\x95\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],
        ["\xF3\xB1\x95\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],
        ["\xF3\xB1\x95\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],
        ["\xF3\xB1\x95\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],
        ["\xF3\xB1\x95\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],
        ["\xF3\xB1\x95\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],
        ["\xF3\xB1\x95\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],
        ["\xF3\xB1\x95\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],
        ["\xF3\xB1\x95\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],
        ["\xF3\xB1\x95\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],
        ["\xF3\xB1\x95\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],
        ["\xF3\xB1\x95\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],
        ["\xF3\xB1\x95\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],
        ["\xF3\xB1\x95\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],
        ["\xF3\xB1\x96\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],
        ["\xF3\xB1\x96\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],
        ["\xF3\xB1\x96\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],
        ["\xF3\xB1\x96\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],
        ["\xF3\xB1\x96\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],
        ["\xF3\xB1\x96\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],
        ["\xF3\xB1\x96\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],
        ["\xF3\xB1\x96\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],
        ["\xF3\xB1\x96\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],
        ["\xF3\xB1\x96\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],
        ["\xF3\xB1\x96\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],
        ["\xF3\xB1\x96\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],
        ["\xF3\xB1\x96\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],
        ["\xF3\xB1\x96\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],
        ["\xF3\xB1\x96\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],
        ["\xF3\xB1\x96\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],
        ["\xF3\xB1\x96\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],
        ["\xF3\xB1\x96\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],
        ["\xF3\xB1\x96\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],
        ["\xF3\xB1\x96\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],
        ["\xF3\xB1\x96\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],
        ["\xF3\xB1\x96\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],
        ["\xF3\xB1\x96\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],
        ["\xF3\xB1\x96\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],
        ["\xF3\xB1\x96\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],
        ["\xF3\xB1\x96\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],
        ["\xF3\xB1\x96\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],
        ["\xF3\xB1\x96\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],
        ["\xF3\xB1\x96\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],
        ["\xF3\xB1\x96\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],
        ["\xF3\xB1\x96\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],
        ["\xF3\xB1\x96\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],
        ["\xF3\xB1\x96\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],
        ["\xF3\xB1\x96\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],
        ["\xF3\xB1\x96\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],
        ["\xF3\xB1\x96\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],
        ["\xF3\xB1\x96\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],
        ["\xF3\xB1\x96\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],
        ["\xF3\xB1\x96\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],
        ["\xF3\xB1\x96\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],
        ["\xF3\xB1\x96\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],
        ["\xF3\xB1\x96\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],
        ["\xF3\xB1\x96\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],
        ["\xF3\xB1\x96\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],
        ["\xF3\xB1\x96\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],
        ["\xF3\xB1\x96\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],
        ["\xF3\xB1\x96\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],
        ["\xF3\xB1\x96\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],
        ["\xF3\xB1\x96\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],
        ["\xF3\xB1\x96\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],
        ["\xF3\xB1\x96\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],
        ["\xF3\xB1\x96\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],
        ["\xF3\xB1\x96\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],
        ["\xF3\xB1\x96\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],
        ["\xF3\xB1\x96\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],
        ["\xF3\xB1\x96\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],
        ["\xF3\xB1\x96\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],
        ["\xF3\xB1\x96\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],
        ["\xF3\xB1\x96\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],
        ["\xF3\xB1\x96\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],
        ["\xF3\xB1\x96\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],
        ["\xF3\xB1\x96\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],
        ["\xF3\xB1\x96\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],
        ["\xF3\xB1\x96\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],
        ["\xF3\xB1\x97\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],
        ["\xF3\xB1\x97\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],
        ["\xF3\xB1\x97\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],
        ["\xF3\xB1\x97\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],
        ["\xF3\xB1\x97\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],
        ["\xF3\xB1\x97\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],
        ["\xF3\xB1\x97\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],
        ["\xF3\xB1\x97\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],
        ["\xF3\xB1\x97\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],
        ["\xF3\xB1\x97\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],
        ["\xF3\xB1\x97\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],
        ["\xF3\xB1\x97\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],
        ["\xF3\xB1\x97\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],
        ["\xF3\xB1\x97\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],
        ["\xF3\xB1\x97\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],
        ["\xF3\xB1\x97\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],
        ["\xF3\xB1\x97\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],
        ["\xF3\xB1\x97\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],
        ["\xF3\xB1\x97\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],
        ["\xF3\xB1\x97\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],
        ["\xF3\xB1\x97\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],
        ["\xF3\xB1\x97\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],
        ["\xF3\xB1\x97\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],
        ["\xF3\xB1\x97\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],
        ["\xF3\xB1\x97\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],
        ["\xF3\xB1\x97\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],
        ["\xF3\xB1\x97\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],
        ["\xF3\xB1\x97\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],
        ["\xF3\xB1\x97\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],
        ["\xF3\xB1\x97\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],
        ["\xF3\xB1\x97\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],
        ["\xF3\xB1\x97\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],
        ["\xF3\xB1\x97\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],
        ["\xF3\xB1\x97\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],
        ["\xF3\xB1\x97\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],
        ["\xF3\xB1\x97\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],
        ["\xF3\xB1\x97\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],
        ["\xF3\xB1\x97\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],
        ["\xF3\xB1\x97\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],
        ["\xF3\xB1\x97\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],
        ["\xF3\xB1\x97\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],
        ["\xF3\xB1\x97\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],
        ["\xF3\xB1\x97\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],
        ["\xF3\xB1\x97\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],
        ["\xF3\xB1\x97\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],
        ["\xF3\xB1\x97\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],
        ["\xF3\xB1\x97\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],
        ["\xF3\xB1\x97\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],
        ["\xF3\xB1\x97\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],
        ["\xF3\xB1\x97\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],
        ["\xF3\xB1\x97\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],
        ["\xF3\xB1\x97\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],
        ["\xF3\xB1\x97\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],
        ["\xF3\xB1\x97\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],
        ["\xF3\xB1\x97\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],
        ["\xF3\xB1\x97\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],
        ["\xF3\xB1\x97\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],
        ["\xF3\xB1\x97\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],
        ["\xF3\xB1\x97\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],
        ["\xF3\xB1\x97\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],
        ["\xF3\xB1\x97\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],
        ["\xF3\xB1\x97\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],
        ["\xF3\xB1\x97\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],
        ["\xF3\xB1\x97\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],
        ["\xF3\xB1\x98\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],
        ["\xF3\xB1\x98\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],
        ["\xF3\xB1\x98\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],
        ["\xF3\xB1\x98\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],
        ["\xF3\xB1\x98\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],
        ["\xF3\xB1\x98\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],
        ["\xF3\xB1\x98\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],
        ["\xF3\xB1\x98\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],
        ["\xF3\xB1\x98\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],
        ["\xF3\xB1\x98\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],
        ["\xF3\xB1\x98\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],
        ["\xF3\xB1\x98\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],
        ["\xF3\xB1\x98\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],
        ["\xF3\xB1\x98\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],
        ["\xF3\xB1\x98\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],
        ["\xF3\xB1\x98\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],
        ["\xF3\xB1\x98\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],
        ["\xF3\xB1\x98\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],
        ["\xF3\xB1\x98\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],
        ["\xF3\xB1\x98\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],
        ["\xF3\xB1\x98\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],
        ["\xF3\xB1\x98\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],
        ["\xF3\xB1\x98\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],
        ["\xF3\xB1\x98\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],
        ["\xF3\xB1\x98\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],
        ["\xF3\xB1\x98\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],
        ["\xF3\xB1\x98\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],
        ["\xF3\xB1\x98\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],
        ["\xF3\xB1\x98\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],
        ["\xF3\xB1\x98\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],
        ["\xF3\xB1\x98\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],
        ["\xF3\xB1\x98\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],
        ["\xF3\xB1\x98\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],
        ["\xF3\xB1\x98\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],
        ["\xF3\xB1\x98\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],
        ["\xF3\xB1\x98\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],
        ["\xF3\xB1\x98\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],
        ["\xF3\xB1\x98\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],
        ["\xF3\xB1\x98\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],
        ["\xF3\xB1\x98\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],
        ["\xF3\xB1\x98\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],
        ["\xF3\xB1\x98\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],
        ["\xF3\xB1\x98\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],
        ["\xF3\xB1\x98\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],
        ["\xF3\xB1\x98\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],
        ["\xF3\xB1\x98\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],
        ["\xF3\xB1\x98\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],
        ["\xF3\xB1\x98\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],
        ["\xF3\xB1\x98\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],
        ["\xF3\xB1\x98\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],
        ["\xF3\xB1\x98\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],
        ["\xF3\xB1\x98\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],
        ["\xF3\xB1\x98\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],
        ["\xF3\xB1\x98\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],
        ["\xF3\xB1\x98\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],
        ["\xF3\xB1\x98\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],
        ["\xF3\xB1\x98\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],
        ["\xF3\xB1\x98\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],
        ["\xF3\xB1\x98\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],
        ["\xF3\xB1\x98\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],
        ["\xF3\xB1\x98\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],
        ["\xF3\xB1\x98\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],
        ["\xF3\xB1\x98\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],
        ["\xF3\xB1\x98\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],
        ["\xF3\xB1\x99\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],
        ["\xF3\xB1\x99\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],
        ["\xF3\xB1\x99\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],
        ["\xF3\xB1\x99\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],
        ["\xF3\xB1\x99\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],
        ["\xF3\xB1\x99\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],
        ["\xF3\xB1\x99\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],
        ["\xF3\xB1\x99\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],
        ["\xF3\xB1\x99\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],
        ["\xF3\xB1\x99\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],
        ["\xF3\xB1\x99\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],
        ["\xF3\xB1\x99\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],
        ["\xF3\xB1\x99\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],
        ["\xF3\xB1\x99\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],
        ["\xF3\xB1\x99\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],
        ["\xF3\xB1\x99\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],
        ["\xF3\xB1\x99\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],
        ["\xF3\xB1\x99\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],
        ["\xF3\xB1\x99\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],
        ["\xF3\xB1\x99\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],
        ["\xF3\xB1\x99\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],
        ["\xF3\xB1\x99\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],
        ["\xF3\xB1\x99\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],
        ["\xF3\xB1\x99\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],
        ["\xF3\xB1\x99\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],
        ["\xF3\xB1\x99\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],
        ["\xF3\xB1\x99\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],
        ["\xF3\xB1\x99\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],
        ["\xF3\xB1\x99\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],
        ["\xF3\xB1\x99\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],
        ["\xF3\xB1\x99\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],
        ["\xF3\xB1\x99\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],
        ["\xF3\xB1\x99\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],
        ["\xF3\xB1\x99\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],
        ["\xF3\xB1\x99\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],
        ["\xF3\xB1\x99\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],
        ["\xF3\xB1\x99\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],
        ["\xF3\xB1\x99\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],
        ["\xF3\xB1\x99\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],
        ["\xF3\xB1\x99\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],
        ["\xF3\xB1\x99\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],
        ["\xF3\xB1\x99\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],
        ["\xF3\xB1\x99\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],
        ["\xF3\xB1\x99\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],
        ["\xF3\xB1\x99\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],
        ["\xF3\xB1\x99\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],
        ["\xF3\xB1\x99\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],
        ["\xF3\xB1\x99\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],
        ["\xF3\xB1\x99\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],
        ["\xF3\xB1\x99\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],
        ["\xF3\xB1\x99\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],
        ["\xF3\xB1\x99\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],
        ["\xF3\xB1\x99\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],
        ["\xF3\xB1\x99\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],
        ["\xF3\xB1\x99\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],
        ["\xF3\xB1\x99\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],
        ["\xF3\xB1\x99\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],
        ["\xF3\xB1\x99\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],
        ["\xF3\xB1\x99\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],
        ["\xF3\xB1\x99\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],
        ["\xF3\xB1\x99\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],
        ["\xF3\xB1\x99\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],
        ["\xF3\xB1\x99\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],
        ["\xF3\xB1\x99\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],
        ["\xF3\xB1\x9A\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],
        ["\xF3\xB1\x9A\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],
        ["\xF3\xB1\x9A\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],
        ["\xF3\xB1\x9A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],
        ["\xF3\xB1\x9A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],
        ["\xF3\xB1\x9A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],
        ["\xF3\xB1\x9A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],
        ["\xF3\xB1\x9A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],
        ["\xF3\xB1\x9A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],
        ["\xF3\xB1\x9A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],
        ["\xF3\xB1\x9A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],
        ["\xF3\xB1\x9A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],
        ["\xF3\xB1\x9A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],
        ["\xF3\xB1\x9A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],
        ["\xF3\xB1\x9A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],
        ["\xF3\xB1\x9A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],
        ["\xF3\xB1\x9A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],
        ["\xF3\xB1\x9A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],
        ["\xF3\xB1\x9A\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],
        ["\xF3\xB1\x9A\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],
        ["\xF3\xB1\x9A\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],
        ["\xF3\xB1\x9A\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],
        ["\xF3\xB1\x9A\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],
        ["\xF3\xB1\x9A\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],
        ["\xF3\xB1\x9A\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],
        ["\xF3\xB1\x9A\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],
        ["\xF3\xB1\x9A\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],
        ["\xF3\xB1\x9A\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],
        ["\xF3\xB1\x9A\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],
        ["\xF3\xB1\x9A\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],
        ["\xF3\xB1\x9A\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],
        ["\xF3\xB1\x9A\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],
        ["\xF3\xB1\x9A\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],
        ["\xF3\xB1\x9A\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],
        ["\xF3\xB1\x9A\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],
        ["\xF3\xB1\x9A\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],
        ["\xF3\xB1\x9A\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],
        ["\xF3\xB1\x9A\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],
        ["\xF3\xB1\x9A\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],
        ["\xF3\xB1\x9A\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],
        ["\xF3\xB1\x9A\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],
        ["\xF3\xB1\x9A\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],
        ["\xF3\xB1\x9A\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],
        ["\xF3\xB1\x9A\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],
        ["\xF3\xB1\x9A\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],
        ["\xF3\xB1\x9A\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],
        ["\xF3\xB1\x9A\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],
        ["\xF3\xB1\x9A\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],
        ["\xF3\xB1\x9A\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],
        ["\xF3\xB1\x9A\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],
        ["\xF3\xB1\x9A\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],
        ["\xF3\xB1\x9A\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],
        ["\xF3\xB1\x9A\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],
        ["\xF3\xB1\x9A\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],
        ["\xF3\xB1\x9A\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],
        ["\xF3\xB1\x9A\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],
        ["\xF3\xB1\x9A\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],
        ["\xF3\xB1\x9A\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],
        ["\xF3\xB1\x9A\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],
        ["\xF3\xB1\x9A\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],
        ["\xF3\xB1\x9A\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],
        ["\xF3\xB1\x9A\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],
        ["\xF3\xB1\x9A\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],
        ["\xF3\xB1\x9A\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],
        ["\xF3\xB1\x9B\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],
        ["\xF3\xB1\x9B\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],
        ["\xF3\xB1\x9B\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],
        ["\xF3\xB1\x9B\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],
        ["\xF3\xB1\x9B\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],
        ["\xF3\xB1\x9B\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],
        ["\xF3\xB1\x9B\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],
        ["\xF3\xB1\x9B\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],
        ["\xF3\xB1\x9B\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],
        ["\xF3\xB1\x9B\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],
        ["\xF3\xB1\x9B\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],
        ["\xF3\xB1\x9B\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],
        ["\xF3\xB1\x9B\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],
        ["\xF3\xB1\x9B\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],
        ["\xF3\xB1\x9B\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],
        ["\xF3\xB1\x9B\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],
        ["\xF3\xB1\x9B\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],
        ["\xF3\xB1\x9B\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],
        ["\xF3\xB1\x9B\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],
        ["\xF3\xB1\x9B\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],
        ["\xF3\xB1\x9B\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],
        ["\xF3\xB1\x9B\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],
        ["\xF3\xB1\x9B\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],
        ["\xF3\xB1\x9B\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],
        ["\xF3\xB1\x9B\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],
        ["\xF3\xB1\x9B\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],
        ["\xF3\xB1\x9B\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],
        ["\xF3\xB1\x9B\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],
        ["\xF3\xB1\x9B\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],
        ["\xF3\xB1\x9B\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],
        ["\xF3\xB1\x9B\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],
        ["\xF3\xB1\x9B\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],
        ["\xF3\xB1\x9B\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],
        ["\xF3\xB1\x9B\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],
        ["\xF3\xB1\x9B\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],
        ["\xF3\xB1\x9B\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],
        ["\xF3\xB1\x9B\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],
        ["\xF3\xB1\x9B\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],
        ["\xF3\xB1\x9B\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],
        ["\xF3\xB1\x9B\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],
        ["\xF3\xB1\x9B\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],
        ["\xF3\xB1\x9B\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],
        ["\xF3\xB1\x9B\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],
        ["\xF3\xB1\x9B\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],
        ["\xF3\xB1\x9B\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],
        ["\xF3\xB1\x9B\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],
        ["\xF3\xB1\x9B\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],
        ["\xF3\xB1\x9B\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],
        ["\xF3\xB1\x9B\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],
        ["\xF3\xB1\x9B\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],
        ["\xF3\xB1\x9B\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],
        ["\xF3\xB1\x9B\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],
        ["\xF3\xB1\x9B\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],
        ["\xF3\xB1\x9B\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],
        ["\xF3\xB1\x9B\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],
        ["\xF3\xB1\x9B\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],
        ["\xF3\xB1\x9B\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],
        ["\xF3\xB1\x9B\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],
        ["\xF3\xB1\x9B\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],
        ["\xF3\xB1\x9B\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],
        ["\xF3\xB1\x9B\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],
        ["\xF3\xB1\x9B\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],
        ["\xF3\xB1\x9B\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],
        ["\xF3\xB1\x9B\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],
        ["\xF3\xB1\x9C\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],
        ["\xF3\xB1\x9C\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],
        ["\xF3\xB1\x9C\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],
        ["\xF3\xB1\x9C\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],
        ["\xF3\xB1\x9C\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],
        ["\xF3\xB1\x9C\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],
        ["\xF3\xB1\x9C\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],
        ["\xF3\xB1\x9C\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],
        ["\xF3\xB1\x9C\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],
        ["\xF3\xB1\x9C\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],
        ["\xF3\xB1\x9C\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],
        ["\xF3\xB1\x9C\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],
        ["\xF3\xB1\x9C\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],
        ["\xF3\xB1\x9C\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],
        ["\xF3\xB1\x9C\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],
        ["\xF3\xB1\x9C\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],
        ["\xF3\xB1\x9C\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],
        ["\xF3\xB1\x9C\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],
        ["\xF3\xB1\x9C\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],
        ["\xF3\xB1\x9C\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],
        ["\xF3\xB1\x9C\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],
        ["\xF3\xB1\x9C\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],
        ["\xF3\xB1\x9C\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],
        ["\xF3\xB1\x9C\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],
        ["\xF3\xB1\x9C\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],
        ["\xF3\xB1\x9C\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],
        ["\xF3\xB1\x9C\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],
        ["\xF3\xB1\x9C\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],
        ["\xF3\xB1\x9C\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],
        ["\xF3\xB1\x9C\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],
        ["\xF3\xB1\x9C\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],
        ["\xF3\xB1\x9C\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],
        ["\xF3\xB1\x9C\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],
        ["\xF3\xB1\x9C\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],
        ["\xF3\xB1\x9C\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],
        ["\xF3\xB1\x9C\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],
        ["\xF3\xB1\x9C\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],
        ["\xF3\xB1\x9C\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],
        ["\xF3\xB1\x9C\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],
        ["\xF3\xB1\x9C\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],
        ["\xF3\xB1\x9C\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],
        ["\xF3\xB1\x9C\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],
        ["\xF3\xB1\x9C\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],
        ["\xF3\xB1\x9C\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],
        ["\xF3\xB1\x9C\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],
        ["\xF3\xB1\x9C\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],
        ["\xF3\xB1\x9C\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],
        ["\xF3\xB1\x9C\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],
        ["\xF3\xB1\x9C\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],
        ["\xF3\xB1\x9C\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],
        ["\xF3\xB1\x9C\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],
        ["\xF3\xB1\x9C\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],
        ["\xF3\xB1\x9C\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],
        ["\xF3\xB1\x9C\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],
        ["\xF3\xB1\x9C\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],
        ["\xF3\xB1\x9C\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],
        ["\xF3\xB1\x9C\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],
        ["\xF3\xB1\x9C\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],
        ["\xF3\xB1\x9C\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],
        ["\xF3\xB1\x9C\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],
        ["\xF3\xB1\x9C\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],
        ["\xF3\xB1\x9C\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],
        ["\xF3\xB1\x9C\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],
        ["\xF3\xB1\x9C\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],
        ["\xF3\xB1\x9D\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],
        ["\xF3\xB1\x9D\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],
        ["\xF3\xB1\x9D\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],
        ["\xF3\xB1\x9D\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],
        ["\xF3\xB1\x9D\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],
        ["\xF3\xB1\x9D\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],
        ["\xF3\xB1\x9D\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],
        ["\xF3\xB1\x9D\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],
        ["\xF3\xB1\x9D\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],
        ["\xF3\xB1\x9D\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],
        ["\xF3\xB1\x9D\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],
        ["\xF3\xB1\x9D\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],
        ["\xF3\xB1\x9D\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],
        ["\xF3\xB1\x9D\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],
        ["\xF3\xB1\x9D\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],
        ["\xF3\xB1\x9D\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],
        ["\xF3\xB1\x9D\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],
        ["\xF3\xB1\x9D\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],
        ["\xF3\xB1\x9D\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],
        ["\xF3\xB1\x9D\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],
        ["\xF3\xB1\x9D\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],
        ["\xF3\xB1\x9D\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],
        ["\xF3\xB1\x9D\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],
        ["\xF3\xB1\x9D\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],
        ["\xF3\xB1\x9D\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],
        ["\xF3\xB1\x9D\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],
        ["\xF3\xB1\x9D\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],
        ["\xF3\xB1\x9D\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],
        ["\xF3\xB1\x9D\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],
        ["\xF3\xB1\x9D\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],
        ["\xF3\xB1\x9D\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],
        ["\xF3\xB1\x9D\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],
        ["\xF3\xB1\x9D\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],
        ["\xF3\xB1\x9D\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],
        ["\xF3\xB1\x9D\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],
        ["\xF3\xB1\x9D\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],
        ["\xF3\xB1\x9D\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],
        ["\xF3\xB1\x9D\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],
        ["\xF3\xB1\x9D\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],
        ["\xF3\xB1\x9D\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],
        ["\xF3\xB1\x9D\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],
        ["\xF3\xB1\x9D\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],
        ["\xF3\xB1\x9D\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],
        ["\xF3\xB1\x9D\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],
        ["\xF3\xB1\x9D\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],
        ["\xF3\xB1\x9D\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],
        ["\xF3\xB1\x9D\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],
        ["\xF3\xB1\x9D\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],
        ["\xF3\xB1\x9D\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],
        ["\xF3\xB1\x9D\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],
        ["\xF3\xB1\x9D\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],
        ["\xF3\xB1\x9D\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],
        ["\xF3\xB1\x9D\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],
        ["\xF3\xB1\x9D\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],
        ["\xF3\xB1\x9D\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],
        ["\xF3\xB1\x9D\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],
        ["\xF3\xB1\x9D\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],
        ["\xF3\xB1\x9D\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],
        ["\xF3\xB1\x9D\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],
        ["\xF3\xB1\x9D\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],
        ["\xF3\xB1\x9D\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],
        ["\xF3\xB1\x9D\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],
        ["\xF3\xB1\x9D\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],
        ["\xF3\xB1\x9D\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],
        ["\xF3\xB1\x9E\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],
        ["\xF3\xB1\x9E\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],
        ["\xF3\xB1\x9E\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],
        ["\xF3\xB1\x9E\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],
        ["\xF3\xB1\x9E\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],
        ["\xF3\xB1\x9E\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],
        ["\xF3\xB1\x9E\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],
        ["\xF3\xB1\x9E\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],
        ["\xF3\xB1\x9E\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],
        ["\xF3\xB1\x9E\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],
        ["\xF3\xB1\x9E\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],
        ["\xF3\xB1\x9E\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],
        ["\xF3\xB1\x9E\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],
        ["\xF3\xB1\x9E\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],
        ["\xF3\xB1\x9E\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],
        ["\xF3\xB1\x9E\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],
        ["\xF3\xB1\x9E\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],
        ["\xF3\xB1\x9E\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],
        ["\xF3\xB1\x9E\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],
        ["\xF3\xB1\x9E\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],
        ["\xF3\xB1\x9E\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],
        ["\xF3\xB1\x9E\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],
        ["\xF3\xB1\x9E\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],
        ["\xF3\xB1\x9E\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],
        ["\xF3\xB1\x9E\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],
        ["\xF3\xB1\x9E\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],
        ["\xF3\xB1\x9E\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],
        ["\xF3\xB1\x9E\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],
        ["\xF3\xB1\x9E\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],
        ["\xF3\xB1\x9E\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],
        ["\xF3\xB1\x9E\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],
        ["\xF3\xB1\x9E\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],
        ["\xF3\xB1\x9E\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],
        ["\xF3\xB1\x9E\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],
        ["\xF3\xB1\x9E\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],
        ["\xF3\xB1\x9E\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],
        ["\xF3\xB1\x9E\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],
        ["\xF3\xB1\x9E\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],
        ["\xF3\xB1\x9E\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],
        ["\xF3\xB1\x9E\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],
        ["\xF3\xB1\x9E\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],
        ["\xF3\xB1\x9E\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],
        ["\xF3\xB1\x9E\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],
        ["\xF3\xB1\x9E\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],
        ["\xF3\xB1\x9E\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],
        ["\xF3\xB1\x9E\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],
        ["\xF3\xB1\x9E\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],
        ["\xF3\xB1\x9E\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],
        ["\xF3\xB1\x9E\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],
        ["\xF3\xB1\x9E\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],
        ["\xF3\xB1\x9E\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],
        ["\xF3\xB1\x9E\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],
        ["\xF3\xB1\x9E\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],
        ["\xF3\xB1\x9E\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],
        ["\xF3\xB1\x9E\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],
        ["\xF3\xB1\x9E\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],
        ["\xF3\xB1\x9E\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],
        ["\xF3\xB1\x9E\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],
        ["\xF3\xB1\x9E\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],
        ["\xF3\xB1\x9E\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],
        ["\xF3\xB1\x9E\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],
        ["\xF3\xB1\x9E\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],
        ["\xF3\xB1\x9E\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],
        ["\xF3\xB1\x9E\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],
        ["\xF3\xB1\x9F\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],
        ["\xF3\xB1\x9F\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],
        ["\xF3\xB1\x9F\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],
        ["\xF3\xB1\x9F\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],
        ["\xF3\xB1\x9F\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],
        ["\xF3\xB1\x9F\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],
        ["\xF3\xB1\x9F\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],
        ["\xF3\xB1\x9F\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],
        ["\xF3\xB1\x9F\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],
        ["\xF3\xB1\x9F\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],
        ["\xF3\xB1\x9F\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],
        ["\xF3\xB1\x9F\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],
        ["\xF3\xB1\x9F\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],
        ["\xF3\xB1\x9F\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],
        ["\xF3\xB1\x9F\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],
        ["\xF3\xB1\x9F\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],
        ["\xF3\xB1\x9F\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],
        ["\xF3\xB1\x9F\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],
        ["\xF3\xB1\x9F\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],
        ["\xF3\xB1\x9F\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],
        ["\xF3\xB1\x9F\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],
        ["\xF3\xB1\x9F\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],
        ["\xF3\xB1\x9F\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],
        ["\xF3\xB1\x9F\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],
        ["\xF3\xB1\x9F\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],
        ["\xF3\xB1\x9F\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],
        ["\xF3\xB1\x9F\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],
        ["\xF3\xB1\x9F\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],
        ["\xF3\xB1\x9F\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],
        ["\xF3\xB1\x9F\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],
        ["\xF3\xB1\x9F\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],
        ["\xF3\xB1\x9F\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],
        ["\xF3\xB1\x9F\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],
        ["\xF3\xB1\x9F\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],
        ["\xF3\xB1\x9F\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],
        ["\xF3\xB1\x9F\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],
        ["\xF3\xB1\x9F\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],
        ["\xF3\xB1\x9F\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],
        ["\xF3\xB1\x9F\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],
        ["\xF3\xB1\x9F\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],
        ["\xF3\xB1\x9F\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],
        ["\xF3\xB1\x9F\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],
        ["\xF3\xB1\x9F\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],
        ["\xF3\xB1\x9F\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],
        ["\xF3\xB1\x9F\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],
        ["\xF3\xB1\x9F\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],
        ["\xF3\xB1\x9F\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],
        ["\xF3\xB1\x9F\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],
        ["\xF3\xB1\x9F\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],
        ["\xF3\xB1\x9F\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],
        ["\xF3\xB1\x9F\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],
        ["\xF3\xB1\x9F\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],
        ["\xF3\xB1\x9F\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],
        ["\xF3\xB1\x9F\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],
        ["\xF3\xB1\x9F\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],
        ["\xF3\xB1\x9F\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],
        ["\xF3\xB1\x9F\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],
        ["\xF3\xB1\x9F\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],
        ["\xF3\xB1\x9F\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],
        ["\xF3\xB1\x9F\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],
        ["\xF3\xB1\x9F\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],
        ["\xF3\xB1\x9F\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],
        ["\xF3\xB1\x9F\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],
        ["\xF3\xB1\x9F\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],
        ["\xF3\xB1\xA0\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],
        ["\xF3\xB1\xA0\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],
        ["\xF3\xB1\xA0\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],
        ["\xF3\xB1\xA0\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],
        ["\xF3\xB1\xA0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],
        ["\xF3\xB1\xA0\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],
        ["\xF3\xB1\xA0\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],
        ["\xF3\xB1\xA0\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],
        ["\xF3\xB1\xA0\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],
        ["\xF3\xB1\xA0\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],
        ["\xF3\xB1\xA0\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],
        ["\xF3\xB1\xA0\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],
        ["\xF3\xB1\xA0\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],
        ["\xF3\xB1\xA0\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],
        ["\xF3\xB1\xA0\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],
        ["\xF3\xB1\xA0\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],
        ["\xF3\xB1\xA0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],
        ["\xF3\xB1\xA0\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],
        ["\xF3\xB1\xA0\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],
        ["\xF3\xB1\xA0\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],
        ["\xF3\xB1\xA0\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],
        ["\xF3\xB1\xA0\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],
        ["\xF3\xB1\xA0\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],
        ["\xF3\xB1\xA0\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],
        ["\xF3\xB1\xA0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],
        ["\xF3\xB1\xA0\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],
        ["\xF3\xB1\xA0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],
        ["\xF3\xB1\xA0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],
        ["\xF3\xB1\xA0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],
        ["\xF3\xB1\xA0\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],
        ["\xF3\xB1\xA0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],
        ["\xF3\xB1\xA0\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],
        ["\xF3\xB1\xA0\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],
        ["\xF3\xB1\xA0\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],
        ["\xF3\xB1\xA0\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],
        ["\xF3\xB1\xA0\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],
        ["\xF3\xB1\xA0\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],
        ["\xF3\xB1\xA0\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],
        ["\xF3\xB1\xA0\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],
        ["\xF3\xB1\xA0\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],
        ["\xF3\xB1\xA0\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],
        ["\xF3\xB1\xA0\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],
        ["\xF3\xB1\xA0\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],
        ["\xF3\xB1\xA0\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],
        ["\xF3\xB1\xA0\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],
        ["\xF3\xB1\xA0\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],
        ["\xF3\xB1\xA0\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],
        ["\xF3\xB1\xA0\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],
        ["\xF3\xB1\xA0\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],
        ["\xF3\xB1\xA0\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],
        ["\xF3\xB1\xA0\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],
        ["\xF3\xB1\xA0\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],
        ["\xF3\xB1\xA0\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],
        ["\xF3\xB1\xA0\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],
        ["\xF3\xB1\xA0\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],
        ["\xF3\xB1\xA0\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],
        ["\xF3\xB1\xA0\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],
        ["\xF3\xB1\xA0\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],
        ["\xF3\xB1\xA0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],
        ["\xF3\xB1\xA0\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],
        ["\xF3\xB1\xA0\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],
        ["\xF3\xB1\xA0\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],
        ["\xF3\xB1\xA0\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],
        ["\xF3\xB1\xA0\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],
        ["\xF3\xB1\xA1\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],
        ["\xF3\xB1\xA1\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],
        ["\xF3\xB1\xA1\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],
        ["\xF3\xB1\xA1\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],
        ["\xF3\xB1\xA1\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],
        ["\xF3\xB1\xA1\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],
        ["\xF3\xB1\xA1\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],
        ["\xF3\xB1\xA1\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],
        ["\xF3\xB1\xA1\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],
        ["\xF3\xB1\xA1\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],
        ["\xF3\xB1\xA1\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],
        ["\xF3\xB1\xA1\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],
        ["\xF3\xB1\xA1\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],
        ["\xF3\xB1\xA1\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],
        ["\xF3\xB1\xA1\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],
        ["\xF3\xB1\xA1\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],
        ["\xF3\xB1\xA1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],
        ["\xF3\xB1\xA1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],
        ["\xF3\xB1\xA1\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],
        ["\xF3\xB1\xA1\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],
        ["\xF3\xB1\xA1\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],
        ["\xF3\xB1\xA1\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],
        ["\xF3\xB1\xA1\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],
        ["\xF3\xB1\xA1\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],
        ["\xF3\xB1\xA1\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],
        ["\xF3\xB1\xA1\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],
        ["\xF3\xB1\xA1\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],
        ["\xF3\xB1\xA1\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],
        ["\xF3\xB1\xA1\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],
        ["\xF3\xB1\xA1\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],
        ["\xF3\xB1\xA1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],
        ["\xF3\xB1\xA1\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],
        ["\xF3\xB1\xA1\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],
        ["\xF3\xB1\xA1\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],
        ["\xF3\xB1\xA1\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],
        ["\xF3\xB1\xA1\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],
        ["\xF3\xB1\xA1\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],
        ["\xF3\xB1\xA1\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],
        ["\xF3\xB1\xA1\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],
        ["\xF3\xB1\xA1\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],
        ["\xF3\xB1\xA1\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],
        ["\xF3\xB1\xA1\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],
        ["\xF3\xB1\xA1\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],
        ["\xF3\xB1\xA1\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],
        ["\xF3\xB1\xA1\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],
        ["\xF3\xB1\xA1\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],
        ["\xF3\xB1\xA1\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],
        ["\xF3\xB1\xA1\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],
        ["\xF3\xB1\xA1\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],
        ["\xF3\xB1\xA1\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],
        ["\xF3\xB1\xA1\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],
        ["\xF3\xB1\xA1\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],
        ["\xF3\xB1\xA1\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],
        ["\xF3\xB1\xA1\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],
        ["\xF3\xB1\xA1\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],
        ["\xF3\xB1\xA1\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],
        ["\xF3\xB1\xA1\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],
        ["\xF3\xB1\xA1\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],
        ["\xF3\xB1\xA1\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],
        ["\xF3\xB1\xA1\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],
        ["\xF3\xB1\xA1\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],
        ["\xF3\xB1\xA1\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],
        ["\xF3\xB1\xA1\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],
        ["\xF3\xB1\xA1\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],
        ["\xF3\xB1\xA2\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],
        ["\xF3\xB1\xA2\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],
        ["\xF3\xB1\xA2\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],
        ["\xF3\xB1\xA2\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],
        ["\xF3\xB1\xA2\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],
        ["\xF3\xB1\xA2\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],
        ["\xF3\xB1\xA2\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],
        ["\xF3\xB1\xA2\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],
        ["\xF3\xB1\xA2\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],
        ["\xF3\xB1\xA2\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],
        ["\xF3\xB1\xA2\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],
        ["\xF3\xB1\xA2\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],
        ["\xF3\xB1\xA2\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],
        ["\xF3\xB1\xA2\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],
        ["\xF3\xB1\xA2\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],
        ["\xF3\xB1\xA2\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],
        ["\xF3\xB1\xA2\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],
        ["\xF3\xB1\xA2\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],
        ["\xF3\xB1\xA2\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],
        ["\xF3\xB1\xA2\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],
        ["\xF3\xB1\xA2\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],
        ["\xF3\xB1\xA2\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],
        ["\xF3\xB1\xA2\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],
        ["\xF3\xB1\xA2\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],
        ["\xF3\xB1\xA2\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],
        ["\xF3\xB1\xA2\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],
        ["\xF3\xB1\xA2\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],
        ["\xF3\xB1\xA2\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],
        ["\xF3\xB1\xA2\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],
        ["\xF3\xB1\xA2\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],
        ["\xF3\xB1\xA2\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],
        ["\xF3\xB1\xA2\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],
        ["\xF3\xB1\xA2\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],
        ["\xF3\xB1\xA2\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],
        ["\xF3\xB1\xA2\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],
        ["\xF3\xB1\xA2\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],
        ["\xF3\xB1\xA2\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],
        ["\xF3\xB1\xA2\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],
        ["\xF3\xB1\xA2\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],
        ["\xF3\xB1\xA2\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],
        ["\xF3\xB1\xA2\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],
        ["\xF3\xB1\xA2\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],
        ["\xF3\xB1\xA2\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],
        ["\xF3\xB1\xA2\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],
        ["\xF3\xB1\xA2\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],
        ["\xF3\xB1\xA2\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],
        ["\xF3\xB1\xA2\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],
        ["\xF3\xB1\xA2\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],
        ["\xF3\xB1\xA2\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],
        ["\xF3\xB1\xA2\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],
        ["\xF3\xB1\xA2\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],
        ["\xF3\xB1\xA2\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],
        ["\xF3\xB1\xA2\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],
        ["\xF3\xB1\xA2\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],
        ["\xF3\xB1\xA2\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],
        ["\xF3\xB1\xA2\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],
        ["\xF3\xB1\xA2\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],
        ["\xF3\xB1\xA2\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],
        ["\xF3\xB1\xA2\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],
        ["\xF3\xB1\xA2\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],
        ["\xF3\xB1\xA2\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],
        ["\xF3\xB1\xA2\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],
        ["\xF3\xB1\xA2\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],
        ["\xF3\xB1\xA2\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],
        ["\xF3\xB1\xA3\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],
        ["\xF3\xB1\xA3\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],
        ["\xF3\xB1\xA3\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],
        ["\xF3\xB1\xA3\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],
        ["\xF3\xB1\xA3\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],
        ["\xF3\xB1\xA3\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],
        ["\xF3\xB1\xA3\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],
        ["\xF3\xB1\xA3\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],
        ["\xF3\xB1\xA3\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],
        ["\xF3\xB1\xA3\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],
        ["\xF3\xB1\xA3\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],
        ["\xF3\xB1\xA3\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],
        ["\xF3\xB1\xA3\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],
        ["\xF3\xB1\xA3\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],
        ["\xF3\xB1\xA3\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],
        ["\xF3\xB1\xA3\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],
        ["\xF3\xB1\xA3\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],
        ["\xF3\xB1\xA3\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],
        ["\xF3\xB1\xA3\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],
        ["\xF3\xB1\xA3\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],
        ["\xF3\xB1\xA3\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],
        ["\xF3\xB1\xA3\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],
        ["\xF3\xB1\xA3\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],
        ["\xF3\xB1\xA3\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],
        ["\xF3\xB1\xA3\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],
        ["\xF3\xB1\xA3\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],
        ["\xF3\xB1\xA3\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],
        ["\xF3\xB1\xA3\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],
        ["\xF3\xB1\xA3\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],
        ["\xF3\xB1\xA3\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],
        ["\xF3\xB1\xA3\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],
        ["\xF3\xB1\xA3\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],
        ["\xF3\xB1\xA3\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],
        ["\xF3\xB1\xA3\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],
        ["\xF3\xB1\xA3\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],
        ["\xF3\xB1\xA3\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],
        ["\xF3\xB1\xA3\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],
        ["\xF3\xB1\xA3\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],
        ["\xF3\xB1\xA3\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],
        ["\xF3\xB1\xA3\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],
        ["\xF3\xB1\xA3\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],
        ["\xF3\xB1\xA3\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],
        ["\xF3\xB1\xA3\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],
        ["\xF3\xB1\xA3\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],
        ["\xF3\xB1\xA3\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],
        ["\xF3\xB1\xA3\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],
        ["\xF3\xB1\xA3\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],
        ["\xF3\xB1\xA3\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],
        ["\xF3\xB1\xA3\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],
        ["\xF3\xB1\xA3\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],
        ["\xF3\xB1\xA3\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],
        ["\xF3\xB1\xA3\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],
        ["\xF3\xB1\xA3\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],
        ["\xF3\xB1\xA3\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],
        ["\xF3\xB1\xA3\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],
        ["\xF3\xB1\xA3\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],
        ["\xF3\xB1\xA3\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],
        ["\xF3\xB1\xA3\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],
        ["\xF3\xB1\xA3\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],
        ["\xF3\xB1\xA3\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],
        ["\xF3\xB1\xA3\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],
        ["\xF3\xB1\xA3\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],
        ["\xF3\xB1\xA3\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],
        ["\xF3\xB1\xA3\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],
        ["\xF3\xB1\xA4\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],
        ["\xF3\xB1\xA4\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],
        ["\xF3\xB1\xA4\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],
        ["\xF3\xB1\xA4\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],
        ["\xF3\xB1\xA4\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],
        ["\xF3\xB1\xA4\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],
        ["\xF3\xB1\xA4\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],
        ["\xF3\xB1\xA4\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],
        ["\xF3\xB1\xA4\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],
        ["\xF3\xB1\xA4\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],
        ["\xF3\xB1\xA4\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],
        ["\xF3\xB1\xA4\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],
        ["\xF3\xB1\xA4\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],
        ["\xF3\xB1\xA4\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],
        ["\xF3\xB1\xA4\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],
        ["\xF3\xB1\xA4\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],
        ["\xF3\xB1\xA4\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],
        ["\xF3\xB1\xA4\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],
        ["\xF3\xB1\xA4\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],
        ["\xF3\xB1\xA4\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],
        ["\xF3\xB1\xA4\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],
        ["\xF3\xB1\xA4\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],
        ["\xF3\xB1\xA4\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],
        ["\xF3\xB1\xA4\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],
        ["\xF3\xB1\xA4\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],
        ["\xF3\xB1\xA4\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],
        ["\xF3\xB1\xA4\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],
        ["\xF3\xB1\xA4\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],
        ["\xF3\xB1\xA4\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],
        ["\xF3\xB1\xA4\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],
        ["\xF3\xB1\xA4\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],
        ["\xF3\xB1\xA4\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],
        ["\xF3\xB1\xA4\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],
        ["\xF3\xB1\xA4\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],
        ["\xF3\xB1\xA4\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],
        ["\xF3\xB1\xA4\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],
        ["\xF3\xB1\xA4\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],
        ["\xF3\xB1\xA4\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],
        ["\xF3\xB1\xA4\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],
        ["\xF3\xB1\xA4\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],
        ["\xF3\xB1\xA4\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],
        ["\xF3\xB1\xA4\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],
        ["\xF3\xB1\xA4\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],
        ["\xF3\xB1\xA4\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],
        ["\xF3\xB1\xA4\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],
        ["\xF3\xB1\xA4\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],
        ["\xF3\xB1\xA4\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],
        ["\xF3\xB1\xA4\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],
        ["\xF3\xB1\xA4\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],
        ["\xF3\xB1\xA4\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],
        ["\xF3\xB1\xA4\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],
        ["\xF3\xB1\xA4\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],
        ["\xF3\xB1\xA4\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],
        ["\xF3\xB1\xA4\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],
        ["\xF3\xB1\xA4\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],
        ["\xF3\xB1\xA4\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],
        ["\xF3\xB1\xA4\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],
        ["\xF3\xB1\xA4\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],
        ["\xF3\xB1\xA4\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],
        ["\xF3\xB1\xA4\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],
        ["\xF3\xB1\xA4\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],
        ["\xF3\xB1\xA4\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],
        ["\xF3\xB1\xA4\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],
        ["\xF3\xB1\xA4\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],
        ["\xF3\xB1\xA5\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],
        ["\xF3\xB1\xA5\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],
        ["\xF3\xB1\xA5\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],
        ["\xF3\xB1\xA5\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],
        ["\xF3\xB1\xA5\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],
        ["\xF3\xB1\xA5\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],
        ["\xF3\xB1\xA5\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],
        ["\xF3\xB1\xA5\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],
        ["\xF3\xB1\xA5\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],
        ["\xF3\xB1\xA5\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],
        ["\xF3\xB1\xA5\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],
        ["\xF3\xB1\xA5\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],
        ["\xF3\xB1\xA5\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],
        ["\xF3\xB1\xA5\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],
        ["\xF3\xB1\xA5\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],
        ["\xF3\xB1\xA5\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],
        ["\xF3\xB1\xA5\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],
        ["\xF3\xB1\xA5\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],
        ["\xF3\xB1\xA5\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],
        ["\xF3\xB1\xA5\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],
        ["\xF3\xB1\xA5\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],
        ["\xF3\xB1\xA5\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],
        ["\xF3\xB1\xA5\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],
        ["\xF3\xB1\xA5\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],
        ["\xF3\xB1\xA5\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],
        ["\xF3\xB1\xA5\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],
        ["\xF3\xB1\xA5\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],
        ["\xF3\xB1\xA5\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],
        ["\xF3\xB1\xA5\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],
        ["\xF3\xB1\xA5\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],
        ["\xF3\xB1\xA5\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],
        ["\xF3\xB1\xA5\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],
        ["\xF3\xB1\xA5\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],
        ["\xF3\xB1\xA5\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],
        ["\xF3\xB1\xA5\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],
        ["\xF3\xB1\xA5\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],
        ["\xF3\xB1\xA5\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],
        ["\xF3\xB1\xA5\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],
        ["\xF3\xB1\xA5\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],
        ["\xF3\xB1\xA5\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],
        ["\xF3\xB1\xA5\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],
        ["\xF3\xB1\xA5\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],
        ["\xF3\xB1\xA5\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],
        ["\xF3\xB1\xA5\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],
        ["\xF3\xB1\xA5\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],
        ["\xF3\xB1\xA5\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],
        ["\xF3\xB1\xA5\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],
        ["\xF3\xB1\xA5\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],
        ["\xF3\xB1\xA5\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],
        ["\xF3\xB1\xA5\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],
        ["\xF3\xB1\xA5\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],
        ["\xF3\xB1\xA5\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],
        ["\xF3\xB1\xA5\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],
        ["\xF3\xB1\xA5\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],
        ["\xF3\xB1\xA5\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],
        ["\xF3\xB1\xA5\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],
        ["\xF3\xB1\xA5\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],
        ["\xF3\xB1\xA5\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],
        ["\xF3\xB1\xA5\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],
        ["\xF3\xB1\xA5\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],
        ["\xF3\xB1\xA5\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],
        ["\xF3\xB1\xA5\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],
        ["\xF3\xB1\xA5\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],
        ["\xF3\xB1\xA5\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],
        ["\xF3\xB1\xA6\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],
        ["\xF3\xB1\xA6\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],
        ["\xF3\xB1\xA6\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],
        ["\xF3\xB1\xA6\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],
        ["\xF3\xB1\xA6\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],
        ["\xF3\xB1\xA6\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],
        ["\xF3\xB1\xA6\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],
        ["\xF3\xB1\xA6\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],
        ["\xF3\xB1\xA6\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],
        ["\xF3\xB1\xA6\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],
        ["\xF3\xB1\xA6\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],
        ["\xF3\xB1\xA6\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],
        ["\xF3\xB1\xA6\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],
        ["\xF3\xB1\xA6\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],
        ["\xF3\xB1\xA6\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],
        ["\xF3\xB1\xA6\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],
        ["\xF3\xB1\xA6\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],
        ["\xF3\xB1\xA6\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],
        ["\xF3\xB1\xA6\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],
        ["\xF3\xB1\xA6\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],
        ["\xF3\xB1\xA6\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],
        ["\xF3\xB1\xA6\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],
        ["\xF3\xB1\xA6\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],
        ["\xF3\xB1\xA6\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],
        ["\xF3\xB1\xA6\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],
        ["\xF3\xB1\xA6\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],
        ["\xF3\xB1\xA6\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],
        ["\xF3\xB1\xA6\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],
        ["\xF3\xB1\xA6\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],
        ["\xF3\xB1\xA6\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],
        ["\xF3\xB1\xA6\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],
        ["\xF3\xB1\xA6\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],
        ["\xF3\xB1\xA6\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],
        ["\xF3\xB1\xA6\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],
        ["\xF3\xB1\xA6\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],
        ["\xF3\xB1\xA6\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],
        ["\xF3\xB1\xA6\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],
        ["\xF3\xB1\xA6\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],
        ["\xF3\xB1\xA6\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],
        ["\xF3\xB1\xA6\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],
        ["\xF3\xB1\xA6\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],
        ["\xF3\xB1\xA6\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],
        ["\xF3\xB1\xA6\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],
        ["\xF3\xB1\xA6\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],
        ["\xF3\xB1\xA6\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],
        ["\xF3\xB1\xA6\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],
        ["\xF3\xB1\xA6\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],
        ["\xF3\xB1\xA6\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],
        ["\xF3\xB1\xA6\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],
        ["\xF3\xB1\xA6\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],
        ["\xF3\xB1\xA6\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],
        ["\xF3\xB1\xA6\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],
        ["\xF3\xB1\xA6\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],
        ["\xF3\xB1\xA6\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],
        ["\xF3\xB1\xA6\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],
        ["\xF3\xB1\xA6\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],
        ["\xF3\xB1\xA6\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],
        ["\xF3\xB1\xA6\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],
        ["\xF3\xB1\xA6\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],
        ["\xF3\xB1\xA6\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],
        ["\xF3\xB1\xA6\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],
        ["\xF3\xB1\xA6\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],
        ["\xF3\xB1\xA6\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],
        ["\xF3\xB1\xA6\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],
        ["\xF3\xB1\xA7\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],
        ["\xF3\xB1\xA7\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],
        ["\xF3\xB1\xA7\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],
        ["\xF3\xB1\xA7\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],
        ["\xF3\xB1\xA7\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],
        ["\xF3\xB1\xA7\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],
        ["\xF3\xB1\xA7\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],
        ["\xF3\xB1\xA7\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],
        ["\xF3\xB1\xA7\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],
        ["\xF3\xB1\xA7\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],
        ["\xF3\xB1\xA7\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],
        ["\xF3\xB1\xA7\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],
        ["\xF3\xB1\xA7\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],
        ["\xF3\xB1\xA7\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],
        ["\xF3\xB1\xA7\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],
        ["\xF3\xB1\xA7\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],
        ["\xF3\xB1\xA7\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],
        ["\xF3\xB1\xA7\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],
        ["\xF3\xB1\xA7\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],
        ["\xF3\xB1\xA7\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],
        ["\xF3\xB1\xA7\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],
        ["\xF3\xB1\xA7\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],
        ["\xF3\xB1\xA7\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],
        ["\xF3\xB1\xA7\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],
        ["\xF3\xB1\xA7\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],
        ["\xF3\xB1\xA7\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],
        ["\xF3\xB1\xA7\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],
        ["\xF3\xB1\xA7\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],
        ["\xF3\xB1\xA7\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],
        ["\xF3\xB1\xA7\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],
        ["\xF3\xB1\xA7\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],
        ["\xF3\xB1\xA7\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],
        ["\xF3\xB1\xA7\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],
        ["\xF3\xB1\xA7\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],
        ["\xF3\xB1\xA7\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],
        ["\xF3\xB1\xA7\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],
        ["\xF3\xB1\xA7\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],
        ["\xF3\xB1\xA7\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],
        ["\xF3\xB1\xA7\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],
        ["\xF3\xB1\xA7\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],
        ["\xF3\xB1\xA7\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],
        ["\xF3\xB1\xA7\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],
        ["\xF3\xB1\xA7\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],
        ["\xF3\xB1\xA7\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],
        ["\xF3\xB1\xA7\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],
        ["\xF3\xB1\xA7\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],
        ["\xF3\xB1\xA7\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],
        ["\xF3\xB1\xA7\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],
        ["\xF3\xB1\xA7\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],
        ["\xF3\xB1\xA7\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],
        ["\xF3\xB1\xA7\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],
        ["\xF3\xB1\xA7\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],
        ["\xF3\xB1\xA7\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],
        ["\xF3\xB1\xA7\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],
        ["\xF3\xB1\xA7\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],
        ["\xF3\xB1\xA7\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],
        ["\xF3\xB1\xA7\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],
        ["\xF3\xB1\xA7\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],
        ["\xF3\xB1\xA7\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],
        ["\xF3\xB1\xA7\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],
        ["\xF3\xB1\xA7\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],
        ["\xF3\xB1\xA7\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],
        ["\xF3\xB1\xA7\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],
        ["\xF3\xB1\xA7\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],
        ["\xF3\xB1\xA8\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],
        ["\xF3\xB1\xA8\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],
        ["\xF3\xB1\xA8\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],
        ["\xF3\xB1\xA8\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],
        ["\xF3\xB1\xA8\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],
        ["\xF3\xB1\xA8\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],
        ["\xF3\xB1\xA8\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],
        ["\xF3\xB1\xA8\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],
        ["\xF3\xB1\xA8\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],
        ["\xF3\xB1\xA8\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],
        ["\xF3\xB1\xA8\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],
        ["\xF3\xB1\xA8\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],
        ["\xF3\xB1\xA8\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],
        ["\xF3\xB1\xA8\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],
        ["\xF3\xB1\xA8\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],
        ["\xF3\xB1\xA8\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],
        ["\xF3\xB1\xA8\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],
        ["\xF3\xB1\xA8\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],
        ["\xF3\xB1\xA8\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],
        ["\xF3\xB1\xA8\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],
        ["\xF3\xB1\xA8\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],
        ["\xF3\xB1\xA8\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],
        ["\xF3\xB1\xA8\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],
        ["\xF3\xB1\xA8\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],
        ["\xF3\xB1\xA8\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],
        ["\xF3\xB1\xA8\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],
        ["\xF3\xB1\xA8\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],
        ["\xF3\xB1\xA8\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],
        ["\xF3\xB1\xA8\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],
        ["\xF3\xB1\xA8\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],
        ["\xF3\xB1\xA8\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],
        ["\xF3\xB1\xA8\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],
        ["\xF3\xB1\xA8\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],
        ["\xF3\xB1\xA8\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],
        ["\xF3\xB1\xA8\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],
        ["\xF3\xB1\xA8\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],
        ["\xF3\xB1\xA8\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],
        ["\xF3\xB1\xA8\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],
        ["\xF3\xB1\xA8\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],
        ["\xF3\xB1\xA8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],
        ["\xF3\xB1\xA8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],
        ["\xF3\xB1\xA8\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],
        ["\xF3\xB1\xA8\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],
        ["\xF3\xB1\xA8\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],
        ["\xF3\xB1\xA8\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],
        ["\xF3\xB1\xA8\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],
        ["\xF3\xB1\xA8\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],
        ["\xF3\xB1\xA8\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],
        ["\xF3\xB1\xA8\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],
        ["\xF3\xB1\xA8\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],
        ["\xF3\xB1\xA8\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],
        ["\xF3\xB1\xA8\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],
        ["\xF3\xB1\xA8\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],
        ["\xF3\xB1\xA8\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],
        ["\xF3\xB1\xA8\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],
        ["\xF3\xB1\xA8\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],
        ["\xF3\xB1\xA8\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],
        ["\xF3\xB1\xA8\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],
        ["\xF3\xB1\xA8\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],
        ["\xF3\xB1\xA8\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],
        ["\xF3\xB1\xA8\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],
        ["\xF3\xB1\xA8\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],
        ["\xF3\xB1\xA8\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],
        ["\xF3\xB1\xA8\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],
        ["\xF3\xB1\xA9\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],
        ["\xF3\xB1\xA9\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],
        ["\xF3\xB1\xA9\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],
        ["\xF3\xB1\xA9\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],
        ["\xF3\xB1\xA9\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],
        ["\xF3\xB1\xA9\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],
        ["\xF3\xB1\xA9\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],
        ["\xF3\xB1\xA9\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],
        ["\xF3\xB1\xA9\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],
        ["\xF3\xB1\xA9\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],
        ["\xF3\xB1\xA9\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],
        ["\xF3\xB1\xA9\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],
        ["\xF3\xB1\xA9\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],
        ["\xF3\xB1\xA9\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],
        ["\xF3\xB1\xA9\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],
        ["\xF3\xB1\xA9\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],
        ["\xF3\xB1\xA9\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],
        ["\xF3\xB1\xA9\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],
        ["\xF3\xB1\xA9\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],
        ["\xF3\xB1\xA9\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],
        ["\xF3\xB1\xA9\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],
        ["\xF3\xB1\xA9\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],
        ["\xF3\xB1\xA9\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],
        ["\xF3\xB1\xA9\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],
        ["\xF3\xB1\xA9\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],
        ["\xF3\xB1\xA9\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],
        ["\xF3\xB1\xA9\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],
        ["\xF3\xB1\xA9\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],
        ["\xF3\xB1\xA9\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],
        ["\xF3\xB1\xA9\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],
        ["\xF3\xB1\xA9\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],
        ["\xF3\xB1\xA9\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],
        ["\xF3\xB1\xA9\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],
        ["\xF3\xB1\xA9\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],
        ["\xF3\xB1\xA9\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],
        ["\xF3\xB1\xA9\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],
        ["\xF3\xB1\xA9\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],
        ["\xF3\xB1\xA9\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],
        ["\xF3\xB1\xA9\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],
        ["\xF3\xB1\xA9\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],
        ["\xF3\xB1\xA9\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],
        ["\xF3\xB1\xA9\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],
        ["\xF3\xB1\xA9\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],
        ["\xF3\xB1\xA9\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],
        ["\xF3\xB1\xA9\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],
        ["\xF3\xB1\xA9\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],
        ["\xF3\xB1\xA9\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],
        ["\xF3\xB1\xA9\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],
        ["\xF3\xB1\xA9\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],
        ["\xF3\xB1\xA9\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],
        ["\xF3\xB1\xA9\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],
        ["\xF3\xB1\xA9\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],
        ["\xF3\xB1\xA9\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],
        ["\xF3\xB1\xA9\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],
        ["\xF3\xB1\xA9\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],
        ["\xF3\xB1\xA9\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],
        ["\xF3\xB1\xA9\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],
        ["\xF3\xB1\xA9\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],
        ["\xF3\xB1\xA9\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],
        ["\xF3\xB1\xA9\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],
        ["\xF3\xB1\xA9\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],
        ["\xF3\xB1\xA9\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],
        ["\xF3\xB1\xA9\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],
        ["\xF3\xB1\xA9\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],
        ["\xF3\xB1\xAA\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],
        ["\xF3\xB1\xAA\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],
        ["\xF3\xB1\xAA\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],
        ["\xF3\xB1\xAA\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],
        ["\xF3\xB1\xAA\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],
        ["\xF3\xB1\xAA\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],
        ["\xF3\xB1\xAA\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],
        ["\xF3\xB1\xAA\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],
        ["\xF3\xB1\xAA\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],
        ["\xF3\xB1\xAA\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],
        ["\xF3\xB1\xAA\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],
        ["\xF3\xB1\xAA\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],
        ["\xF3\xB1\xAA\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],
        ["\xF3\xB1\xAA\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],
        ["\xF3\xB1\xAA\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],
        ["\xF3\xB1\xAA\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],
        ["\xF3\xB1\xAA\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],
        ["\xF3\xB1\xAA\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],
        ["\xF3\xB1\xAA\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],
        ["\xF3\xB1\xAA\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],
        ["\xF3\xB1\xAA\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],
        ["\xF3\xB1\xAA\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],
        ["\xF3\xB1\xAA\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],
        ["\xF3\xB1\xAA\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],
        ["\xF3\xB1\xAA\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],
        ["\xF3\xB1\xAA\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],
        ["\xF3\xB1\xAA\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],
        ["\xF3\xB1\xAA\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],
        ["\xF3\xB1\xAA\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],
        ["\xF3\xB1\xAA\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],
        ["\xF3\xB1\xAA\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],
        ["\xF3\xB1\xAA\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],
        ["\xF3\xB1\xAA\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],
        ["\xF3\xB1\xAA\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],
        ["\xF3\xB1\xAA\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],
        ["\xF3\xB1\xAA\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],
        ["\xF3\xB1\xAA\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],
        ["\xF3\xB1\xAA\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],
        ["\xF3\xB1\xAA\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],
        ["\xF3\xB1\xAA\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],
        ["\xF3\xB1\xAA\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],
        ["\xF3\xB1\xAA\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],
        ["\xF3\xB1\xAA\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],
        ["\xF3\xB1\xAA\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],
        ["\xF3\xB1\xAA\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],
        ["\xF3\xB1\xAA\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],
        ["\xF3\xB1\xAA\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],
        ["\xF3\xB1\xAA\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],
        ["\xF3\xB1\xAA\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],
        ["\xF3\xB1\xAA\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],
        ["\xF3\xB1\xAA\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],
        ["\xF3\xB1\xAA\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],
        ["\xF3\xB1\xAA\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],
        ["\xF3\xB1\xAA\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],
        ["\xF3\xB1\xAA\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],
        ["\xF3\xB1\xAA\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],
        ["\xF3\xB1\xAA\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],
        ["\xF3\xB1\xAA\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],
        ["\xF3\xB1\xAA\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],
        ["\xF3\xB1\xAA\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],
        ["\xF3\xB1\xAA\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],
        ["\xF3\xB1\xAA\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],
        ["\xF3\xB1\xAA\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],
        ["\xF3\xB1\xAA\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],
        ["\xF3\xB1\xAB\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],
        ["\xF3\xB1\xAB\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],
        ["\xF3\xB1\xAB\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],
        ["\xF3\xB1\xAB\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],
        ["\xF3\xB1\xAB\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],
        ["\xF3\xB1\xAB\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],
        ["\xF3\xB1\xAB\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],
        ["\xF3\xB1\xAB\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],
        ["\xF3\xB1\xAB\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],
        ["\xF3\xB1\xAB\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],
        ["\xF3\xB1\xAB\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],
        ["\xF3\xB1\xAB\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],
        ["\xF3\xB1\xAB\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],
        ["\xF3\xB1\xAB\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],
        ["\xF3\xB1\xAB\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],
        ["\xF3\xB1\xAB\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],
        ["\xF3\xB1\xAB\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],
        ["\xF3\xB1\xAB\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],
        ["\xF3\xB1\xAB\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],
        ["\xF3\xB1\xAB\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],
        ["\xF3\xB1\xAB\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],
        ["\xF3\xB1\xAB\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],
        ["\xF3\xB1\xAB\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],
        ["\xF3\xB1\xAB\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],
        ["\xF3\xB1\xAB\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],
        ["\xF3\xB1\xAB\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],
        ["\xF3\xB1\xAB\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],
        ["\xF3\xB1\xAB\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],
        ["\xF3\xB1\xAB\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],
        ["\xF3\xB1\xAB\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],
        ["\xF3\xB1\xAB\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],
        ["\xF3\xB1\xAB\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],
        ["\xF3\xB1\xAB\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],
        ["\xF3\xB1\xAB\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],
        ["\xF3\xB1\xAB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],
        ["\xF3\xB1\xAB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],
        ["\xF3\xB1\xAB\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],
        ["\xF3\xB1\xAB\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],
        ["\xF3\xB1\xAB\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],
        ["\xF3\xB1\xAB\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],
        ["\xF3\xB1\xAB\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],
        ["\xF3\xB1\xAB\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],
        ["\xF3\xB1\xAB\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],
        ["\xF3\xB1\xAB\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],
        ["\xF3\xB1\xAB\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],
        ["\xF3\xB1\xAB\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],
        ["\xF3\xB1\xAB\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],
        ["\xF3\xB1\xAB\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],
        ["\xF3\xB1\xAB\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],
        ["\xF3\xB1\xAB\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],
        ["\xF3\xB1\xAB\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],
        ["\xF3\xB1\xAB\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],
        ["\xF3\xB1\xAB\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],
        ["\xF3\xB1\xAB\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],
        ["\xF3\xB1\xAB\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],
        ["\xF3\xB1\xAB\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],
        ["\xF3\xB1\xAB\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],
        ["\xF3\xB1\xAB\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],
        ["\xF3\xB1\xAB\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],
        ["\xF3\xB1\xAB\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],
        ["\xF3\xB1\xAB\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],
        ["\xF3\xB1\xAB\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],
        ["\xF3\xB1\xAB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],
        ["\xF3\xB1\xAB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],
        ["\xF3\xB1\xAC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],
        ["\xF3\xB1\xAC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],
        ["\xF3\xB1\xAC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],
        ["\xF3\xB1\xAC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],
        ["\xF3\xB1\xAC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],
        ["\xF3\xB1\xAC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],
        ["\xF3\xB1\xAC\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],
        ["\xF3\xB1\xAC\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],
        ["\xF3\xB1\xAC\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],
        ["\xF3\xB1\xAC\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],
        ["\xF3\xB1\xAC\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],
        ["\xF3\xB1\xAC\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],
        ["\xF3\xB1\xAC\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],
        ["\xF3\xB1\xAC\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],
        ["\xF3\xB1\xAC\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],
        ["\xF3\xB1\xAC\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],
        ["\xF3\xB1\xAC\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],
        ["\xF3\xB1\xAC\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],
        ["\xF3\xB1\xAC\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],
        ["\xF3\xB1\xAC\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],
        ["\xF3\xB1\xAC\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],
        ["\xF3\xB1\xAC\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],
        ["\xF3\xB1\xAC\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],
        ["\xF3\xB1\xAC\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],
        ["\xF3\xB1\xAC\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],
        ["\xF3\xB1\xAC\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],
        ["\xF3\xB1\xAC\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],
        ["\xF3\xB1\xAC\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],
        ["\xF3\xB1\xAC\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],
        ["\xF3\xB1\xAC\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],
        ["\xF3\xB1\xAC\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],
        ["\xF3\xB1\xAC\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],
        ["\xF3\xB1\xAC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],
        ["\xF3\xB1\xAC\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],
        ["\xF3\xB1\xAC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],
        ["\xF3\xB1\xAC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],
        ["\xF3\xB1\xAC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],
        ["\xF3\xB1\xAC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],
        ["\xF3\xB1\xAC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],
        ["\xF3\xB1\xAC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],
        ["\xF3\xB1\xAC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],
        ["\xF3\xB1\xAC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],
        ["\xF3\xB1\xAC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],
        ["\xF3\xB1\xAC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],
        ["\xF3\xB1\xAC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],
        ["\xF3\xB1\xAC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],
        ["\xF3\xB1\xAC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],
        ["\xF3\xB1\xAC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],
        ["\xF3\xB1\xAC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],
        ["\xF3\xB1\xAC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],
        ["\xF3\xB1\xAC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],
        ["\xF3\xB1\xAC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],
        ["\xF3\xB1\xAC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],
        ["\xF3\xB1\xAC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],
        ["\xF3\xB1\xAC\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],
        ["\xF3\xB1\xAC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],
        ["\xF3\xB1\xAC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],
        ["\xF3\xB1\xAC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],
        ["\xF3\xB1\xAC\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],
        ["\xF3\xB1\xAC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],
        ["\xF3\xB1\xAC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],
        ["\xF3\xB1\xAC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],
        ["\xF3\xB1\xAC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],
        ["\xF3\xB1\xAC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],
        ["\xF3\xB1\xAD\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],
        ["\xF3\xB1\xAD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],
        ["\xF3\xB1\xAD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],
        ["\xF3\xB1\xAD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],
        ["\xF3\xB1\xAD\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],
        ["\xF3\xB1\xAD\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],
        ["\xF3\xB1\xAD\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],
        ["\xF3\xB1\xAD\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],
        ["\xF3\xB1\xAD\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],
        ["\xF3\xB1\xAD\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],
        ["\xF3\xB1\xAD\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],
        ["\xF3\xB1\xAD\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],
        ["\xF3\xB1\xAD\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],
        ["\xF3\xB1\xAD\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],
        ["\xF3\xB1\xAD\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],
        ["\xF3\xB1\xAD\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],
        ["\xF3\xB1\xAD\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],
        ["\xF3\xB1\xAD\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],
        ["\xF3\xB1\xAD\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],
        ["\xF3\xB1\xAD\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],
        ["\xF3\xB1\xAD\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],
        ["\xF3\xB1\xAD\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],
        ["\xF3\xB1\xAD\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],
        ["\xF3\xB1\xAD\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],
        ["\xF3\xB1\xAD\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],
        ["\xF3\xB1\xAD\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],
        ["\xF3\xB1\xAD\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],
        ["\xF3\xB1\xAD\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],
        ["\xF3\xB1\xAD\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],
        ["\xF3\xB1\xAD\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],
        ["\xF3\xB1\xAD\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],
        ["\xF3\xB1\xAD\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],
        ["\xF3\xB1\xAD\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],
        ["\xF3\xB1\xAD\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],
        ["\xF3\xB1\xAD\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],
        ["\xF3\xB1\xAD\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],
        ["\xF3\xB1\xAD\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],
        ["\xF3\xB1\xAD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],
        ["\xF3\xB1\xAD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],
        ["\xF3\xB1\xAD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],
        ["\xF3\xB1\xAD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],
        ["\xF3\xB1\xAD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],
        ["\xF3\xB1\xAD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],
        ["\xF3\xB1\xAD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],
        ["\xF3\xB1\xAD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],
        ["\xF3\xB1\xAD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],
        ["\xF3\xB1\xAD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],
        ["\xF3\xB1\xAD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],
        ["\xF3\xB1\xAD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],
        ["\xF3\xB1\xAD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],
        ["\xF3\xB1\xAD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],
        ["\xF3\xB1\xAD\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],
        ["\xF3\xB1\xAD\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],
        ["\xF3\xB1\xAD\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],
        ["\xF3\xB1\xAD\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],
        ["\xF3\xB1\xAD\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],
        ["\xF3\xB1\xAD\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],
        ["\xF3\xB1\xAD\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],
        ["\xF3\xB1\xAD\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],
        ["\xF3\xB1\xAD\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],
        ["\xF3\xB1\xAD\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],
        ["\xF3\xB1\xAD\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],
        ["\xF3\xB1\xAD\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],
        ["\xF3\xB1\xAD\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],
        ["\xF3\xB1\xAE\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],
        ["\xF3\xB1\xAE\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],
        ["\xF3\xB1\xAE\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],
        ["\xF3\xB1\xAE\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],
        ["\xF3\xB1\xAE\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],
        ["\xF3\xB1\xAE\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],
        ["\xF3\xB1\xAE\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],
        ["\xF3\xB1\xAE\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],
        ["\xF3\xB1\xAE\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],
        ["\xF3\xB1\xAE\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],
        ["\xF3\xB1\xAE\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],
        ["\xF3\xB1\xAE\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],
        ["\xF3\xB1\xAE\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],
        ["\xF3\xB1\xAE\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],
        ["\xF3\xB1\xAE\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],
        ["\xF3\xB1\xAE\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],
        ["\xF3\xB1\xAE\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],
        ["\xF3\xB1\xAE\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],
        ["\xF3\xB1\xAE\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],
        ["\xF3\xB1\xAE\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],
        ["\xF3\xB1\xAE\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],
        ["\xF3\xB1\xAE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],
        ["\xF3\xB1\xAE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],
        ["\xF3\xB1\xAE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],
        ["\xF3\xB1\xAE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],
        ["\xF3\xB1\xAE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],
        ["\xF3\xB1\xAE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],
        ["\xF3\xB1\xAE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],
        ["\xF3\xB1\xAE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],
        ["\xF3\xB1\xAE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],
        ["\xF3\xB1\xAE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],
        ["\xF3\xB1\xAE\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],
        ["\xF3\xB1\xAE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],
        ["\xF3\xB1\xAE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],
        ["\xF3\xB1\xAE\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],
        ["\xF3\xB1\xAE\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],
        ["\xF3\xB1\xAE\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],
        ["\xF3\xB1\xAE\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],
        ["\xF3\xB1\xAE\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],
        ["\xF3\xB1\xAE\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],
        ["\xF3\xB1\xAE\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],
        ["\xF3\xB1\xAE\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],
        ["\xF3\xB1\xAE\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],
        ["\xF3\xB1\xAE\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],
        ["\xF3\xB1\xAE\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],
        ["\xF3\xB1\xAE\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],
        ["\xF3\xB1\xAE\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],
        ["\xF3\xB1\xAE\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],
        ["\xF3\xB1\xAE\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],
        ["\xF3\xB1\xAE\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],
        ["\xF3\xB1\xAE\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],
        ["\xF3\xB1\xAE\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],
        ["\xF3\xB1\xAE\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],
        ["\xF3\xB1\xAE\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],
        ["\xF3\xB1\xAE\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],
        ["\xF3\xB1\xAE\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],
        ["\xF3\xB1\xAE\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],
        ["\xF3\xB1\xAE\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],
        ["\xF3\xB1\xAE\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],
        ["\xF3\xB1\xAE\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],
        ["\xF3\xB1\xAE\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],
        ["\xF3\xB1\xAE\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],
        ["\xF3\xB1\xAE\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],
        ["\xF3\xB1\xAE\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],
        ["\xF3\xB1\xAF\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],
        ["\xF3\xB1\xAF\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],
        ["\xF3\xB1\xAF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],
        ["\xF3\xB1\xAF\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],
        ["\xF3\xB1\xAF\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],
        ["\xF3\xB1\xAF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],
        ["\xF3\xB1\xAF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],
        ["\xF3\xB1\xAF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],
        ["\xF3\xB1\xAF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],
        ["\xF3\xB1\xAF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],
        ["\xF3\xB1\xAF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],
        ["\xF3\xB1\xAF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],
        ["\xF3\xB1\xAF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],
        ["\xF3\xB1\xAF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],
        ["\xF3\xB1\xAF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],
        ["\xF3\xB1\xAF\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],
        ["\xF3\xB1\xAF\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],
        ["\xF3\xB1\xAF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],
        ["\xF3\xB1\xAF\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],
        ["\xF3\xB1\xAF\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],
        ["\xF3\xB1\xAF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],
        ["\xF3\xB1\xAF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],
        ["\xF3\xB1\xAF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],
        ["\xF3\xB1\xAF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],
        ["\xF3\xB1\xAF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],
        ["\xF3\xB1\xAF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],
        ["\xF3\xB1\xAF\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],
        ["\xF3\xB1\xAF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],
        ["\xF3\xB1\xAF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],
        ["\xF3\xB1\xAF\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],
        ["\xF3\xB1\xAF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],
        ["\xF3\xB1\xAF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],
        ["\xF3\xB1\xAF\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],
        ["\xF3\xB1\xAF\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],
        ["\xF3\xB1\xAF\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],
        ["\xF3\xB1\xAF\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],
        ["\xF3\xB1\xAF\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],
        ["\xF3\xB1\xAF\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],
        ["\xF3\xB1\xAF\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],
        ["\xF3\xB1\xAF\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],
        ["\xF3\xB1\xAF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],
        ["\xF3\xB1\xAF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],
        ["\xF3\xB1\xAF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],
        ["\xF3\xB1\xAF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],
        ["\xF3\xB1\xAF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],
        ["\xF3\xB1\xAF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],
        ["\xF3\xB1\xAF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],
        ["\xF3\xB1\xAF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],
        ["\xF3\xB1\xAF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],
        ["\xF3\xB1\xAF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],
        ["\xF3\xB1\xAF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],
        ["\xF3\xB1\xAF\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],
        ["\xF3\xB1\xAF\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],
        ["\xF3\xB1\xAF\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],
        ["\xF3\xB1\xAF\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],
        ["\xF3\xB1\xAF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],
        ["\xF3\xB1\xAF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],
        ["\xF3\xB1\xAF\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],
        ["\xF3\xB1\xAF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],
        ["\xF3\xB1\xAF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],
        ["\xF3\xB1\xAF\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],
        ["\xF3\xB1\xAF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],
        ["\xF3\xB1\xAF\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],
        ["\xF3\xB1\xAF\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],
        ["\xF3\xB1\xB0\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],
        ["\xF3\xB1\xB0\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],
        ["\xF3\xB1\xB0\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],
        ["\xF3\xB1\xB0\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],
        ["\xF3\xB1\xB0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],
        ["\xF3\xB1\xB0\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],
        ["\xF3\xB1\xB0\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],
        ["\xF3\xB1\xB0\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],
        ["\xF3\xB1\xB0\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],
        ["\xF3\xB1\xB0\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],
        ["\xF3\xB1\xB0\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],
        ["\xF3\xB1\xB0\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],
        ["\xF3\xB1\xB0\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],
        ["\xF3\xB1\xB0\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],
        ["\xF3\xB1\xB0\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],
        ["\xF3\xB1\xB0\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],
        ["\xF3\xB1\xB0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],
        ["\xF3\xB1\xB0\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],
        ["\xF3\xB1\xB0\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],
        ["\xF3\xB1\xB0\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],
        ["\xF3\xB1\xB0\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],
        ["\xF3\xB1\xB0\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],
        ["\xF3\xB1\xB0\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],
        ["\xF3\xB1\xB0\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],
        ["\xF3\xB1\xB0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],
        ["\xF3\xB1\xB0\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],
        ["\xF3\xB1\xB0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],
        ["\xF3\xB1\xB0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],
        ["\xF3\xB1\xB0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],
        ["\xF3\xB1\xB0\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],
        ["\xF3\xB1\xB0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],
        ["\xF3\xB1\xB0\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],
        ["\xF3\xB1\xB0\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],
        ["\xF3\xB1\xB0\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],
        ["\xF3\xB1\xB0\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],
        ["\xF3\xB1\xB0\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],
        ["\xF3\xB1\xB0\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],
        ["\xF3\xB1\xB0\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],
        ["\xF3\xB1\xB0\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],
        ["\xF3\xB1\xB0\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],
        ["\xF3\xB1\xB0\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],
        ["\xF3\xB1\xB0\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],
        ["\xF3\xB1\xB0\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],
        ["\xF3\xB1\xB0\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],
        ["\xF3\xB1\xB0\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],
        ["\xF3\xB1\xB0\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],
        ["\xF3\xB1\xB0\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],
        ["\xF3\xB1\xB0\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],
        ["\xF3\xB1\xB0\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],
        ["\xF3\xB1\xB0\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],
        ["\xF3\xB1\xB0\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],
        ["\xF3\xB1\xB0\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],
        ["\xF3\xB1\xB0\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],
        ["\xF3\xB1\xB0\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],
        ["\xF3\xB1\xB0\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],
        ["\xF3\xB1\xB0\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],
        ["\xF3\xB1\xB0\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],
        ["\xF3\xB1\xB0\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],
        ["\xF3\xB1\xB0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],
        ["\xF3\xB1\xB0\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],
        ["\xF3\xB1\xB0\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],
        ["\xF3\xB1\xB0\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],
        ["\xF3\xB1\xB0\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],
        ["\xF3\xB1\xB0\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],
        ["\xF3\xB1\xB1\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],
        ["\xF3\xB1\xB1\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],
        ["\xF3\xB1\xB1\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],
        ["\xF3\xB1\xB1\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],
        ["\xF3\xB1\xB1\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],
        ["\xF3\xB1\xB1\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],
        ["\xF3\xB1\xB1\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],
        ["\xF3\xB1\xB1\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],
        ["\xF3\xB1\xB1\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],
        ["\xF3\xB1\xB1\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],
        ["\xF3\xB1\xB1\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],
        ["\xF3\xB1\xB1\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],
        ["\xF3\xB1\xB1\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],
        ["\xF3\xB1\xB1\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],
        ["\xF3\xB1\xB1\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],
        ["\xF3\xB1\xB1\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],
        ["\xF3\xB1\xB1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],
        ["\xF3\xB1\xB1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],
        ["\xF3\xB1\xB1\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],
        ["\xF3\xB1\xB1\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],
        ["\xF3\xB1\xB1\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],
        ["\xF3\xB1\xB1\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],
        ["\xF3\xB1\xB1\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],
        ["\xF3\xB1\xB1\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],
        ["\xF3\xB1\xB1\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],
        ["\xF3\xB1\xB1\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],
        ["\xF3\xB1\xB1\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],
        ["\xF3\xB1\xB1\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],
        ["\xF3\xB1\xB1\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],
        ["\xF3\xB1\xB1\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],
        ["\xF3\xB1\xB1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],
        ["\xF3\xB1\xB1\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],
        ["\xF3\xB1\xB1\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],
        ["\xF3\xB1\xB1\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],
        ["\xF3\xB1\xB1\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],
        ["\xF3\xB1\xB1\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],
        ["\xF3\xB1\xB1\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],
        ["\xF3\xB1\xB1\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],
        ["\xF3\xB1\xB1\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],
        ["\xF3\xB1\xB1\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],
        ["\xF3\xB1\xB1\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],
        ["\xF3\xB1\xB1\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],
        ["\xF3\xB1\xB1\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],
        ["\xF3\xB1\xB1\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],
        ["\xF3\xB1\xB1\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],
        ["\xF3\xB1\xB1\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],
        ["\xF3\xB1\xB1\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],
        ["\xF3\xB1\xB1\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],
        ["\xF3\xB1\xB1\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],
        ["\xF3\xB1\xB1\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],
        ["\xF3\xB1\xB1\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],
        ["\xF3\xB1\xB1\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],
        ["\xF3\xB1\xB1\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],
        ["\xF3\xB1\xB1\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],
        ["\xF3\xB1\xB1\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],
        ["\xF3\xB1\xB1\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],
        ["\xF3\xB1\xB1\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],
        ["\xF3\xB1\xB1\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],
        ["\xF3\xB1\xB1\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],
        ["\xF3\xB1\xB1\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],
        ["\xF3\xB1\xB1\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],
        ["\xF3\xB1\xB1\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],
        ["\xF3\xB1\xB1\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],
        ["\xF3\xB1\xB1\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],
        ["\xF3\xB1\xB2\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],
        ["\xF3\xB1\xB2\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],
        ["\xF3\xB1\xB2\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],
        ["\xF3\xB1\xB2\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],
        ["\xF3\xB1\xB2\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],
        ["\xF3\xB1\xB2\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],
        ["\xF3\xB1\xB2\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],
        ["\xF3\xB1\xB2\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],
        ["\xF3\xB1\xB2\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],
        ["\xF3\xB1\xB2\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],
        ["\xF3\xB1\xB2\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],
        ["\xF3\xB1\xB2\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],
        ["\xF3\xB1\xB2\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],
        ["\xF3\xB1\xB2\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],
        ["\xF3\xB1\xB2\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],
        ["\xF3\xB1\xB2\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],
        ["\xF3\xB1\xB2\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],
        ["\xF3\xB1\xB2\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],
        ["\xF3\xB1\xB2\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],
        ["\xF3\xB1\xB2\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],
        ["\xF3\xB1\xB2\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],
        ["\xF3\xB1\xB2\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],
        ["\xF3\xB1\xB2\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],
        ["\xF3\xB1\xB2\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],
        ["\xF3\xB1\xB2\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],
        ["\xF3\xB1\xB2\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],
        ["\xF3\xB1\xB2\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],
        ["\xF3\xB1\xB2\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],
        ["\xF3\xB1\xB2\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],
        ["\xF3\xB1\xB2\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],
        ["\xF3\xB1\xB2\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],
        ["\xF3\xB1\xB2\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],
        ["\xF3\xB1\xB2\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],
        ["\xF3\xB1\xB2\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],
        ["\xF3\xB1\xB2\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],
        ["\xF3\xB1\xB2\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],
        ["\xF3\xB1\xB2\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],
        ["\xF3\xB1\xB2\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],
        ["\xF3\xB1\xB2\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],
        ["\xF3\xB1\xB2\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],
        ["\xF3\xB1\xB2\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],
        ["\xF3\xB1\xB2\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],
        ["\xF3\xB1\xB2\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],
        ["\xF3\xB1\xB2\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],
        ["\xF3\xB1\xB2\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],
        ["\xF3\xB1\xB2\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],
        ["\xF3\xB1\xB2\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],
        ["\xF3\xB1\xB2\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],
        ["\xF3\xB1\xB2\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],
        ["\xF3\xB1\xB2\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],
        ["\xF3\xB1\xB2\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],
        ["\xF3\xB1\xB2\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],
        ["\xF3\xB1\xB2\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],
        ["\xF3\xB1\xB2\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],
        ["\xF3\xB1\xB2\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],
        ["\xF3\xB1\xB2\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],
        ["\xF3\xB1\xB2\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],
        ["\xF3\xB1\xB2\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],
        ["\xF3\xB1\xB2\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],
        ["\xF3\xB1\xB2\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],
        ["\xF3\xB1\xB2\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],
        ["\xF3\xB1\xB2\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],
        ["\xF3\xB1\xB2\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],
        ["\xF3\xB1\xB2\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],
        ["\xF3\xB1\xB3\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],
        ["\xF3\xB1\xB3\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],
        ["\xF3\xB1\xB3\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],
        ["\xF3\xB1\xB3\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],
        ["\xF3\xB1\xB3\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],
        ["\xF3\xB1\xB3\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],
        ["\xF3\xB1\xB3\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],
        ["\xF3\xB1\xB3\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],
        ["\xF3\xB1\xB3\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],
        ["\xF3\xB1\xB3\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],
        ["\xF3\xB1\xB3\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],
        ["\xF3\xB1\xB3\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],
        ["\xF3\xB1\xB3\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],
        ["\xF3\xB1\xB3\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],
        ["\xF3\xB1\xB3\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],
        ["\xF3\xB1\xB3\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],
        ["\xF3\xB1\xB3\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],
        ["\xF3\xB1\xB3\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],
        ["\xF3\xB1\xB3\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],
        ["\xF3\xB1\xB3\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],
        ["\xF3\xB1\xB3\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],
        ["\xF3\xB1\xB3\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],
        ["\xF3\xB1\xB3\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],
        ["\xF3\xB1\xB3\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],
        ["\xF3\xB1\xB3\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],
        ["\xF3\xB1\xB3\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],
        ["\xF3\xB1\xB3\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],
        ["\xF3\xB1\xB3\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],
        ["\xF3\xB1\xB3\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],
        ["\xF3\xB1\xB3\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],
        ["\xF3\xB1\xB3\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],
        ["\xF3\xB1\xB3\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],
        ["\xF3\xB1\xB3\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],
        ["\xF3\xB1\xB3\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],
        ["\xF3\xB1\xB3\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],
        ["\xF3\xB1\xB3\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],
        ["\xF3\xB1\xB3\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],
        ["\xF3\xB1\xB3\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],
        ["\xF3\xB1\xB3\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],
        ["\xF3\xB1\xB3\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],
        ["\xF3\xB1\xB3\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],
        ["\xF3\xB1\xB3\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],
        ["\xF3\xB1\xB3\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],
        ["\xF3\xB1\xB3\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],
        ["\xF3\xB1\xB3\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],
        ["\xF3\xB1\xB3\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],
        ["\xF3\xB1\xB3\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],
        ["\xF3\xB1\xB3\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],
        ["\xF3\xB1\xB3\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],
        ["\xF3\xB1\xB3\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],
        ["\xF3\xB1\xB3\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],
        ["\xF3\xB1\xB3\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],
        ["\xF3\xB1\xB3\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],
        ["\xF3\xB1\xB3\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],
        ["\xF3\xB1\xB3\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],
        ["\xF3\xB1\xB3\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],
        ["\xF3\xB1\xB3\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],
        ["\xF3\xB1\xB3\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],
        ["\xF3\xB1\xB3\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],
        ["\xF3\xB1\xB3\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],
        ["\xF3\xB1\xB3\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],
        ["\xF3\xB1\xB3\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],
        ["\xF3\xB1\xB3\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],
        ["\xF3\xB1\xB3\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],
        ["\xF3\xB1\xB4\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],
        ["\xF3\xB1\xB4\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],
        ["\xF3\xB1\xB4\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],
        ["\xF3\xB1\xB4\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],
        ["\xF3\xB1\xB4\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],
        ["\xF3\xB1\xB4\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],
        ["\xF3\xB1\xB4\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],
        ["\xF3\xB1\xB4\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],
        ["\xF3\xB1\xB4\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],
        ["\xF3\xB1\xB4\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],
        ["\xF3\xB1\xB4\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],
        ["\xF3\xB1\xB4\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],
        ["\xF3\xB1\xB4\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],
        ["\xF3\xB1\xB4\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],
        ["\xF3\xB1\xB4\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],
        ["\xF3\xB1\xB4\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],
        ["\xF3\xB1\xB4\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],
        ["\xF3\xB1\xB4\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],
        ["\xF3\xB1\xB4\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],
        ["\xF3\xB1\xB4\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],
        ["\xF3\xB1\xB4\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],
        ["\xF3\xB1\xB4\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],
        ["\xF3\xB1\xB4\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],
        ["\xF3\xB1\xB4\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],
        ["\xF3\xB1\xB4\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],
        ["\xF3\xB1\xB4\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],
        ["\xF3\xB1\xB4\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],
        ["\xF3\xB1\xB4\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],
        ["\xF3\xB1\xB4\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],
        ["\xF3\xB1\xB4\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],
        ["\xF3\xB1\xB4\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],
        ["\xF3\xB1\xB4\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],
        ["\xF3\xB1\xB4\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],
        ["\xF3\xB1\xB4\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],
        ["\xF3\xB1\xB4\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],
        ["\xF3\xB1\xB4\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],
        ["\xF3\xB1\xB4\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],
        ["\xF3\xB1\xB4\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],
        ["\xF3\xB1\xB4\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],
        ["\xF3\xB1\xB4\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],
        ["\xF3\xB1\xB4\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],
        ["\xF3\xB1\xB4\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],
        ["\xF3\xB1\xB4\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],
        ["\xF3\xB1\xB4\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],
        ["\xF3\xB1\xB4\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],
        ["\xF3\xB1\xB4\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],
        ["\xF3\xB1\xB4\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],
        ["\xF3\xB1\xB4\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],
        ["\xF3\xB1\xB4\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],
        ["\xF3\xB1\xB4\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],
        ["\xF3\xB1\xB4\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],
        ["\xF3\xB1\xB4\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],
        ["\xF3\xB1\xB4\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],
        ["\xF3\xB1\xB4\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],
        ["\xF3\xB1\xB4\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],
        ["\xF3\xB1\xB4\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],
        ["\xF3\xB1\xB4\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],
        ["\xF3\xB1\xB4\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],
        ["\xF3\xB1\xB4\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],
        ["\xF3\xB1\xB4\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],
        ["\xF3\xB1\xB4\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],
        ["\xF3\xB1\xB4\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],
        ["\xF3\xB1\xB4\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],
        ["\xF3\xB1\xB4\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],
        ["\xF3\xB1\xB5\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],
        ["\xF3\xB1\xB5\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],
        ["\xF3\xB1\xB5\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],
        ["\xF3\xB1\xB5\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],
        ["\xF3\xB1\xB5\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],
        ["\xF3\xB1\xB5\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],
        ["\xF3\xB1\xB5\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],
        ["\xF3\xB1\xB5\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],
        ["\xF3\xB1\xB5\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],
        ["\xF3\xB1\xB5\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],
        ["\xF3\xB1\xB5\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],
        ["\xF3\xB1\xB5\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],
        ["\xF3\xB1\xB5\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],
        ["\xF3\xB1\xB5\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],
        ["\xF3\xB1\xB5\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],
        ["\xF3\xB1\xB5\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],
        ["\xF3\xB1\xB5\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],
        ["\xF3\xB1\xB5\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],
        ["\xF3\xB1\xB5\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],
        ["\xF3\xB1\xB5\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],
        ["\xF3\xB1\xB5\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],
        ["\xF3\xB1\xB5\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],
        ["\xF3\xB1\xB5\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],
        ["\xF3\xB1\xB5\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],
        ["\xF3\xB1\xB5\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],
        ["\xF3\xB1\xB5\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],
        ["\xF3\xB1\xB5\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],
        ["\xF3\xB1\xB5\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],
        ["\xF3\xB1\xB5\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],
        ["\xF3\xB1\xB5\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],
        ["\xF3\xB1\xB5\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],
        ["\xF3\xB1\xB5\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],
        ["\xF3\xB1\xB5\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],
        ["\xF3\xB1\xB5\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],
        ["\xF3\xB1\xB5\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],
        ["\xF3\xB1\xB5\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],
        ["\xF3\xB1\xB5\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],
        ["\xF3\xB1\xB5\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],
        ["\xF3\xB1\xB5\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],
        ["\xF3\xB1\xB5\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],
        ["\xF3\xB1\xB5\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],
        ["\xF3\xB1\xB5\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],
        ["\xF3\xB1\xB5\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],
        ["\xF3\xB1\xB5\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],
        ["\xF3\xB1\xB5\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],
        ["\xF3\xB1\xB5\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],
        ["\xF3\xB1\xB5\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],
        ["\xF3\xB1\xB5\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],
        ["\xF3\xB1\xB5\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],
        ["\xF3\xB1\xB5\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],
        ["\xF3\xB1\xB5\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],
        ["\xF3\xB1\xB5\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],
        ["\xF3\xB1\xB5\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],
        ["\xF3\xB1\xB5\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],
        ["\xF3\xB1\xB5\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],
        ["\xF3\xB1\xB5\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],
        ["\xF3\xB1\xB5\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],
        ["\xF3\xB1\xB5\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],
        ["\xF3\xB1\xB5\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],
        ["\xF3\xB1\xB5\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],
        ["\xF3\xB1\xB5\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],
        ["\xF3\xB1\xB5\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],
        ["\xF3\xB1\xB5\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],
        ["\xF3\xB1\xB5\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],
        ["\xF3\xB1\xB6\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],
        ["\xF3\xB1\xB6\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],
        ["\xF3\xB1\xB6\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],
        ["\xF3\xB1\xB6\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],
        ["\xF3\xB1\xB6\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],
        ["\xF3\xB1\xB6\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],
        ["\xF3\xB1\xB6\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],
        ["\xF3\xB1\xB6\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],
        ["\xF3\xB1\xB6\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],
        ["\xF3\xB1\xB6\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],
        ["\xF3\xB1\xB6\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],
        ["\xF3\xB1\xB6\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],
        ["\xF3\xB1\xB6\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],
        ["\xF3\xB1\xB6\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],
        ["\xF3\xB1\xB6\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],
        ["\xF3\xB1\xB6\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],
        ["\xF3\xB1\xB6\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],
        ["\xF3\xB1\xB6\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],
        ["\xF3\xB1\xB6\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],
        ["\xF3\xB1\xB6\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],
        ["\xF3\xB1\xB6\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],
        ["\xF3\xB1\xB6\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],
        ["\xF3\xB1\xB6\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],
        ["\xF3\xB1\xB6\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],
        ["\xF3\xB1\xB6\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],
        ["\xF3\xB1\xB6\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],
        ["\xF3\xB1\xB6\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],
        ["\xF3\xB1\xB6\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],
        ["\xF3\xB1\xB6\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],
        ["\xF3\xB1\xB6\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],
        ["\xF3\xB1\xB6\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],
        ["\xF3\xB1\xB6\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],
        ["\xF3\xB1\xB6\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],
        ["\xF3\xB1\xB6\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],
        ["\xF3\xB1\xB6\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],
        ["\xF3\xB1\xB6\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],
        ["\xF3\xB1\xB6\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],
        ["\xF3\xB1\xB6\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],
        ["\xF3\xB1\xB6\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],
        ["\xF3\xB1\xB6\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],
        ["\xF3\xB1\xB6\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],
        ["\xF3\xB1\xB6\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],
        ["\xF3\xB1\xB6\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],
        ["\xF3\xB1\xB6\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],
        ["\xF3\xB1\xB6\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],
        ["\xF3\xB1\xB6\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],
        ["\xF3\xB1\xB6\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],
        ["\xF3\xB1\xB6\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],
        ["\xF3\xB1\xB6\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],
        ["\xF3\xB1\xB6\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],
        ["\xF3\xB1\xB6\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],
        ["\xF3\xB1\xB6\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],
        ["\xF3\xB1\xB6\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],
        ["\xF3\xB1\xB6\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],
        ["\xF3\xB1\xB6\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],
        ["\xF3\xB1\xB6\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],
        ["\xF3\xB1\xB6\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],
        ["\xF3\xB1\xB6\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],
        ["\xF3\xB1\xB6\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],
        ["\xF3\xB1\xB6\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],
        ["\xF3\xB1\xB6\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],
        ["\xF3\xB1\xB6\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],
        ["\xF3\xB1\xB6\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],
        ["\xF3\xB1\xB6\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],
        ["\xF3\xB1\xB7\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],
        ["\xF3\xB1\xB7\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],
        ["\xF3\xB1\xB7\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],
        ["\xF3\xB1\xB7\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],
        ["\xF3\xB1\xB7\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],
        ["\xF3\xB1\xB7\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],
        ["\xF3\xB1\xB7\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],
        ["\xF3\xB1\xB7\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],
        ["\xF3\xB1\xB7\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],
        ["\xF3\xB1\xB7\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],
        ["\xF3\xB1\xB7\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],
        ["\xF3\xB1\xB7\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],
        ["\xF3\xB1\xB7\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],
        ["\xF3\xB1\xB7\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],
        ["\xF3\xB1\xB7\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],
        ["\xF3\xB1\xB7\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],
        ["\xF3\xB1\xB7\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],
        ["\xF3\xB1\xB7\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],
        ["\xF3\xB1\xB7\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],
        ["\xF3\xB1\xB7\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],
        ["\xF3\xB1\xB7\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],
        ["\xF3\xB1\xB7\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],
        ["\xF3\xB1\xB7\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],
        ["\xF3\xB1\xB7\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],
        ["\xF3\xB1\xB7\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],
        ["\xF3\xB1\xB7\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],
        ["\xF3\xB1\xB7\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],
        ["\xF3\xB1\xB7\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],
        ["\xF3\xB1\xB7\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],
        ["\xF3\xB1\xB7\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],
        ["\xF3\xB1\xB7\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],
        ["\xF3\xB1\xB7\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],
        ["\xF3\xB1\xB7\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],
        ["\xF3\xB1\xB7\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],
        ["\xF3\xB1\xB7\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],
        ["\xF3\xB1\xB7\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],
        ["\xF3\xB1\xB7\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA8"],
        ["\xF3\xB1\xB7\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA7"],
        ["\xF3\xB1\xB7\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAD"],
        ["\xF3\xB1\xB7\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBC"],
        ["\xF3\xB1\xB7\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBB"],
        ["\xF3\xB1\xB7\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB9"],
        ["\xF3\xB1\xB7\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBE"],
        ["\xF3\xB1\xB7\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8A"],
        ["\xF3\xB1\xB7\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB6"],
        ["\xF3\xB1\xB7\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x83"],
        ["\xF3\xB1\xB7\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8D"],
        ["\xF3\xB1\xB7\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8C"],
        ["\xF3\xB1\xB7\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x95"],
        ["\xF3\xB1\xB7\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x94"],
        ["\xF3\xB1\xB7\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x96"],
        ["\xF3\xB1\xB7\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9C"],
        ["\xF3\xB1\xB7\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA1"],
        ["\xF3\xB1\xB7\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA5"],
        ["\xF3\xB1\xB7\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA2"],
        ["\xF3\xB1\xB7\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA1"],
        ["\xF3\xB1\xB7\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA8"],
        ["\xF3\xB1\xB7\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAE"],
        ["\xF3\xB1\xB7\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAF"],
        ["\xF3\xB1\xB7\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x82"],
        ["\xF3\xB1\xB7\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8C"],
        ["\xF3\xB1\xB7\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8F"],
        ["\xF3\xB1\xB7\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8B"],
        ["\xF3\xB1\xB7\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB7"],
        ["\xF3\xB1\xB8\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9C"],
        ["\xF3\xB1\xB8\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9E"],
        ["\xF3\xB1\xB8\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9D"],
        ["\xF3\xB1\xB8\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9F"],
        ["\xF3\xB1\xB8\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA6"],
        ["\xF3\xB1\xB8\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB2"],
        ["\xF3\xB1\xB8\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAC"],
        ["\xF3\xB1\xB8\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8D"],
        ["\xF3\xB1\xB8\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x98"],
        ["\xF3\xB1\xB8\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x95"],
        ["\xF3\xB1\xB8\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x97"],
        ["\xF3\xB1\xB8\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAA"],
        ["\xF3\xB1\xB8\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA7"],
        ["\xF3\xB1\xB8\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB1"],
        ["\xF3\xB1\xB8\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB2"],
        ["\xF3\xB1\xB8\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB0"],
        ["\xF3\xB1\xB8\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB4"],
        ["\xF3\xB1\xB8\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB6"],
        ["\xF3\xB1\xB8\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB8"],
        ["\xF3\xB1\xB8\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB9"],
        ["\xF3\xB1\xB8\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8E"],
        ["\xF3\xB1\xB8\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8B"],
        ["\xF3\xB1\xB8\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x89"],
        ["\xF3\xB1\xB8\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8D"],
        ["\xF3\xB1\xB8\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8D"],
        ["\xF3\xB1\xB8\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9C"],
        ["\xF3\xB1\xB8\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8D"],
        ["\xF3\xB1\xB8\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x95"],
        ["\xF3\xB1\xB8\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB9"],
        ["\xF3\xB1\xB8\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x84"],
        ["\xF3\xB1\xB8\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x86"],
        ["\xF3\xB1\xB8\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x88"],
        ["\xF3\xB1\xB8\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x93"],
        ["\xF3\xB1\xB8\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8E"],
        ["\xF3\xB1\xB8\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x91"],
        ["\xF3\xB1\xB8\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8F"],
        ["\xF3\xB1\xB8\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x96"],
        ["\xF3\xB1\xB8\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x99"],
        ["\xF3\xB1\xB8\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA4"],
        ["\xF3\xB1\xB8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xAA"],
        ["\xF3\xB1\xB8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB0"],
        ["\xF3\xB1\xB8\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB9"],
        ["\xF3\xB1\xB8\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBD"],
        ["\xF3\xB1\xB8\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBE"],
        ["\xF3\xB1\xB8\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x84"],
        ["\xF3\xB1\xB8\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x86"],
        ["\xF3\xB1\xB8\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x88"],
        ["\xF3\xB1\xB8\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x82"],
        ["\xF3\xB1\xB8\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x89"],
        ["\xF3\xB1\xB8\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9C"],
        ["\xF3\xB1\xB8\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA0"],
        ["\xF3\xB1\xB8\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA4"],
        ["\xF3\xB1\xB8\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA6"],
        ["\xF3\xB1\xB8\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA8"],
        ["\xF3\xB1\xB8\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x92"],
        ["\xF3\xB1\xB8\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAB"],
        ["\xF3\xB1\xB8\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB1"],
        ["\xF3\xB1\xB8\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB9"],
        ["\xF3\xB1\xB8\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x85"],
        ["\xF3\xB1\xB8\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBC"],
        ["\xF3\xB1\xB8\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x81"],
        ["\xF3\xB1\xB8\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBA"],
        ["\xF3\xB1\xB8\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x86"],
        ["\xF3\xB1\xB8\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8B"],
        ["\xF3\xB1\xB9\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8F"],
        ["\xF3\xB1\xB9\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x90"],
        ["\xF3\xB1\xB9\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x9C"],
        ["\xF3\xB1\xB9\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA8"],
        ["\xF3\xB1\xB9\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA6"],
        ["\xF3\xB1\xB9\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA3"],
        ["\xF3\xB1\xB9\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB3"],
        ["\xF3\xB1\xB9\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB4"],
        ["\xF3\xB1\xB9\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x83"],
        ["\xF3\xB1\xB9\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x86"],
        ["\xF3\xB1\xB9\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x88"],
        ["\xF3\xB1\xB9\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8B"],
        ["\xF3\xB1\xB9\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9C"],
        ["\xF3\xB1\xB9\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAD"],
        ["\xF3\xB1\xB9\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8F"],
        ["\xF3\xB1\xB9\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB2"],
        ["\xF3\xB1\xB9\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9F"],
        ["\xF3\xB1\xB9\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB6"],
        ["\xF3\xB1\xB9\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB5"],
        ["\xF3\xB1\xB9\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8F"],
        ["\xF3\xB1\xB9\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8C"],
        ["\xF3\xB1\xB9\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB8"],
        ["\xF3\xB1\xB9\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA4"],
        ["\xF3\xB1\xB9\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA1"],
        ["\xF3\xB1\xB9\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB7"],
        ["\xF3\xB1\xB9\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBD"],
        ["\xF3\xB1\xB9\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x86"],
        ["\xF3\xB1\xB9\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8F"],
        ["\xF3\xB1\xB9\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8B"],
        ["\xF3\xB1\xB9\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAB"],
        ["\xF3\xB1\xB9\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAF"],
        ["\xF3\xB1\xB9\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB0"],
        ["\xF3\xB1\xB9\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB1"],
        ["\xF3\xB1\xB9\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB4"],
        ["\xF3\xB1\xB9\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB3"],
        ["\xF3\xB1\xB9\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAA"],
        ["\xF3\xB1\xB9\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAF"],
        ["\xF3\xB1\xB9\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB1"],
        ["\xF3\xB1\xB9\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB6"],
        ["\xF3\xB1\xB9\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x84"],
        ["\xF3\xB1\xB9\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x83"],
        ["\xF3\xB1\xB9\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x86"],
        ["\xF3\xB1\xB9\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA9"],
        ["\xF3\xB1\xB9\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAB"],
        ["\xF3\xB1\xB9\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x83"],
        ["\xF3\xB1\xB9\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x89"],
        ["\xF3\xB1\xB9\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x92"],
        ["\xF3\xB1\xB9\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x94"],
        ["\xF3\xB1\xB9\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x98"],
        ["\xF3\xB1\xB9\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA1"],
        ["\xF3\xB1\xB9\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9D"],
        ["\xF3\xB1\xB9\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9E"],
        ["\xF3\xB1\xB9\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA4"],
        ["\xF3\xB1\xB9\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA0"],
        ["\xF3\xB1\xB9\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAC"],
        ["\xF3\xB1\xB9\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAE"],
        ["\xF3\xB1\xB9\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBD"],
        ["\xF3\xB1\xB9\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBE"],
        ["\xF3\xB1\xB9\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x82"],
        ["\xF3\xB1\xB9\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x89"],
        ["\xF3\xB1\xB9\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x85"],
        ["\xF3\xB1\xB9\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x90"],
        ["\xF3\xB1\xB9\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8B"],
        ["\xF3\xB1\xB9\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x91"],
        ["\xF3\xB1\xBA\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x92"],
        ["\xF3\xB1\xBA\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8C"],
        ["\xF3\xB1\xBA\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x95"],
        ["\xF3\xB1\xBA\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x97"],
        ["\xF3\xB1\xBA\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x98"],
        ["\xF3\xB1\xBA\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA5"],
        ["\xF3\xB1\xBA\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAD"],
        ["\xF3\xB1\xBA\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAE"],
        ["\xF3\xB1\xBA\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xBC"],
        ["\xF3\xB1\xBA\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9F"],
        ["\xF3\xB1\xBA\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9B"],
        ["\xF3\xB1\xBA\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9D"],
        ["\xF3\xB1\xBA\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x98"],
        ["\xF3\xB1\xBA\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x91"],
        ["\xF3\xB1\xBA\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAD"],
        ["\xF3\xB1\xBA\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAE"],
        ["\xF3\xB1\xBA\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB1"],
        ["\xF3\xB1\xBA\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB2"],
        ["\xF3\xB1\xBA\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBB"],
        ["\xF3\xB1\xBA\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB8"],
        ["\xF3\xB1\xBA\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x81"],
        ["\xF3\xB1\xBA\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8F"],
        ["\xF3\xB1\xBA\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x85"],
        ["\xF3\xB1\xBA\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xA2"],
        ["\xF3\xB1\xBA\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x99"],
        ["\xF3\xB1\xBA\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAB"],
        ["\xF3\xB1\xBA\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB7"],
        ["\xF3\xB1\xBA\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x85"],
        ["\xF3\xB1\xBA\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x82"],
        ["\xF3\xB1\xBA\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x80"],
        ["\xF3\xB1\xBA\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x83"],
        ["\xF3\xB1\xBA\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xBE"],
        ["\xF3\xB1\xBA\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x95"],
        ["\xF3\xB1\xBA\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8D"],
        ["\xF3\xB1\xBA\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9B"],
        ["\xF3\xB1\xBA\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x97"],
        ["\xF3\xB1\xBA\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9F"],
        ["\xF3\xB1\xBA\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA2"],
        ["\xF3\xB1\xBA\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA5"],
        ["\xF3\xB1\xBA\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA4"],
        ["\xF3\xB1\xBA\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA9"],
        ["\xF3\xB1\xBA\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAB"],
        ["\xF3\xB1\xBA\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAA"],
        ["\xF3\xB1\xBA\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAD"],
        ["\xF3\xB1\xBA\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB0"],
        ["\xF3\xB1\xBA\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xBC"],
        ["\xF3\xB1\xBA\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x80"],
        ["\xF3\xB1\xBA\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8F"],
        ["\xF3\xB1\xBA\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x91"],
        ["\xF3\xB1\xBA\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x93"],
        ["\xF3\xB1\xBA\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x94"],
        ["\xF3\xB1\xBA\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9E"],
        ["\xF3\xB1\xBA\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9F"],
        ["\xF3\xB1\xBA\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA2"],
        ["\xF3\xB1\xBA\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA3"],
        ["\xF3\xB1\xBA\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA6"],
        ["\xF3\xB1\xBA\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAF"],
        ["\xF3\xB1\xBA\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAB"],
        ["\xF3\xB1\xBA\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAE"],
        ["\xF3\xB1\xBA\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB4"],
        ["\xF3\xB1\xBA\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB1"],
        ["\xF3\xB1\xBA\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB7"],
        ["\xF3\xB1\xBA\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xBB"],
        ["\xF3\xB1\xBA\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x86"],
        ["\xF3\xB1\xBB\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x98"],
        ["\xF3\xB1\xBB\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9A"],
        ["\xF3\xB1\xBB\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9F"],
        ["\xF3\xB1\xBB\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA2"],
        ["\xF3\xB1\xBB\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA3"],
        ["\xF3\xB1\xBB\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA5"],
        ["\xF3\xB1\xBB\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA7"],
        ["\xF3\xB1\xBB\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA8"],
        ["\xF3\xB1\xBB\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA9"],
        ["\xF3\xB1\xBB\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAA"],
        ["\xF3\xB1\xBB\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAE"],
        ["\xF3\xB1\xBB\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAF"],
        ["\xF3\xB1\xBB\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB2"],
        ["\xF3\xB1\xBB\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x84"],
        ["\xF3\xB1\xBB\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x83"],
        ["\xF3\xB1\xBB\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8F"],
        ["\xF3\xB1\xBB\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8D"],
        ["\xF3\xB1\xBB\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8E"],
        ["\xF3\xB1\xBB\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x91"],
        ["\xF3\xB1\xBB\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x98"],
        ["\xF3\xB1\xBB\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB4"],
        ["\xF3\xB1\xBB\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x93"],
        ["\xF3\xB1\xBB\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x83"],
        ["\xF3\xB1\xBB\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x91"],
        ["\xF3\xB1\xBB\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x96"],
        ["\xF3\xB1\xBB\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x97"],
        ["\xF3\xB1\xBB\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9F"],
        ["\xF3\xB1\xBB\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA0"],
        ["\xF3\xB1\xBB\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA8"],
        ["\xF3\xB1\xBB\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB4"],
        ["\xF3\xB1\xBB\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x80"],
        ["\xF3\xB1\xBB\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8A"],
        ["\xF3\xB1\xBB\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB9"],
        ["\xF3\xB1\xBB\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x86"],
        ["\xF3\xB1\xBB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8F"],
        ["\xF3\xB1\xBB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x91"],
        ["\xF3\xB1\xBB\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x92"],
        ["\xF3\xB1\xBB\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA3"],
        ["\xF3\xB1\xBB\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA2"],
        ["\xF3\xB1\xBB\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA4"],
        ["\xF3\xB1\xBB\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x94"],
        ["\xF3\xB1\xBB\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA1"],
        ["\xF3\xB1\xBB\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBA"],
        ["\xF3\xB1\xBB\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB2"],
        ["\xF3\xB1\xBB\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB1"],
        ["\xF3\xB1\xBB\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB0"],
        ["\xF3\xB1\xBB\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x95"],
        ["\xF3\xB1\xBB\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x94"],
        ["\xF3\xB1\xBB\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x89"],
        ["\xF3\xB1\xBB\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x93"],
        ["\xF3\xB1\xBB\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8C"],
        ["\xF3\xB1\xBB\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x86"],
        ["\xF3\xB1\xBB\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x88"],
        ["\xF3\xB1\xBB\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x92"],
        ["\xF3\xB1\xBB\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8A"],
        ["\xF3\xB1\xBB\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x84"],
        ["\xF3\xB1\xBB\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAE"],
        ["\xF3\xB1\xBB\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9B"],
        ["\xF3\xB1\xBB\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA5"],
        ["\xF3\xB1\xBB\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA4"],
        ["\xF3\xB1\xBB\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA1"],
        ["\xF3\xB1\xBB\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB0"],
        ["\xF3\xB1\xBB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x87"],
        ["\xF3\xB1\xBB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB2"],
        ["\xF3\xB1\xBC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x86"],
        ["\xF3\xB1\xBC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBE"],
        ["\xF3\xB1\xBC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9A"],
        ["\xF3\xB1\xBC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA0"],
        ["\xF3\xB1\xBC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA7"],
        ["\xF3\xB1\xBC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB6"],
        ["\xF3\xB1\xBC\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB8"],
        ["\xF3\xB1\xBC\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA7"],
        ["\xF3\xB1\xBC\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAC"],
        ["\xF3\xB1\xBC\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB0"],
        ["\xF3\xB1\xBC\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x89"],
        ["\xF3\xB1\xBC\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x88"],
        ["\xF3\xB1\xBC\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAB"],
        ["\xF3\xB1\xBC\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x83"],
        ["\xF3\xB1\xBC\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x86"],
        ["\xF3\xB1\xBC\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAA"],
        ["\xF3\xB1\xBC\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA6"],
        ["\xF3\xB1\xBC\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAF"],
        ["\xF3\xB1\xBC\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA3"],
        ["\xF3\xB1\xBC\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9F"],
        ["\xF3\xB1\xBC\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x84"],
        ["\xF3\xB1\xBC\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x95"],
        ["\xF3\xB1\xBC\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x92"],
        ["\xF3\xB1\xBC\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x81"],
        ["\xF3\xB1\xBC\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBF"],
        ["\xF3\xB1\xBC\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBE"],
        ["\xF3\xB1\xBC\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x86"],
        ["\xF3\xB1\xBC\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x88"],
        ["\xF3\xB1\xBC\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9D"],
        ["\xF3\xB1\xBC\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9E"],
        ["\xF3\xB1\xBC\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA4"],
        ["\xF3\xB1\xBC\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x91"],
        ["\xF3\xB1\xBC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x90"],
        ["\xF3\xB1\xBC\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x99"],
        ["\xF3\xB1\xBC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB2"],
        ["\xF3\xB1\xBC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x89"],
        ["\xF3\xB1\xBC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x87"],
        ["\xF3\xB1\xBC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAB"],
        ["\xF3\xB1\xBC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAF"],
        ["\xF3\xB1\xBC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBA"],
        ["\xF3\xB1\xBC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x9A"],
        ["\xF3\xB1\xBC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA4"],
        ["\xF3\xB1\xBC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA9"],
        ["\xF3\xB1\xBC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB2"],
        ["\xF3\xB1\xBC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x84"],
        ["\xF3\xB1\xBC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x81"],
        ["\xF3\xB1\xBC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBB"],
        ["\xF3\xB1\xBC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB8"],
        ["\xF3\xB1\xBC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBA"],
        ["\xF3\xB1\xBC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x86"],
        ["\xF3\xB1\xBC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x8F"],
        ["\xF3\xB1\xBC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x82"],
        ["\xF3\xB1\xBC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x99"],
        ["\xF3\xB1\xBC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x93"],
        ["\xF3\xB1\xBC\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB8"],
        ["\xF3\xB1\xBC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA6"],
        ["\xF3\xB1\xBC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAD"],
        ["\xF3\xB1\xBC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAF"],
        ["\xF3\xB1\xBC\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBD"],
        ["\xF3\xB1\xBC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9A"],
        ["\xF3\xB1\xBC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9B"],
        ["\xF3\xB1\xBC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9E"],
        ["\xF3\xB1\xBC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB5"],
        ["\xF3\xB1\xBC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB9"],
        ["\xF3\xB1\xBD\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBD"],
        ["\xF3\xB1\xBD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x81"],
        ["\xF3\xB1\xBD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x88"],
        ["\xF3\xB1\xBD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8B"],
        ["\xF3\xB1\xBD\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8C"],
        ["\xF3\xB1\xBD\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x92"],
        ["\xF3\xB1\xBD\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x95"],
        ["\xF3\xB1\xBD\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x91"],
        ["\xF3\xB1\xBD\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9D"],
        ["\xF3\xB1\xBD\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA5"],
        ["\xF3\xB1\xBD\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA9"],
        ["\xF3\xB1\xBD\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB8"],
        ["\xF3\xB1\xBD\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAA"],
        ["\xF3\xB1\xBD\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAD"],
        ["\xF3\xB1\xBD\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA1"],
        ["\xF3\xB1\xBD\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8C"],
        ["\xF3\xB1\xBD\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8E"],
        ["\xF3\xB1\xBD\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8F"],
        ["\xF3\xB1\xBD\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x90"],
        ["\xF3\xB1\xBD\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x94"],
        ["\xF3\xB1\xBD\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9C"],
        ["\xF3\xB1\xBD\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9E"],
        ["\xF3\xB1\xBD\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9D"],
        ["\xF3\xB1\xBD\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA0"],
        ["\xF3\xB1\xBD\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA5"],
        ["\xF3\xB1\xBD\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA8"],
        ["\xF3\xB1\xBD\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xAF"],
        ["\xF3\xB1\xBD\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB4"],
        ["\xF3\xB1\xBD\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB6"],
        ["\xF3\xB1\xBD\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB7"],
        ["\xF3\xB1\xBD\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB9"],
        ["\xF3\xB1\xBD\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBB"],
        ["\xF3\xB1\xBD\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBC"],
        ["\xF3\xB1\xBD\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBD"],
        ["\xF3\xB1\xBD\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x87"],
        ["\xF3\xB1\xBD\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x88"],
        ["\xF3\xB1\xBD\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB7"],
        ["\xF3\xB1\xBD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x95"],
        ["\xF3\xB1\xBD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA1"],
        ["\xF3\xB1\xBD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xAC"],
        ["\xF3\xB1\xBD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBE"],
        ["\xF3\xB1\xBD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8A"],
        ["\xF3\xB1\xBD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x92"],
        ["\xF3\xB1\xBD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x94"],
        ["\xF3\xB1\xBD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA3"],
        ["\xF3\xB1\xBD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x9F"],
        ["\xF3\xB1\xBD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA0"],
        ["\xF3\xB1\xBD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA1"],
        ["\xF3\xB1\xBD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA6"],
        ["\xF3\xB1\xBD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA7"],
        ["\xF3\xB1\xBD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAC"],
        ["\xF3\xB1\xBD\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAA"],
        ["\xF3\xB1\xBD\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB7"],
        ["\xF3\xB1\xBD\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB2"],
        ["\xF3\xB1\xBD\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB6"],
        ["\xF3\xB1\xBD\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x95"],
        ["\xF3\xB1\xBD\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9C"],
        ["\xF3\xB1\xBD\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA0"],
        ["\xF3\xB1\xBD\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAF"],
        ["\xF3\xB1\xBD\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x87"],
        ["\xF3\xB1\xBD\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x99"],
        ["\xF3\xB1\xBD\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA4"],
        ["\xF3\xB1\xBD\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9C"],
        ["\xF3\xB1\xBD\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x99"],
        ["\xF3\xB2\xAB\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB0"],
        ["\xF3\xB2\xAB\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB1"],
        ["\xF3\xB2\xAB\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB2"],
        ["\xF3\xB2\xAB\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB3"],
        ["\xF3\xB2\xAB\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB4"],
        ["\xF3\xB2\xAB\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB5"],
        ["\xF3\xB2\xAB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB6"],
        ["\xF3\xB2\xAB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB7"],
        ["\xF3\xB2\xAB\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB8"],
        ["\xF3\xB2\xAB\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB9"],
        ["\xF3\xB2\xAB\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA4"],
        ["\xF3\xB2\xAB\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x87"],
        ["\xF3\xB2\xAB\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x82"],
        ["\xF3\xB2\xAB\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8A"],
        ["\xF3\xB2\xAB\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9C"],
        ["\xF3\xB2\xAB\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x88"],
        ["\xF3\xB2\xAB\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x88"],
        ["\xF3\xB2\xAB\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9C"],
        ["\xF3\xB2\xAB\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x89"],
        ["\xF3\xB2\xAB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBB"],
        ["\xF3\xB2\xAB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB1"],
        ["\xF3\xB2\xAC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x88"],
        ["\xF3\xB2\xAC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB9"],
        ["\xF3\xB2\xAC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBB"],
        ["\xF3\xB2\xAC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x85"],
        ["\xF3\xB2\xAC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA8"],
        ["\xF3\xB2\xAC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA1"],
        ["\xF3\xB2\xAC\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBC"],
        ["\xF3\xB2\xAC\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x80"],
        ["\xF3\xB2\xAC\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x83"],
        ["\xF3\xB2\xAC\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB9"],
        ["\xF3\xB2\xAC\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x96"],
        ["\xF3\xB2\xAC\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x92"],
        ["\xF3\xB2\xAC\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8A"],
        ["\xF3\xB2\xAC\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9A"],
        ["\xF3\xB2\xAC\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x94"],
        ["\xF3\xB2\xAC\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8D"],
        ["\xF3\xB2\xAC\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x80"],
        ["\xF3\xB2\xAC\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA2"],
        ["\xF3\xB2\xAC\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBF"],
        ["\xF3\xB2\xAC\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9E"],
        ["\xF3\xB2\xAC\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x86"],
        ["\xF3\xB2\xAC\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB0"],
        ["\xF3\xB2\xAC\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x82"],
        ["\xF3\xB2\xAC\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x94"],
        ["\xF3\xB2\xAC\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB4"],
        ["\xF3\xB2\xAC\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x98"],
        ["\xF3\xB2\xAC\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8A"],
        ["\xF3\xB2\xAC\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA4"],
        ["\xF3\xB2\xAC\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x9D"],
        ["\xF3\xB2\xAC\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBE"],
        ["\xF3\xB2\xAC\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAC"],
        ["\xF3\xB2\xAC\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x95"],
        ["\xF3\xB2\xAC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9C"],
        ["\xF3\xB2\xAC\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA6"],
        ["\xF3\xB2\xAC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x80"],
        ["\xF3\xB2\xAC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9B"],
        ["\xF3\xB2\xAC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x80"],
        ["\xF3\xB2\xAC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x87"],
        ["\xF3\xB2\xAC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA4"],
        ["\xF3\xB2\xAC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB2"],
        ["\xF3\xB2\xAC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x93"],
        ["\xF3\xB2\xAC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB2"],
        ["\xF3\xB2\xAC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9D"],
        ["\xF3\xB2\xAC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8E"],
        ["\xF3\xB2\xAC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x9C"],
        ["\xF3\xB2\xAC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8A"],
        ["\xF3\xB2\xAC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA9"],
        ["\xF3\xB2\xAC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBF"],
        ["\xF3\xB2\xAC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x86"],
        ["\xF3\xB2\xAC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x99"],
        ["\xF3\xB2\xAC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA5"],
        ["\xF3\xB2\xAC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAC"],
        ["\xF3\xB2\xAC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x88"],
        ["\xF3\xB2\xAC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x87"],
        ["\xF3\xB2\xAC\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8F"],
        ["\xF3\xB2\xAC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x90"],
        ["\xF3\xB2\xAC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9E"],
        ["\xF3\xB2\xAC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB2"],
        ["\xF3\xB2\xAC\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8B"],
        ["\xF3\xB2\xAC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x93"],
        ["\xF3\xB2\xAC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9B"],
        ["\xF3\xB2\xAC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9D"],
        ["\xF3\xB2\xAC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA3"],
        ["\xF3\xB2\xAC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA4"],
        ["\xF3\xB2\xAD\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBA"],
        ["\xF3\xB2\xAD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x96"],
        ["\xF3\xB2\xAD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x80"],
        ["\xF3\xB2\xAD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAF"],
        ["\xF3\xB2\xAD\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x98"],
        ["\xF3\xB2\xAD\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAC"],
        ["\xF3\xB2\xAD\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9E"],
        ["\xF3\xB2\xAD\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA6"],
        ["\xF3\xB2\xAD\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBA"],
        ["\xF3\xB2\xAD\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB5"],
        ["\xF3\xB2\xAD\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA7"],
        ["\xF3\xB2\xAD\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x93"],
        ["\xF3\xB2\xAD\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x91"],
        ["\xF3\xB2\xAD\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x82"],
        ["\xF3\xB2\xAD\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAD"],
        ["\xF3\xB2\xAD\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB8"],
        ["\xF3\xB2\xAD\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB9"],
        ["\xF3\xB2\xAD\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x90"],
        ["\xF3\xB2\xAD\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA1"],
        ["\xF3\xB2\xAD\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB4"],
        ["\xF3\xB2\xAD\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA7"],
        ["\xF3\xB2\xAD\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB7"],
        ["\xF3\xB2\xAD\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9E"],
        ["\xF3\xB2\xAD\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9D"],
        ["\xF3\xB2\xAD\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x85"],
        ["\xF3\xB2\xAD\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8A"],
        ["\xF3\xB2\xAD\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9E"],
        ["\xF3\xB2\xAD\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x95"],
        ["\xF3\xB2\xAD\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA0"],
        ["\xF3\xB2\xAD\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB2"],
        ["\xF3\xB2\xAD\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x91"],
        ["\xF3\xB2\xAD\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB7"],
        ["\xF3\xB2\xAD\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB0"],
        ["\xF3\xB2\xAD\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x98"],
        ["\xF3\xB2\xAD\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x93"],
        ["\xF3\xB2\xAD\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xA6"],
        ["\xF3\xB2\xAD\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB5"],
        ["\xF3\xB2\xAD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA0"],
        ["\xF3\xB2\xAD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9D"],
        ["\xF3\xB2\xAD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8E"],
        ["\xF3\xB2\xAD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8E"],
        ["\xF3\xB2\xAD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x80"],
        ["\xF3\xB2\xAD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x95"],
        ["\xF3\xB2\xAD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBB"],
        ["\xF3\xB2\xAD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x89"],
        ["\xF3\xB2\xAD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAE"],
        ["\xF3\xB2\xAD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9E"],
        ["\xF3\xB2\xAD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA4"],
        ["\xF3\xB2\xAD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA5"],
        ["\xF3\xB2\xAD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x97"],
        ["\xF3\xB2\xAD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x99"],
        ["\xF3\xB2\xAD\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x92"],
        ["\xF3\xB2\xAD\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB3"],
        ["\xF3\xB2\xAD\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x99"],
        ["\xF3\xB2\xAD\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA0"],
        ["\xF3\xB2\xAD\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB2"],
        ["\xF3\xB2\xAD\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBF"],
        ["\xF3\xB2\xAD\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBA"],
        ["\xF3\xB2\xAD\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8E"],
        ["\xF3\xB2\xAD\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA9"],
        ["\xF3\xB2\xAD\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA6"],
        ["\xF3\xB2\xAD\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xBB"],
        ["\xF3\xB2\xAD\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x92"],
        ["\xF3\xB2\xAD\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x80"],
        ["\xF3\xB2\xAE\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x81"],
        ["\xF3\xB2\xAE\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x84"],
        ["\xF3\xB2\xAE\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8F"],
        ["\xF3\xB2\xAE\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x93"],
        ["\xF3\xB2\xAE\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA8"],
        ["\xF3\xB2\xAE\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x94"],
        ["\xF3\xB2\xAE\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x98"],
        ["\xF3\xB2\xAE\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA2"],
        ["\xF3\xB2\xAE\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB0"],
        ["\xF3\xB2\xAE\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xAB"],
        ["\xF3\xB2\xAE\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x86"],
        ["\xF3\xB2\xAE\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB3"],
        ["\xF3\xB2\xAE\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBE"],
        ["\xF3\xB2\xAE\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA2"],
        ["\xF3\xB2\xAE\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA4"],
        ["\xF3\xB2\xAE\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x96"],
        ["\xF3\xB2\xAE\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBF"],
        ["\xF3\xB2\xAE\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9C"],
        ["\xF3\xB2\xAE\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x86"],
        ["\xF3\xB2\xAE\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAF"],
        ["\xF3\xB2\xAE\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9A"],
        ["\xF3\xB2\xAE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x84"],
        ["\xF3\xB2\xAE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x87"],
        ["\xF3\xB2\xAE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAF"],
        ["\xF3\xB2\xAE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x96"],
        ["\xF3\xB2\xAE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAC"],
        ["\xF3\xB2\xAE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8F"],
        ["\xF3\xB2\xAE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB8"],
        ["\xF3\xB2\xAE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB2"],
        ["\xF3\xB2\xAE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBC"],
        ["\xF3\xB2\xAE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB9"],
        ["\xF3\xB2\xAE\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9C"],
        ["\xF3\xB2\xAE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA7"],
        ["\xF3\xB2\xAE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBC"],
        ["\xF3\xB2\xAE\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBF"],
        ["\xF3\xB2\xAE\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x88"],
        ["\xF3\xB2\xAE\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB5"],
        ["\xF3\xB2\xAE\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB5"],
        ["\xF3\xB2\xAE\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x85"],
        ["\xF3\xB2\xAE\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x87"],
        ["\xF3\xB2\xAE\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA8"],
        ["\xF3\xB2\xAE\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x85"],
        ["\xF3\xB2\xAE\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAB"],
        ["\xF3\xB2\xAE\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x8F"],
        ["\xF3\xB2\xAE\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x84"],
        ["\xF3\xB2\xAE\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x9C"],
        ["\xF3\xB2\xAE\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x86"],
        ["\xF3\xB2\xAE\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x87"],
        ["\xF3\xB2\xAE\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x95"],
        ["\xF3\xB2\xAE\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x81"],
        ["\xF3\xB2\xAE\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBE"],
        ["\xF3\xB2\xAE\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB1"],
        ["\xF3\xB2\xAE\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xBE"],
        ["\xF3\xB2\xAE\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA4"],
        ["\xF3\xB2\xAE\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x96"],
        ["\xF3\xB2\xAE\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB7"],
        ["\xF3\xB2\xAE\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBD"],
        ["\xF3\xB2\xAE\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x89"],
        ["\xF3\xB2\xAE\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x96"],
        ["\xF3\xB2\xAE\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA3"],
        ["\xF3\xB2\xAE\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x92"],
        ["\xF3\xB2\xAE\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x87"],
        ["\xF3\xB2\xAE\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB5"],
        ["\xF3\xB2\xAE\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA6"],
        ["\xF3\xB2\xAF\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAA"],
        ["\xF3\xB2\xAF\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA9"],
        ["\xF3\xB2\xAF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAE"],
        ["\xF3\xB2\xAF\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA2"],
        ["\xF3\xB2\xAF\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x89"],
        ["\xF3\xB2\xAF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9F"],
        ["\xF3\xB2\xAF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x81"],
        ["\xF3\xB2\xAF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAF"],
        ["\xF3\xB2\xAF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x82"],
        ["\xF3\xB2\xAF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9C"],
        ["\xF3\xB2\xAF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9E"],
        ["\xF3\xB2\xAF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9B"],
        ["\xF3\xB2\xAF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA6"],
        ["\xF3\xB2\xAF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x97"],
        ["\xF3\xB2\xAF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x86"],
        ["\xF3\xB2\xAF\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAF"],
        ["\xF3\xB2\xAF\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA1"],
        ["\xF3\xB2\xAF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8E"],
        ["\xF3\xB2\xAF\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA4"],
        ["\xF3\xB2\xAF\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBA"],
        ["\xF3\xB2\xAF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB0"],
        ["\xF3\xB2\xAF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x98"],
        ["\xF3\xB2\xAF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x99"],
        ["\xF3\xB2\xAF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9A"],
        ["\xF3\xB2\xAF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x94"],
        ["\xF3\xB2\xAF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9B"],
        ["\xF3\xB2\xAF\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9B"],
        ["\xF3\xB2\xAF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x91"],
        ["\xF3\xB2\xAF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA7"],
        ["\xF3\xB2\xAF\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9C"],
        ["\xF3\xB2\xAF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAB"],
        ["\xF3\xB2\xAF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9E"],
        ["\xF3\xB2\xAF\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9D"],
        ["\xF3\xB2\xAF\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x88"],
        ["\xF3\xB2\xAF\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9C"],
        ["\xF3\xB2\xAF\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB7"],
        ["\xF3\xB2\xAF\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA0"],
        ["\xF3\xB2\xAF\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x96"],
        ["\xF3\xB2\xAF\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x92"],
        ["\xF3\xB2\xAF\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x87"],
        ["\xF3\xB2\xAF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA1"],
        ["\xF3\xB2\xAF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9E"],
        ["\xF3\xB2\xAF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x81"],
        ["\xF3\xB2\xAF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xA2"],
        ["\xF3\xB2\xAF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBF"],
        ["\xF3\xB2\xAF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x87"],
        ["\xF3\xB2\xAF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB6"],
        ["\xF3\xB2\xAF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x88"],
        ["\xF3\xB2\xAF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB4"],
        ["\xF3\xB2\xAF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x93"],
        ["\xF3\xB2\xAF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x99"],
        ["\xF3\xB2\xAF\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAB"],
        ["\xF3\xB2\xAF\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9F"],
        ["\xF3\xB2\xAF\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB0"],
        ["\xF3\xB2\xAF\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA0"],
        ["\xF3\xB2\xAF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA1"],
        ["\xF3\xB2\xAF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x87"],
        ["\xF3\xB2\xAF\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB5"],
        ["\xF3\xB2\xAF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x92"],
        ["\xF3\xB2\xAF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB7"],
        ["\xF3\xB2\xAF\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB9"],
        ["\xF3\xB2\xAF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA7"],
        ["\xF3\xB2\xAF\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBE"],
        ["\xF3\xB2\xAF\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9F"],
        ["\xF3\xB2\xB0\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA2"],
        ["\xF3\xB2\xB0\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB6"],
        ["\xF3\xB2\xB0\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x93"],
        ["\xF3\xB2\xB0\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBF"],
        ["\xF3\xB2\xB0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB0"],
        ["\xF3\xB2\xB0\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB4"],
        ["\xF3\xB2\xB0\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x92"],
        ["\xF3\xB2\xB0\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB6"],
        ["\xF3\xB2\xB0\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA3"],
        ["\xF3\xB2\xB0\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8F"],
        ["\xF3\xB2\xB0\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA4"],
        ["\xF3\xB2\xB0\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA5"],
        ["\xF3\xB2\xB0\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA7"],
        ["\xF3\xB2\xB0\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9E"],
        ["\xF3\xB2\xB0\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA6"],
        ["\xF3\xB2\xB0\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x95"],
        ["\xF3\xB2\xB0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA7"],
        ["\xF3\xB2\xB0\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9A"],
        ["\xF3\xB2\xB0\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x97"],
        ["\xF3\xB2\xB0\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9E"],
        ["\xF3\xB2\xB0\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAD"],
        ["\xF3\xB2\xB0\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAE"],
        ["\xF3\xB2\xB0\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA4"],
        ["\xF3\xB2\xB0\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA5"],
        ["\xF3\xB2\xB0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x86"],
        ["\xF3\xB2\xB0\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x90"],
        ["\xF3\xB2\xB0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8A"],
        ["\xF3\xB2\xB0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBA"],
        ["\xF3\xB2\xB0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x80"],
        ["\xF3\xB2\xB0\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBC"],
        ["\xF3\xB2\xB0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8E"],
        ["\xF3\xB2\xB0\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x99"],
        ["\xF3\xB2\xB0\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x91"],
        ["\xF3\xB2\xB0\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB9"],
        ["\xF3\xB2\xB0\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA7"],
        ["\xF3\xB2\xB0\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xA7"],
        ["\xF3\xB2\xB0\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB7"],
        ["\xF3\xB2\xB0\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB8"],
        ["\xF3\xB2\xB0\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA7"],
        ["\xF3\xB2\xB0\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x97"],
        ["\xF3\xB2\xB0\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x99"],
        ["\xF3\xB2\xB0\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x90"],
        ["\xF3\xB2\xB0\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA7"],
        ["\xF3\xB2\xB0\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x95"],
        ["\xF3\xB2\xB0\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA0"],
        ["\xF3\xB2\xB0\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x93"],
        ["\xF3\xB2\xB0\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA5"],
        ["\xF3\xB2\xB0\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA1"],
        ["\xF3\xB2\xB0\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBB"],
        ["\xF3\xB2\xB0\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA8"],
        ["\xF3\xB2\xB0\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9E"],
        ["\xF3\xB2\xB0\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBF"],
        ["\xF3\xB2\xB0\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9D"],
        ["\xF3\xB2\xB0\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x82"],
        ["\xF3\xB2\xB0\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB0"],
        ["\xF3\xB2\xB0\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x97"],
        ["\xF3\xB2\xB0\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA4"],
        ["\xF3\xB2\xB0\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x86"],
        ["\xF3\xB2\xB0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9E"],
        ["\xF3\xB2\xB0\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xB8"],
        ["\xF3\xB2\xB0\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB1"],
        ["\xF3\xB2\xB0\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x85"],
        ["\xF3\xB2\xB0\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x88"],
        ["\xF3\xB2\xB0\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x92"],
        ["\xF3\xB2\xB1\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x9C"],
        ["\xF3\xB2\xB1\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA9"],
        ["\xF3\xB2\xB1\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9D"],
        ["\xF3\xB2\xB1\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAF"],
        ["\xF3\xB2\xB1\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB3"],
        ["\xF3\xB2\xB1\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBB"],
        ["\xF3\xB2\xB1\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x83"],
        ["\xF3\xB2\xB1\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8D"],
        ["\xF3\xB2\xB1\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8F"],
        ["\xF3\xB2\xB1\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x91"],
        ["\xF3\xB2\xB1\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x95"],
        ["\xF3\xB2\xB1\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x97"],
        ["\xF3\xB2\xB1\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA5"],
        ["\xF3\xB2\xB1\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAA"],
        ["\xF3\xB2\xB1\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAB"],
        ["\xF3\xB2\xB1\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA7"],
        ["\xF3\xB2\xB1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAC"],
        ["\xF3\xB2\xB1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x9E"],
        ["\xF3\xB2\xB1\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8E"],
        ["\xF3\xB2\xB1\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x99"],
        ["\xF3\xB2\xB1\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9C"],
        ["\xF3\xB2\xB1\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB5"],
        ["\xF3\xB2\xB1\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB2"],
        ["\xF3\xB2\xB1\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8F"],
        ["\xF3\xB2\xB1\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB1"],
        ["\xF3\xB2\xB1\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xBB"],
        ["\xF3\xB2\xB1\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x80"],
        ["\xF3\xB2\xB1\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB0"],
        ["\xF3\xB2\xB1\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAB"],
        ["\xF3\xB2\xB1\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAD"],
        ["\xF3\xB2\xB1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x99"],
        ["\xF3\xB2\xB1\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x91"],
        ["\xF3\xB2\xB4\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x94"],
        ["\xF3\xB2\xB4\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x96"],
        ["\xF3\xB2\xB5\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x92"],
        ["\xF3\xB2\xB5\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xF3\xB2\xB5\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xF3\xB2\xB6\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xB3"],
        ["\xF3\xB2\xB6\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xB4"],
        ["\xF3\xB2\xB6\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xB5"],
        ["\xF3\xB2\xB6\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBB"],
        ["\xF3\xB2\xB6\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBC"],
        ["\xF3\xB2\xB6\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBF"],
        ["\xF3\xB2\xB6\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9F"],
        ["\xF3\xB2\xB6\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x84"],
        ["\xF3\xB2\xB6\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x85"],
        ["\xF3\xB2\xB6\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x8A"],
        ["\xF3\xB2\xB6\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x8B"],
        ["\xF3\xB2\xB6\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x89"],
        ["\xF3\xB2\xB6\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x85"],
        ["\xF3\xB2\xB6\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x85"],
        ["\xF3\xB2\xB6\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x86"],
        ["\xF3\xB2\xB6\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xF3\xB2\xB6\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x95"],
        ["\xF3\xB2\xB6\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x96"],
        ["\xF3\xB2\xB6\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x97"],
        ["\xF3\xB2\xB6\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA6"],
        ["\xF3\xB2\xB6\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9F"],
        ["\xF3\xB2\xB6\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\xA0"],
        ["\xF3\xB2\xB6\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x98"],
        ["\xF3\xB2\xB6\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x99"],
        ["\xF3\xB2\xB6\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x96"],
        ["\xF3\xB2\xB6\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x97"],
        ["\xF3\xB2\xB6\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA2"],
        ["\xF3\xB2\xB6\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x83"],
        ["\xF3\xB2\xB6\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x85"],
        ["\xF3\xB2\xB6\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x88"],
        ["\xF3\xB2\xB6\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB6"],
        ["\xF3\xB2\xB6\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB7"],
        ["\xF3\xB2\xB6\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x94"],
        ["\xF3\xB2\xB7\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAE"],
        ["\xF3\xB2\xB7\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAB"],
        ["\xF3\xB2\xB7\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAC"],
        ["\xF3\xB2\xB7\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA9"],
        ["\xF3\xB2\xB7\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB7"],
        ["\xF3\xB2\xB7\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB6"],
        ["\xF3\xB2\xB7\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x81"],
        ["\xF3\xB2\xB7\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x80"],
        ["\xF3\xB2\xB7\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x97"],
        ["\xF3\xB2\xB7\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x98"],
        ["\xF3\xB2\xB7\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x96"],
        ["\xF3\xB2\xB7\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x99"],
        ["\xF3\xB2\xB7\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x84"],
        ["\xF3\xB2\xB7\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA8"],
        ["\xF3\xB2\xB7\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA6"],
        ["\xF3\xB2\xB7\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA7"],
        ["\xF3\xB2\xB7\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\xA9"],
        ["\xF3\xB2\xB7\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4\xB4"],
        ["\xF3\xB2\xB7\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4\xB5"],
        ["\xF3\xB2\xB7\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6\xBF"],
        ["\xF3\xB2\xB7\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x89"],
        ["\xF3\xB2\xB7\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xBD"],
        ["\xF3\xB2\xB7\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9\x86"],
        ["\xF3\xB2\xB7\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9\x85"],
        ["\xF3\xB2\xB7\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xA6"],
        ["\xF3\xB2\xB7\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA2"],
        ["\xF3\xB2\xB8\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x93"],
        ["\xF3\xB2\xB8\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xB5"],
        ["\xF3\xB2\xB8\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x8F"],
        ["\xF3\xB2\xB8\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8B"],
        ["\xF3\xB2\xB8\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x93"],
        ["\xF3\xB2\xB8\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA7"],
        ["\xF3\xB2\xB8\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA0"],
        ["\xF3\xB2\xB8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x93"],
        ["\xF3\xB2\xB8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7\xBA"],
        ["\xF3\xB2\xB8\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7\xBB"],
        ["\xF3\xB2\xB9\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x94"],
        ["\xF3\xB2\xB9\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x95"],
        ["\xF3\xB2\xB9\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x96"],
        ["\xF3\xB2\xBA\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B\xE3\x82\x9A"],
        ["\xF3\xB2\xBA\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D\xE3\x82\x9A"],
        ["\xF3\xB2\xBA\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F\xE3\x82\x9A"],
        ["\xF3\xB2\xBA\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91\xE3\x82\x9A"],
        ["\xF3\xB2\xBA\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88\xE3\x82\x9A"],
        ["\xF3\xB2\xBB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA4"],
        ["\xF3\xB2\xBB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA0"],
        ["\xF3\xB2\xBC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA2"],
        ["\xF3\xB2\xBC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA6"],
        ["\xF3\xB2\xBC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA1"],
        ["\xF3\xB2\xBC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA5"],
        ["\xF3\xB2\xBC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA7"],
        ["\xF3\xB2\xBC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA3"],
        ["\xF3\xB2\xBC\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF\x82"],
        ["\xF3\xB2\xBC\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB5"],
        ["\xF3\xB2\xBC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB6"],
        ["\xF3\xB2\xBC\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB7"],
        ["\xF3\xB2\xBC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB8"],
        ["\xF3\xB2\xBC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB9"],
        ["\xF3\xB2\xBC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBA"],
        ["\xF3\xB2\xBC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBB"],
        ["\xF3\xB2\xBC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBC"],
        ["\xF3\xB2\xBC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBD"],
        ["\xF3\xB2\xBC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xBE"],
        ["\xF3\xB2\xBC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x96"],
        ["\xF3\xB2\xBC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x97"],
        ["\xF3\xB2\xBC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\xA0"],
        ["\xF3\xB2\xBC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x8E"],
        ["\xF3\xB2\xBC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x80"],
        ["\xF3\xB2\xBC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x81"],
        ["\xF3\xB2\xBC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x82"],
        ["\xF3\xB2\xBC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x83"],
        ["\xF3\xB2\xBC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA8"],
        ["\xF3\xB2\xBC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB1"],
        ["\xF3\xB2\xBC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB0"],
        ["\xF3\xB2\xBC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB1"],
        ["\xF3\xB2\xBC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB2"],
        ["\xF3\xB2\xBC\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB3"],
        ["\xF3\xB2\xBC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB4"],
        ["\xF3\xB2\xBC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB5"],
        ["\xF3\xB2\xBC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB6"],
        ["\xF3\xB2\xBC\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB7"],
        ["\xF3\xB2\xBC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB8"],
        ["\xF3\xB2\xBC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB9"],
        ["\xF3\xB2\xBC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xB7\xE3\x82\x9A"],
        ["\xF3\xB2\xBC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBA"],
        ["\xF3\xB2\xBC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBB"],
        ["\xF3\xB2\xBD\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBC"],
        ["\xF3\xB2\xBD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBD"],
        ["\xF3\xB2\xBD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBE"],
        ["\xF3\xB2\xBD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87\xBF"],
        ["\xF3\xB2\xBD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E\xBE"],
        ["\xF3\xB2\xBD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E\xBF"],
        ["\xF3\xB2\xBD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x80"],
        ["\xF3\xB2\xBD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x81"],
        ["\xF3\xB2\xBD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x82"],
        ["\xF3\xB2\xBD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x83"],
        ["\xF3\xB2\xBD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x84"],
        ["\xF3\xB2\xBD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x85"],
        ["\xF3\xB2\xBD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x86"],
        ["\xF3\xB2\xBD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x87"],
        ["\xF3\xB2\xBD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x88"],
        ["\xF3\xB2\xBD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x89"],
        ["\xF3\xB2\xBD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8A"],
        ["\xF3\xB2\xBD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8B"],
        ["\xF3\xB2\xBD\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8C"],
        ["\xF3\xB2\xBE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB7"],
        ["\xF3\xB2\xBE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB8"],
        ["\xF3\xB2\xBE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB9"],
        ["\xF3\xB2\xBE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBA"],
        ["\xF3\xB2\xBE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B\x9A"],
        ["\xF3\xB2\xBE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B\x9B"],
        ["\xF3\xB2\xBE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x93"],
        ["\xF3\xB2\xBE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x94"],
        ["\xF3\xB2\xBE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x95"],
        ["\xF3\xB2\xBE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C\x93"],
        ["\xF3\xB2\xBE\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x98"],
        ["\xF3\xB2\xBE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x90\xA3"],
        ["\xF3\xB2\xBE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F\x8E"],
        ["\xF3\xB2\xBF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x91"],
        ["\xF3\xB2\xBF\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x92"],
        ["\xF3\xB2\xBF\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x93"],
        ["\xF3\xB2\xBF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x94"],
        ["\xF3\xB2\xBF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x95"],
        ["\xF3\xB2\xBF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x96"],
        ["\xF3\xB2\xBF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x97"],
        ["\xF3\xB2\xBF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x98"],
        ["\xF3\xB2\xBF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x99"],
        ["\xF3\xB2\xBF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9A"],
        ["\xF3\xB2\xBF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9B"],
        ["\xF3\xB2\xBF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9C"],
        ["\xF3\xB2\xBF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9D"],
        ["\xF3\xB2\xBF\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9E"],
        ["\xF3\xB2\xBF\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89\x9F"],
        ["\xF3\xB2\xBF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB1"],
        ["\xF3\xB2\xBF\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB2"],
        ["\xF3\xB2\xBF\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB3"],
        ["\xF3\xB2\xBF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB4"],
        ["\xF3\xB2\xBF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB5"],
        ["\xF3\xB2\xBF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB6"],
        ["\xF3\xB2\xBF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB7"],
        ["\xF3\xB2\xBF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB8"],
        ["\xF3\xB2\xBF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xB9"],
        ["\xF3\xB2\xBF\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBA"],
        ["\xF3\xB2\xBF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBB"],
        ["\xF3\xB2\xBF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBC"],
        ["\xF3\xB2\xBF\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBD"],
        ["\xF3\xB2\xBF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBE"],
        ["\xF3\xB2\xBF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xBF"],
        ["\xF3\xB2\xBF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x90"],
        ["\xF3\xB2\xBF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x91"],
        ["\xF3\xB2\xBF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x92"],
        ["\xF3\xB2\xBF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x93"],
        ["\xF3\xB2\xBF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBC"],
        ["\xF3\xB2\xBF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x87"],
        ["\xF3\xB2\xBF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x88"],
        ["\xF3\xB2\xBF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x89"],
        ["\xF3\xB2\xBF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x8D"],
        ["\xF3\xB2\xBF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x8E"],
        ["\xF3\xB2\xBF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x90"],
        ["\xF3\xB2\xBF\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8\xBE"],
        ["\xF3\xB2\xBF\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8\xBF"],
        ["\xF3\xB2\xBF\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xF3\xB2\xBF\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xF3\xB2\xBF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x91"],
        ["\xF3\xB2\xBF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x92"],
        ["\xF3\xB2\xBF\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x94"],
        ["\xF3\xB2\xBF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x96"],
        ["\xF3\xB2\xBF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x98"],
        ["\xF3\xB2\xBF\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x9A"],
        ["\xF3\xB2\xBF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],
        ["\xF3\xB3\x80\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x82\xAC"],
        ["\xF3\xB3\x80\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA0"],
        ["\xF3\xB3\x80\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xF3\xB3\x80\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xF3\xB3\x80\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xF3\xB3\x80\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xF3\xB3\x80\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xF3\xB3\x80\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xF3\xB3\x80\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xF3\xB3\x80\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xF3\xB3\x80\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xF3\xB3\x80\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xF3\xB3\x80\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xF3\xB3\x80\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xF3\xB3\x80\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xF3\xB3\x80\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xF3\xB3\x80\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xF3\xB3\x80\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xF3\xB3\x80\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xF3\xB3\x80\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xF3\xB3\x80\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xF3\xB3\x80\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xF3\xB3\x80\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x80"],
        ["\xF3\xB3\x80\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x81"],
        ["\xF3\xB3\x80\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x82"],
        ["\xF3\xB3\x80\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x83"],
        ["\xF3\xB3\x80\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x84"],
        ["\xF3\xB3\x80\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x85"],
        ["\xF3\xB3\x80\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x86"],
        ["\xF3\xB3\x80\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x87"],
        ["\xF3\xB3\x80\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x88"],
        ["\xF3\xB3\x80\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x89"],
        ["\xF3\xB3\x80\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8A"],
        ["\xF3\xB3\x80\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8B"],
        ["\xF3\xB3\x80\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8C"],
        ["\xF3\xB3\x80\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8D"],
        ["\xF3\xB3\x80\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8E"],
        ["\xF3\xB3\x80\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8F"],
        ["\xF3\xB3\x80\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x90"],
        ["\xF3\xB3\x80\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x91"],
        ["\xF3\xB3\x80\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x92"],
        ["\xF3\xB3\x80\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x93"],
        ["\xF3\xB3\x80\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x94"],
        ["\xF3\xB3\x80\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x95"],
        ["\xF3\xB3\x80\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x96"],
        ["\xF3\xB3\x80\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x98"],
        ["\xF3\xB3\x80\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x99"],
        ["\xF3\xB3\x80\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9A"],
        ["\xF3\xB3\x80\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9B"],
        ["\xF3\xB3\x80\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\xF3\xB3\x80\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9D"],
        ["\xF3\xB3\x80\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9E"],
        ["\xF3\xB3\x80\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9F"],
        ["\xF3\xB3\x80\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA0"],
        ["\xF3\xB3\x80\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xF3\xB3\x80\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xF3\xB3\x80\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xF3\xB3\x80\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xF3\xB3\x80\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xF3\xB3\x80\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xF3\xB3\x80\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xF3\xB3\x80\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xF3\xB3\x80\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xF3\xB3\x80\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xF3\xB3\x81\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xF3\xB3\x81\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xF3\xB3\x81\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xF3\xB3\x81\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xF3\xB3\x81\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xF3\xB3\x81\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xF3\xB3\x81\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xF3\xB3\x81\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xF3\xB3\x81\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xF3\xB3\x81\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xF3\xB3\x81\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xF3\xB3\x81\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xF3\xB3\x81\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xF3\xB3\x81\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xF3\xB3\x81\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xF3\xB3\x81\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xF3\xB3\x81\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xF3\xB3\x81\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xF3\xB3\x81\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xF3\xB3\x81\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xF3\xB3\x81\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x80"],
        ["\xF3\xB3\x81\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xF3\xB3\x81\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xF3\xB3\x81\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x92"],
        ["\xF3\xB3\x81\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x8C"],
        ["\xF3\xB3\x81\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x81"],
        ["\xF3\xB3\x81\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xF3\xB3\x81\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xF3\xB3\x81\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x93"],
        ["\xF3\xB3\x81\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x8D"],
        ["\xF3\xB3\x81\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x84"],
        ["\xF3\xB3\x81\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x98"],
        ["\xF3\xB3\x81\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x81"],
        ["\xF3\xB3\x81\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xF3\xB3\x81\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9A"],
        ["\xF3\xB3\x81\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],
        ["\xF3\xB3\x81\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9E"],
        ["\xF3\xB3\x81\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xF3\xB3\x81\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xF3\xB3\x81\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xF3\xB3\x81\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xF3\xB3\x81\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x85"],
        ["\xF3\xB3\x81\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x9B"],
        ["\xF3\xB3\x81\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x82"],
        ["\xF3\xB3\x81\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xF3\xB3\x81\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9B"],
        ["\xF3\xB3\x81\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x87"],
        ["\xF3\xB3\x81\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xF3\xB3\x81\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9F"],
        ["\xF3\xB3\x81\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xF3\xB3\x81\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xF3\xB3\x81\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x9D"],
        ["\xF3\xB3\x81\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xF3\xB3\x81\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xF3\xB3\x81\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x94"],
        ["\xF3\xB3\x81\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x82"],
        ["\xF3\xB3\x81\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xF3\xB3\x81\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x86"],
        ["\xF3\xB3\x81\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x8C"],
        ["\xF3\xB3\x81\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x98"],
        ["\xF3\xB3\x81\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x9A"],
        ["\xF3\xB3\x81\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x8E"],
        ["\xF3\xB3\x81\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x83"],
        ["\xF3\xB3\x81\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x87"],
        ["\xF3\xB3\x82\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x90"],
        ["\xF3\xB3\x82\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x98"],
        ["\xF3\xB3\x82\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xF3\xB3\x82\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xF3\xB3\x82\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xF3\xB3\x82\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x95"],
        ["\xF3\xB3\x82\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x83"],
        ["\xF3\xB3\x82\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xF3\xB3\x82\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x87"],
        ["\xF3\xB3\x82\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x8D"],
        ["\xF3\xB3\x82\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x99"],
        ["\xF3\xB3\x82\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],
        ["\xF3\xB3\x82\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x8F"],
        ["\xF3\xB3\x82\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x91"],
        ["\xF3\xB3\x82\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x84"],
        ["\xF3\xB3\x82\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x88"],
        ["\xF3\xB3\x82\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x91"],
        ["\xF3\xB3\x82\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x99"],
        ["\xF3\xB3\x82\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xF3\xB3\x82\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xF3\xB3\x82\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xF3\xB3\x82\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x99"],
        ["\xF3\xB3\x82\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x88"],
        ["\xF3\xB3\x82\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x9C"],
        ["\xF3\xB3\x82\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xF3\xB3\x82\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xF3\xB3\x82\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9C"],
        ["\xF3\xB3\x82\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xF3\xB3\x82\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x89"],
        ["\xF3\xB3\x82\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x9D"],
        ["\xF3\xB3\x82\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xF3\xB3\x82\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xF3\xB3\x82\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9D"],
        ["\xF3\xB3\x82\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xF3\xB3\x82\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xF3\xB3\x82\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8B"],
        ["\xF3\xB3\x82\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xF3\xB3\x82\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x83"],
        ["\xF3\xB3\x82\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x92"],
        ["\xF3\xB3\x82\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xF3\xB3\x82\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xF3\xB3\x82\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xF3\xB3\x82\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x88"],
        ["\xF3\xB3\x82\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x96"],
        ["\xF3\xB3\x82\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xF3\xB3\x82\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xF3\xB3\x82\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x82"],
        ["\xF3\xB3\x82\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x90"],
        ["\xF3\xB3\x82\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xF3\xB3\x82\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xF3\xB3\x82\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9F"],
        ["\xF3\xB3\x82\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xF3\xB3\x82\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x9D"],
        ["\xF3\xB3\x82\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8E"],
        ["\xF3\xB3\x82\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xF3\xB3\x82\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],
        ["\xF3\xB3\x82\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xF3\xB3\x82\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x81"],
        ["\xF3\xB3\x82\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xF3\xB3\x82\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x95"],
        ["\xF3\xB3\x82\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x94"],
        ["\xF3\xB3\x82\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xF3\xB3\x82\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x98"],
        ["\xF3\xB3\x82\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x82"],
        ["\xF3\xB3\x83\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x93"],
        ["\xF3\xB3\x83\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x97"],
        ["\xF3\xB3\x83\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x84"],
        ["\xF3\xB3\x83\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],
        ["\xF3\xB3\x83\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x93"],
        ["\xF3\xB3\x83\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x93"],
        ["\xF3\xB3\x83\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x92"],
        ["\xF3\xB3\x83\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xF3\xB3\x83\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x89"],
        ["\xF3\xB3\x83\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x98"],
        ["\xF3\xB3\x83\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xF3\xB3\x83\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x99"],
        ["\xF3\xB3\x83\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],
        ["\xF3\xB3\x83\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9E"],
        ["\xF3\xB3\x83\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x90"],
        ["\xF3\xB3\x83\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xF3\xB3\x83\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8A"],
        ["\xF3\xB3\x83\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xF3\xB3\x83\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8C"],
        ["\xF3\xB3\x83\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x94"],
        ["\xF3\xB3\x83\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x91"],
        ["\xF3\xB3\x83\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x92"],
        ["\xF3\xB3\x83\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8D"],
        ["\xF3\xB3\x83\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xF3\xB3\x83\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xF3\xB3\x83\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xF3\xB3\x83\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x95"],
        ["\xF3\xB3\x83\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x91"],
        ["\xF3\xB3\x83\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xF3\xB3\x83\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xF3\xB3\x83\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9A"],
        ["\xF3\xB3\x83\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6\xCC\x80"],
        ["\xF3\xB3\x83\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xF3\xB3\x83\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB0"],
        ["\xF3\xB3\x83\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB1"],
        ["\xF3\xB3\x83\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x94\xCC\x80"],
        ["\xF3\xB3\x83\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x94\xCC\x81"],
        ["\xF3\xB3\x83\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8C\xCC\x80"],
        ["\xF3\xB3\x83\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA\x8C\xCC\x81"],
        ["\xF3\xB3\x83\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x99\xCC\x80"],
        ["\xF3\xB3\x83\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x99\xCC\x81"],
        ["\xF3\xB3\x83\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9A\xCC\x80"],
        ["\xF3\xB3\x83\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9A\xCC\x81"],
        ["\xF3\xB3\x83\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB2"],
        ["\xF3\xB3\x83\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD\xB3"],
        ["\xF3\xB3\x83\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xF3\xB3\x83\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x88"],
        ["\xF3\xB3\x83\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x8C"],
        ["\xF3\xB3\x83\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x90"],
        ["\xF3\xB3\x83\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x91"],
        ["\xF3\xB3\x83\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x86"],
        ["\xF3\xB3\x83\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBF"],
        ["\xF3\xB3\x83\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x8B"],
        ["\xF3\xB3\x83\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x81"],
        ["\xF3\xB3\x83\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x84"],
        ["\xF3\xB3\x83\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x80"],
        ["\xF3\xB3\x83\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x8F"],
        ["\xF3\xB3\x83\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x8C"],
        ["\xF3\xB3\x83\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x82"],
        ["\xF3\xB3\x83\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xF3\xB3\x83\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xF3\xB3\x83\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xF3\xB3\x83\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xF3\xB3\x83\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xF3\xB3\x84\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9\xCB\xA5"],
        ["\xF3\xB3\x84\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5\xCB\xA9"],
        ["\xF3\xB3\x84\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xF3\xB3\x84\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xF3\xB3\x84\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xF3\xB3\x84\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x9C"],
        ["\xF3\xB3\x84\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x9F"],
        ["\xF3\xB3\x84\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA0"],
        ["\xF3\xB3\x84\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x88"],
        ["\xF3\xB3\x84\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xF3\xB3\x84\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xF3\xB3\x84\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xF3\xB3\x84\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB\x9E"],
        ["\xF3\xB3\x84\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xF3\xB3\x84\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xF3\xB3\x84\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xF3\xB3\x84\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xF3\xB3\x84\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x9D"],
        ["\xF3\xB3\x84\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x9E"],
        ["\xF3\xB3\x84\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x98"],
        ["\xF3\xB3\x84\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x99"],
        ["\xF3\xB3\x84\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xF3\xB3\x84\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xF3\xB3\x84\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xF3\xB3\x84\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x83"],
        ["\xF3\xB3\x84\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC\x9A"],
        ["\xF3\xB3\x84\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB6"],
        ["\xF3\xB3\x84\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB7"],
        ["\xF3\xB3\x84\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB8"],
        ["\xF3\xB3\x84\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB9"],
        ["\xF3\xB3\x84\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBA"],
        ["\xF3\xB3\x84\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBB"],
        ["\xF3\xB3\x84\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBC"],
        ["\xF3\xB3\x84\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBD"],
        ["\xF3\xB3\x84\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBE"],
        ["\xF3\xB3\x84\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBF"],
        ["\xF3\xB3\x84\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAB"],
        ["\xF3\xB3\x84\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAC"],
        ["\xF3\xB3\x84\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAD"],
        ["\xF3\xB3\x84\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAE"],
        ["\xF3\xB3\x84\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xAF"],
        ["\xF3\xB3\x84\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB0"],
        ["\xF3\xB3\x84\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB1"],
        ["\xF3\xB3\x84\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB2"],
        ["\xF3\xB3\x84\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB3"],
        ["\xF3\xB3\x84\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xB4"],
        ["\xF3\xB3\x84\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBA"],
        ["\xF3\xB3\x84\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBB"],
        ["\xF3\xB3\x84\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x90"],
        ["\xF3\xB3\x84\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x91"],
        ["\xF3\xB3\x84\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x92"],
        ["\xF3\xB3\x84\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x93"],
        ["\xF3\xB3\x84\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x94"],
        ["\xF3\xB3\x84\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x95"],
        ["\xF3\xB3\x85\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x96"],
        ["\xF3\xB3\x85\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x97"],
        ["\xF3\xB3\x85\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x98"],
        ["\xF3\xB3\x85\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x99"],
        ["\xF3\xB3\x85\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9A"],
        ["\xF3\xB3\x85\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9B"],
        ["\xF3\xB3\x85\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9C"],
        ["\xF3\xB3\x85\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9D"],
        ["\xF3\xB3\x85\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9E"],
        ["\xF3\xB3\x85\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9F"],
        ["\xF3\xB3\x85\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA0"],
        ["\xF3\xB3\x85\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA1"],
        ["\xF3\xB3\x85\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA2"],
        ["\xF3\xB3\x85\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA3"],
        ["\xF3\xB3\x85\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA4"],
        ["\xF3\xB3\x85\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA5"],
        ["\xF3\xB3\x85\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA6"],
        ["\xF3\xB3\x85\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA7"],
        ["\xF3\xB3\x85\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA8"],
        ["\xF3\xB3\x85\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA9"],
        ["\xF3\xB3\x85\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x90"],
        ["\xF3\xB3\x85\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x91"],
        ["\xF3\xB3\x85\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x92"],
        ["\xF3\xB3\x85\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x93"],
        ["\xF3\xB3\x85\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x94"],
        ["\xF3\xB3\x85\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x95"],
        ["\xF3\xB3\x85\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x96"],
        ["\xF3\xB3\x85\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x97"],
        ["\xF3\xB3\x85\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x98"],
        ["\xF3\xB3\x85\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x99"],
        ["\xF3\xB3\x85\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9A"],
        ["\xF3\xB3\x85\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9B"],
        ["\xF3\xB3\x85\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9C"],
        ["\xF3\xB3\x85\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9D"],
        ["\xF3\xB3\x85\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9E"],
        ["\xF3\xB3\x85\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x9F"],
        ["\xF3\xB3\x85\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA0"],
        ["\xF3\xB3\x85\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA1"],
        ["\xF3\xB3\x85\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA2"],
        ["\xF3\xB3\x85\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA3"],
        ["\xF3\xB3\x85\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xBA"],
        ["\xF3\xB3\x85\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA9"],
        ["\xF3\xB3\x85\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA5"],
        ["\xF3\xB3\x85\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAD"],
        ["\xF3\xB3\x85\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAC"],
        ["\xF3\xB3\x85\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x91"],
        ["\xF3\xB3\x85\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81\x82"],
        ["\xF3\xB3\x86\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAA"],
        ["\xF3\xB3\x86\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAB"],
        ["\xF3\xB3\x87\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\x96"],
        ["\xF3\xB3\x87\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x9E"],
        ["\xF3\xB3\x87\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB1"],
        ["\xF3\xB3\x87\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x80\x8B"],
        ["\xF3\xB3\x87\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\x82"],
        ["\xF3\xB3\x87\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAF"],
        ["\xF3\xB3\x87\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB0"],
        ["\xF3\xB3\x87\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8D"],
        ["\xF3\xB3\x87\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBD"],
        ["\xF3\xB3\x87\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBF"],
        ["\xF3\xB3\x87\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8B"],
        ["\xF3\xB3\x87\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA0"],
        ["\xF3\xB3\x87\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x88"],
        ["\xF3\xB3\x87\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x89"],
        ["\xF3\xB3\x87\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9F"],
        ["\xF3\xB3\x87\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAA"],
        ["\xF3\xB3\x87\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAC"],
        ["\xF3\xB3\x87\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBE"],
        ["\xF3\xB3\x87\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x97"],
        ["\xF3\xB3\x87\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB0"],
        ["\xF3\xB3\x87\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA0"],
        ["\xF3\xB3\x87\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x81"],
        ["\xF3\xB3\x87\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x82"],
        ["\xF3\xB3\x87\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8E"],
        ["\xF3\xB3\x87\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x98"],
        ["\xF3\xB3\x87\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA7"],
        ["\xF3\xB3\x87\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAE"],
        ["\xF3\xB3\x87\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xBB"],
        ["\xF3\xB3\x87\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x81"],
        ["\xF3\xB3\x87\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8C"],
        ["\xF3\xB3\x87\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB2"],
        ["\xF3\xB3\x87\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x90"],
        ["\xF3\xB3\x87\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA6"],
        ["\xF3\xB3\x87\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB1"],
        ["\xF3\xB3\x87\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x86"],
        ["\xF3\xB3\x88\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x83"],
        ["\xF3\xB3\x88\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x8B"],
        ["\xF3\xB3\x88\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9E"],
        ["\xF3\xB3\x88\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB5"],
        ["\xF3\xB3\x88\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB2"],
        ["\xF3\xB3\x88\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x95"],
        ["\xF3\xB3\x88\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x97"],
        ["\xF3\xB3\x88\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\xB5"],
        ["\xF3\xB3\x88\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x83"],
        ["\xF3\xB3\x88\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8A"],
        ["\xF3\xB3\x88\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9E"],
        ["\xF3\xB3\x88\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA2"],
        ["\xF3\xB3\x88\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAE"],
        ["\xF3\xB3\x88\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x81"],
        ["\xF3\xB3\x88\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x9B"],
        ["\xF3\xB3\x88\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x93"],
        ["\xF3\xB3\x88\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x89"],
        ["\xF3\xB3\x88\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x97"],
        ["\xF3\xB3\x88\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA1"],
        ["\xF3\xB3\x88\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x93"],
        ["\xF3\xB3\x88\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x88"],
        ["\xF3\xB3\x88\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB3"],
        ["\xF3\xB3\x88\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8C"],
        ["\xF3\xB3\x88\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x90"],
        ["\xF3\xB3\x88\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x96"],
        ["\xF3\xB3\x88\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB4"],
        ["\xF3\xB3\x88\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB0"],
        ["\xF3\xB3\x88\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBB"],
        ["\xF3\xB3\x88\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9C"],
        ["\xF3\xB3\x88\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB5"],
        ["\xF3\xB3\x88\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA1"],
        ["\xF3\xB3\x88\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA3"],
        ["\xF3\xB3\x88\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBD"],
        ["\xF3\xB3\x88\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9D"],
        ["\xF3\xB3\x88\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x92"],
        ["\xF3\xB3\x88\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA7"],
        ["\xF3\xB3\x88\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8D"],
        ["\xF3\xB3\x88\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAB"],
        ["\xF3\xB3\x88\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB4"],
        ["\xF3\xB3\x88\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBF"],
        ["\xF3\xB3\x88\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x88"],
        ["\xF3\xB3\x88\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x96"],
        ["\xF3\xB3\x88\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA1"],
        ["\xF3\xB3\x88\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x86"],
        ["\xF3\xB3\x88\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8E"],
        ["\xF3\xB3\x88\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAB"],
        ["\xF3\xB3\x88\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB5"],
        ["\xF3\xB3\x88\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x90"],
        ["\xF3\xB3\x88\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9E"],
        ["\xF3\xB3\x88\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x81"],
        ["\xF3\xB3\x88\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8E"],
        ["\xF3\xB3\x88\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB6"],
        ["\xF3\xB3\x89\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAD"],
        ["\xF3\xB3\x89\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x8E"],
        ["\xF3\xB3\x89\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB7"],
        ["\xF3\xB3\x89\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x88"],
        ["\xF3\xB3\x89\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x8E"],
        ["\xF3\xB3\x89\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBB"],
        ["\xF3\xB3\x89\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x89"],
        ["\xF3\xB3\x89\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB6"],
        ["\xF3\xB3\x89\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA6"],
        ["\xF3\xB3\x89\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB8"],
        ["\xF3\xB3\x89\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAF"],
        ["\xF3\xB3\x89\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB1"],
        ["\xF3\xB3\x89\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB2"],
        ["\xF3\xB3\x89\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x99"],
        ["\xF3\xB3\x89\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9E"],
        ["\xF3\xB3\x89\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA9"],
        ["\xF3\xB3\x89\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAC"],
        ["\xF3\xB3\x89\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB3"],
        ["\xF3\xB3\x89\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x89"],
        ["\xF3\xB3\x89\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8A"],
        ["\xF3\xB3\x89\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8A"],
        ["\xF3\xB3\x89\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x88\xBD"],
        ["\xF3\xB3\x89\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA1"],
        ["\xF3\xB3\x89\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAF"],
        ["\xF3\xB3\x89\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB3"],
        ["\xF3\xB3\x89\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB4"],
        ["\xF3\xB3\x89\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB0"],
        ["\xF3\xB3\x89\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB7"],
        ["\xF3\xB3\x89\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBC"],
        ["\xF3\xB3\x89\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9C"],
        ["\xF3\xB3\x89\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8C\x9B"],
        ["\xF3\xB3\x89\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB8"],
        ["\xF3\xB3\x89\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8F"],
        ["\xF3\xB3\x89\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA4"],
        ["\xF3\xB3\x89\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xAD"],
        ["\xF3\xB3\x89\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB5"],
        ["\xF3\xB3\x89\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB6"],
        ["\xF3\xB3\x89\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBF"],
        ["\xF3\xB3\x89\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x89"],
        ["\xF3\xB3\x89\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA1"],
        ["\xF3\xB3\x89\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA4"],
        ["\xF3\xB3\x89\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xB9"],
        ["\xF3\xB3\x89\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBC"],
        ["\xF3\xB3\x89\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x89"],
        ["\xF3\xB3\x89\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBA"],
        ["\xF3\xB3\x89\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA9"],
        ["\xF3\xB3\x89\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x91\xAE"],
        ["\xF3\xB3\x89\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x92"],
        ["\xF3\xB3\x89\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8E"],
        ["\xF3\xB3\x89\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x94"],
        ["\xF3\xB3\x89\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9A"],
        ["\xF3\xB3\x89\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA0"],
        ["\xF3\xB3\x89\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA9"],
        ["\xF3\xB3\x89\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8C"],
        ["\xF3\xB3\x89\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x81"],
        ["\xF3\xB3\x89\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAD"],
        ["\xF3\xB3\x89\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8B"],
        ["\xF3\xB3\x89\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x92"],
        ["\xF3\xB3\x8A\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x83"],
        ["\xF3\xB3\x8A\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x92"],
        ["\xF3\xB3\x8A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9D"],
        ["\xF3\xB3\x8A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x93"],
        ["\xF3\xB3\x8A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA3"],
        ["\xF3\xB3\x8A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA7"],
        ["\xF3\xB3\x8A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAD"],
        ["\xF3\xB3\x8A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xB7"],
        ["\xF3\xB3\x8A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBE"],
        ["\xF3\xB3\x8A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x84"],
        ["\xF3\xB3\x8A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9E"],
        ["\xF3\xB3\x8A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xA7"],
        ["\xF3\xB3\x8A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x84"],
        ["\xF3\xB3\x8A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xA2\xBD"],
        ["\xF3\xB3\x8A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x99"],
        ["\xF3\xB3\x8A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA5"],
        ["\xF3\xB3\x8A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9D"],
        ["\xF3\xB3\xB8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAE\x9F"],
        ["\xF3\xB3\xB8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x81"],
        ["\xF3\xB3\xB8\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBD"],
        ["\xF3\xB3\xB8\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x93"],
        ["\xF3\xB3\xB8\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x92"],
        ["\xF3\xB3\xB8\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA3"],
        ["\xF3\xB3\xB8\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAB"],
        ["\xF3\xB3\xB8\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E\x8D"],
        ["\xF3\xB3\xB8\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA2"],
        ["\xF3\xB3\xB8\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBB"],
        ["\xF3\xB3\xB8\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBC"],
        ["\xF3\xB3\xB8\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x9A\xB4"],
        ["\xF3\xB3\xB8\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xBA"],
        ["\xF3\xB3\xB8\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8F"],
        ["\xF3\xB3\xB8\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x9F"],
        ["\xF3\xB3\xB8\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA3"],
        ["\xF3\xB3\xB8\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAA"],
        ["\xF3\xB3\xB8\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x8B"],
        ["\xF3\xB3\xB8\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x90"],
        ["\xF3\xB3\xB8\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x92"],
        ["\xF3\xB3\xB9\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB4"],
        ["\xF3\xB3\xB9\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB8\xB4"],
        ["\xF3\xB3\xB9\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xA2"],
        ["\xF3\xB3\xB9\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8D"],
        ["\xF3\xB3\xB9\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x86"],
        ["\xF3\xB3\xB9\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x87"],
        ["\xF3\xB3\xB9\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8A"],
        ["\xF3\xB3\xB9\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x81"],
        ["\xF3\xB3\xB9\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA0"],
        ["\xF3\xB3\xB9\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA4"],
        ["\xF3\xB3\xB9\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA7"],
        ["\xF3\xB3\xB9\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8B"],
        ["\xF3\xB3\xB9\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9E"],
        ["\xF3\xB4\x83\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x81"],
        ["\xF3\xB4\xAE\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x93"],
        ["\xF3\xB4\xAE\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA2"],
        ["\xF3\xB4\xAE\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x94"],
        ["\xF3\xB4\xAE\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x98"],
        ["\xF3\xB4\xAE\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x98"],
        ["\xF3\xB4\xAE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9E"],
        ["\xF3\xB4\xAE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xBE"],
        ["\xF3\xB4\xAE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA8"],
        ["\xF3\xB4\xAE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8B"],
        ["\xF3\xB4\xAE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB9"],
        ["\xF3\xB4\xAE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x80"],
        ["\xF3\xB4\xAE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x82"],
        ["\xF3\xB4\xAE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x87"],
        ["\xF3\xB4\xAE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9D"],
        ["\xF3\xB4\xAE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA3"],
        ["\xF3\xB4\xAE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB6"],
        ["\xF3\xB4\xAE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBD"],
        ["\xF3\xB4\xAE\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x80"],
        ["\xF3\xB4\xAE\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x94"],
        ["\xF3\xB4\xAE\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x98"],
        ["\xF3\xB4\xAE\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA4"],
        ["\xF3\xB4\xAE\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBD"],
        ["\xF3\xB4\xAE\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x89"],
        ["\xF3\xB4\xAE\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9C"],
        ["\xF3\xB4\xAE\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA7"],
        ["\xF3\xB4\xAE\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAF"],
        ["\xF3\xB4\xAE\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB5"],
        ["\xF3\xB4\xAE\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x89"],
        ["\xF3\xB4\xAE\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA1"],
        ["\xF3\xB4\xAE\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA9"],
        ["\xF3\xB4\xAE\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8D"],
        ["\xF3\xB4\xAE\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x94"],
        ["\xF3\xB4\xAE\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x98"],
        ["\xF3\xB4\xAE\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB3"],
        ["\xF3\xB4\xAE\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB5"],
        ["\xF3\xB4\xAE\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x87"],
        ["\xF3\xB4\xAE\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBD"],
        ["\xF3\xB4\xAE\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9D"],
        ["\xF3\xB4\xAE\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9E"],
        ["\xF3\xB4\xAE\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x8B"],
        ["\xF3\xB4\xAE\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x94"],
        ["\xF3\xB4\xAE\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9D"],
        ["\xF3\xB4\xAF\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB8"],
        ["\xF3\xB4\xAF\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9C"],
        ["\xF3\xB4\xAF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAB"],
        ["\xF3\xB4\xAF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBE"],
        ["\xF3\xB4\xAF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8D"],
        ["\xF3\xB4\xAF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xBF"],
        ["\xF3\xB4\xAF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBC"],
        ["\xF3\xB4\xAF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB9"],
        ["\xF3\xB4\xAF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x80"],
        ["\xF3\xB4\xAF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA2"],
        ["\xF3\xB4\xAF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBE"],
        ["\xF3\xB4\xAF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x83"],
        ["\xF3\xB4\xAF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x96"],
        ["\xF3\xB4\xAF\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9A"],
        ["\xF3\xB4\xAF\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAF"],
        ["\xF3\xB4\xAF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x85"],
        ["\xF3\xB4\xAF\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x84"],
        ["\xF3\xB4\xAF\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x96"],
        ["\xF3\xB4\xAF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBC"],
        ["\xF3\xB4\xAF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8A"],
        ["\xF3\xB4\xAF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x98"],
        ["\xF3\xB4\xAF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB9"],
        ["\xF3\xB4\xAF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x83"],
        ["\xF3\xB4\xAF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA5"],
        ["\xF3\xB4\xAF\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBC"],
        ["\xF3\xB4\xAF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA5"],
        ["\xF3\xB4\xAF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAD"],
        ["\xF3\xB4\xAF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x90"],
        ["\xF3\xB4\xAF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x94"],
        ["\xF3\xB4\xAF\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA2"],
        ["\xF3\xB4\xAF\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB9"],
        ["\xF3\xB4\xAF\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x91"],
        ["\xF3\xB4\xAF\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAD"],
        ["\xF3\xB4\xAF\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBE"],
        ["\xF3\xB4\xAF\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBF"],
        ["\xF3\xB4\xAF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x84"],
        ["\xF3\xB4\xAF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8A"],
        ["\xF3\xB4\xAF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x90"],
        ["\xF3\xB4\xAF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB7"],
        ["\xF3\xB4\xAF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBB"],
        ["\xF3\xB4\xAF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA2"],
        ["\xF3\xB4\xAF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA9"],
        ["\xF3\xB4\xAF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x81"],
        ["\xF3\xB4\xAF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA7"],
        ["\xF3\xB4\xAF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9D"],
        ["\xF3\xB4\xAF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x82"],
        ["\xF3\xB4\xAF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBA"],
        ["\xF3\xB4\xAF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA2"],
        ["\xF3\xB4\xAF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAB"],
        ["\xF3\xB4\xAF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB0"],
        ["\xF3\xB4\xAF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB3"],
        ["\xF3\xB4\xAF\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x88"],
        ["\xF3\xB4\xB0\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8C"],
        ["\xF3\xB4\xB0\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\x84"],
        ["\xF3\xB4\xB0\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9A"],
        ["\xF3\xB4\xB0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA1"],
        ["\xF3\xB4\xB0\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB7"],
        ["\xF3\xB4\xB0\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB8"],
        ["\xF3\xB4\xB0\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8D"],
        ["\xF3\xB4\xB0\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x83"],
        ["\xF3\xB4\xB0\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBB"],
        ["\xF3\xB4\xB0\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x86"],
        ["\xF3\xB4\xB0\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x88"],
        ["\xF3\xB4\xB0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\xA2"],
        ["\xF3\xB4\xB0\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9B"],
        ["\xF3\xB4\xB0\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA8"],
        ["\xF3\xB4\xB0\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x93"],
        ["\xF3\xB4\xB0\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB3"],
        ["\xF3\xB4\xB0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x87"],
        ["\xF3\xB4\xB0\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x88"],
        ["\xF3\xB4\xB0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBB"],
        ["\xF3\xB4\xB0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x81"],
        ["\xF3\xB4\xB0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x93"],
        ["\xF3\xB4\xB0\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x98"],
        ["\xF3\xB4\xB0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9B"],
        ["\xF3\xB4\xB0\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB9"],
        ["\xF3\xB4\xB0\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x97"],
        ["\xF3\xB4\xB0\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBC"],
        ["\xF3\xB4\xB0\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9D"],
        ["\xF3\xB4\xB0\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAC"],
        ["\xF3\xB4\xB0\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB1"],
        ["\xF3\xB4\xB0\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9B"],
        ["\xF3\xB4\xB0\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB2"],
        ["\xF3\xB4\xB0\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB5"],
        ["\xF3\xB4\xB0\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x84"],
        ["\xF3\xB4\xB0\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA3"],
        ["\xF3\xB4\xB0\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA5"],
        ["\xF3\xB4\xB0\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB2"],
        ["\xF3\xB4\xB0\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x90"],
        ["\xF3\xB4\xB0\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA8"],
        ["\xF3\xB4\xB0\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAD"],
        ["\xF3\xB4\xB0\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB0"],
        ["\xF3\xB4\xB0\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB1"],
        ["\xF3\xB4\xB0\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBC"],
        ["\xF3\xB4\xB0\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8A"],
        ["\xF3\xB4\xB0\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x89"],
        ["\xF3\xB4\xB0\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x97\x84"],
        ["\xF3\xB4\xB0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB5"],
        ["\xF3\xB4\xB0\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x82"],
        ["\xF3\xB4\xB0\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x97"],
        ["\xF3\xB4\xB0\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA3"],
        ["\xF3\xB4\xB0\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA4"],
        ["\xF3\xB4\xB1\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x80"],
        ["\xF3\xB4\xB1\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA5"],
        ["\xF3\xB4\xB1\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAD"],
        ["\xF3\xB4\xB1\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8F"],
        ["\xF3\xB4\xB1\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\xB6"],
        ["\xF3\xB4\xB1\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF\x83"],
        ["\xF3\xB4\xB1\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA9"],
        ["\xF3\xB4\xB1\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAA"],
        ["\xF3\xB4\xB1\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB5"],
        ["\xF3\xB4\xB1\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB6"],
        ["\xF3\xB4\xB1\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8F"],
        ["\xF3\xB4\xB1\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x95"],
        ["\xF3\xB4\xB1\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9C\xBF"],
        ["\xF3\xB4\xB1\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBB"],
        ["\xF3\xB4\xB1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBE"],
        ["\xF3\xB4\xB1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x85"],
        ["\xF3\xB4\xB1\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x90"],
        ["\xF3\xB4\xB1\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x96"],
        ["\xF3\xB4\xB1\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9B"],
        ["\xF3\xB4\xB1\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9D\xA3"],
        ["\xF3\xB4\xB1\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x89"],
        ["\xF3\xB4\xB1\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x94"],
        ["\xF3\xB4\xB1\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9D"],
        ["\xF3\xB4\xB1\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9E"],
        ["\xF3\xB4\xB1\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA5"],
        ["\xF3\xB4\xB1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA7"],
        ["\xF3\xB4\xB1\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0\x8F"],
        ["\xF3\xB4\xB1\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\x9D"],
        ["\xF3\xB4\xB1\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9B"],
        ["\xF3\xB4\xB1\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9E"],
        ["\xF3\xB4\xB1\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xAC"],
        ["\xF3\xB4\xB1\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB5"],
        ["\xF3\xB4\xB1\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x86"],
        ["\xF3\xB4\xB1\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x96"],
        ["\xF3\xB4\xB1\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA0"],
        ["\xF3\xB4\xB1\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA5"],
        ["\xF3\xB4\xB1\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA7"],
        ["\xF3\xB4\xB1\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB7"],
        ["\xF3\xB4\xB1\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x82"],
        ["\xF3\xB4\xB1\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA9"],
        ["\xF3\xB4\xB1\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAD"],
        ["\xF3\xB4\xB1\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5\xB0"],
        ["\xF3\xB4\xB1\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8F"],
        ["\xF3\xB4\xB1\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x97"],
        ["\xF3\xB4\xB1\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xBF"],
        ["\xF3\xB4\xB1\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x85"],
        ["\xF3\xB4\xB1\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x90"],
        ["\xF3\xB4\xB1\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB3"],
        ["\xF3\xB4\xB1\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x99"],
        ["\xF3\xB4\xB1\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAA"],
        ["\xF3\xB4\xB1\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB4"],
        ["\xF3\xB4\xB1\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB6"],
        ["\xF3\xB4\xB1\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x85"],
        ["\xF3\xB4\xB1\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x98"],
        ["\xF3\xB4\xB1\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9C"],
        ["\xF3\xB4\xB1\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xBB"],
        ["\xF3\xB4\xB2\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x86"],
        ["\xF3\xB4\xB2\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x94"],
        ["\xF3\xB4\xB2\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA0"],
        ["\xF3\xB4\xB2\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAB"],
        ["\xF3\xB4\xB2\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAE"],
        ["\xF3\xB4\xB2\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB3\xBE"],
        ["\xF3\xB4\xB2\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8E"],
        ["\xF3\xB4\xB2\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAE"],
        ["\xF3\xB4\xB2\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB1"],
        ["\xF3\xB4\xB2\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB9"],
        ["\xF3\xB4\xB2\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBF"],
        ["\xF3\xB4\xB2\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x98"],
        ["\xF3\xB4\xB2\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA5"],
        ["\xF3\xB4\xB2\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x85"],
        ["\xF3\xB4\xB2\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x82"],
        ["\xF3\xB4\xB2\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x89"],
        ["\xF3\xB4\xB2\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x94"],
        ["\xF3\xB4\xB2\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAA"],
        ["\xF3\xB4\xB2\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBF"],
        ["\xF3\xB4\xB2\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x84"],
        ["\xF3\xB4\xB2\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x96"],
        ["\xF3\xB4\xB2\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9A"],
        ["\xF3\xB4\xB2\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9B"],
        ["\xF3\xB4\xB2\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9D"],
        ["\xF3\xB4\xB2\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x86"],
        ["\xF3\xB4\xB2\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB4"],
        ["\xF3\xB4\xB2\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x84"],
        ["\xF3\xB4\xB2\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9E"],
        ["\xF3\xB4\xB2\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAB"],
        ["\xF3\xB4\xB2\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB1"],
        ["\xF3\xB4\xB2\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x81"],
        ["\xF3\xB4\xB2\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x87"],
        ["\xF3\xB4\xB2\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8E"],
        ["\xF3\xB4\xB2\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x90"],
        ["\xF3\xB4\xB2\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x9A"],
        ["\xF3\xB4\xB2\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x87"],
        ["\xF3\xB4\xB2\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAA"],
        ["\xF3\xB4\xB2\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAF"],
        ["\xF3\xB4\xB2\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB3"],
        ["\xF3\xB4\xB2\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x91"],
        ["\xF3\xB4\xB2\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x99"],
        ["\xF3\xB4\xB2\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9E"],
        ["\xF3\xB4\xB2\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA1"],
        ["\xF3\xB4\xB2\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA2"],
        ["\xF3\xB4\xB2\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBE"],
        ["\xF3\xB4\xB2\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8C"],
        ["\xF3\xB4\xB2\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8D"],
        ["\xF3\xB4\xB2\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x94"],
        ["\xF3\xB4\xB2\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA0"],
        ["\xF3\xB4\xB2\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA7"],
        ["\xF3\xB4\xB2\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB6"],
        ["\xF3\xB4\xB2\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xBC"],
        ["\xF3\xB4\xB2\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x87"],
        ["\xF3\xB4\xB2\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x8A"],
        ["\xF3\xB4\xB2\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB9"],
        ["\xF3\xB4\xB2\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB0"],
        ["\xF3\xB4\xB3\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x86"],
        ["\xF3\xB4\xB3\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8A"],
        ["\xF3\xB4\xB3\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x9D"],
        ["\xF3\xB4\xB3\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x9E"],
        ["\xF3\xB4\xB3\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8E"],
        ["\xF3\xB4\xB3\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA4"],
        ["\xF3\xB4\xB3\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB5"],
        ["\xF3\xB4\xB3\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xA4"],
        ["\xF3\xB4\xB3\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB7"],
        ["\xF3\xB4\xB3\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x94"],
        ["\xF3\xB4\xB3\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x98"],
        ["\xF3\xB4\xB3\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xA4"],
        ["\xF3\xB4\xB3\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAB"],
        ["\xF3\xB4\xB3\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9E"],
        ["\xF3\xB4\xB3\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA0"],
        ["\xF3\xB4\xB3\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAE"],
        ["\xF3\xB4\xB3\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB0"],
        ["\xF3\xB4\xB3\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x91"],
        ["\xF3\xB4\xB3\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x88"],
        ["\xF3\xB4\xB3\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x92"],
        ["\xF3\xB4\xB3\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA0"],
        ["\xF3\xB4\xB3\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA8"],
        ["\xF3\xB4\xB3\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x85"],
        ["\xF3\xB4\xB3\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x87"],
        ["\xF3\xB4\xB3\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x92"],
        ["\xF3\xB4\xB3\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBA"],
        ["\xF3\xB4\xB3\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x84"],
        ["\xF3\xB4\xB3\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x80"],
        ["\xF3\xB4\xB3\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x95"],
        ["\xF3\xB4\xB3\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x95"],
        ["\xF3\xB4\xB3\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x96"],
        ["\xF3\xB4\xB3\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8\xBF"],
        ["\xF3\xB4\xB3\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x8D"],
        ["\xF3\xB4\xB3\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x9B"],
        ["\xF3\xB4\xB3\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x80"],
        ["\xF3\xB4\xB3\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBB"],
        ["\xF3\xB4\xB3\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x9F\xB1"],
        ["\xF3\xB4\xB3\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA7"],
        ["\xF3\xB4\xB3\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA8"],
        ["\xF3\xB4\xB3\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x90"],
        ["\xF3\xB4\xB3\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA6"],
        ["\xF3\xB4\xB3\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBC"],
        ["\xF3\xB4\xB3\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x95"],
        ["\xF3\xB4\xB3\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9F"],
        ["\xF3\xB4\xB3\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA0"],
        ["\xF3\xB4\xB3\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA2"],
        ["\xF3\xB4\xB3\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA6"],
        ["\xF3\xB4\xB3\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xAB"],
        ["\xF3\xB4\xB3\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8F"],
        ["\xF3\xB4\xB3\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x99"],
        ["\xF3\xB4\xB4\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA9"],
        ["\xF3\xB4\xB4\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x8A"],
        ["\xF3\xB4\xB4\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9A"],
        ["\xF3\xB4\xB4\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9B"],
        ["\xF3\xB4\xB4\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8A"],
        ["\xF3\xB4\xB4\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA8"],
        ["\xF3\xB4\xB4\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAB"],
        ["\xF3\xB4\xB4\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAC"],
        ["\xF3\xB4\xB4\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAF"],
        ["\xF3\xB4\xB4\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB0"],
        ["\xF3\xB4\xB4\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x84"],
        ["\xF3\xB4\xB4\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x86"],
        ["\xF3\xB4\xB4\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x87"],
        ["\xF3\xB4\xB4\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x8B"],
        ["\xF3\xB4\xB4\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x97"],
        ["\xF3\xB4\xB4\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAB"],
        ["\xF3\xB4\xB4\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAD"],
        ["\xF3\xB4\xB4\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x86"],
        ["\xF3\xB4\xB4\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x87"],
        ["\xF3\xB4\xB4\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x98"],
        ["\xF3\xB4\xB4\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9C"],
        ["\xF3\xB4\xB4\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA3"],
        ["\xF3\xB4\xB4\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x90"],
        ["\xF3\xB4\xB4\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA6"],
        ["\xF3\xB4\xB4\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA8"],
        ["\xF3\xB4\xB4\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA9"],
        ["\xF3\xB4\xB4\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB5"],
        ["\xF3\xB4\xB4\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBF"],
        ["\xF3\xB4\xB4\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x88"],
        ["\xF3\xB4\xB4\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x89"],
        ["\xF3\xB4\xB4\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9A"],
        ["\xF3\xB4\xB4\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xBF"],
        ["\xF3\xB4\xB4\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x97"],
        ["\xF3\xB4\xB4\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB9"],
        ["\xF3\xB4\xB4\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x92"],
        ["\xF3\xB4\xB4\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\xB2"],
        ["\xF3\xB4\xB4\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8E"],
        ["\xF3\xB4\xB4\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA4"],
        ["\xF3\xB4\xB4\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x80"],
        ["\xF3\xB4\xB4\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x82"],
        ["\xF3\xB4\xB4\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x88"],
        ["\xF3\xB4\xB4\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x95"],
        ["\xF3\xB4\xB4\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x96"],
        ["\xF3\xB4\xB4\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x99"],
        ["\xF3\xB4\xB4\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9E"],
        ["\xF3\xB4\xB4\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xAD"],
        ["\xF3\xB4\xB4\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB5"],
        ["\xF3\xB4\xB4\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x83"],
        ["\xF3\xB4\xB4\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8B"],
        ["\xF3\xB4\xB4\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA4"],
        ["\xF3\xB4\xB4\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA5"],
        ["\xF3\xB4\xB4\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAD"],
        ["\xF3\xB4\xB4\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAF"],
        ["\xF3\xB4\xB5\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB1"],
        ["\xF3\xB4\xB5\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x81"],
        ["\xF3\xB4\xB5\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9D"],
        ["\xF3\xB4\xB5\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAA"],
        ["\xF3\xB4\xB5\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB6"],
        ["\xF3\xB4\xB5\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x85"],
        ["\xF3\xB4\xB5\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8C"],
        ["\xF3\xB4\xB5\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8E"],
        ["\xF3\xB4\xB5\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x94"],
        ["\xF3\xB4\xB5\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA6"],
        ["\xF3\xB4\xB5\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB1"],
        ["\xF3\xB4\xB5\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBC"],
        ["\xF3\xB4\xB5\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8A"],
        ["\xF3\xB4\xB5\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x99"],
        ["\xF3\xB4\xB5\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB4"],
        ["\xF3\xB4\xB5\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB6"],
        ["\xF3\xB4\xB5\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x8D"],
        ["\xF3\xB4\xB5\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x8E"],
        ["\xF3\xB4\xB5\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9C"],
        ["\xF3\xB4\xB5\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9F"],
        ["\xF3\xB4\xB5\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA2"],
        ["\xF3\xB4\xB5\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBA"],
        ["\xF3\xB4\xB5\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x80"],
        ["\xF3\xB4\xB5\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x94"],
        ["\xF3\xB4\xB5\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAA"],
        ["\xF3\xB4\xB5\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA0"],
        ["\xF3\xB4\xB5\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xAD"],
        ["\xF3\xB4\xB5\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x92\x8E"],
        ["\xF3\xB4\xB5\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x83"],
        ["\xF3\xB4\xB5\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8F"],
        ["\xF3\xB4\xB5\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x91"],
        ["\xF3\xB4\xB5\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA8"],
        ["\xF3\xB4\xB5\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAE"],
        ["\xF3\xB4\xB5\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8B"],
        ["\xF3\xB4\xB5\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB0"],
        ["\xF3\xB4\xB5\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x94\x8E"],
        ["\xF3\xB4\xB5\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAD"],
        ["\xF3\xB4\xB5\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA4"],
        ["\xF3\xB4\xB5\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB2"],
        ["\xF3\xB4\xB5\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x80"],
        ["\xF3\xB4\xB5\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB7"],
        ["\xF3\xB4\xB5\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x9C"],
        ["\xF3\xB4\xB5\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAE"],
        ["\xF3\xB4\xB5\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB1"],
        ["\xF3\xB4\xB5\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB4"],
        ["\xF3\xB4\xB5\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8C"],
        ["\xF3\xB4\xB5\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8D"],
        ["\xF3\xB4\xB5\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x85"],
        ["\xF3\xB4\xB5\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x86"],
        ["\xF3\xB4\xB5\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8E"],
        ["\xF3\xB4\xB5\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x8F"],
        ["\xF3\xB4\xB5\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x90"],
        ["\xF3\xB4\xB5\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9C"],
        ["\xF3\xB4\xB5\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x91"],
        ["\xF3\xB4\xB5\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB9"],
        ["\xF3\xB4\xB5\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x92"],
        ["\xF3\xB4\xB5\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x93"],
        ["\xF3\xB4\xB6\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x98"],
        ["\xF3\xB4\xB6\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB1"],
        ["\xF3\xB4\xB6\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB8"],
        ["\xF3\xB4\xB6\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x88"],
        ["\xF3\xB4\xB6\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8A"],
        ["\xF3\xB4\xB6\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x9D\xB1"],
        ["\xF3\xB4\xB6\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x94"],
        ["\xF3\xB4\xB6\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9E"],
        ["\xF3\xB4\xB6\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAB"],
        ["\xF3\xB4\xB6\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAD"],
        ["\xF3\xB4\xB6\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x83"],
        ["\xF3\xB4\xB6\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x94"],
        ["\xF3\xB4\xB6\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB9"],
        ["\xF3\xB4\xB6\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9D"],
        ["\xF3\xB4\xB6\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAD"],
        ["\xF3\xB4\xB6\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x95"],
        ["\xF3\xB4\xB6\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x85"],
        ["\xF3\xB4\xB6\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA0"],
        ["\xF3\xB4\xB6\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xA7\x84"],
        ["\xF3\xB4\xB6\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB3"],
        ["\xF3\xB4\xB6\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBB"],
        ["\xF3\xB4\xB6\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8E"],
        ["\xF3\xB4\xB6\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBD"],
        ["\xF3\xB4\xB6\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x92"],
        ["\xF3\xB4\xB6\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAD"],
        ["\xF3\xB4\xB6\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xBB"],
        ["\xF3\xB4\xB6\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x87"],
        ["\xF3\xB4\xB6\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8E"],
        ["\xF3\xB4\xB6\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA0"],
        ["\xF3\xB4\xB6\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAD"],
        ["\xF3\xB4\xB6\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAF"],
        ["\xF3\xB4\xB6\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB2"],
        ["\xF3\xB4\xB6\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x96"],
        ["\xF3\xB4\xB6\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x97"],
        ["\xF3\xB4\xB6\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x99"],
        ["\xF3\xB4\xB6\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x81"],
        ["\xF3\xB4\xB6\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB1"],
        ["\xF3\xB4\xB6\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9E"],
        ["\xF3\xB4\xB6\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA0"],
        ["\xF3\xB4\xB6\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB3"],
        ["\xF3\xB4\xB6\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB6"],
        ["\xF3\xB4\xB6\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x89\xA4"],
        ["\xF3\xB4\xB6\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB6\xA1"],
        ["\xF3\xB4\xB6\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x99"],
        ["\xF3\xB4\xB6\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAD"],
        ["\xF3\xB4\xB6\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB9"],
        ["\xF3\xB4\xB6\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8F"],
        ["\xF3\xB4\xB6\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x94"],
        ["\xF3\xB4\xB6\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA0"],
        ["\xF3\xB4\xB6\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBC"],
        ["\xF3\xB4\xB6\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x95"],
        ["\xF3\xB4\xB6\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x99"],
        ["\xF3\xB4\xB6\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9D"],
        ["\xF3\xB4\xB6\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x87"],
        ["\xF3\xB4\xB6\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x88"],
        ["\xF3\xB4\xB6\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x93"],
        ["\xF3\xB4\xB6\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9D"],
        ["\xF3\xB4\xB6\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA3"],
        ["\xF3\xB4\xB6\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB1"],
        ["\xF3\xB4\xB6\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x81"],
        ["\xF3\xB4\xB7\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x93"],
        ["\xF3\xB4\xB7\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBA"],
        ["\xF3\xB4\xB7\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x83"],
        ["\xF3\xB4\xB7\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8B"],
        ["\xF3\xB4\xB7\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA6"],
        ["\xF3\xB4\xB7\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x82"],
        ["\xF3\xB4\xB7\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8C"],
        ["\xF3\xB4\xB7\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA3"],
        ["\xF3\xB4\xB7\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x97"],
        ["\xF3\xB4\xB7\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA8"],
        ["\xF3\xB4\xB7\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x88"],
        ["\xF3\xB4\xB7\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x91"],
        ["\xF3\xB4\xB7\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x95"],
        ["\xF3\xB4\xB7\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x99"],
        ["\xF3\xB4\xB7\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x87"],
        ["\xF3\xB4\xB7\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA1"],
        ["\xF3\xB4\xB7\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8D"],
        ["\xF3\xB4\xB7\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9A"],
        ["\xF3\xB4\xB7\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x91"],
        ["\xF3\xB4\xB7\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x97"],
        ["\xF3\xB4\xB7\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBF"],
        ["\xF3\xB4\xB7\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8E"],
        ["\xF3\xB4\xB7\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x9B"],
        ["\xF3\xB4\xB7\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x9F"],
        ["\xF3\xB4\xB7\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAC"],
        ["\xF3\xB4\xB7\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAE"],
        ["\xF3\xB4\xB7\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBA"],
        ["\xF3\xB4\xB7\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9B"],
        ["\xF3\xB4\xB7\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x94"],
        ["\xF3\xB4\xB7\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA6"],
        ["\xF3\xB4\xB7\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB5"],
        ["\xF3\xB4\xB7\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB7"],
        ["\xF3\xB4\xB7\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBC"],
        ["\xF3\xB4\xB7\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8A"],
        ["\xF3\xB4\xB7\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x97"],
        ["\xF3\xB4\xB7\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA0"],
        ["\xF3\xB4\xB7\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB3"],
        ["\xF3\xB4\xB7\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x98"],
        ["\xF3\xB4\xB7\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8A"],
        ["\xF3\xB4\xB7\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA0"],
        ["\xF3\xB4\xB7\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA7"],
        ["\xF3\xB4\xB7\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA8"],
        ["\xF3\xB4\xB7\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAD"],
        ["\xF3\xB4\xB7\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBB"],
        ["\xF3\xB4\xB7\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8A"],
        ["\xF3\xB4\xB7\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8F"],
        ["\xF3\xB4\xB7\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x97"],
        ["\xF3\xB4\xB7\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9C"],
        ["\xF3\xB4\xB7\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\x93"],
        ["\xF3\xB4\xB7\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\x9B"],
        ["\xF3\xB4\xB7\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA0"],
        ["\xF3\xB4\xB7\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB4"],
        ["\xF3\xB4\xB7\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xAB\xBF"],
        ["\xF3\xB4\xB7\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8E"],
        ["\xF3\xB4\xB7\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA1"],
        ["\xF3\xB4\xB7\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA3"],
        ["\xF3\xB4\xB7\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA4"],
        ["\xF3\xB4\xB7\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA9"],
        ["\xF3\xB4\xB8\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAE"],
        ["\xF3\xB4\xB8\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB7"],
        ["\xF3\xB4\xB8\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBE"],
        ["\xF3\xB4\xB8\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBF"],
        ["\xF3\xB4\xB8\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x86"],
        ["\xF3\xB4\xB8\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x95"],
        ["\xF3\xB4\xB8\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBD"],
        ["\xF3\xB4\xB8\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBE"],
        ["\xF3\xB4\xB8\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x80"],
        ["\xF3\xB4\xB8\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA2"],
        ["\xF3\xB4\xB8\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAD"],
        ["\xF3\xB4\xB8\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xBA"],
        ["\xF3\xB4\xB8\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x83"],
        ["\xF3\xB4\xB8\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x87"],
        ["\xF3\xB4\xB8\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x91"],
        ["\xF3\xB4\xB8\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x95"],
        ["\xF3\xB4\xB8\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBD"],
        ["\xF3\xB4\xB8\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x86"],
        ["\xF3\xB4\xB8\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x92"],
        ["\xF3\xB4\xB8\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x98"],
        ["\xF3\xB4\xB8\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA7"],
        ["\xF3\xB4\xB8\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA9"],
        ["\xF3\xB4\xB8\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBF"],
        ["\xF3\xB4\xB8\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x80"],
        ["\xF3\xB4\xB8\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8F"],
        ["\xF3\xB4\xB8\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x91"],
        ["\xF3\xB4\xB8\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA1"],
        ["\xF3\xB4\xB8\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAA"],
        ["\xF3\xB4\xB8\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x81"],
        ["\xF3\xB4\xB8\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x86"],
        ["\xF3\xB4\xB8\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8A"],
        ["\xF3\xB4\xB8\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9F"],
        ["\xF3\xB4\xB8\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9F"],
        ["\xF3\xB4\xB8\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB0"],
        ["\xF3\xB4\xB8\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB3"],
        ["\xF3\xB4\xB8\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x85"],
        ["\xF3\xB4\xB8\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9E"],
        ["\xF3\xB4\xB8\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAF"],
        ["\xF3\xB4\xB8\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBA"],
        ["\xF3\xB4\xB8\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x80"],
        ["\xF3\xB4\xB8\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x82"],
        ["\xF3\xB4\xB8\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB9\x80"],
        ["\xF3\xB4\xB8\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB2"],
        ["\xF3\xB4\xB8\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9E"],
        ["\xF3\xB4\xB8\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA3"],
        ["\xF3\xB4\xB8\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAF"],
        ["\xF3\xB4\xB8\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA4"],
        ["\xF3\xB4\xB8\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAD"],
        ["\xF3\xB4\xB8\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBA"],
        ["\xF3\xB4\xB8\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8C"],
        ["\xF3\xB4\xB8\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8F"],
        ["\xF3\xB4\xB8\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA2"],
        ["\xF3\xB4\xB8\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8B"],
        ["\xF3\xB4\xB8\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8E"],
        ["\xF3\xB4\xB8\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAD"],
        ["\xF3\xB4\xB8\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x92"],
        ["\xF3\xB4\xB9\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBF"],
        ["\xF3\xB4\xB9\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x84"],
        ["\xF3\xB4\xB9\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x85"],
        ["\xF3\xB4\xB9\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x90"],
        ["\xF3\xB4\xB9\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x83\xB4"],
        ["\xF3\xB4\xB9\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x98"],
        ["\xF3\xB4\xB9\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA9"],
        ["\xF3\xB4\xB9\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB8"],
        ["\xF3\xB4\xB9\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x97"],
        ["\xF3\xB4\xB9\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9B"],
        ["\xF3\xB4\xB9\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xB6"],
        ["\xF3\xB4\xB9\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA2"],
        ["\xF3\xB4\xB9\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x96\x9D"],
        ["\xF3\xB4\xB9\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAC"],
        ["\xF3\xB4\xB9\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB5"],
        ["\xF3\xB4\xB9\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x98"],
        ["\xF3\xB4\xB9\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB8"],
        ["\xF3\xB4\xB9\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBA"],
        ["\xF3\xB4\xB9\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBC"],
        ["\xF3\xB4\xB9\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBD"],
        ["\xF3\xB4\xB9\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8B"],
        ["\xF3\xB4\xB9\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB1"],
        ["\xF3\xB4\xB9\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x87"],
        ["\xF3\xB4\xB9\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x88"],
        ["\xF3\xB4\xB9\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAC"],
        ["\xF3\xB4\xB9\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAD"],
        ["\xF3\xB4\xB9\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB5"],
        ["\xF3\xB4\xB9\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x97\xAA"],
        ["\xF3\xB4\xB9\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x96"],
        ["\xF3\xB4\xB9\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAC"],
        ["\xF3\xB4\xB9\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x86"],
        ["\xF3\xB4\xB9\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8A"],
        ["\xF3\xB4\xB9\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x90"],
        ["\xF3\xB4\xB9\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x94"],
        ["\xF3\xB4\xB9\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x9F"],
        ["\xF3\xB4\xB9\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x98"],
        ["\xF3\xB4\xB9\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAA"],
        ["\xF3\xB4\xB9\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8A"],
        ["\xF3\xB4\xB9\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8E"],
        ["\xF3\xB4\xB9\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9A\x84"],
        ["\xF3\xB4\xB9\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA0"],
        ["\xF3\xB4\xB9\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x98"],
        ["\xF3\xB4\xB9\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x99"],
        ["\xF3\xB4\xB9\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9A"],
        ["\xF3\xB4\xB9\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA7"],
        ["\xF3\xB4\xB9\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB0"],
        ["\xF3\xB4\xB9\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB2"],
        ["\xF3\xB4\xB9\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB9"],
        ["\xF3\xB4\xB9\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x80"],
        ["\xF3\xB4\xB9\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x94"],
        ["\xF3\xB4\xB9\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA1"],
        ["\xF3\xB4\xB9\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x94"],
        ["\xF3\xB4\xB9\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA5"],
        ["\xF3\xB4\xB9\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB6"],
        ["\xF3\xB4\xB9\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x95"],
        ["\xF3\xB4\xB9\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA2"],
        ["\xF3\xB4\xB9\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x87"],
        ["\xF3\xB4\xB9\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8E"],
        ["\xF3\xB4\xB9\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9D"],
        ["\xF3\xB4\xB9\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA1"],
        ["\xF3\xB4\xBA\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB5"],
        ["\xF3\xB4\xBA\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x90"],
        ["\xF3\xB4\xBA\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB4"],
        ["\xF3\xB4\xBA\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA2"],
        ["\xF3\xB4\xBA\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA3"],
        ["\xF3\xB4\xBA\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x86"],
        ["\xF3\xB4\xBA\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x94"],
        ["\xF3\xB4\xBA\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x99"],
        ["\xF3\xB4\xBA\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA9"],
        ["\xF3\xB4\xBA\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9D"],
        ["\xF3\xB4\xBA\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x89"],
        ["\xF3\xB4\xBA\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA8"],
        ["\xF3\xB4\xBA\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA4"],
        ["\xF3\xB4\xBA\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA1"],
        ["\xF3\xB4\xBA\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB8"],
        ["\xF3\xB4\xBA\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBE"],
        ["\xF3\xB4\xBA\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA5"],
        ["\xF3\xB4\xBA\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x9B"],
        ["\xF3\xB4\xBA\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xAF"],
        ["\xF3\xB4\xBA\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8E"],
        ["\xF3\xB4\xBA\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x91"],
        ["\xF3\xB4\xBA\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x97"],
        ["\xF3\xB4\xBA\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA0"],
        ["\xF3\xB4\xBA\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA3"],
        ["\xF3\xB4\xBA\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xBD"],
        ["\xF3\xB4\xBA\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB0"],
        ["\xF3\xB4\xBA\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBB"],
        ["\xF3\xB4\xBA\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8\x89\xB7"],
        ["\xF3\xB4\xBA\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x80"],
        ["\xF3\xB4\xBA\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1\x84"],
        ["\xF3\xB4\xBA\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBA"],
        ["\xF3\xB4\xBA\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9E"],
        ["\xF3\xB4\xBA\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAD"],
        ["\xF3\xB4\xBA\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB6"],
        ["\xF3\xB4\xBA\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x94"],
        ["\xF3\xB4\xBA\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8\x8F\x8D"],
        ["\xF3\xB4\xBA\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA6"],
        ["\xF3\xB4\xBA\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB5"],
        ["\xF3\xB4\xBA\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA4"],
        ["\xF3\xB4\xBA\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA8"],
        ["\xF3\xB4\xBA\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAE"],
        ["\xF3\xB4\xBA\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x88"],
        ["\xF3\xB4\xBA\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAD"],
        ["\xF3\xB4\xBA\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA7"],
        ["\xF3\xB4\xBA\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x88"],
        ["\xF3\xB4\xBA\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x95"],
        ["\xF3\xB4\xBA\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x97"],
        ["\xF3\xB4\xBA\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x99"],
        ["\xF3\xB4\xBA\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x9B"],
        ["\xF3\xB4\xBA\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA2"],
        ["\xF3\xB4\xBA\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB3"],
        ["\xF3\xB4\xBA\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xBE"],
        ["\xF3\xB4\xBA\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x84"],
        ["\xF3\xB4\xBA\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x85"],
        ["\xF3\xB4\xBA\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x87"],
        ["\xF3\xB4\xBA\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x97"],
        ["\xF3\xB4\xBA\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9D"],
        ["\xF3\xB4\xBB\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAF"],
        ["\xF3\xB4\xBB\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB4"],
        ["\xF3\xB4\xBB\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x94"],
        ["\xF3\xB4\xBB\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x96"],
        ["\xF3\xB4\xBB\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA2"],
        ["\xF3\xB4\xBB\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA3"],
        ["\xF3\xB4\xBB\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAF"],
        ["\xF3\xB4\xBB\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB1"],
        ["\xF3\xB4\xBB\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB4"],
        ["\xF3\xB4\xBB\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xBD"],
        ["\xF3\xB4\xBB\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x88"],
        ["\xF3\xB4\xBB\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x9B"],
        ["\xF3\xB4\xBB\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x83"],
        ["\xF3\xB4\xBB\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9E"],
        ["\xF3\xB4\xBB\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAC"],
        ["\xF3\xB4\xBB\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB1"],
        ["\xF3\xB4\xBB\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBC"],
        ["\xF3\xB4\xBB\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBB"],
        ["\xF3\xB4\xBB\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB1"],
        ["\xF3\xB4\xBB\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x87"],
        ["\xF3\xB4\xBB\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB8"],
        ["\xF3\xB4\xBB\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x83"],
        ["\xF3\xB4\xBB\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8F"],
        ["\xF3\xB4\xBB\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x82"],
        ["\xF3\xB4\xBB\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8B"],
        ["\xF3\xB4\xBB\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8C"],
        ["\xF3\xB4\xBB\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x84"],
        ["\xF3\xB4\xBB\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9F"],
        ["\xF3\xB4\xBB\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x89"],
        ["\xF3\xB4\xBB\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8A"],
        ["\xF3\xB4\xBB\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA4"],
        ["\xF3\xB4\xBB\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA5"],
        ["\xF3\xB4\xBB\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAA"],
        ["\xF3\xB4\xBB\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9B"],
        ["\xF3\xB4\xBB\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA3"],
        ["\xF3\xB4\xBB\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xBA"],
        ["\xF3\xB4\xBB\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9F"],
        ["\xF3\xB4\xBB\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x84"],
        ["\xF3\xB4\xBB\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xBD"],
        ["\xF3\xB4\xBB\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB3"],
        ["\xF3\xB4\xBC\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x8A"],
        ["\xF3\xB4\xBC\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA3"],
        ["\xF3\xB4\xBC\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAB"],
        ["\xF3\xB4\xBC\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB1"],
        ["\xF3\xB4\xBC\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB2"],
        ["\xF3\xB4\xBC\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8E"],
        ["\xF3\xB4\xBC\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x9F"],
        ["\xF3\xB4\xBC\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA6"],
        ["\xF3\xB4\xBC\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA9"],
        ["\xF3\xB4\xBC\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAC"],
        ["\xF3\xB4\xBC\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB6"],
        ["\xF3\xB4\xBC\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBD"],
        ["\xF3\xB4\xBC\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8B"],
        ["\xF3\xB4\xBC\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x90"],
        ["\xF3\xB4\xBC\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x93"],
        ["\xF3\xB4\xBC\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6\xB0"],
        ["\xF3\xB4\xBC\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9A"],
        ["\xF3\xB4\xBC\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9E"],
        ["\xF3\xB4\xBC\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x98"],
        ["\xF3\xB4\xBC\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x84"],
        ["\xF3\xB4\xBC\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA4"],
        ["\xF3\xB4\xBC\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA5"],
        ["\xF3\xB4\xBC\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x92"],
        ["\xF3\xB4\xBC\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9E"],
        ["\xF3\xB4\xBC\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA8"],
        ["\xF3\xB4\xBC\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA9"],
        ["\xF3\xB4\xBC\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAF"],
        ["\xF3\xB4\xBC\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8E"],
        ["\xF3\xB4\xBC\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9A"],
        ["\xF3\xB4\xBC\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAE"],
        ["\xF3\xB4\xBC\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB3"],
        ["\xF3\xB4\xBC\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x95"],
        ["\xF3\xB4\xBC\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAE"],
        ["\xF3\xB4\xBC\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xBA"],
        ["\xF3\xB4\xBC\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x81"],
        ["\xF3\xB4\xBC\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x89"],
        ["\xF3\xB4\xBC\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9E"],
        ["\xF3\xB4\xBC\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9B"],
        ["\xF3\xB4\xBC\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB4"],
        ["\xF3\xB4\xBC\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xA9"],
        ["\xF3\xB4\xBC\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8A"],
        ["\xF3\xB4\xBC\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9E"],
        ["\xF3\xB4\xBC\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAB"],
        ["\xF3\xB4\xBC\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB0"],
        ["\xF3\xB4\xBC\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\xAA"],
        ["\xF3\xB4\xBC\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x92"],
        ["\xF3\xB4\xBC\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x93"],
        ["\xF3\xB4\xBC\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x96"],
        ["\xF3\xB4\xBC\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x99"],
        ["\xF3\xB4\xBC\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9A"],
        ["\xF3\xB4\xBC\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x90"],
        ["\xF3\xB4\xBC\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAC"],
        ["\xF3\xB4\xBC\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xBA"],
        ["\xF3\xB4\xBC\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x88"],
        ["\xF3\xB4\xBC\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA7"],
        ["\xF3\xB4\xBC\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x98"],
        ["\xF3\xB4\xBD\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x82"],
        ["\xF3\xB4\xBD\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x83"],
        ["\xF3\xB4\xBD\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA4"],
        ["\xF3\xB4\xBD\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAD"],
        ["\xF3\xB4\xBD\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAE"],
        ["\xF3\xB4\xBD\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB8"],
        ["\xF3\xB4\xBD\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8A"],
        ["\xF3\xB4\xBD\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x92"],
        ["\xF3\xB4\xBD\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB6"],
        ["\xF3\xB4\xBD\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x81"],
        ["\xF3\xB4\xBD\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x83"],
        ["\xF3\xB4\xBD\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8E"],
        ["\xF3\xB4\xBD\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x96"],
        ["\xF3\xB4\xBD\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB9"],
        ["\xF3\xB4\xBD\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x82"],
        ["\xF3\xB4\xBD\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x88"],
        ["\xF3\xB4\xBD\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA0"],
        ["\xF3\xB4\xBD\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0\x97"],
        ["\xF3\xB4\xBD\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAD"],
        ["\xF3\xB4\xBD\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9E"],
        ["\xF3\xB4\xBD\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB9"],
        ["\xF3\xB4\xBD\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA6"],
        ["\xF3\xB4\xBD\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x84"],
        ["\xF3\xB4\xBD\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8A"],
        ["\xF3\xB4\xBD\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9E"],
        ["\xF3\xB4\xBD\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA7"],
        ["\xF3\xB4\xBD\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x81"],
        ["\xF3\xB4\xBD\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8E"],
        ["\xF3\xB4\xBD\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA5"],
        ["\xF3\xB4\xBD\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB8"],
        ["\xF3\xB4\xBD\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xBD"],
        ["\xF3\xB4\xBD\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA3"],
        ["\xF3\xB4\xBD\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x81"],
        ["\xF3\xB4\xBD\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x8F"],
        ["\xF3\xB4\xBD\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x90"],
        ["\xF3\xB4\xBD\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x93"],
        ["\xF3\xB4\xBD\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA3"],
        ["\xF3\xB4\xBD\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA5"],
        ["\xF3\xB4\xBD\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB7"],
        ["\xF3\xB4\xBD\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9D"],
        ["\xF3\xB4\xBD\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9E"],
        ["\xF3\xB4\xBD\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x83"],
        ["\xF3\xB4\xBD\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x87"],
        ["\xF3\xB4\xBD\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x92"],
        ["\xF3\xB4\xBD\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA3"],
        ["\xF3\xB4\xBD\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBC"],
        ["\xF3\xB4\xBD\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8A"],
        ["\xF3\xB4\xBD\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x96"],
        ["\xF3\xB4\xBD\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x80"],
        ["\xF3\xB4\xBD\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAC"],
        ["\xF3\xB4\xBD\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBC"],
        ["\xF3\xB4\xBD\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x97"],
        ["\xF3\xB4\xBD\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x86\x90"],
        ["\xF3\xB4\xBD\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA7"],
        ["\xF3\xB4\xBD\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x87"],
        ["\xF3\xB4\xBD\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x95"],
        ["\xF3\xB4\xBD\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBC"],
        ["\xF3\xB4\xBE\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9E"],
        ["\xF3\xB4\xBE\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA4"],
        ["\xF3\xB4\xBE\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAC"],
        ["\xF3\xB4\xBE\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAF"],
        ["\xF3\xB4\xBE\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB4"],
        ["\xF3\xB4\xBE\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB5"],
        ["\xF3\xB4\xBE\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x83"],
        ["\xF3\xB4\xBE\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x90"],
        ["\xF3\xB4\xBE\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xB9"],
        ["\xF3\xB4\xBE\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x97"],
        ["\xF3\xB4\xBE\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x90"],
        ["\xF3\xB4\xBE\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x94"],
        ["\xF3\xB4\xBE\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x97"],
        ["\xF3\xB4\xBE\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA2"],
        ["\xF3\xB4\xBE\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB8"],
        ["\xF3\xB4\xBE\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9B"],
        ["\xF3\xB4\xBE\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB7"],
        ["\xF3\xB4\xBE\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA6"],
        ["\xF3\xB4\xBE\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAB"],
        ["\xF3\xB4\xBE\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x82\x89"],
        ["\xF3\xB4\xBE\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x82"],
        ["\xF3\xB4\xBE\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8F"],
        ["\xF3\xB4\xBE\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x92"],
        ["\xF3\xB4\xBE\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA9"],
        ["\xF3\xB4\xBE\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAB"],
        ["\xF3\xB4\xBE\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAE"],
        ["\xF3\xB4\xBE\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x80"],
        ["\xF3\xB4\xBE\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x87"],
        ["\xF3\xB4\xBE\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x88"],
        ["\xF3\xB4\xBE\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x82\xA2"],
        ["\xF3\xB4\xBE\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x91"],
        ["\xF3\xB4\xBE\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\x86"],
        ["\xF3\xB4\xBE\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x82\xA4"],
        ["\xF3\xB4\xBE\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9A"],
        ["\xF3\xB4\xBE\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA9"],
        ["\xF3\xB4\xBE\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9D"],
        ["\xF3\xB4\xBE\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\xAC"],
        ["\xF3\xB4\xBE\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x90\xAE"],
        ["\xF3\xB4\xBE\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB9"],
        ["\xF3\xB4\xBE\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBB"],
        ["\xF3\xB4\xBE\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x86\xA2"],
        ["\xF3\xB4\xBE\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBC"],
        ["\xF3\xB4\xBE\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x83"],
        ["\xF3\xB4\xBE\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x88"],
        ["\xF3\xB4\xBE\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x90"],
        ["\xF3\xB4\xBE\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAB"],
        ["\xF3\xB4\xBE\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9A"],
        ["\xF3\xB4\xBE\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB1"],
        ["\xF3\xB4\xBE\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB5"],
        ["\xF3\xB4\xBE\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x96"],
        ["\xF3\xB4\xBE\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA4"],
        ["\xF3\xB4\xBE\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB7"],
        ["\xF3\xB4\xBE\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBE"],
        ["\xF3\xB4\xBE\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x94"],
        ["\xF3\xB4\xBE\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x98"],
        ["\xF3\xB4\xBE\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x88\x93"],
        ["\xF3\xB4\xBE\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB7"],
        ["\xF3\xB4\xBE\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB8"],
        ["\xF3\xB4\xBE\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBA"],
        ["\xF3\xB4\xBE\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBD"],
        ["\xF3\xB4\xBE\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x82"],
        ["\xF3\xB4\xBE\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x85"],
        ["\xF3\xB4\xBF\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA6"],
        ["\xF3\xB4\xBF\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB2"],
        ["\xF3\xB4\xBF\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBE"],
        ["\xF3\xB4\xBF\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x85"],
        ["\xF3\xB4\xBF\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8B"],
        ["\xF3\xB4\xBF\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8F"],
        ["\xF3\xB4\xBF\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x92"],
        ["\xF3\xB4\xBF\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x91\xAA"],
        ["\xF3\xB4\xBF\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB2"],
        ["\xF3\xB4\xBF\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x80"],
        ["\xF3\xB4\xBF\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x90"],
        ["\xF3\xB4\xBF\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x93"],
        ["\xF3\xB4\xBF\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9C"],
        ["\xF3\xB4\xBF\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x91\xA8"],
        ["\xF3\xB4\xBF\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8E"],
        ["\xF3\xB4\xBF\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x93"],
        ["\xF3\xB4\xBF\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x97"],
        ["\xF3\xB4\xBF\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA3"],
        ["\xF3\xB4\xBF\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA6"],
        ["\xF3\xB4\xBF\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAA"],
        ["\xF3\xB4\xBF\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xA3"],
        ["\xF3\xB4\xBF\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x88"],
        ["\xF3\xB4\xBF\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x92"],
        ["\xF3\xB4\xBF\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x93"],
        ["\xF3\xB4\xBF\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x95"],
        ["\xF3\xB4\xBF\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x96"],
        ["\xF3\xB4\xBF\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9C"],
        ["\xF3\xB4\xBF\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAA"],
        ["\xF3\xB4\xBF\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8C\xAB"],
        ["\xF3\xB4\xBF\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB1"],
        ["\xF3\xB4\xBF\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBA"],
        ["\xF3\xB4\xBF\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBB"],
        ["\xF3\xB4\xBF\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x84"],
        ["\xF3\xB4\xBF\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x87"],
        ["\xF3\xB4\xBF\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB3"],
        ["\xF3\xB4\xBF\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8E\x81"],
        ["\xF3\xB4\xBF\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8E"],
        ["\xF3\xB4\xBF\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8D\xB1"],
        ["\xF3\xB4\xBF\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x94"],
        ["\xF3\xB4\xBF\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x99"],
        ["\xF3\xB4\xBF\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA1"],
        ["\xF3\xB4\xBF\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA9"],
        ["\xF3\xB4\xBF\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\x92"],
        ["\xF3\xB4\xBF\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x96"],
        ["\xF3\xB4\xBF\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAC"],
        ["\xF3\xB4\xBF\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xA1"],
        ["\xF3\xB4\xBF\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xA2"],
        ["\xF3\xB4\xBF\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8E"],
        ["\xF3\xB4\xBF\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x96"],
        ["\xF3\xB4\xBF\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xAC"],
        ["\xF3\xB4\xBF\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xAB"],
        ["\xF3\xB4\xBF\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB1"],
        ["\xF3\xB4\xBF\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBD"],
        ["\xF3\xB4\xBF\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D\xB5"],
        ["\xF3\xB4\xBF\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x83"],
        ["\xF3\xB4\xBF\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA9"],
        ["\xF3\xB5\x80\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB0"],
        ["\xF3\xB5\x80\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB1\x96"],
        ["\xF3\xB5\x80\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9F"],
        ["\xF3\xB5\x80\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA3"],
        ["\xF3\xB5\x80\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA7"],
        ["\xF3\xB5\x80\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA8"],
        ["\xF3\xB5\x80\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA9"],
        ["\xF3\xB5\x80\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB0"],
        ["\xF3\xB5\x80\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB4\xAD"],
        ["\xF3\xB5\x80\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB5\x85"],
        ["\xF3\xB5\x80\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xBC"],
        ["\xF3\xB5\x80\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB5\xB8"],
        ["\xF3\xB5\x80\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB5\xA2"],
        ["\xF3\xB5\x80\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x88"],
        ["\xF3\xB5\x80\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8A"],
        ["\xF3\xB5\x80\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\x81"],
        ["\xF3\xB5\x80\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\xA1"],
        ["\xF3\xB5\x80\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\x9C"],
        ["\xF3\xB5\x80\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA0"],
        ["\xF3\xB5\x80\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA2"],
        ["\xF3\xB5\x80\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA7"],
        ["\xF3\xB5\x80\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\x92"],
        ["\xF3\xB5\x80\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAD"],
        ["\xF3\xB5\x80\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB5"],
        ["\xF3\xB5\x80\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB6\xB7"],
        ["\xF3\xB5\x80\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x89"],
        ["\xF3\xB5\x80\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB7\xA0"],
        ["\xF3\xB5\x80\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xB8\xB3"],
        ["\xF3\xB5\x80\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x86"],
        ["\xF3\xB5\x80\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x90"],
        ["\xF3\xB5\x80\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xAB"],
        ["\xF3\xB5\x80\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9D"],
        ["\xF3\xB5\x80\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA0"],
        ["\xF3\xB5\x80\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA4"],
        ["\xF3\xB5\x80\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA6"],
        ["\xF3\xB5\x80\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xB1"],
        ["\xF3\xB5\x80\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xB9"],
        ["\xF3\xB5\x80\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xA8"],
        ["\xF3\xB5\x80\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA1"],
        ["\xF3\xB5\x80\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAA"],
        ["\xF3\xB5\x80\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xB4"],
        ["\xF3\xB5\x80\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB0"],
        ["\xF3\xB5\x80\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xBC\x9E"],
        ["\xF3\xB5\x80\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F\xBD"],
        ["\xF3\xB5\x80\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x88"],
        ["\xF3\xB5\x80\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\x80"],
        ["\xF3\xB5\x80\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x92"],
        ["\xF3\xB5\x80\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x94"],
        ["\xF3\xB5\x80\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x97"],
        ["\xF3\xB5\x80\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x99"],
        ["\xF3\xB5\x80\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB0"],
        ["\xF3\xB5\x80\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB2"],
        ["\xF3\xB5\x80\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB4"],
        ["\xF3\xB5\x80\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xBD\xB6"],
        ["\xF3\xB5\x80\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x91"],
        ["\xF3\xB5\x80\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x97"],
        ["\xF3\xB5\x80\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x98"],
        ["\xF3\xB5\x80\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA0"],
        ["\xF3\xB5\x80\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xBF\xBA"],
        ["\xF3\xB5\x80\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA4"],
        ["\xF3\xB5\x80\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA9"],
        ["\xF3\xB5\x81\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\xAF"],
        ["\xF3\xB5\x81\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x80"],
        ["\xF3\xB5\x81\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0\xB6"],
        ["\xF3\xB5\x81\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x92"],
        ["\xF3\xB5\x81\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x95"],
        ["\xF3\xB5\x81\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1\x80"],
        ["\xF3\xB5\x81\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9F"],
        ["\xF3\xB5\x81\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAE"],
        ["\xF3\xB5\x81\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBE"],
        ["\xF3\xB5\x81\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x89"],
        ["\xF3\xB5\x81\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1\x9C"],
        ["\xF3\xB5\x81\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x96"],
        ["\xF3\xB5\x81\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1\xA1"],
        ["\xF3\xB5\x81\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAB"],
        ["\xF3\xB5\x81\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAC"],
        ["\xF3\xB5\x81\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAD"],
        ["\xF3\xB5\x81\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x88"],
        ["\xF3\xB5\x81\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x8F\xB9"],
        ["\xF3\xB5\x81\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x97"],
        ["\xF3\xB5\x81\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9B"],
        ["\xF3\xB5\x81\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x91\x8A"],
        ["\xF3\xB5\x81\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA0"],
        ["\xF3\xB5\x81\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x94\x89"],
        ["\xF3\xB5\x81\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB3"],
        ["\xF3\xB5\x81\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x83"],
        ["\xF3\xB5\x81\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8B"],
        ["\xF3\xB5\x81\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x92\xBC"],
        ["\xF3\xB5\x81\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x98"],
        ["\xF3\xB5\x81\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA3"],
        ["\xF3\xB5\x81\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAD"],
        ["\xF3\xB5\x81\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x87"],
        ["\xF3\xB5\x81\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBC"],
        ["\xF3\xB5\x81\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x97\x96"],
        ["\xF3\xB5\x81\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x98\xA8"],
        ["\xF3\xB5\x81\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB3"],
        ["\xF3\xB5\x81\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB4"],
        ["\xF3\xB5\x81\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x82"],
        ["\xF3\xB5\x81\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x92"],
        ["\xF3\xB5\x81\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x96"],
        ["\xF3\xB5\x81\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\x9D\x8F"],
        ["\xF3\xB5\x81\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x95"],
        ["\xF3\xB5\x81\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9C"],
        ["\xF3\xB5\x81\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAC"],
        ["\xF3\xB5\x81\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB7"],
        ["\xF3\xB5\x81\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x84"],
        ["\xF3\xB5\x81\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x82"],
        ["\xF3\xB5\x81\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA0\x87"],
        ["\xF3\xB5\x81\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x98"],
        ["\xF3\xB5\x81\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA0\xBA"],
        ["\xF3\xB5\x81\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA4"],
        ["\xF3\xB5\x81\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBA"],
        ["\xF3\xB5\x81\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBB"],
        ["\xF3\xB5\x81\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8A"],
        ["\xF3\xB5\x81\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x94\x9F"],
        ["\xF3\xB5\x81\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x91"],
        ["\xF3\xB5\x81\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA2\xB9"],
        ["\xF3\xB5\x81\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB7"],
        ["\xF3\xB5\x81\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8A"],
        ["\xF3\xB5\x81\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8B"],
        ["\xF3\xB5\x81\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB5"],
        ["\xF3\xB5\x81\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBE"],
        ["\xF3\xB5\x82\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x82"],
        ["\xF3\xB5\x82\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA5\xBC"],
        ["\xF3\xB5\x82\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xA6\x9D"],
        ["\xF3\xB5\x82\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA7"],
        ["\xF3\xB5\x82\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAC"],
        ["\xF3\xB5\x82\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBA"],
        ["\xF3\xB5\x82\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA4"],
        ["\xF3\xB5\x82\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB4"],
        ["\xF3\xB5\x82\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAB\x93"],
        ["\xF3\xB5\x82\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB7"],
        ["\xF3\xB5\x82\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x80"],
        ["\xF3\xB5\x82\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xAC\x9D"],
        ["\xF3\xB5\x82\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\x9D"],
        ["\xF3\xB5\x82\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\x9E"],
        ["\xF3\xB5\x82\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x95"],
        ["\xF3\xB5\x82\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9A"],
        ["\xF3\xB5\x82\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\xA3"],
        ["\xF3\xB5\x82\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB4"],
        ["\xF3\xB5\x82\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB5"],
        ["\xF3\xB5\x82\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x95"],
        ["\xF3\xB5\x82\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA4"],
        ["\xF3\xB5\x82\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA8"],
        ["\xF3\xB5\x82\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x95\xAE"],
        ["\xF3\xB5\x82\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x83"],
        ["\xF3\xB5\x82\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA2"],
        ["\xF3\xB5\x82\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA6"],
        ["\xF3\xB5\x82\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAC"],
        ["\xF3\xB5\x82\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8D"],
        ["\xF3\xB5\x82\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x95"],
        ["\xF3\xB5\x82\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA0"],
        ["\xF3\xB5\x82\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA6"],
        ["\xF3\xB5\x82\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAD"],
        ["\xF3\xB5\x82\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAE"],
        ["\xF3\xB5\x82\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB7"],
        ["\xF3\xB5\x82\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBA"],
        ["\xF3\xB5\x82\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBF"],
        ["\xF3\xB5\x82\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x83"],
        ["\xF3\xB5\x82\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB5\x85"],
        ["\xF3\xB5\x82\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAC"],
        ["\xF3\xB5\x82\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAF"],
        ["\xF3\xB5\x82\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB1"],
        ["\xF3\xB5\x82\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB3"],
        ["\xF3\xB5\x82\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x80"],
        ["\xF3\xB5\x82\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x81"],
        ["\xF3\xB5\x82\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x89"],
        ["\xF3\xB5\x82\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBC"],
        ["\xF3\xB5\x82\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x81"],
        ["\xF3\xB5\x82\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x96\xA6"],
        ["\xF3\xB5\x82\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x87"],
        ["\xF3\xB5\x82\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8A"],
        ["\xF3\xB5\x82\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x96\xA8"],
        ["\xF3\xB5\x82\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA0"],
        ["\xF3\xB5\x82\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA1"],
        ["\xF3\xB5\x82\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA4"],
        ["\xF3\xB5\x82\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB7\xA1"],
        ["\xF3\xB5\x82\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBD"],
        ["\xF3\xB5\x82\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x82"],
        ["\xF3\xB5\x82\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x88"],
        ["\xF3\xB5\x82\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x91"],
        ["\xF3\xB5\x82\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x97\x85"],
        ["\xF3\xB5\x82\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x92"],
        ["\xF3\xB5\x82\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xBA\x95"],
        ["\xF3\xB5\x82\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB9\xAD"],
        ["\xF3\xB5\x83\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xBF"],
        ["\xF3\xB5\x83\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x89"],
        ["\xF3\xB5\x83\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x8C"],
        ["\xF3\xB5\x83\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x91"],
        ["\xF3\xB5\x83\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9D"],
        ["\xF3\xB5\x83\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x97\x9A"],
        ["\xF3\xB5\x83\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA2"],
        ["\xF3\xB5\x83\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xB9\xA4"],
        ["\xF3\xB5\x83\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA9"],
        ["\xF3\xB5\x83\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA8"],
        ["\xF3\xB5\x83\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0\xBD\x9F"],
        ["\xF3\xB5\x83\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x87"],
        ["\xF3\xB5\x83\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x90"],
        ["\xF3\xB5\x83\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB0"],
        ["\xF3\xB5\x83\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB7"],
        ["\xF3\xB5\x83\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x97\xB4"],
        ["\xF3\xB5\x83\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBD"],
        ["\xF3\xB5\x83\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBF"],
        ["\xF3\xB5\x83\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x80"],
        ["\xF3\xB5\x83\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x87"],
        ["\xF3\xB5\x83\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9E"],
        ["\xF3\xB5\x83\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA0"],
        ["\xF3\xB5\x83\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAD"],
        ["\xF3\xB5\x83\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x98\x85"],
        ["\xF3\xB5\x83\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x88"],
        ["\xF3\xB5\x83\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8C"],
        ["\xF3\xB5\x83\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x95"],
        ["\xF3\xB5\x83\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9A"],
        ["\xF3\xB5\x83\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9D"],
        ["\xF3\xB5\x83\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA8"],
        ["\xF3\xB5\x83\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAD"],
        ["\xF3\xB5\x83\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB2"],
        ["\xF3\xB5\x83\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x85"],
        ["\xF3\xB5\x83\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8D"],
        ["\xF3\xB5\x83\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9F"],
        ["\xF3\xB5\x83\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA8"],
        ["\xF3\xB5\x83\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB6"],
        ["\xF3\xB5\x83\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB7"],
        ["\xF3\xB5\x83\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x88\x81"],
        ["\xF3\xB5\x83\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x95"],
        ["\xF3\xB5\x83\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA3"],
        ["\xF3\xB5\x83\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\x95"],
        ["\xF3\xB5\x83\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA9"],
        ["\xF3\xB5\x83\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\xBB"],
        ["\xF3\xB5\x83\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x85"],
        ["\xF3\xB5\x83\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x86"],
        ["\xF3\xB5\x83\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8C"],
        ["\xF3\xB5\x83\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8D"],
        ["\xF3\xB5\x83\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x89\xB4"],
        ["\xF3\xB5\x83\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA8"],
        ["\xF3\xB5\x83\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAF"],
        ["\xF3\xB5\x83\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB3"],
        ["\xF3\xB5\x83\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB4"],
        ["\xF3\xB5\x83\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xB5"],
        ["\xF3\xB5\x83\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBB"],
        ["\xF3\xB5\x83\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8B\xA4"],
        ["\xF3\xB5\x83\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8B\x97"],
        ["\xF3\xB5\x83\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9A"],
        ["\xF3\xB5\x83\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9D"],
        ["\xF3\xB5\x83\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9E"],
        ["\xF3\xB5\x83\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA8"],
        ["\xF3\xB5\x83\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x97"],
        ["\xF3\xB5\x83\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8B\xBD"],
        ["\xF3\xB5\x84\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8C"],
        ["\xF3\xB5\x84\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8C\xB6"],
        ["\xF3\xB5\x84\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8D\x84"],
        ["\xF3\xB5\x84\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9E"],
        ["\xF3\xB5\x84\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA6"],
        ["\xF3\xB5\x84\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB0"],
        ["\xF3\xB5\x84\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x99\x8A"],
        ["\xF3\xB5\x84\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB8"],
        ["\xF3\xB5\x84\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBB"],
        ["\xF3\xB5\x84\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBD"],
        ["\xF3\xB5\x84\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x84"],
        ["\xF3\xB5\x84\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9E"],
        ["\xF3\xB5\x84\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA0"],
        ["\xF3\xB5\x84\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA7"],
        ["\xF3\xB5\x84\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB2"],
        ["\xF3\xB5\x84\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB9"],
        ["\xF3\xB5\x84\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x8F\x84"],
        ["\xF3\xB5\x84\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x89"],
        ["\xF3\xB5\x84\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8C"],
        ["\xF3\xB5\x84\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA7"],
        ["\xF3\xB5\x84\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8A"],
        ["\xF3\xB5\x84\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8B"],
        ["\xF3\xB5\x84\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8D"],
        ["\xF3\xB5\x84\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8F"],
        ["\xF3\xB5\x84\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x90"],
        ["\xF3\xB5\x84\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x94"],
        ["\xF3\xB5\x84\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9D"],
        ["\xF3\xB5\x84\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAA"],
        ["\xF3\xB5\x84\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB1"],
        ["\xF3\xB5\x84\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x91\xAD"],
        ["\xF3\xB5\x84\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x83"],
        ["\xF3\xB5\x84\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8D"],
        ["\xF3\xB5\x84\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA2"],
        ["\xF3\xB5\x84\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB3"],
        ["\xF3\xB5\x84\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB4"],
        ["\xF3\xB5\x84\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x85"],
        ["\xF3\xB5\x84\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x86"],
        ["\xF3\xB5\x84\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8D"],
        ["\xF3\xB5\x84\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x94"],
        ["\xF3\xB5\x84\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA4"],
        ["\xF3\xB5\x84\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x97\x97"],
        ["\xF3\xB5\x84\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A\x91"],
        ["\xF3\xB5\x84\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBD"],
        ["\xF3\xB5\x84\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A\x99"],
        ["\xF3\xB5\x84\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x86"],
        ["\xF3\xB5\x84\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A\x96"],
        ["\xF3\xB5\x84\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB0\xA9"],
        ["\xF3\xB5\x84\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9F"],
        ["\xF3\xB5\x84\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x99\x87"],
        ["\xF3\xB5\x84\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB5"],
        ["\xF3\xB5\x84\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB6"],
        ["\xF3\xB5\x84\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBC"],
        ["\xF3\xB5\x84\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9F"],
        ["\xF3\xB5\x84\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAE"],
        ["\xF3\xB5\x84\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBC"],
        ["\xF3\xB5\x84\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x88"],
        ["\xF3\xB5\x84\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8D"],
        ["\xF3\xB5\x84\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9E"],
        ["\xF3\xB5\x84\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA3"],
        ["\xF3\xB5\x84\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA4"],
        ["\xF3\xB5\x84\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA7"],
        ["\xF3\xB5\x84\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAE"],
        ["\xF3\xB5\x85\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x9C\x86"],
        ["\xF3\xB5\x85\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\x9D\x82"],
        ["\xF3\xB5\x85\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B\x8F"],
        ["\xF3\xB5\x85\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x8C"],
        ["\xF3\xB5\x85\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x8D"],
        ["\xF3\xB5\x85\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x97"],
        ["\xF3\xB5\x85\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA7"],
        ["\xF3\xB5\x85\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAD"],
        ["\xF3\xB5\x85\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x95"],
        ["\xF3\xB5\x85\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA5"],
        ["\xF3\xB5\x85\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBA"],
        ["\xF3\xB5\x85\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x8B"],
        ["\xF3\xB5\x85\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9C"],
        ["\xF3\xB5\x85\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9F"],
        ["\xF3\xB5\x85\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xA0"],
        ["\xF3\xB5\x85\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xA2"],
        ["\xF3\xB5\x85\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB1"],
        ["\xF3\xB5\x85\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB3"],
        ["\xF3\xB5\x85\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xB5"],
        ["\xF3\xB5\x85\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBA"],
        ["\xF3\xB5\x85\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBF"],
        ["\xF3\xB5\x85\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x9A"],
        ["\xF3\xB5\x85\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x9C"],
        ["\xF3\xB5\x85\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA0"],
        ["\xF3\xB5\x85\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA5"],
        ["\xF3\xB5\x85\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xB0"],
        ["\xF3\xB5\x85\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xAE"],
        ["\xF3\xB5\x85\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xB5"],
        ["\xF3\xB5\x85\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x80"],
        ["\xF3\xB5\x85\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x88"],
        ["\xF3\xB5\x85\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x97"],
        ["\xF3\xB5\x85\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB4"],
        ["\xF3\xB5\x85\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAD"],
        ["\xF3\xB5\x85\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x8C"],
        ["\xF3\xB5\x85\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x92"],
        ["\xF3\xB5\x85\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA8"],
        ["\xF3\xB5\x85\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAF"],
        ["\xF3\xB5\x85\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBC"],
        ["\xF3\xB5\x85\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBF"],
        ["\xF3\xB5\x85\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x81"],
        ["\xF3\xB5\x85\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x84"],
        ["\xF3\xB5\x85\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1\xA7\x83"],
        ["\xF3\xB5\x85\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xAE"],
        ["\xF3\xB5\x85\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x85\xBB"],
        ["\xF3\xB5\x85\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA5"],
        ["\xF3\xB5\x85\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAA"],
        ["\xF3\xB5\x85\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAC"],
        ["\xF3\xB5\x85\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB9"],
        ["\xF3\xB5\x85\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xBF"],
        ["\xF3\xB5\x85\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x86"],
        ["\xF3\xB5\x85\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x92"],
        ["\xF3\xB5\x85\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x99"],
        ["\xF3\xB5\x85\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x8C\x9E"],
        ["\xF3\xB5\x85\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBD"],
        ["\xF3\xB5\x85\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x88"],
        ["\xF3\xB5\x85\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8E"],
        ["\xF3\xB5\x85\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9C"],
        ["\xF3\xB5\x85\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x8E\xAD"],
        ["\xF3\xB5\x85\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9E"],
        ["\xF3\xB5\x85\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x87"],
        ["\xF3\xB5\x85\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA3"],
        ["\xF3\xB5\x85\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB2"],
        ["\xF3\xB5\x85\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBE"],
        ["\xF3\xB5\x85\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8F"],
        ["\xF3\xB5\x86\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA2"],
        ["\xF3\xB5\x86\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA4"],
        ["\xF3\xB5\x86\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB8"],
        ["\xF3\xB5\x86\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x84"],
        ["\xF3\xB5\x86\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3\xBA"],
        ["\xF3\xB5\x86\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x87"],
        ["\xF3\xB5\x86\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8B"],
        ["\xF3\xB5\x86\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x92"],
        ["\xF3\xB5\x86\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x93"],
        ["\xF3\xB5\x86\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x94"],
        ["\xF3\xB5\x86\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA2"],
        ["\xF3\xB5\x86\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAE"],
        ["\xF3\xB5\x86\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAF"],
        ["\xF3\xB5\x86\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB3"],
        ["\xF3\xB5\x86\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBC"],
        ["\xF3\xB5\x86\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4\x97"],
        ["\xF3\xB5\x86\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x97"],
        ["\xF3\xB5\x86\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA2"],
        ["\xF3\xB5\x86\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA4"],
        ["\xF3\xB5\x86\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4\x9A"],
        ["\xF3\xB5\x86\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8C"],
        ["\xF3\xB5\x86\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xBF"],
        ["\xF3\xB5\x86\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x95"],
        ["\xF3\xB5\x86\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA8"],
        ["\xF3\xB5\x86\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x9B\xB3"],
        ["\xF3\xB5\x86\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB0"],
        ["\xF3\xB5\x86\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB1"],
        ["\xF3\xB5\x86\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBE"],
        ["\xF3\xB5\x86\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x88"],
        ["\xF3\xB5\x86\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x99"],
        ["\xF3\xB5\x86\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9B"],
        ["\xF3\xB5\x86\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xAE"],
        ["\xF3\xB5\x86\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB5"],
        ["\xF3\xB5\x86\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x90"],
        ["\xF3\xB5\x86\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x92"],
        ["\xF3\xB5\x86\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x93"],
        ["\xF3\xB5\x86\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x99"],
        ["\xF3\xB5\x86\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9E"],
        ["\xF3\xB5\x86\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBA"],
        ["\xF3\xB5\x86\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5\xAF"],
        ["\xF3\xB5\x86\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x81"],
        ["\xF3\xB5\x86\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x86"],
        ["\xF3\xB5\x86\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA0"],
        ["\xF3\xB5\x86\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBC"],
        ["\xF3\xB5\x86\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xA1\x9B"],
        ["\xF3\xB5\x86\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x92"],
        ["\xF3\xB5\x86\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x93"],
        ["\xF3\xB5\x86\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x97"],
        ["\xF3\xB5\x86\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA5"],
        ["\xF3\xB5\x86\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA8"],
        ["\xF3\xB5\x86\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAD"],
        ["\xF3\xB5\x86\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xA2\xAB"],
        ["\xF3\xB5\x86\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x95"],
        ["\xF3\xB5\x86\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x9D"],
        ["\xF3\xB5\x86\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x9F"],
        ["\xF3\xB5\x86\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB5"],
        ["\xF3\xB5\x86\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xA6\x8F"],
        ["\xF3\xB5\x86\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x95"],
        ["\xF3\xB5\x86\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA3"],
        ["\xF3\xB5\x86\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA9"],
        ["\xF3\xB5\x86\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x86"],
        ["\xF3\xB5\x87\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8C"],
        ["\xF3\xB5\x87\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x91"],
        ["\xF3\xB5\x87\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x92"],
        ["\xF3\xB5\x87\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA1"],
        ["\xF3\xB5\x87\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA4"],
        ["\xF3\xB5\x87\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBB"],
        ["\xF3\xB5\x87\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAD"],
        ["\xF3\xB5\x87\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB3"],
        ["\xF3\xB5\x87\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x99"],
        ["\xF3\xB5\x87\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x95"],
        ["\xF3\xB5\x87\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAA\xB8"],
        ["\xF3\xB5\x87\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBD"],
        ["\xF3\xB5\x87\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x83"],
        ["\xF3\xB5\x87\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8D"],
        ["\xF3\xB5\x87\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x90"],
        ["\xF3\xB5\x87\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAD\x8F"],
        ["\xF3\xB5\x87\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAD\x90"],
        ["\xF3\xB5\x87\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB2"],
        ["\xF3\xB5\x87\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB5"],
        ["\xF3\xB5\x87\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBB"],
        ["\xF3\xB5\x87\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBC"],
        ["\xF3\xB5\x87\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x81"],
        ["\xF3\xB5\x87\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x84"],
        ["\xF3\xB5\x87\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8E"],
        ["\xF3\xB5\x87\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAD\x86"],
        ["\xF3\xB5\x87\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x99"],
        ["\xF3\xB5\x87\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xB0\x9D"],
        ["\xF3\xB5\x87\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xAE\xA6"],
        ["\xF3\xB5\x87\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAC"],
        ["\xF3\xB5\x87\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x84"],
        ["\xF3\xB5\x87\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x99"],
        ["\xF3\xB5\x87\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xB0\xA4"],
        ["\xF3\xB5\x87\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x94"],
        ["\xF3\xB5\x87\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBD"],
        ["\xF3\xB5\x87\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB7"],
        ["\xF3\xB5\x87\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x94"],
        ["\xF3\xB5\x87\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x95"],
        ["\xF3\xB5\x87\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9C"],
        ["\xF3\xB5\x87\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA0"],
        ["\xF3\xB5\x87\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAB"],
        ["\xF3\xB5\x87\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAC"],
        ["\xF3\xB5\x87\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB2"],
        ["\xF3\xB5\x87\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x89"],
        ["\xF3\xB5\x87\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9E"],
        ["\xF3\xB5\x87\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA5"],
        ["\xF3\xB5\x87\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA9"],
        ["\xF3\xB5\x87\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAF"],
        ["\xF3\xB5\x87\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x9A"],
        ["\xF3\xB5\x87\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x9B"],
        ["\xF3\xB5\x87\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x9D"],
        ["\xF3\xB5\x87\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB3"],
        ["\xF3\xB5\x87\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBD"],
        ["\xF3\xB5\x87\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x87"],
        ["\xF3\xB5\x87\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x91"],
        ["\xF3\xB5\x87\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9F"],
        ["\xF3\xB5\x87\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8B"],
        ["\xF3\xB5\x87\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8C"],
        ["\xF3\xB5\x87\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x95"],
        ["\xF3\xB5\x87\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x97"],
        ["\xF3\xB5\x87\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\xB7\xA1"],
        ["\xF3\xB5\x87\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA4"],
        ["\xF3\xB5\x87\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA5"],
        ["\xF3\xB5\x88\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBF"],
        ["\xF3\xB5\x88\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x84"],
        ["\xF3\xB5\x88\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9\xAE"],
        ["\xF3\xB5\x88\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x8F"],
        ["\xF3\xB5\x88\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x94"],
        ["\xF3\xB5\x88\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x96"],
        ["\xF3\xB5\x88\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9\xB3"],
        ["\xF3\xB5\x88\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9E"],
        ["\xF3\xB5\x88\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB2"],
        ["\xF3\xB5\x88\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x84"],
        ["\xF3\xB5\x88\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x94"],
        ["\xF3\xB5\x88\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAB"],
        ["\xF3\xB5\x88\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xBA"],
        ["\xF3\xB5\x88\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x81"],
        ["\xF3\xB5\x88\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x84"],
        ["\xF3\xB5\x88\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x85"],
        ["\xF3\xB5\x88\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8A"],
        ["\xF3\xB5\x88\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB2"],
        ["\xF3\xB5\x88\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB5"],
        ["\xF3\xB5\x88\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB8"],
        ["\xF3\xB5\x88\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBF"],
        ["\xF3\xB5\x88\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x82"],
        ["\xF3\xB5\x88\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x89"],
        ["\xF3\xB5\x88\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x94"],
        ["\xF3\xB5\x88\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\x96"],
        ["\xF3\xB5\x88\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB2"],
        ["\xF3\xB5\x88\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB9"],
        ["\xF3\xB5\x88\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBC"],
        ["\xF3\xB5\x88\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x84"],
        ["\xF3\xB5\x88\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x88"],
        ["\xF3\xB5\x88\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA1"],
        ["\xF3\xB5\x88\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAA"],
        ["\xF3\xB5\x88\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x85"],
        ["\xF3\xB5\x88\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x91"],
        ["\xF3\xB5\x88\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8E"],
        ["\xF3\xB5\x88\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\xAA"],
        ["\xF3\xB5\x88\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\x83"],
        ["\xF3\xB5\x88\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9B"],
        ["\xF3\xB5\x88\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA3"],
        ["\xF3\xB5\x88\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x87\xB5"],
        ["\xF3\xB5\x88\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x86\xB6"],
        ["\xF3\xB5\x88\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAA"],
        ["\xF3\xB5\x88\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAB"],
        ["\xF3\xB5\x88\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAC"],
        ["\xF3\xB5\x88\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAD"],
        ["\xF3\xB5\x88\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBB"],
        ["\xF3\xB5\x88\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x80"],
        ["\xF3\xB5\x88\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x90"],
        ["\xF3\xB5\x88\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x92"],
        ["\xF3\xB5\x88\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x8E"],
        ["\xF3\xB5\x88\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAD"],
        ["\xF3\xB5\x88\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB1"],
        ["\xF3\xB5\x88\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB5"],
        ["\xF3\xB5\x88\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x9A"],
        ["\xF3\xB5\x88\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC\x9C"],
        ["\xF3\xB5\x88\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xAC"],
        ["\xF3\xB5\x88\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB\x97"],
        ["\xF3\xB5\x88\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x81"],
        ["\xF3\xB5\x88\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x85"],
        ["\xF3\xB5\x88\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x92"],
        ["\xF3\xB5\x88\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8D\xB2"],
        ["\xF3\xB5\x89\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x99"],
        ["\xF3\xB5\x89\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x93"],
        ["\xF3\xB5\x89\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x92"],
        ["\xF3\xB5\x89\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8C"],
        ["\xF3\xB5\x89\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8D"],
        ["\xF3\xB5\x89\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x94"],
        ["\xF3\xB5\x89\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9D"],
        ["\xF3\xB5\x89\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x90"],
        ["\xF3\xB5\x89\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\xA4"],
        ["\xF3\xB5\x89\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x95"],
        ["\xF3\xB5\x89\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB4"],
        ["\xF3\xB5\x89\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB6"],
        ["\xF3\xB5\x89\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x9A"],
        ["\xF3\xB5\x89\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x92"],
        ["\xF3\xB5\x89\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x8F\x9F"],
        ["\xF3\xB5\x89\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xA3"],
        ["\xF3\xB5\x89\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x90"],
        ["\xF3\xB5\x89\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB0"],
        ["\xF3\xB5\x89\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB2"],
        ["\xF3\xB5\x89\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x83"],
        ["\xF3\xB5\x89\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x88"],
        ["\xF3\xB5\x89\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x92"],
        ["\xF3\xB5\x89\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x99"],
        ["\xF3\xB5\x89\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9B"],
        ["\xF3\xB5\x89\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB0"],
        ["\xF3\xB5\x89\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB7"],
        ["\xF3\xB5\x89\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\x8A"],
        ["\xF3\xB5\x89\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\x91"],
        ["\xF3\xB5\x89\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\x8B"],
        ["\xF3\xB5\x89\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x98"],
        ["\xF3\xB5\x89\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9F"],
        ["\xF3\xB5\x89\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAD"],
        ["\xF3\xB5\x89\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x91\xA5"],
        ["\xF3\xB5\x89\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB3"],
        ["\xF3\xB5\x89\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBB"],
        ["\xF3\xB5\x89\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBE"],
        ["\xF3\xB5\x89\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x85"],
        ["\xF3\xB5\x89\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x89"],
        ["\xF3\xB5\x89\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8C"],
        ["\xF3\xB5\x89\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x95"],
        ["\xF3\xB5\x89\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x97"],
        ["\xF3\xB5\x89\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD\xB7"],
        ["\xF3\xB5\x89\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xAB"],
        ["\xF3\xB5\x89\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xAE"],
        ["\xF3\xB5\x89\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBA"],
        ["\xF3\xB5\x89\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBC"],
        ["\xF3\xB5\x89\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x82"],
        ["\xF3\xB5\x89\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x90"],
        ["\xF3\xB5\x89\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x96"],
        ["\xF3\xB5\x89\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD\xAD"],
        ["\xF3\xB5\x89\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x98"],
        ["\xF3\xB5\x89\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x99"],
        ["\xF3\xB5\x89\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9A"],
        ["\xF3\xB5\x89\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9C"],
        ["\xF3\xB5\x89\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAA"],
        ["\xF3\xB5\x89\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAB"],
        ["\xF3\xB5\x89\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB4"],
        ["\xF3\xB5\x89\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBB"],
        ["\xF3\xB5\x89\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBB"],
        ["\xF3\xB5\x89\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x93\xA4"],
        ["\xF3\xB5\x89\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x95\x9A"],
        ["\xF3\xB5\x89\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x83"],
        ["\xF3\xB5\x8A\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x85"],
        ["\xF3\xB5\x8A\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8C"],
        ["\xF3\xB5\x8A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x96"],
        ["\xF3\xB5\x8A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x99"],
        ["\xF3\xB5\x8A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA4"],
        ["\xF3\xB5\x8A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA5"],
        ["\xF3\xB5\x8A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAC"],
        ["\xF3\xB5\x8A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB7"],
        ["\xF3\xB5\x8A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x83"],
        ["\xF3\xB5\x8A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x87"],
        ["\xF3\xB5\x8A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x87"],
        ["\xF3\xB5\x8A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x88"],
        ["\xF3\xB5\x8A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x96\x94"],
        ["\xF3\xB5\x8A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBB"],
        ["\xF3\xB5\x8A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\x8D"],
        ["\xF3\xB5\x8A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x86"],
        ["\xF3\xB5\x8A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA9"],
        ["\xF3\xB5\x8A\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAC"],
        ["\xF3\xB5\x8A\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB2"],
        ["\xF3\xB5\x8A\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBA"],
        ["\xF3\xB5\x8A\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBF"],
        ["\xF3\xB5\x8A\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x92"],
        ["\xF3\xB5\x8A\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE\xA4"],
        ["\xF3\xB5\x8A\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x96"],
        ["\xF3\xB5\x8A\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA6"],
        ["\xF3\xB5\x8A\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB0"],
        ["\xF3\xB5\x8A\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB7"],
        ["\xF3\xB5\x8A\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBA"],
        ["\xF3\xB5\x8A\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBC"],
        ["\xF3\xB5\x8A\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x80"],
        ["\xF3\xB5\x8A\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x91"],
        ["\xF3\xB5\x8A\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x96"],
        ["\xF3\xB5\x8A\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xB9"],
        ["\xF3\xB5\x8A\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x99\x87"],
        ["\xF3\xB5\x8A\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xB8"],
        ["\xF3\xB5\x8A\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x98\xBA"],
        ["\xF3\xB5\x8A\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA3"],
        ["\xF3\xB5\x8A\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAE"],
        ["\xF3\xB5\x8A\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAF"],
        ["\xF3\xB5\x8A\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB3"],
        ["\xF3\xB5\x8A\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF\x8D"],
        ["\xF3\xB5\x8A\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB4"],
        ["\xF3\xB5\x8A\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBE"],
        ["\xF3\xB5\x8A\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x91"],
        ["\xF3\xB5\x8A\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9A"],
        ["\xF3\xB5\x8A\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9D"],
        ["\xF3\xB5\x8A\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9C\x9C"],
        ["\xF3\xB5\x8A\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB2"],
        ["\xF3\xB5\x8A\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB3"],
        ["\xF3\xB5\x8A\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB4"],
        ["\xF3\xB5\x8A\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBF"],
        ["\xF3\xB5\x8A\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x89"],
        ["\xF3\xB5\x8A\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBA"],
        ["\xF3\xB5\x8A\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8E"],
        ["\xF3\xB5\x8A\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x92"],
        ["\xF3\xB5\x8A\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA4"],
        ["\xF3\xB5\x8A\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9C\x8C"],
        ["\xF3\xB5\x8A\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x83"],
        ["\xF3\xB5\x8A\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8B"],
        ["\xF3\xB5\x8B\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF\xB0"],
        ["\xF3\xB5\x8B\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x91"],
        ["\xF3\xB5\x8B\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9F"],
        ["\xF3\xB5\x8B\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA1"],
        ["\xF3\xB5\x8B\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9D\xA4"],
        ["\xF3\xB5\x8B\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAB"],
        ["\xF3\xB5\x8B\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBD"],
        ["\xF3\xB5\x8B\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x86"],
        ["\xF3\xB5\x8B\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x94"],
        ["\xF3\xB5\x8B\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x90"],
        ["\xF3\xB5\x8B\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9C"],
        ["\xF3\xB5\x8B\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9D"],
        ["\xF3\xB5\x8B\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9F\xBF"],
        ["\xF3\xB5\x8B\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\x9F\xA7"],
        ["\xF3\xB5\x8B\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAC"],
        ["\xF3\xB5\x8B\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB1"],
        ["\xF3\xB5\x8B\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB2"],
        ["\xF3\xB5\x8B\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB3"],
        ["\xF3\xB5\x8B\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBD"],
        ["\xF3\xB5\x8B\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xA0\xA4"],
        ["\xF3\xB5\x8B\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8B"],
        ["\xF3\xB5\x8B\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8F"],
        ["\xF3\xB5\x8B\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x90"],
        ["\xF3\xB5\x8B\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x91"],
        ["\xF3\xB5\x8B\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xA0\xBD"],
        ["\xF3\xB5\x8B\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x97"],
        ["\xF3\xB5\x8B\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0\xA6"],
        ["\xF3\xB5\x8B\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xAF"],
        ["\xF3\xB5\x8B\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8A"],
        ["\xF3\xB5\x8B\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x98"],
        ["\xF3\xB5\x8B\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAC"],
        ["\xF3\xB5\x8B\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB5"],
        ["\xF3\xB5\x8B\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBA"],
        ["\xF3\xB5\x8B\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x81"],
        ["\xF3\xB5\x8B\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9B"],
        ["\xF3\xB5\x8B\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAE"],
        ["\xF3\xB5\x8B\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xAA\x98"],
        ["\xF3\xB5\x8B\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBD"],
        ["\xF3\xB5\x8B\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBE"],
        ["\xF3\xB5\x8B\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x87"],
        ["\xF3\xB5\x8B\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x88"],
        ["\xF3\xB5\x8B\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x89"],
        ["\xF3\xB5\x8B\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9A"],
        ["\xF3\xB5\x8B\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xA6"],
        ["\xF3\xB5\x8B\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xA7"],
        ["\xF3\xB5\x8B\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAE"],
        ["\xF3\xB5\x8B\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB1"],
        ["\xF3\xB5\x8B\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x82"],
        ["\xF3\xB5\x8B\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8A"],
        ["\xF3\xB5\x8B\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8E"],
        ["\xF3\xB5\x8B\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB5"],
        ["\xF3\xB5\x8B\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB6"],
        ["\xF3\xB5\x8B\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBA"],
        ["\xF3\xB5\x8B\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB1\xBF"],
        ["\xF3\xB5\x8B\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8D"],
        ["\xF3\xB5\x8B\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9B"],
        ["\xF3\xB5\x8B\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAD"],
        ["\xF3\xB5\x8B\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x84"],
        ["\xF3\xB5\x8B\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x89"],
        ["\xF3\xB5\x8B\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3\x83"],
        ["\xF3\xB5\x8B\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x94"],
        ["\xF3\xB5\x8B\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x95"],
        ["\xF3\xB5\x8B\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x97"],
        ["\xF3\xB5\x8C\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAD"],
        ["\xF3\xB5\x8C\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x82"],
        ["\xF3\xB5\x8C\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x90"],
        ["\xF3\xB5\x8C\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3\x92"],
        ["\xF3\xB5\x8C\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x96"],
        ["\xF3\xB5\x8C\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9C"],
        ["\xF3\xB5\x8C\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA9"],
        ["\xF3\xB5\x8C\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAC"],
        ["\xF3\xB5\x8C\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAD"],
        ["\xF3\xB5\x8C\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB4\x80"],
        ["\xF3\xB5\x8C\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x80"],
        ["\xF3\xB5\x8C\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8A"],
        ["\xF3\xB5\x8C\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA4"],
        ["\xF3\xB5\x8C\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA6"],
        ["\xF3\xB5\x8C\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA7"],
        ["\xF3\xB5\x8C\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA7"],
        ["\xF3\xB5\x8C\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAF"],
        ["\xF3\xB5\x8C\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBC"],
        ["\xF3\xB5\x8C\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9B"],
        ["\xF3\xB5\x8C\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9E"],
        ["\xF3\xB5\x8C\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA0"],
        ["\xF3\xB5\x8C\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB0"],
        ["\xF3\xB5\x8C\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x80"],
        ["\xF3\xB5\x8C\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x81"],
        ["\xF3\xB5\x8C\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8A"],
        ["\xF3\xB5\x8C\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8D"],
        ["\xF3\xB5\x8C\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x91"],
        ["\xF3\xB5\x8C\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x98"],
        ["\xF3\xB5\x8C\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB5\x80"],
        ["\xF3\xB5\x8C\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x97"],
        ["\xF3\xB5\x8C\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB7\xBA"],
        ["\xF3\xB5\x8C\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB7\xB9"],
        ["\xF3\xB5\x8C\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB7\x93"],
        ["\xF3\xB5\x8C\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAB"],
        ["\xF3\xB5\x8C\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAE"],
        ["\xF3\xB5\x8C\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB4"],
        ["\xF3\xB5\x8C\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x82"],
        ["\xF3\xB5\x8C\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB4"],
        ["\xF3\xB5\x8C\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x88"],
        ["\xF3\xB5\x8C\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8E"],
        ["\xF3\xB5\x8C\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x90"],
        ["\xF3\xB5\x8C\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9F"],
        ["\xF3\xB5\x8C\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA9"],
        ["\xF3\xB5\x8C\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB6"],
        ["\xF3\xB5\x8C\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB6"],
        ["\xF3\xB5\x8C\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9E"],
        ["\xF3\xB5\x8C\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA2"],
        ["\xF3\xB5\x8C\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4\x91"],
        ["\xF3\xB5\x8C\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB2"],
        ["\xF3\xB5\x8C\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x88"],
        ["\xF3\xB5\x8C\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x89"],
        ["\xF3\xB5\x8C\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8B"],
        ["\xF3\xB5\x8C\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8C"],
        ["\xF3\xB5\x8C\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8F"],
        ["\xF3\xB5\x8C\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x91"],
        ["\xF3\xB5\x8C\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x93"],
        ["\xF3\xB5\x8C\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x94"],
        ["\xF3\xB5\x8C\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x97"],
        ["\xF3\xB5\x8C\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA3"],
        ["\xF3\xB5\x8C\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4\x9E"],
        ["\xF3\xB5\x8D\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x93"],
        ["\xF3\xB5\x8D\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA7"],
        ["\xF3\xB5\x8D\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB4"],
        ["\xF3\xB5\x8D\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x83"],
        ["\xF3\xB5\x8D\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8A"],
        ["\xF3\xB5\x8D\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x99"],
        ["\xF3\xB5\x8D\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB5"],
        ["\xF3\xB5\x8D\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAB"],
        ["\xF3\xB5\x8D\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB9"],
        ["\xF3\xB5\x8D\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBB"],
        ["\xF3\xB5\x8D\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8A"],
        ["\xF3\xB5\x8D\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8C"],
        ["\xF3\xB5\x8D\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x98"],
        ["\xF3\xB5\x8D\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA5"],
        ["\xF3\xB5\x8D\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB6"],
        ["\xF3\xB5\x8D\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBC"],
        ["\xF3\xB5\x8D\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xBD\xBE"],
        ["\xF3\xB5\x8D\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x92"],
        ["\xF3\xB5\x8D\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x97"],
        ["\xF3\xB5\x8D\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9A"],
        ["\xF3\xB5\x8D\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA0"],
        ["\xF3\xB5\x8D\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA8"],
        ["\xF3\xB5\x8D\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x98"],
        ["\xF3\xB5\x8D\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBD"],
        ["\xF3\xB5\x8D\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x90"],
        ["\xF3\xB5\x8D\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x96"],
        ["\xF3\xB5\x8D\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xBE"],
        ["\xF3\xB5\x8D\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x9F"],
        ["\xF3\xB5\x8D\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA5"],
        ["\xF3\xB5\x8D\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAF"],
        ["\xF3\xB5\x8D\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5\xA4"],
        ["\xF3\xB5\x8D\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x88"],
        ["\xF3\xB5\x8D\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x89"],
        ["\xF3\xB5\x8D\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9A"],
        ["\xF3\xB5\x8D\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9E"],
        ["\xF3\xB5\x8D\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA9"],
        ["\xF3\xB5\x8D\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x82\x96"],
        ["\xF3\xB5\x8D\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBC"],
        ["\xF3\xB5\x8D\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x80"],
        ["\xF3\xB5\x8D\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8A"],
        ["\xF3\xB5\x8D\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA3"],
        ["\xF3\xB5\x8D\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x84\x83"],
        ["\xF3\xB5\x8D\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB9"],
        ["\xF3\xB5\x8D\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBA"],
        ["\xF3\xB5\x8D\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBC"],
        ["\xF3\xB5\x8D\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x83"],
        ["\xF3\xB5\x8D\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x87"],
        ["\xF3\xB5\x8D\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8B"],
        ["\xF3\xB5\x8D\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6\x9A"],
        ["\xF3\xB5\x8D\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x94"],
        ["\xF3\xB5\x8D\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA5"],
        ["\xF3\xB5\x8D\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA9"],
        ["\xF3\xB5\x8D\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAC"],
        ["\xF3\xB5\x8D\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAE"],
        ["\xF3\xB5\x8D\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB6"],
        ["\xF3\xB5\x8D\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBE"],
        ["\xF3\xB5\x8D\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x81"],
        ["\xF3\xB5\x8D\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x86"],
        ["\xF3\xB5\x8D\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x95"],
        ["\xF3\xB5\x8D\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x97"],
        ["\xF3\xB5\x8E\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x87\x86"],
        ["\xF3\xB5\x8E\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x9F"],
        ["\xF3\xB5\x8E\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB1"],
        ["\xF3\xB5\x8E\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x87\xBE"],
        ["\xF3\xB5\x8E\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xAC"],
        ["\xF3\xB5\x8E\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8A"],
        ["\xF3\xB5\x8E\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x91"],
        ["\xF3\xB5\x8E\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x93"],
        ["\xF3\xB5\x8E\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9C"],
        ["\xF3\xB5\x8E\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x83"],
        ["\xF3\xB5\x8E\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x86"],
        ["\xF3\xB5\x8E\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x87"],
        ["\xF3\xB5\x8E\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x88"],
        ["\xF3\xB5\x8E\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x8C"],
        ["\xF3\xB5\x8E\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7\x80"],
        ["\xF3\xB5\x8E\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAF"],
        ["\xF3\xB5\x8E\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB1"],
        ["\xF3\xB5\x8E\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x90"],
        ["\xF3\xB5\x8E\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8A"],
        ["\xF3\xB5\x8E\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x93"],
        ["\xF3\xB5\x8E\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x9E"],
        ["\xF3\xB5\x8E\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7\x94"],
        ["\xF3\xB5\x8E\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x96"],
        ["\xF3\xB5\x8E\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x80"],
        ["\xF3\xB5\x8E\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9B"],
        ["\xF3\xB5\x8E\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA0"],
        ["\xF3\xB5\x8E\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA2"],
        ["\xF3\xB5\x8E\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAE"],
        ["\xF3\xB5\x8E\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAF"],
        ["\xF3\xB5\x8E\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB3"],
        ["\xF3\xB5\x8E\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x8E\xBC"],
        ["\xF3\xB5\x8E\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8B"],
        ["\xF3\xB5\x8E\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x93"],
        ["\xF3\xB5\x8E\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x99"],
        ["\xF3\xB5\x8E\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9C"],
        ["\xF3\xB5\x8E\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x87"],
        ["\xF3\xB5\x8E\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8\x85"],
        ["\xF3\xB5\x8E\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x89"],
        ["\xF3\xB5\x8E\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAB"],
        ["\xF3\xB5\x8E\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB4"],
        ["\xF3\xB5\x8E\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB8"],
        ["\xF3\xB5\x8E\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB9"],
        ["\xF3\xB5\x8E\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAC"],
        ["\xF3\xB5\x8E\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x82"],
        ["\xF3\xB5\x8E\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x93"],
        ["\xF3\xB5\x8E\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x97"],
        ["\xF3\xB5\x8E\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA3"],
        ["\xF3\xB5\x8E\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x98\xA9"],
        ["\xF3\xB5\x8E\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xAE"],
        ["\xF3\xB5\x8E\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xAF"],
        ["\xF3\xB5\x8E\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB8"],
        ["\xF3\xB5\x8E\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBF"],
        ["\xF3\xB5\x8E\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x8E"],
        ["\xF3\xB5\x8E\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\x9A\xA5"],
        ["\xF3\xB5\x8E\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAD"],
        ["\xF3\xB5\x8E\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAE"],
        ["\xF3\xB5\x8E\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB0"],
        ["\xF3\xB5\x8E\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x81"],
        ["\xF3\xB5\x8E\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9\xA0"],
        ["\xF3\xB5\x8E\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8C"],
        ["\xF3\xB5\x8E\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9\xA6"],
        ["\xF3\xB5\x8E\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9\xA8"],
        ["\xF3\xB5\x8F\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB3"],
        ["\xF3\xB5\x8F\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBA"],
        ["\xF3\xB5\x8F\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x87"],
        ["\xF3\xB5\x8F\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x92"],
        ["\xF3\xB5\x8F\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x98"],
        ["\xF3\xB5\x8F\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x99"],
        ["\xF3\xB5\x8F\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA\x83"],
        ["\xF3\xB5\x8F\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB9"],
        ["\xF3\xB5\x8F\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAC"],
        ["\xF3\xB5\x8F\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB1"],
        ["\xF3\xB5\x8F\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB3"],
        ["\xF3\xB5\x8F\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBD"],
        ["\xF3\xB5\x8F\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x92"],
        ["\xF3\xB5\x8F\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA\x94"],
        ["\xF3\xB5\x8F\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAB"],
        ["\xF3\xB5\x8F\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAC"],
        ["\xF3\xB5\x8F\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xA2\x96"],
        ["\xF3\xB5\x8F\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAE"],
        ["\xF3\xB5\x8F\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAF"],
        ["\xF3\xB5\x8F\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB1"],
        ["\xF3\xB5\x8F\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x81"],
        ["\xF3\xB5\x8F\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x85"],
        ["\xF3\xB5\x8F\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8A"],
        ["\xF3\xB5\x8F\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x94"],
        ["\xF3\xB5\x8F\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x98"],
        ["\xF3\xB5\x8F\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9C"],
        ["\xF3\xB5\x8F\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9E"],
        ["\xF3\xB5\x8F\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA5"],
        ["\xF3\xB5\x8F\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA8"],
        ["\xF3\xB5\x8F\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB5"],
        ["\xF3\xB5\x8F\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB7"],
        ["\xF3\xB5\x8F\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB9"],
        ["\xF3\xB5\x8F\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBC"],
        ["\xF3\xB5\x8F\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBF"],
        ["\xF3\xB5\x8F\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x85"],
        ["\xF3\xB5\x8F\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8B"],
        ["\xF3\xB5\x8F\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA1"],
        ["\xF3\xB5\x8F\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA7"],
        ["\xF3\xB5\x8F\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB9"],
        ["\xF3\xB5\x8F\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x93"],
        ["\xF3\xB5\x8F\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBA"],
        ["\xF3\xB5\x8F\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x81"],
        ["\xF3\xB5\x8F\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA4"],
        ["\xF3\xB5\x8F\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB1"],
        ["\xF3\xB5\x8F\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB9"],
        ["\xF3\xB5\x8F\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x93"],
        ["\xF3\xB5\x8F\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x80"],
        ["\xF3\xB5\x8F\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x83"],
        ["\xF3\xB5\x8F\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x8D"],
        ["\xF3\xB5\x8F\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x92"],
        ["\xF3\xB5\x8F\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9D"],
        ["\xF3\xB5\x8F\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB1"],
        ["\xF3\xB5\x8F\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x81"],
        ["\xF3\xB5\x8F\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x85"],
        ["\xF3\xB5\x8F\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x88"],
        ["\xF3\xB5\x8F\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xA9\x8D"],
        ["\xF3\xB5\x8F\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x92"],
        ["\xF3\xB5\x8F\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x97"],
        ["\xF3\xB5\x8F\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x99"],
        ["\xF3\xB5\x8F\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA0"],
        ["\xF3\xB5\x8F\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA1"],
        ["\xF3\xB5\x8F\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA5"],
        ["\xF3\xB5\x8F\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xAA"],
        ["\xF3\xB5\x90\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xAB"],
        ["\xF3\xB5\x90\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB9"],
        ["\xF3\xB5\x90\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBB"],
        ["\xF3\xB5\x90\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBA"],
        ["\xF3\xB5\x90\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x96"],
        ["\xF3\xB5\x90\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x98"],
        ["\xF3\xB5\x90\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9E"],
        ["\xF3\xB5\x90\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAF"],
        ["\xF3\xB5\x90\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAB"],
        ["\xF3\xB5\x90\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xAD\x96"],
        ["\xF3\xB5\x90\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xBA"],
        ["\xF3\xB5\x90\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xAD\xAF"],
        ["\xF3\xB5\x90\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA0"],
        ["\xF3\xB5\x90\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA4"],
        ["\xF3\xB5\x90\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAA"],
        ["\xF3\xB5\x90\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\x97"],
        ["\xF3\xB5\x90\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB0\x96"],
        ["\xF3\xB5\x90\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBD"],
        ["\xF3\xB5\x90\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBE"],
        ["\xF3\xB5\x90\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x80"],
        ["\xF3\xB5\x90\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x88"],
        ["\xF3\xB5\x90\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8E"],
        ["\xF3\xB5\x90\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x90"],
        ["\xF3\xB5\x90\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x92"],
        ["\xF3\xB5\x90\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAC"],
        ["\xF3\xB5\x90\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB2"],
        ["\xF3\xB5\x90\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB1"],
        ["\xF3\xB5\x90\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBA"],
        ["\xF3\xB5\x90\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBD"],
        ["\xF3\xB5\x90\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBE"],
        ["\xF3\xB5\x90\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x81"],
        ["\xF3\xB5\x90\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB4\x94"],
        ["\xF3\xB5\x90\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8C"],
        ["\xF3\xB5\x90\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\xB5"],
        ["\xF3\xB5\x90\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA2"],
        ["\xF3\xB5\x90\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD\xB7"],
        ["\xF3\xB5\x90\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB0"],
        ["\xF3\xB5\x90\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB7"],
        ["\xF3\xB5\x90\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBF"],
        ["\xF3\xB5\x90\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x80"],
        ["\xF3\xB5\x90\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x86"],
        ["\xF3\xB5\x90\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8F"],
        ["\xF3\xB5\x90\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x93"],
        ["\xF3\xB5\x90\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9D"],
        ["\xF3\xB5\x90\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9F"],
        ["\xF3\xB5\x90\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA0"],
        ["\xF3\xB5\x90\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA7"],
        ["\xF3\xB5\x90\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xAC"],
        ["\xF3\xB5\x90\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xAE"],
        ["\xF3\xB5\x90\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB1"],
        ["\xF3\xB5\x90\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB9"],
        ["\xF3\xB5\x90\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x83"],
        ["\xF3\xB5\x90\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x98"],
        ["\xF3\xB5\x90\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x87"],
        ["\xF3\xB5\x90\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8F"],
        ["\xF3\xB5\x90\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE\xAE"],
        ["\xF3\xB5\x90\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB8\x8E"],
        ["\xF3\xB5\x90\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x93"],
        ["\xF3\xB5\x90\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9B"],
        ["\xF3\xB5\x90\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9C"],
        ["\xF3\xB5\x90\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB8\xB7"],
        ["\xF3\xB5\x90\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA5"],
        ["\xF3\xB5\x90\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA8"],
        ["\xF3\xB5\x90\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBC"],
        ["\xF3\xB5\x91\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB3"],
        ["\xF3\xB5\x91\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xB9\xAA"],
        ["\xF3\xB5\x91\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF\x89"],
        ["\xF3\xB5\x91\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x81"],
        ["\xF3\xB5\x91\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4\xBA\x8B"],
        ["\xF3\xB5\x91\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x89"],
        ["\xF3\xB5\x91\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x95"],
        ["\xF3\xB5\x91\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF\x97"],
        ["\xF3\xB5\x91\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAE"],
        ["\xF3\xB5\x91\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x95"],
        ["\xF3\xB5\x91\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA1"],
        ["\xF3\xB5\x91\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA0"],
        ["\xF3\xB5\x91\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA7"],
        ["\xF3\xB5\x91\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA8"],
        ["\xF3\xB5\x91\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAF"],
        ["\xF3\xB5\x91\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x81\x8A"],
        ["\xF3\xB5\x91\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x89"],
        ["\xF3\xB5\x91\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x81\x95"],
        ["\xF3\xB5\x91\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA8"],
        ["\xF3\xB5\x91\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAC"],
        ["\xF3\xB5\x91\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x84\xA2"],
        ["\xF3\xB5\x91\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x97"],
        ["\xF3\xB5\x91\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9A"],
        ["\xF3\xB5\x91\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xAD"],
        ["\xF3\xB5\x91\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB5"],
        ["\xF3\xB5\x91\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x86\xA9"],
        ["\xF3\xB5\x91\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x80\xB9"],
        ["\xF3\xB5\x91\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x87\xA5"],
        ["\xF3\xB5\x91\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x87\x8D"],
        ["\xF3\xB5\x91\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x98"],
        ["\xF3\xB5\x91\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA0"],
        ["\xF3\xB5\x91\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAA"],
        ["\xF3\xB5\x91\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x88\x9E"],
        ["\xF3\xB5\x91\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB2"],
        ["\xF3\xB5\x91\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBC"],
        ["\xF3\xB5\x91\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBD"],
        ["\xF3\xB5\x91\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x89\x8C"],
        ["\xF3\xB5\x91\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x81\x98"],
        ["\xF3\xB5\x91\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9A"],
        ["\xF3\xB5\x91\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9F"],
        ["\xF3\xB5\x91\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA2"],
        ["\xF3\xB5\x91\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA4"],
        ["\xF3\xB5\x91\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA9"],
        ["\xF3\xB5\x91\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9E"],
        ["\xF3\xB5\x91\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9F"],
        ["\xF3\xB5\x91\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA4"],
        ["\xF3\xB5\x91\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA6"],
        ["\xF3\xB5\x91\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAA"],
        ["\xF3\xB5\x91\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAC"],
        ["\xF3\xB5\x91\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x82\x93"],
        ["\xF3\xB5\x91\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB0"],
        ["\xF3\xB5\x91\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB4"],
        ["\xF3\xB5\x91\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBB"],
        ["\xF3\xB5\x91\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x90\xAE"],
        ["\xF3\xB5\x91\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x85"],
        ["\xF3\xB5\x91\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x86"],
        ["\xF3\xB5\x91\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x89"],
        ["\xF3\xB5\x91\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8D"],
        ["\xF3\xB5\x91\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x99"],
        ["\xF3\xB5\x91\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xAC"],
        ["\xF3\xB5\x91\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x87"],
        ["\xF3\xB5\x92\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAA"],
        ["\xF3\xB5\x92\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x93\x99"],
        ["\xF3\xB5\x92\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8A"],
        ["\xF3\xB5\x92\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x94"],
        ["\xF3\xB5\x92\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA4"],
        ["\xF3\xB5\x92\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9D"],
        ["\xF3\xB5\x92\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9E"],
        ["\xF3\xB5\x92\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9F"],
        ["\xF3\xB5\x92\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBB"],
        ["\xF3\xB5\x92\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x88"],
        ["\xF3\xB5\x92\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8C"],
        ["\xF3\xB5\x92\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8E"],
        ["\xF3\xB5\x92\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x95"],
        ["\xF3\xB5\x92\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA0"],
        ["\xF3\xB5\x92\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA1"],
        ["\xF3\xB5\x92\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA6"],
        ["\xF3\xB5\x92\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB9"],
        ["\xF3\xB5\x92\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBA"],
        ["\xF3\xB5\x92\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBB"],
        ["\xF3\xB5\x92\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBE"],
        ["\xF3\xB5\x92\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x96\xA7"],
        ["\xF3\xB5\x92\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x90"],
        ["\xF3\xB5\x92\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x9B"],
        ["\xF3\xB5\x92\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA5"],
        ["\xF3\xB5\x92\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBB"],
        ["\xF3\xB5\x92\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x8A"],
        ["\xF3\xB5\x92\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x98"],
        ["\xF3\xB5\x92\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9B"],
        ["\xF3\xB5\x92\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x84\x85"],
        ["\xF3\xB5\x92\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA7"],
        ["\xF3\xB5\x92\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB2"],
        ["\xF3\xB5\x92\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x95"],
        ["\xF3\xB5\x92\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x96"],
        ["\xF3\xB5\x92\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA1"],
        ["\xF3\xB5\x92\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA9"],
        ["\xF3\xB5\x92\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB4"],
        ["\xF3\xB5\x92\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBB"],
        ["\xF3\xB5\x92\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x82"],
        ["\xF3\xB5\x92\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x87"],
        ["\xF3\xB5\x92\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8C"],
        ["\xF3\xB5\x92\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8D"],
        ["\xF3\xB5\x92\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x96"],
        ["\xF3\xB5\x92\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\x88"],
        ["\xF3\xB5\x92\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x9E\xA9"],
        ["\xF3\xB5\x92\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\x9E\xB4"],
        ["\xF3\xB5\x92\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\x8F"],
        ["\xF3\xB5\x92\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8A"],
        ["\xF3\xB5\x92\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x91"],
        ["\xF3\xB5\x92\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x95"],
        ["\xF3\xB5\x92\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9B"],
        ["\xF3\xB5\x92\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9E"],
        ["\xF3\xB5\x92\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x85\xA3"],
        ["\xF3\xB5\x92\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAD"],
        ["\xF3\xB5\x92\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB8"],
        ["\xF3\xB5\x92\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x87"],
        ["\xF3\xB5\x92\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8C"],
        ["\xF3\xB5\x92\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x96"],
        ["\xF3\xB5\x92\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x99"],
        ["\xF3\xB5\x92\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9C"],
        ["\xF3\xB5\x92\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9F"],
        ["\xF3\xB5\x92\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA0"],
        ["\xF3\xB5\x93\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA7"],
        ["\xF3\xB5\x93\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAA"],
        ["\xF3\xB5\x93\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB5"],
        ["\xF3\xB5\x93\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB8"],
        ["\xF3\xB5\x93\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x82"],
        ["\xF3\xB5\x93\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x8A"],
        ["\xF3\xB5\x93\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x90"],
        ["\xF3\xB5\x93\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA3"],
        ["\xF3\xB5\x93\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAC"],
        ["\xF3\xB5\x93\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xA7\x94"],
        ["\xF3\xB5\x93\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x86\xB4"],
        ["\xF3\xB5\x93\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB9"],
        ["\xF3\xB5\x93\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBC"],
        ["\xF3\xB5\x93\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBE"],
        ["\xF3\xB5\x93\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x86\xBF"],
        ["\xF3\xB5\x93\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8C"],
        ["\xF3\xB5\x93\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA8"],
        ["\xF3\xB5\x93\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB4"],
        ["\xF3\xB5\x93\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAB\xA4"],
        ["\xF3\xB5\x93\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAB\xA3"],
        ["\xF3\xB5\x93\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x87"],
        ["\xF3\xB5\x93\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAB\xB1"],
        ["\xF3\xB5\x93\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xBD"],
        ["\xF3\xB5\x93\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA7"],
        ["\xF3\xB5\x93\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAA"],
        ["\xF3\xB5\x93\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAE"],
        ["\xF3\xB5\x93\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAF"],
        ["\xF3\xB5\x93\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB1"],
        ["\xF3\xB5\x93\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x87\xA6"],
        ["\xF3\xB5\x93\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x87\xB3"],
        ["\xF3\xB5\x93\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBF"],
        ["\xF3\xB5\x93\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x81"],
        ["\xF3\xB5\x93\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x87\xAE"],
        ["\xF3\xB5\x93\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x95"],
        ["\xF3\xB5\x93\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB9"],
        ["\xF3\xB5\x93\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA4"],
        ["\xF3\xB5\x93\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA6"],
        ["\xF3\xB5\x93\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA9"],
        ["\xF3\xB5\x93\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB3"],
        ["\xF3\xB5\x93\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xAE\xB2"],
        ["\xF3\xB5\x93\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x88\x87"],
        ["\xF3\xB5\x93\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x90"],
        ["\xF3\xB5\x93\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x91"],
        ["\xF3\xB5\x93\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9B"],
        ["\xF3\xB5\x93\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x88\x8E"],
        ["\xF3\xB5\x93\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAF"],
        ["\xF3\xB5\x93\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB5"],
        ["\xF3\xB5\x93\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xBC"],
        ["\xF3\xB5\x93\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x85"],
        ["\xF3\xB5\x93\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8A"],
        ["\xF3\xB5\x93\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB1\x8B"],
        ["\xF3\xB5\x93\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB1\xA4"],
        ["\xF3\xB5\x93\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x94"],
        ["\xF3\xB5\x93\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x96"],
        ["\xF3\xB5\x93\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9A"],
        ["\xF3\xB5\x93\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAA"],
        ["\xF3\xB5\x93\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB0"],
        ["\xF3\xB5\x93\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x83"],
        ["\xF3\xB5\x93\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8B"],
        ["\xF3\xB5\x93\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8E"],
        ["\xF3\xB5\x93\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8F"],
        ["\xF3\xB5\x93\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA6"],
        ["\xF3\xB5\x94\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x85"],
        ["\xF3\xB5\x94\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8A"],
        ["\xF3\xB5\x94\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x91"],
        ["\xF3\xB5\x94\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x97"],
        ["\xF3\xB5\x94\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9E"],
        ["\xF3\xB5\x94\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA1"],
        ["\xF3\xB5\x94\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA9"],
        ["\xF3\xB5\x94\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAE"],
        ["\xF3\xB5\x94\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAF"],
        ["\xF3\xB5\x94\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB0"],
        ["\xF3\xB5\x94\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB8\xAE"],
        ["\xF3\xB5\x94\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB9\x96"],
        ["\xF3\xB5\x94\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB9\xA5"],
        ["\xF3\xB5\x94\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA6"],
        ["\xF3\xB5\x94\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xB9\xA2"],
        ["\xF3\xB5\x94\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB6"],
        ["\xF3\xB5\x94\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB7"],
        ["\xF3\xB5\x94\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBF"],
        ["\xF3\xB5\x94\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBB\x98"],
        ["\xF3\xB5\x94\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x84"],
        ["\xF3\xB5\x94\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBB\x82"],
        ["\xF3\xB5\x94\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x88"],
        ["\xF3\xB5\x94\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8D"],
        ["\xF3\xB5\x94\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBB\xA8"],
        ["\xF3\xB5\x94\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x97"],
        ["\xF3\xB5\x94\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBC\xA3"],
        ["\xF3\xB5\x94\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA6"],
        ["\xF3\xB5\x94\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAB"],
        ["\xF3\xB5\x94\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBD\x9C"],
        ["\xF3\xB5\x94\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB5"],
        ["\xF3\xB5\x94\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x83"],
        ["\xF3\xB5\x94\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x89"],
        ["\xF3\xB5\x94\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B\x86"],
        ["\xF3\xB5\x94\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x92"],
        ["\xF3\xB5\x94\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9E"],
        ["\xF3\xB5\x94\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBF\xA0"],
        ["\xF3\xB5\x94\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBF\x94"],
        ["\xF3\xB5\x94\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBD"],
        ["\xF3\xB5\x94\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBE"],
        ["\xF3\xB5\x94\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x80"],
        ["\xF3\xB5\x94\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x87"],
        ["\xF3\xB5\x94\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x80\x8C"],
        ["\xF3\xB5\x94\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5\xBF\xBB"],
        ["\xF3\xB5\x94\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B\x96"],
        ["\xF3\xB5\x94\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x99"],
        ["\xF3\xB5\x94\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9A"],
        ["\xF3\xB5\x94\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAA"],
        ["\xF3\xB5\x94\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB0"],
        ["\xF3\xB5\x94\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B\x9D"],
        ["\xF3\xB5\x94\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBF"],
        ["\xF3\xB5\x94\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x80\x97"],
        ["\xF3\xB5\x94\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x86"],
        ["\xF3\xB5\x94\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x88"],
        ["\xF3\xB5\x94\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8C"],
        ["\xF3\xB5\x94\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x97"],
        ["\xF3\xB5\x94\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x81\xA0"],
        ["\xF3\xB5\x94\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9D"],
        ["\xF3\xB5\x94\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA7"],
        ["\xF3\xB5\x94\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAA"],
        ["\xF3\xB5\x94\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB6"],
        ["\xF3\xB5\x94\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x80"],
        ["\xF3\xB5\x94\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x97"],
        ["\xF3\xB5\x94\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x99"],
        ["\xF3\xB5\x95\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA6"],
        ["\xF3\xB5\x95\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB1"],
        ["\xF3\xB5\x95\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB9"],
        ["\xF3\xB5\x95\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C\x82"],
        ["\xF3\xB5\x95\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x83\xAD"],
        ["\xF3\xB5\x95\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x98"],
        ["\xF3\xB5\x95\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x90"],
        ["\xF3\xB5\x95\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x97"],
        ["\xF3\xB5\x95\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9D"],
        ["\xF3\xB5\x95\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA0"],
        ["\xF3\xB5\x95\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA7"],
        ["\xF3\xB5\x95\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAC"],
        ["\xF3\xB5\x95\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x85"],
        ["\xF3\xB5\x95\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB3"],
        ["\xF3\xB5\x95\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB5"],
        ["\xF3\xB5\x95\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBE"],
        ["\xF3\xB5\x95\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x86"],
        ["\xF3\xB5\x95\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x87"],
        ["\xF3\xB5\x95\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C\xAB"],
        ["\xF3\xB5\x95\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x91"],
        ["\xF3\xB5\x95\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x98"],
        ["\xF3\xB5\x95\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9A"],
        ["\xF3\xB5\x95\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D\x83"],
        ["\xF3\xB5\x95\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBC"],
        ["\xF3\xB5\x95\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBB"],
        ["\xF3\xB5\x95\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBE"],
        ["\xF3\xB5\x95\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x83"],
        ["\xF3\xB5\x95\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x84"],
        ["\xF3\xB5\x95\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8F"],
        ["\xF3\xB5\x95\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x93\x81"],
        ["\xF3\xB5\x95\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x89\xB0"],
        ["\xF3\xB5\x95\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x92"],
        ["\xF3\xB5\x95\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x8A\x86"],
        ["\xF3\xB5\x95\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA1"],
        ["\xF3\xB5\x95\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA3"],
        ["\xF3\xB5\x95\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA4"],
        ["\xF3\xB5\x95\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAD"],
        ["\xF3\xB5\x95\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xBD"],
        ["\xF3\xB5\x95\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xBE"],
        ["\xF3\xB5\x95\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x8D\x8C"],
        ["\xF3\xB5\x95\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x90"],
        ["\xF3\xB5\x95\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBB"],
        ["\xF3\xB5\x95\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3\xB4\x8E"],
        ["\xF3\xB5\x95\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x96"],
        ["\xF3\xB5\x95\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9C"],
        ["\xF3\xB5\x95\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAD"],
        ["\xF3\xB5\x95\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x90\x82"],
        ["\xF3\xB5\x95\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x83"],
        ["\xF3\xB5\x95\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8F"],
        ["\xF3\xB5\x95\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA3"],
        ["\xF3\xB5\x95\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA5"],
        ["\xF3\xB5\x95\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAF"],
        ["\xF3\xB5\x95\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB2"],
        ["\xF3\xB5\x95\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x82"],
        ["\xF3\xB5\x95\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8A"],
        ["\xF3\xB5\x95\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x88"],
        ["\xF3\xB5\x95\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8E"],
        ["\xF3\xB5\x95\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x91"],
        ["\xF3\xB5\x95\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x96"],
        ["\xF3\xB5\x95\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA4"],
        ["\xF3\xB5\x95\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xAC"],
        ["\xF3\xB5\x95\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB0"],
        ["\xF3\xB5\x95\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x83"],
        ["\xF3\xB5\x95\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA6"],
        ["\xF3\xB5\x96\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB1"],
        ["\xF3\xB5\x96\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB5"],
        ["\xF3\xB5\x96\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBB"],
        ["\xF3\xB5\x96\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x99"],
        ["\xF3\xB5\x96\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9C"],
        ["\xF3\xB5\x96\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA4"],
        ["\xF3\xB5\x96\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA7"],
        ["\xF3\xB5\x96\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB8"],
        ["\xF3\xB5\x96\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x99\xBE"],
        ["\xF3\xB5\x96\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x85"],
        ["\xF3\xB5\x96\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x95"],
        ["\xF3\xB5\x96\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x98"],
        ["\xF3\xB5\x96\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA6"],
        ["\xF3\xB5\x96\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x9A\xB0"],
        ["\xF3\xB5\x96\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8D"],
        ["\xF3\xB5\x96\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB5"],
        ["\xF3\xB5\x96\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBB"],
        ["\xF3\xB5\x96\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F\xAE"],
        ["\xF3\xB5\x96\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB5"],
        ["\xF3\xB5\x96\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x96"],
        ["\xF3\xB5\x96\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9E"],
        ["\xF3\xB5\x96\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F\xB0"],
        ["\xF3\xB5\x96\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA4"],
        ["\xF3\xB5\x96\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA7"],
        ["\xF3\xB5\x96\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAC"],
        ["\xF3\xB5\x96\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\x9C\x9D"],
        ["\xF3\xB5\x96\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBD"],
        ["\xF3\xB5\x96\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\x88"],
        ["\xF3\xB5\x96\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA9"],
        ["\xF3\xB5\x96\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\x97"],
        ["\xF3\xB5\x96\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x81"],
        ["\xF3\xB5\x96\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\x9C"],
        ["\xF3\xB5\x96\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x84"],
        ["\xF3\xB5\x96\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x85"],
        ["\xF3\xB5\x96\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x90\xA2"],
        ["\xF3\xB5\x96\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x98"],
        ["\xF3\xB5\x96\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB2"],
        ["\xF3\xB5\x96\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x81"],
        ["\xF3\xB5\x96\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x83"],
        ["\xF3\xB5\x96\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x96"],
        ["\xF3\xB5\x96\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9B"],
        ["\xF3\xB5\x96\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA3\x9D"],
        ["\xF3\xB5\x96\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA4"],
        ["\xF3\xB5\x96\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA3\xAA"],
        ["\xF3\xB5\x96\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAC"],
        ["\xF3\xB5\x96\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA5\x91"],
        ["\xF3\xB5\x96\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBD"],
        ["\xF3\xB5\x96\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBF"],
        ["\xF3\xB5\x96\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA5\xAF"],
        ["\xF3\xB5\x96\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x84"],
        ["\xF3\xB5\x96\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA7\x9D"],
        ["\xF3\xB5\x96\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x99"],
        ["\xF3\xB5\x96\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA1"],
        ["\xF3\xB5\x96\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA2"],
        ["\xF3\xB5\x96\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA8\x9E"],
        ["\xF3\xB5\x96\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB2"],
        ["\xF3\xB5\x96\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB4"],
        ["\xF3\xB5\x96\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xBC"],
        ["\xF3\xB5\x96\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x86"],
        ["\xF3\xB5\x96\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x89"],
        ["\xF3\xB5\x96\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x85"],
        ["\xF3\xB5\x96\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xA9\x98"],
        ["\xF3\xB5\x96\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x8B"],
        ["\xF3\xB5\x96\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\xB6"],
        ["\xF3\xB5\x97\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x8F"],
        ["\xF3\xB5\x97\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x91\xBA"],
        ["\xF3\xB5\x97\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x97"],
        ["\xF3\xB5\x97\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xAA\x8C"],
        ["\xF3\xB5\x97\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9C"],
        ["\xF3\xB5\x97\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA3"],
        ["\xF3\xB5\x97\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xAA\xB7"],
        ["\xF3\xB5\x97\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9D"],
        ["\xF3\xB5\x97\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9\x9E"],
        ["\xF3\xB5\x97\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB9"],
        ["\xF3\xB5\x97\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\x91"],
        ["\xF3\xB5\x97\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBD"],
        ["\xF3\xB5\x97\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBF"],
        ["\xF3\xB5\x97\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x83"],
        ["\xF3\xB5\x97\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8A"],
        ["\xF3\xB5\x97\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x93"],
        ["\xF3\xB5\x97\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA7"],
        ["\xF3\xB5\x97\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA8"],
        ["\xF3\xB5\x97\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB2"],
        ["\xF3\xB5\x97\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB4"],
        ["\xF3\xB5\x97\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBA"],
        ["\xF3\xB5\x97\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBC"],
        ["\xF3\xB5\x97\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA2"],
        ["\xF3\xB5\x97\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA8"],
        ["\xF3\xB5\x97\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB7"],
        ["\xF3\xB5\x97\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x87"],
        ["\xF3\xB5\x97\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x88"],
        ["\xF3\xB5\x97\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8C"],
        ["\xF3\xB5\x97\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x94"],
        ["\xF3\xB5\x97\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9B"],
        ["\xF3\xB5\x97\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9D"],
        ["\xF3\xB5\x97\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB0"],
        ["\xF3\xB5\x97\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xBC"],
        ["\xF3\xB5\x97\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x84"],
        ["\xF3\xB5\x97\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x97"],
        ["\xF3\xB5\x97\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\xBE"],
        ["\xF3\xB5\x97\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x93\x94"],
        ["\xF3\xB5\x97\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x92\xB3"],
        ["\xF3\xB5\x97\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8D"],
        ["\xF3\xB5\x97\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x94"],
        ["\xF3\xB5\x97\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x95"],
        ["\xF3\xB5\x97\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9B"],
        ["\xF3\xB5\x97\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9D"],
        ["\xF3\xB5\x97\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x89"],
        ["\xF3\xB5\x97\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x90"],
        ["\xF3\xB5\x97\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x94"],
        ["\xF3\xB5\x97\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9D"],
        ["\xF3\xB5\x97\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA5"],
        ["\xF3\xB5\x97\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB9"],
        ["\xF3\xB5\x97\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8F"],
        ["\xF3\xB5\x97\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x91"],
        ["\xF3\xB5\x97\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x95"],
        ["\xF3\xB5\x97\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB1\xB3"],
        ["\xF3\xB5\x97\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x97"],
        ["\xF3\xB5\x97\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB9"],
        ["\xF3\xB5\x97\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8A"],
        ["\xF3\xB5\x97\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8F"],
        ["\xF3\xB5\x97\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x91"],
        ["\xF3\xB5\x97\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x92"],
        ["\xF3\xB5\x97\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x99"],
        ["\xF3\xB5\x97\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9A"],
        ["\xF3\xB5\x97\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9C"],
        ["\xF3\xB5\x97\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB3\x9D"],
        ["\xF3\xB5\x98\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA5"],
        ["\xF3\xB5\x98\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB6"],
        ["\xF3\xB5\x98\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB8"],
        ["\xF3\xB5\x98\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBC"],
        ["\xF3\xB5\x98\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x81"],
        ["\xF3\xB5\x98\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x94\x8D"],
        ["\xF3\xB5\x98\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x97"],
        ["\xF3\xB5\x98\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA6"],
        ["\xF3\xB5\x98\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBE"],
        ["\xF3\xB5\x98\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x94\x88"],
        ["\xF3\xB5\x98\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8E"],
        ["\xF3\xB5\x98\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8F"],
        ["\xF3\xB5\x98\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x93"],
        ["\xF3\xB5\x98\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xB9\xA5"],
        ["\xF3\xB5\x98\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xA7"],
        ["\xF3\xB5\x98\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAA"],
        ["\xF3\xB5\x98\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAF"],
        ["\xF3\xB5\x98\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB0"],
        ["\xF3\xB5\x98\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB1"],
        ["\xF3\xB5\x98\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBA"],
        ["\xF3\xB5\x98\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBD"],
        ["\xF3\xB5\x98\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x8C"],
        ["\xF3\xB5\x98\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9B"],
        ["\xF3\xB5\x98\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA4"],
        ["\xF3\xB5\x98\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA5"],
        ["\xF3\xB5\x98\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAB"],
        ["\xF3\xB5\x98\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB4"],
        ["\xF3\xB5\x98\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8F"],
        ["\xF3\xB5\x98\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAF"],
        ["\xF3\xB5\x98\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x94\xA5"],
        ["\xF3\xB5\x98\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x95\x83"],
        ["\xF3\xB5\x98\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBE"],
        ["\xF3\xB5\x98\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x91"],
        ["\xF3\xB5\x98\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9E"],
        ["\xF3\xB5\x98\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA1"],
        ["\xF3\xB5\x98\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA2"],
        ["\xF3\xB5\x98\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBE\x94"],
        ["\xF3\xB5\x98\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBB"],
        ["\xF3\xB5\x98\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBD"],
        ["\xF3\xB5\x98\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBF"],
        ["\xF3\xB5\x98\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x81"],
        ["\xF3\xB5\x98\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x86"],
        ["\xF3\xB5\x98\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x93"],
        ["\xF3\xB5\x98\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9D"],
        ["\xF3\xB5\x98\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9F"],
        ["\xF3\xB5\x98\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBF\xB8"],
        ["\xF3\xB5\x98\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBF\xB6"],
        ["\xF3\xB5\x98\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6\xBF\xB7"],
        ["\xF3\xB5\x98\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB7"],
        ["\xF3\xB5\x98\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBC"],
        ["\xF3\xB5\x98\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x87"],
        ["\xF3\xB5\x98\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8A"],
        ["\xF3\xB5\x98\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x98"],
        ["\xF3\xB5\x98\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x99"],
        ["\xF3\xB5\x98\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9F"],
        ["\xF3\xB5\x98\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA1"],
        ["\xF3\xB5\x98\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA6"],
        ["\xF3\xB5\x98\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB6"],
        ["\xF3\xB5\x98\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x80"],
        ["\xF3\xB5\x98\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x91"],
        ["\xF3\xB5\x98\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9E"],
        ["\xF3\xB5\x98\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA1"],
        ["\xF3\xB5\x99\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA4"],
        ["\xF3\xB5\x99\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA7"],
        ["\xF3\xB5\x99\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x84\x8D"],
        ["\xF3\xB5\x99\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB9"],
        ["\xF3\xB5\x99\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBC"],
        ["\xF3\xB5\x99\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x84\xB9"],
        ["\xF3\xB5\x99\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x80"],
        ["\xF3\xB5\x99\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x93"],
        ["\xF3\xB5\x99\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x96"],
        ["\xF3\xB5\x99\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAF"],
        ["\xF3\xB5\x99\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB7"],
        ["\xF3\xB5\x99\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBA"],
        ["\xF3\xB5\x99\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x87"],
        ["\xF3\xB5\x99\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x89"],
        ["\xF3\xB5\x99\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8D"],
        ["\xF3\xB5\x99\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x91"],
        ["\xF3\xB5\x99\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x9C"],
        ["\xF3\xB5\x99\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x9D"],
        ["\xF3\xB5\x99\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA8"],
        ["\xF3\xB5\x99\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB1"],
        ["\xF3\xB5\x99\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB3"],
        ["\xF3\xB5\x99\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x81"],
        ["\xF3\xB5\x99\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x83"],
        ["\xF3\xB5\x99\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x91"],
        ["\xF3\xB5\x99\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x95"],
        ["\xF3\xB5\x99\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x97"],
        ["\xF3\xB5\x99\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA3"],
        ["\xF3\xB5\x99\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA6"],
        ["\xF3\xB5\x99\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x96\xB8"],
        ["\xF3\xB5\x99\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x85"],
        ["\xF3\xB5\x99\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x87"],
        ["\xF3\xB5\x99\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8E"],
        ["\xF3\xB5\x99\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x90"],
        ["\xF3\xB5\x99\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x93"],
        ["\xF3\xB5\x99\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x99"],
        ["\xF3\xB5\x99\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9F"],
        ["\xF3\xB5\x99\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA1"],
        ["\xF3\xB5\x99\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA3"],
        ["\xF3\xB5\x99\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB1"],
        ["\xF3\xB5\x99\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBA"],
        ["\xF3\xB5\x99\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBE"],
        ["\xF3\xB5\x99\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x80"],
        ["\xF3\xB5\x99\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x83"],
        ["\xF3\xB5\x99\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x91"],
        ["\xF3\xB5\x99\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x98"],
        ["\xF3\xB5\x99\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA4"],
        ["\xF3\xB5\x99\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA5"],
        ["\xF3\xB5\x99\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB2"],
        ["\xF3\xB5\x99\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBC"],
        ["\xF3\xB5\x99\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x8F\x9B"],
        ["\xF3\xB5\x99\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x8F\x9A"],
        ["\xF3\xB5\x99\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA7"],
        ["\xF3\xB5\x99\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x89"],
        ["\xF3\xB5\x99\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8B"],
        ["\xF3\xB5\x99\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x93"],
        ["\xF3\xB5\x99\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA0"],
        ["\xF3\xB5\x99\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x8F\xBE"],
        ["\xF3\xB5\x99\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x97\xA5"],
        ["\xF3\xB5\x99\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBE"],
        ["\xF3\xB5\x99\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x90\x90"],
        ["\xF3\xB5\x99\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x81"],
        ["\xF3\xB5\x99\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8E"],
        ["\xF3\xB5\x9A\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB5"],
        ["\xF3\xB5\x9A\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x9F"],
        ["\xF3\xB5\x9A\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x91\x89"],
        ["\xF3\xB5\x9A\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA3"],
        ["\xF3\xB5\x9A\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA5"],
        ["\xF3\xB5\x9A\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA6"],
        ["\xF3\xB5\x9A\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAA"],
        ["\xF3\xB5\x9A\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAB"],
        ["\xF3\xB5\x9A\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAD"],
        ["\xF3\xB5\x9A\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x81"],
        ["\xF3\xB5\x9A\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x83"],
        ["\xF3\xB5\x9A\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8B"],
        ["\xF3\xB5\x9A\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x93"],
        ["\xF3\xB5\x9A\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA8"],
        ["\xF3\xB5\x9A\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xAE"],
        ["\xF3\xB5\x9A\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB2"],
        ["\xF3\xB5\x9A\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBC"],
        ["\xF3\xB5\x9A\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x98\x8F"],
        ["\xF3\xB5\x9A\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8A"],
        ["\xF3\xB5\x9A\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x98"],
        ["\xF3\xB5\x9A\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9F"],
        ["\xF3\xB5\x9A\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA4"],
        ["\xF3\xB5\x9A\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x98\x95"],
        ["\xF3\xB5\x9A\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x98\x94"],
        ["\xF3\xB5\x9A\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA9"],
        ["\xF3\xB5\x9A\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x98\xB1"],
        ["\xF3\xB5\x9A\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAF"],
        ["\xF3\xB5\x9A\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA0"],
        ["\xF3\xB5\x9A\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBC"],
        ["\xF3\xB5\x9A\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBD"],
        ["\xF3\xB5\x9A\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBE"],
        ["\xF3\xB5\x9A\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x80"],
        ["\xF3\xB5\x9A\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x92"],
        ["\xF3\xB5\x9A\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9A\x93"],
        ["\xF3\xB5\x9A\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x91"],
        ["\xF3\xB5\x9A\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x93"],
        ["\xF3\xB5\x9A\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9B"],
        ["\xF3\xB5\x9A\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB0"],
        ["\xF3\xB5\x9A\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB1"],
        ["\xF3\xB5\x9A\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x99\x81"],
        ["\xF3\xB5\x9A\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x81"],
        ["\xF3\xB5\x9A\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9C\x8E"],
        ["\xF3\xB5\x9A\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB7"],
        ["\xF3\xB5\x9A\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9C\xA3"],
        ["\xF3\xB5\x9A\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x82"],
        ["\xF3\xB5\x9A\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x85"],
        ["\xF3\xB5\x9A\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x89"],
        ["\xF3\xB5\x9A\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\x9D\x92"],
        ["\xF3\xB5\x9A\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x99\xA5"],
        ["\xF3\xB5\x9A\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA2"],
        ["\xF3\xB5\x9A\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x80"],
        ["\xF3\xB5\x9A\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x89"],
        ["\xF3\xB5\x9A\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x90"],
        ["\xF3\xB5\x9A\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9F"],
        ["\xF3\xB5\x9A\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB0"],
        ["\xF3\xB5\x9A\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB7"],
        ["\xF3\xB5\x9A\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x96"],
        ["\xF3\xB5\x9A\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x98"],
        ["\xF3\xB5\x9A\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xAB"],
        ["\xF3\xB5\x9A\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A\xA1"],
        ["\xF3\xB5\x9A\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB1"],
        ["\xF3\xB5\x9A\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB3"],
        ["\xF3\xB5\x9A\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xBD"],
        ["\xF3\xB5\x9A\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xBF"],
        ["\xF3\xB5\x9B\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A\xAF"],
        ["\xF3\xB5\x9B\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x91"],
        ["\xF3\xB5\x9B\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x94"],
        ["\xF3\xB5\x9B\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xA6\x85"],
        ["\xF3\xB5\x9B\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA1"],
        ["\xF3\xB5\x9B\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB5"],
        ["\xF3\xB5\x9B\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBE"],
        ["\xF3\xB5\x9B\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x85"],
        ["\xF3\xB5\x9B\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8D"],
        ["\xF3\xB5\x9B\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x98"],
        ["\xF3\xB5\x9B\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAE"],
        ["\xF3\xB5\x9B\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x90"],
        ["\xF3\xB5\x9B\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB7"],
        ["\xF3\xB5\x9B\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x97"],
        ["\xF3\xB5\x9B\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBC"],
        ["\xF3\xB5\x9B\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAA\x84"],
        ["\xF3\xB5\x9B\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8A"],
        ["\xF3\xB5\x9B\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x85"],
        ["\xF3\xB5\x9B\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8D"],
        ["\xF3\xB5\x9B\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9C"],
        ["\xF3\xB5\x9B\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9F"],
        ["\xF3\xB5\x9B\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAD"],
        ["\xF3\xB5\x9B\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x83"],
        ["\xF3\xB5\x9B\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C\x8C"],
        ["\xF3\xB5\x9B\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x91"],
        ["\xF3\xB5\x9B\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9E"],
        ["\xF3\xB5\x9B\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB6"],
        ["\xF3\xB5\x9B\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x81"],
        ["\xF3\xB5\x9B\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8B"],
        ["\xF3\xB5\x9B\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x94"],
        ["\xF3\xB5\x9B\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x95"],
        ["\xF3\xB5\x9B\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9C"],
        ["\xF3\xB5\x9B\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9E"],
        ["\xF3\xB5\x9B\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB9"],
        ["\xF3\xB5\x9B\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAE\xB3"],
        ["\xF3\xB5\x9B\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBD"],
        ["\xF3\xB5\x9B\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAE\xBE"],
        ["\xF3\xB5\x9B\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xAF\x87"],
        ["\xF3\xB5\x9B\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x85"],
        ["\xF3\xB5\x9B\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x87"],
        ["\xF3\xB5\x9B\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8F"],
        ["\xF3\xB5\x9B\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x94"],
        ["\xF3\xB5\x9B\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA4"],
        ["\xF3\xB5\x9B\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x96"],
        ["\xF3\xB5\x9B\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x95"],
        ["\xF3\xB5\x9B\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x99"],
        ["\xF3\xB5\x9B\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xB6\xA0"],
        ["\xF3\xB5\x9B\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB1"],
        ["\xF3\xB5\x9B\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xB8\x90"],
        ["\xF3\xB5\x9B\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x89"],
        ["\xF3\xB5\x9B\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8E"],
        ["\xF3\xB5\x9C\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAC"],
        ["\xF3\xB5\x9C\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x84"],
        ["\xF3\xB5\x9C\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x95"],
        ["\xF3\xB5\x9C\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA6"],
        ["\xF3\xB5\x9C\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7\xBE\xB7"],
        ["\xF3\xB5\x9C\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x86"],
        ["\xF3\xB5\x9C\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x88"],
        ["\xF3\xB5\x9C\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x99"],
        ["\xF3\xB5\x9C\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F\xBD"],
        ["\xF3\xB5\x9C\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBD"],
        ["\xF3\xB5\x9C\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA2"],
        ["\xF3\xB5\x9C\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0\x96"],
        ["\xF3\xB5\x9C\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1\x8E"],
        ["\xF3\xB5\x9C\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8D"],
        ["\xF3\xB5\x9D\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x83"],
        ["\xF3\xB5\x9D\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x84"],
        ["\xF3\xB5\x9D\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2\xB5"],
        ["\xF3\xB5\x9D\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAB"],
        ["\xF3\xB5\x9E\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x87"],
        ["\xF3\xB5\x9E\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA5"],
        ["\xF3\xB5\x9E\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x89"],
        ["\xF3\xB5\x9E\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x97"],
        ["\xF3\xB5\x9F\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8B"],
        ["\xF3\xB5\x9F\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xB1"],
        ["\xF3\xB5\x9F\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8D"],
        ["\xF3\xB5\x9F\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAC"],
        ["\xF3\xB5\x9F\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB3"],
        ["\xF3\xB5\x9F\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB4"],
        ["\xF3\xB5\x9F\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBC"],
        ["\xF3\xB5\x9F\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x82"],
        ["\xF3\xB5\x9F\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7\xA7"],
        ["\xF3\xB5\x9F\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7\xBA"],
        ["\xF3\xB5\x9F\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x98"],
        ["\xF3\xB5\x9F\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8\x84"],
        ["\xF3\xB5\x9F\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8\xA9"],
        ["\xF3\xB5\xA0\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x97"],
        ["\xF3\xB5\xA0\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAA"],
        ["\xF3\xB5\xA0\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8C"],
        ["\xF3\xB5\xA0\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8D"],
        ["\xF3\xB5\xA0\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x94"],
        ["\xF3\xB5\xA0\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x96"],
        ["\xF3\xB5\xA0\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA\xBC"],
        ["\xF3\xB5\xA0\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA3"],
        ["\xF3\xB5\xA0\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC\xBB"],
        ["\xF3\xB5\xA1\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9C"],
        ["\xF3\xB5\xA1\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\xA0"],
        ["\xF3\xB5\xA1\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA3"],
        ["\xF3\xB5\xA1\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB9"],
        ["\xF3\xB5\xA1\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBC"],
        ["\xF3\xB5\xA1\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x91"],
        ["\xF3\xB5\xA1\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x9A"],
        ["\xF3\xB5\xA1\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA0"],
        ["\xF3\xB5\xA1\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB1"],
        ["\xF3\xB5\xA1\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB6"],
        ["\xF3\xB5\xA1\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x84"],
        ["\xF3\xB5\xA1\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8C"],
        ["\xF3\xB5\xA1\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x98"],
        ["\xF3\xB5\xA1\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\x82"],
        ["\xF3\xB5\xA1\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAF"],
        ["\xF3\xB5\xA1\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\x8A"],
        ["\xF3\xB5\xA1\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB7"],
        ["\xF3\xB5\xA1\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\x92"],
        ["\xF3\xB5\xA1\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB9"],
        ["\xF3\xB5\xA1\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x86"],
        ["\xF3\xB5\xA1\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x90"],
        ["\xF3\xB5\xA1\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x92"],
        ["\xF3\xB5\xA1\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x95"],
        ["\xF3\xB5\xA1\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF\xA8"],
        ["\xF3\xB5\xA1\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA0"],
        ["\xF3\xB5\xA1\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA5"],
        ["\xF3\xB5\xA1\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA9"],
        ["\xF3\xB5\xA1\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x83"],
        ["\xF3\xB5\xA1\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x8C"],
        ["\xF3\xB5\xA1\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x90"],
        ["\xF3\xB5\xA1\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x92"],
        ["\xF3\xB5\xA1\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x96"],
        ["\xF3\xB5\xA1\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9C"],
        ["\xF3\xB5\xA1\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAB"],
        ["\xF3\xB5\xA2\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB3"],
        ["\xF3\xB5\xA2\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBD"],
        ["\xF3\xB5\xA2\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0\xA0"],
        ["\xF3\xB5\xA2\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8B"],
        ["\xF3\xB5\xA2\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA3"],
        ["\xF3\xB5\xA2\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA5"],
        ["\xF3\xB5\xA2\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAB"],
        ["\xF3\xB5\xA2\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAC"],
        ["\xF3\xB5\xA2\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB3"],
        ["\xF3\xB5\xA2\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB6"],
        ["\xF3\xB5\xA2\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB7"],
        ["\xF3\xB5\xA2\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA6"],
        ["\xF3\xB5\xA2\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAC"],
        ["\xF3\xB5\xA2\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB7\x9B"],
        ["\xF3\xB5\xA2\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB8\xBD"],
        ["\xF3\xB5\xA2\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB2"],
        ["\xF3\xB5\xA2\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB8"],
        ["\xF3\xB5\xA2\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xBE"],
        ["\xF3\xB5\xA2\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x87"],
        ["\xF3\xB5\xA2\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB3"],
        ["\xF3\xB5\xA2\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x98"],
        ["\xF3\xB5\xA2\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9D"],
        ["\xF3\xB5\xA2\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA7"],
        ["\xF3\xB5\xA2\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAA"],
        ["\xF3\xB5\xA2\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAB"],
        ["\xF3\xB5\xA2\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAF"],
        ["\xF3\xB5\xA2\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAE"],
        ["\xF3\xB5\xA2\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB8\x95"],
        ["\xF3\xB5\xA2\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xBA"],
        ["\xF3\xB5\xA2\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBA\x8A"],
        ["\xF3\xB5\xA2\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB7"],
        ["\xF3\xB5\xA2\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xB9\x89"],
        ["\xF3\xB5\xA2\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x96"],
        ["\xF3\xB5\xA2\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x98"],
        ["\xF3\xB5\xA2\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x99"],
        ["\xF3\xB5\xA2\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9A"],
        ["\xF3\xB5\xA2\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9D"],
        ["\xF3\xB5\xA2\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA2"],
        ["\xF3\xB5\xA2\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA7"],
        ["\xF3\xB5\xA2\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA9"],
        ["\xF3\xB5\xA2\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAA"],
        ["\xF3\xB5\xA2\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBB\x84"],
        ["\xF3\xB5\xA2\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB1"],
        ["\xF3\xB5\xA2\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB6"],
        ["\xF3\xB5\xA2\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB7"],
        ["\xF3\xB5\xA2\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x85"],
        ["\xF3\xB5\xA2\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9C"],
        ["\xF3\xB5\xA2\xB0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBB\xA9"],
        ["\xF3\xB5\xA2\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x89"],
        ["\xF3\xB5\xA2\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x8A"],
        ["\xF3\xB5\xA2\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBB\x9B"],
        ["\xF3\xB5\xA2\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x94"],
        ["\xF3\xB5\xA2\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x98"],
        ["\xF3\xB5\xA2\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9B"],
        ["\xF3\xB5\xA2\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9D"],
        ["\xF3\xB5\xA2\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9F"],
        ["\xF3\xB5\xA2\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA9"],
        ["\xF3\xB5\xA2\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAA"],
        ["\xF3\xB5\xA2\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAB"],
        ["\xF3\xB5\xA2\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAD"],
        ["\xF3\xB5\xA2\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAE"],
        ["\xF3\xB5\xA2\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB0"],
        ["\xF3\xB5\xA2\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB2"],
        ["\xF3\xB5\xA3\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB5"],
        ["\xF3\xB5\xA3\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xBA"],
        ["\xF3\xB5\xA3\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA6"],
        ["\xF3\xB5\xA3\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB2"],
        ["\xF3\xB5\xA3\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8B"],
        ["\xF3\xB5\xA3\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x82"],
        ["\xF3\xB5\xA3\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9\xBF\x8E"],
        ["\xF3\xB5\xA3\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x91"],
        ["\xF3\xB5\xA3\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x97"],
        ["\xF3\xB5\xA3\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x98"],
        ["\xF3\xB5\xA3\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x80\xAF"],
        ["\xF3\xB5\xA3\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3\x84"],
        ["\xF3\xB5\xA3\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x80\x9A"],
        ["\xF3\xB5\xA3\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xB2"],
        ["\xF3\xB5\xA3\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3\x91"],
        ["\xF3\xB5\xA3\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x82"],
        ["\xF3\xB5\xA3\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x8A"],
        ["\xF3\xB5\xA3\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9F"],
        ["\xF3\xB5\xA3\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA2"],
        ["\xF3\xB5\xA3\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x83\xB9"],
        ["\xF3\xB5\xA3\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA9"],
        ["\xF3\xB5\xA3\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x82\x82"],
        ["\xF3\xB5\xA3\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB3"],
        ["\xF3\xB5\xA3\x98",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB6"],
        ["\xF3\xB5\xA3\x99",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB7"],
        ["\xF3\xB5\xA3\x9A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBE"],
        ["\xF3\xB5\xA3\x9B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x84"],
        ["\xF3\xB5\xA3\x9C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8D"],
        ["\xF3\xB5\xA3\x9D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x99"],
        ["\xF3\xB5\xA3\x9E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA1"],
        ["\xF3\xB5\xA3\x9F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBF"],
        ["\xF3\xB5\xA3\xA0",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB5"],
        ["\xF3\xB5\xA3\xA1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB9"],
        ["\xF3\xB5\xA3\xA2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBD"],
        ["\xF3\xB5\xA3\xA3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x83"],
        ["\xF3\xB5\xA3\xA4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x87"],
        ["\xF3\xB5\xA3\xA5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x89"],
        ["\xF3\xB5\xA3\xA6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x96"],
        ["\xF3\xB5\xA3\xA7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x9A"],
        ["\xF3\xB5\xA3\xA8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x9F"],
        ["\xF3\xB5\xA3\xA9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA0"],
        ["\xF3\xB5\xA3\xAA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA3"],
        ["\xF3\xB5\xA3\xAB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB4"],
        ["\xF3\xB5\xA3\xAC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4\x87"],
        ["\xF3\xB5\xA3\xAD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x8A"],
        ["\xF3\xB5\xA3\xAE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x82"],
        ["\xF3\xB5\xA3\xAF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x8D"],
        ["\xF3\xB5\xA3\xB1",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9C"],
        ["\xF3\xB5\xA3\xB2",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9D"],
        ["\xF3\xB5\xA3\xB3",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBB"],
        ["\xF3\xB5\xA3\xB4",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2\x88\x98"],
        ["\xF3\xB5\xA3\xB5",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x80"],
        ["\xF3\xB5\xA3\xB6",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x85"],
        ["\xF3\xB5\xA3\xB7",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9B"],
        ["\xF3\xB5\xA3\xB8",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA8"],
        ["\xF3\xB5\xA3\xB9",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x8E\x8C"],
        ["\xF3\xB5\xA3\xBA",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBD"],
        ["\xF3\xB5\xA3\xBB",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x90\xB7"],
        ["\xF3\xB5\xA3\xBC",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9F"],
        ["\xF3\xB5\xA3\xBD",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA7"],
        ["\xF3\xB5\xA3\xBE",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xAE"],
        ["\xF3\xB5\xA3\xBF",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBF"],
        ["\xF3\xB5\xA4\x80",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x82"],
        ["\xF3\xB5\xA4\x81",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5\xB7"],
        ["\xF3\xB5\xA4\x82",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x83"],
        ["\xF3\xB5\xA4\x83",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x97"],
        ["\xF3\xB5\xA4\x84",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x99"],
        ["\xF3\xB5\xA4\x85",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xAF"],
        ["\xF3\xB5\xA4\x86",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xB7"],
        ["\xF3\xB5\xA4\x87",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBA"],
        ["\xF3\xB5\xA4\x88",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBD"],
        ["\xF3\xB5\xA4\x89",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x81"],
        ["\xF3\xB5\xA4\x8A",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x85"],
        ["\xF3\xB5\xA4\x8B",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x86"],
        ["\xF3\xB5\xA4\x8C",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x93"],
        ["\xF3\xB5\xA4\x8D",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x95"],
        ["\xF3\xB5\xA4\x8E",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x98"],
        ["\xF3\xB5\xA4\x8F",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x97\xB1"],
        ["\xF3\xB5\xA4\x90",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x9D"],
        ["\xF3\xB5\xA4\x91",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x98\x82"],
        ["\xF3\xB5\xA4\x92",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA9"],
        ["\xF3\xB5\xA4\x93",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x98\x9A"],
        ["\xF3\xB5\xA4\x94",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAD"],
        ["\xF3\xB5\xA4\x95",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB0"],
        ["\xF3\xB5\xA4\x96",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB5"],
        ["\xF3\xB5\xA4\x97",'utf8','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA\x9A\xB2"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        my @option_content = ();
        push(@option_content, qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}})        if exists $option->{'INPUT_LAYOUT'};
        push(@option_content, qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}})  if exists $option->{'OUTPUT_SHIFTING'};
        push(@option_content, qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}}) if exists $option->{'SPACE'};
        push(@option_content, qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}})   if exists $option->{'GETA'};
        $option_content = "{@option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
