use strict;
use warnings;

=pod

Test if connect() is monkexy patched and callbacks are installed. 

=cut


use Test::More;
use Data::Dump;
use lib "../../lib";

use DBI;
use DBIx::HoldMyPlace;


use lib  "../lib";
our $dbh;
do  "DBConnect.pl";


ok(exists $dbh->{Callbacks}, "Has Callbacks");
ok(exists $dbh->{Callbacks}{prepare}, "Has prepare hook");
ok(exists $dbh->{Callbacks}{ChildCallbacks}, "Has ChildCallbacks");
ok(exists $dbh->{Callbacks}{ChildCallbacks}{execute}, "Has execute hook");





TODO: {
    my $what = "Test for preserved callbacks";

    local $TODO = <<'__TXT__';
Some DBD:: or DBIx:: might have installed prior Callbacks.
Make sure they are not overwritten and also called (Before or after?)
__TXT__

    todo_skip "$what (HOW?)", 1;
    ok( 0, $what);
}

TODO: {
    my $what = "Test non-global patching of connect";
    my $how  = "Wrapper class DBI::HMP mit connect method";

    local $TODO = <<'__TXT__';
Using DBIx::HoldMyPlace should have no global effects on connect
__TXT__

    todo_skip "$what \n($how)", 1;
    ok( 0, $what);
}


done_testing();
