package IO::K8s::Api::Networking::V1::IngressLoadBalancerIngress;
# ABSTRACT: IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
our $VERSION = '1.000';
use IO::K8s::Resource;

k8s hostname => Str;


k8s ip => Str;


k8s ports => ['Networking::V1::IngressPortStatus'];


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::K8s::Api::Networking::V1::IngressLoadBalancerIngress - IngressLoadBalancerIngress represents the status of a load-balancer ingress point.

=head1 VERSION

version 1.000

=head2 hostname

hostname is set for load-balancer ingress points that are DNS based.

=head2 ip

ip is set for load-balancer ingress points that are IP based.

=head2 ports

ports provides information about the ports exposed by this LoadBalancer.

=head1 SUPPORT

=head2 Issues

Please report bugs and feature requests on GitHub at
L<https://github.com/pplu/io-k8s-p5/issues>.

=head2 IRC

Join C<#kubernetes> on C<irc.perl.org> or message Getty directly.

=head1 CONTRIBUTING

Contributions are welcome! Please fork the repository and submit a pull request.

=head1 AUTHORS

=over 4

=item *

Torsten Raudssus <torsten@raudssus.de>

=item *

Jose Luis Martinez <jlmartinez@capside.com> (original author, inactive)

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by CAPSiDE.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
