# Generated by default/object.tt
package Paws::CodeArtifact::PackageDependency;
  use Moose;
  has DependencyType => (is => 'ro', isa => 'Str', request_name => 'dependencyType', traits => ['NameInRequest']);
  has Namespace => (is => 'ro', isa => 'Str', request_name => 'namespace', traits => ['NameInRequest']);
  has Package => (is => 'ro', isa => 'Str', request_name => 'package', traits => ['NameInRequest']);
  has VersionRequirement => (is => 'ro', isa => 'Str', request_name => 'versionRequirement', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::PackageDependency

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::PackageDependency object:

  $service_obj->Method(Att1 => { DependencyType => $value, ..., VersionRequirement => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::PackageDependency object:

  $result = $service_obj->Method(...);
  $result->Att1->DependencyType

=head1 DESCRIPTION

Details about a package dependency.

=head1 ATTRIBUTES


=head2 DependencyType => Str

The type of a package dependency. The possible values depend on the
package type. Example types are C<compile>, C<runtime>, and C<test> for
Maven packages, and C<dev>, C<prod>, and C<optional> for npm packages.


=head2 Namespace => Str

The namespace of the package. The package component that specifies its
namespace depends on its type. For example:

=over

=item *

The namespace of a Maven package is its C<groupId>.

=item *

The namespace of an npm package is its C<scope>.

=item *

A Python package does not contain a corresponding component, so Python
packages do not have a namespace.

=back



=head2 Package => Str

The name of the package that this package depends on.


=head2 VersionRequirement => Str

The required version, or version range, of the package that this
package depends on. The version format is specific to the package type.
For example, the following are possible valid required versions:
C<1.2.3>, C<^2.3.4>, or C<4.x>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

