# Generated by default/object.tt
package Paws::Route53::GeoLocation;
  use Moose;
  has ContinentCode => (is => 'ro', isa => 'Str');
  has CountryCode => (is => 'ro', isa => 'Str');
  has SubdivisionCode => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53::GeoLocation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53::GeoLocation object:

  $service_obj->Method(Att1 => { ContinentCode => $value, ..., SubdivisionCode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53::GeoLocation object:

  $result = $service_obj->Method(...);
  $result->Att1->ContinentCode

=head1 DESCRIPTION

A complex type that contains information about a geographic location.

=head1 ATTRIBUTES


=head2 ContinentCode => Str

The two-letter code for the continent.

Amazon Route 53 supports the following continent codes:

=over

=item *

B<AF>: Africa

=item *

B<AN>: Antarctica

=item *

B<AS>: Asia

=item *

B<EU>: Europe

=item *

B<OC>: Oceania

=item *

B<NA>: North America

=item *

B<SA>: South America

=back

Constraint: Specifying C<ContinentCode> with either C<CountryCode> or
C<SubdivisionCode> returns an C<InvalidInput> error.


=head2 CountryCode => Str

For geolocation resource record sets, the two-letter code for a
country.

Amazon Route 53 uses the two-letter country codes that are specified in
ISO standard 3166-1 alpha-2
(https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).


=head2 SubdivisionCode => Str

For geolocation resource record sets, the two-letter code for a state
of the United States. Route 53 doesn't support any other values for
C<SubdivisionCode>. For a list of state abbreviations, see Appendix B:
TwoE<ndash>Letter State and Possession Abbreviations
(https://pe.usps.com/text/pub28/28apb.htm) on the United States Postal
Service website.

If you specify C<subdivisioncode>, you must also specify C<US> for
C<CountryCode>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

