BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.020; 1}) {
    print "Perl 5.020 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.79.
use strict;
use warnings;
use 5.020;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Simple, compact and correct param-checking functions",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Alt-Params-Util-PLICEASE",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020",
  "NAME"             => "Alt::Params::Util::PLICEASE",
  "PM"               => {
    "lib/Alt/Params/Util/PLICEASE.pm" => "\$(INST_LIB)/Alt/Params/Util/PLICEASE.pm",
    "lib/Params/Util.pm"              => "\$(INST_LIB)/Params/Util.pm"
  },
  "PREREQ_PM" => {
    "Params::SomeUtil" => "1.08",
    "true"             => 0
  },
  "TEST_REQUIRES" => {
    "Test2::V0" => "0.000121"
  },
  "VERSION" => "0.01",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Params::SomeUtil" => "1.08",
  "Test2::V0"        => "0.000121",
  "true"             => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

# begin inserted by Dist::Zilla::Plugin::Alt 0.08
print "!!! This is an Alt:: distribution that will not actually install unless you !!!\n";
print "!!! set PERL_ALT_INSTALL=OVERWRITE.  See https://metacpan.org/pod/Alt       !!!\n";
my $alt = $ENV{PERL_ALT_INSTALL} || '';
$WriteMakefileArgs{DESTDIR} =
  $alt ? $alt eq 'OVERWRITE' ? '' : $alt : 'no-install-alt';
if ( $^O eq 'MSWin32' && $WriteMakefileArgs{DESTDIR} ) {

  # Windows is a precious snowflake that can't handle DESTDIR
  # Caveat: this probably ignores any PREFIX specified by the user
  require Config;
  require File::Spec;
  my @prefix = split /:/, $Config::Config{prefix};
  $WriteMakefileArgs{PREFIX} = File::Spec->catdir( $WriteMakefileArgs{DESTDIR}, @prefix );
  delete $WriteMakefileArgs{DESTDIR};

  # DO NOT DO THIS SORT OF THING
  # THIS IS PRETTY UGLY AND PROBABLY BAD
  # DO AS I SAY AND NOT AS I DO
  package
    ExtUtils::MM_Any;
  my $orig = \&init_INSTALL;
  *init_INSTALL = sub {
    my ( $self, @args ) = @_;
    delete $self->{ARGS}{INSTALL_BASE} if $self->{ARGS}{PREFIX};
    $self->$orig(@args);
  }
}

# end inserted by Dist::Zilla::Plugin::Alt 0.08
WriteMakefile(%WriteMakefileArgs);