/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.Document;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.base14.Courier;
import org.apache.fop.fonts.base14.CourierBold;
import org.apache.fop.fonts.base14.CourierBoldOblique;
import org.apache.fop.fonts.base14.CourierOblique;
import org.apache.fop.fonts.base14.Helvetica;
import org.apache.fop.fonts.base14.HelveticaBold;
import org.apache.fop.fonts.base14.HelveticaBoldOblique;
import org.apache.fop.fonts.base14.HelveticaOblique;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.TimesBold;
import org.apache.fop.fonts.base14.TimesBoldItalic;
import org.apache.fop.fonts.base14.TimesItalic;
import org.apache.fop.fonts.base14.TimesRoman;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.render.pdf.EmbedFontInfo;
import org.apache.fop.render.pdf.FontTriplet;

public class FontSetup {
    public static void addConfiguredFonts(Document fontInfo, List fontInfos, int num) {
        if (fontInfos == null) {
            return;
        }
        String internalName = null;
        int i = 0;
        while (i < fontInfos.size()) {
            EmbedFontInfo configFontInfo = (EmbedFontInfo)fontInfos.get(i);
            String metricsFile = configFontInfo.getMetricsFile();
            if (metricsFile != null) {
                internalName = "F" + num;
                ++num;
                LazyFont font = new LazyFont(configFontInfo.getEmbedFile(), metricsFile, configFontInfo.getKerning());
                fontInfo.addMetrics(internalName, font);
                List triplets = configFontInfo.getFontTriplets();
                int c = 0;
                while (c < triplets.size()) {
                    FontTriplet triplet = (FontTriplet)triplets.get(c);
                    int weight = FontUtil.parseCSS2FontWeight(triplet.getWeight());
                    fontInfo.addFontProperties(internalName, triplet.getName(), triplet.getStyle(), weight);
                    ++c;
                }
            }
            ++i;
        }
    }

    public static void addToResources(PDFDocument doc, PDFResources resources, Document fontInfo) {
        Map fonts = fontInfo.getUsedFonts();
        Iterator e = fonts.keySet().iterator();
        while (e.hasNext()) {
            String f = (String)e.next();
            Typeface font = (Typeface)fonts.get(f);
            FontDescriptor desc = null;
            if (font instanceof FontDescriptor) {
                desc = (FontDescriptor)((Object)font);
            }
            resources.addFont(doc.getFactory().makeFont(f, font.getFontName(), font.getEncoding(), font, desc));
        }
    }

    public static List buildFontListFromConfiguration(Configuration cfg) throws ConfigurationException {
        ArrayList<EmbedFontInfo> fontList = new ArrayList<EmbedFontInfo>();
        Configuration[] font = cfg.getChildren("font");
        int i = 0;
        while (i < font.length) {
            Configuration[] triple = font[i].getChildren("font-triplet");
            ArrayList<FontTriplet> tripleList = new ArrayList<FontTriplet>();
            int j = 0;
            while (j < triple.length) {
                tripleList.add(new FontTriplet(triple[j].getAttribute("name"), triple[j].getAttribute("weight"), triple[j].getAttribute("style")));
                ++j;
            }
            EmbedFontInfo efi = new EmbedFontInfo(font[i].getAttribute("metrics-url"), font[i].getAttributeAsBoolean("kerning", false), tripleList, font[i].getAttribute("embed-url", null));
            fontList.add(efi);
            ++i;
        }
        return fontList;
    }

    public static void setup(Document fontInfo, List embedList) {
        fontInfo.addMetrics("F1", new Helvetica());
        fontInfo.addMetrics("F2", new HelveticaOblique());
        fontInfo.addMetrics("F3", new HelveticaBold());
        fontInfo.addMetrics("F4", new HelveticaBoldOblique());
        fontInfo.addMetrics("F5", new TimesRoman());
        fontInfo.addMetrics("F6", new TimesItalic());
        fontInfo.addMetrics("F7", new TimesBold());
        fontInfo.addMetrics("F8", new TimesBoldItalic());
        fontInfo.addMetrics("F9", new Courier());
        fontInfo.addMetrics("F10", new CourierOblique());
        fontInfo.addMetrics("F11", new CourierBold());
        fontInfo.addMetrics("F12", new CourierBoldOblique());
        fontInfo.addMetrics("F13", new Symbol());
        fontInfo.addMetrics("F14", new ZapfDingbats());
        fontInfo.addFontProperties("F5", "any", "normal", 400);
        fontInfo.addFontProperties("F6", "any", "italic", 400);
        fontInfo.addFontProperties("F6", "any", "oblique", 400);
        fontInfo.addFontProperties("F7", "any", "normal", 700);
        fontInfo.addFontProperties("F8", "any", "italic", 700);
        fontInfo.addFontProperties("F8", "any", "oblique", 700);
        fontInfo.addFontProperties("F1", "sans-serif", "normal", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "italic", 400);
        fontInfo.addFontProperties("F3", "sans-serif", "normal", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "italic", 700);
        fontInfo.addFontProperties("F5", "serif", "normal", 400);
        fontInfo.addFontProperties("F6", "serif", "oblique", 400);
        fontInfo.addFontProperties("F6", "serif", "italic", 400);
        fontInfo.addFontProperties("F7", "serif", "normal", 700);
        fontInfo.addFontProperties("F8", "serif", "oblique", 700);
        fontInfo.addFontProperties("F8", "serif", "italic", 700);
        fontInfo.addFontProperties("F9", "monospace", "normal", 400);
        fontInfo.addFontProperties("F10", "monospace", "oblique", 400);
        fontInfo.addFontProperties("F10", "monospace", "italic", 400);
        fontInfo.addFontProperties("F11", "monospace", "normal", 700);
        fontInfo.addFontProperties("F12", "monospace", "oblique", 700);
        fontInfo.addFontProperties("F12", "monospace", "italic", 700);
        fontInfo.addFontProperties("F1", "Helvetica", "normal", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "italic", 400);
        fontInfo.addFontProperties("F3", "Helvetica", "normal", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "italic", 700);
        fontInfo.addFontProperties("F5", "Times", "normal", 400);
        fontInfo.addFontProperties("F6", "Times", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times", "italic", 400);
        fontInfo.addFontProperties("F7", "Times", "normal", 700);
        fontInfo.addFontProperties("F8", "Times", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times", "italic", 700);
        fontInfo.addFontProperties("F9", "Courier", "normal", 400);
        fontInfo.addFontProperties("F10", "Courier", "oblique", 400);
        fontInfo.addFontProperties("F10", "Courier", "italic", 400);
        fontInfo.addFontProperties("F11", "Courier", "normal", 700);
        fontInfo.addFontProperties("F12", "Courier", "oblique", 700);
        fontInfo.addFontProperties("F12", "Courier", "italic", 700);
        fontInfo.addFontProperties("F13", "Symbol", "normal", 400);
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", 400);
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", 700);
        fontInfo.addFontProperties("F5", "Times Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "italic", 700);
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", 400);
        FontSetup.addConfiguredFonts(fontInfo, embedList, 15);
    }
}

