/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.modes.MindMapNode;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class BlinkingNodeHook
extends PermanentNodeHookAdapter {
    private Timer timer = null;
    static Vector colors = new Vector();

    public void invoke(MindMapNode node) {
        super.invoke(node);
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new TimerColorChanger(), 500L, 500L);
            this.nodeChanged(this.getNode());
        }
    }

    public void shutdownMapHook() {
        this.timer.cancel();
        this.timer = null;
        super.shutdownMapHook();
    }

    protected class TimerColorChanger
    extends TimerTask {
        TimerColorChanger() {
            colors.clear();
            colors.add(Color.BLUE);
            colors.add(Color.RED);
            colors.add(Color.MAGENTA);
            colors.add(Color.CYAN);
        }

        public void run() {
            if (BlinkingNodeHook.this.getController().isBlocked() || BlinkingNodeHook.this.getNode() == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Color col = BlinkingNodeHook.this.getNode().getColor();
                    int index = -1;
                    if (col != null && colors.contains(col)) {
                        index = colors.indexOf(col);
                    }
                    if (++index >= colors.size()) {
                        index = 0;
                    }
                    BlinkingNodeHook.this.getNode().setColor((Color)colors.get(index));
                    BlinkingNodeHook.this.nodeChanged(BlinkingNodeHook.this.getNode());
                }
            });
        }
    }
}

