/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.extensions.UndoEventReceiver;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MultipleImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeSet;

public class HierarchicalIcons
extends PermanentNodeHookAdapter
implements UndoEventReceiver {
    private HashMap nodeIconSets = new HashMap();

    public void shutdownMapHook() {
        MindMapNode root = this.getController().getRootNode();
        this.removeIcons(root);
        super.shutdownMapHook();
    }

    private void removeIcons(MindMapNode node) {
        node.setStateIcon(this.getName(), null);
        this.getController().nodeRefresh(node);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.removeIcons(child);
        }
    }

    private void setStyle(MindMapNode node) {
        TreeSet storedIconSet;
        TreeSet iconSet = new TreeSet();
        Iterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.addAccumulatedIconsToTreeSet(child, iconSet, (TreeSet)this.nodeIconSets.get(child));
        }
        i = node.getIcons().iterator();
        while (i.hasNext()) {
            MindIcon icon = (MindIcon)i.next();
            iconSet.remove(icon.getName());
        }
        boolean dirty = true;
        if (this.nodeIconSets.containsKey(node) && (storedIconSet = (TreeSet)this.nodeIconSets.get(node)).equals(iconSet)) {
            dirty = false;
        }
        this.nodeIconSets.put(node, iconSet);
        if (dirty) {
            if (iconSet.size() > 0) {
                MultipleImage image = new MultipleImage(0.75);
                Iterator i2 = iconSet.iterator();
                while (i2.hasNext()) {
                    String iconName = (String)i2.next();
                    MindIcon icon = MindIcon.factory(iconName);
                    image.addImage(icon.getIcon(this.getController().getFrame()));
                }
                node.setStateIcon(this.getName(), image);
            } else {
                node.setStateIcon(this.getName(), null);
            }
            this.getController().nodeRefresh(node);
        }
    }

    private void addAccumulatedIconsToTreeSet(MindMapNode child, TreeSet iconSet, TreeSet childsTreeSet) {
        Iterator i = child.getIcons().iterator();
        while (i.hasNext()) {
            MindIcon icon = (MindIcon)i.next();
            iconSet.add(icon.getName());
        }
        if (childsTreeSet == null) {
            return;
        }
        i = childsTreeSet.iterator();
        while (i.hasNext()) {
            String iconName = (String)i.next();
            iconSet.add(iconName);
        }
    }

    public void onAddChildren(MindMapNode newChildNode) {
        this.logger.finest("onAddChildren " + newChildNode);
        super.onAddChild(newChildNode);
        this.setStyleRecursive(newChildNode);
    }

    public void onRemoveChildren(MindMapNode removedChild, MindMapNode oldDad) {
        this.logger.finest("onRemoveChildren " + removedChild);
        super.onRemoveChildren(removedChild, oldDad);
        this.setStyleRecursive(oldDad);
    }

    public void onUpdateChildrenHook(MindMapNode updatedNode) {
        super.onUpdateChildrenHook(updatedNode);
        this.setStyleRecursive(updatedNode);
    }

    public void onUpdateNodeHook() {
        super.onUpdateNodeHook();
        this.setStyle(this.getNode());
    }

    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.gatherLeavesAndSetStyle(node);
        this.gatherLeavesAndSetParentsStyle(node);
    }

    private void gatherLeavesAndSetStyle(MindMapNode node) {
        if (node.getChildCount() == 0) {
            this.setStyle(node);
            return;
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.gatherLeavesAndSetStyle(child);
        }
    }

    private void gatherLeavesAndSetParentsStyle(MindMapNode node) {
        if (node.getChildCount() == 0) {
            if (node.getParentNode() != null) {
                this.setStyleRecursive(node.getParentNode());
            }
            return;
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.gatherLeavesAndSetParentsStyle(child);
        }
    }

    private void setStyleRecursive(MindMapNode node) {
        this.setStyle(node);
        if (node.getParentNode() != null) {
            this.setStyleRecursive(node.getParentNode());
        }
    }
}

