/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.common.JaxbTools;
import freemind.controller.actions.generated.instance.Plugin;
import freemind.controller.actions.generated.instance.PluginActionType;
import freemind.controller.actions.generated.instance.PluginClasspathType;
import freemind.controller.actions.generated.instance.PluginModeType;
import freemind.controller.actions.generated.instance.PluginRegistrationType;
import freemind.extensions.HookDescriptor;
import freemind.extensions.HookInstanciationMethod;
import freemind.extensions.HookRegistration;
import freemind.extensions.ImportWizard;
import freemind.extensions.MindMapHook;
import freemind.extensions.ModeControllerHook;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.modes.MindMapNode;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.xml.bind.Unmarshaller;

public class HookFactory {
    private static final String pluginPrefixRegEx = "(accessories\\.|)plugins\\.[^.]*";
    private FreeMindMain frame;
    private Logger logger;
    private HashMap pluginInfo;
    private Vector allPlugins;
    private HashMap allRegistrations;
    private HashMap allRegistrationInstances;
    private ImportWizard importWizard;
    private HashMap classLoaderCache = new HashMap();
    static /* synthetic */ Class class$freemind$extensions$NodeHook;
    static /* synthetic */ Class class$freemind$extensions$ModeControllerHook;

    public HookFactory(FreeMindMain frame) {
        this.frame = frame;
        this.logger = frame.getLogger(this.getClass().getName());
        this.allRegistrationInstances = new HashMap();
    }

    public Vector getPossibleNodeHooks(Class mode) {
        return this.searchFor(class$freemind$extensions$NodeHook == null ? (class$freemind$extensions$NodeHook = HookFactory.class$("freemind.extensions.NodeHook")) : class$freemind$extensions$NodeHook, mode);
    }

    public Vector getPossibleModeControllerHooks(Class mode) {
        return this.searchFor(class$freemind$extensions$ModeControllerHook == null ? (class$freemind$extensions$ModeControllerHook = HookFactory.class$("freemind.extensions.ModeControllerHook")) : class$freemind$extensions$ModeControllerHook, mode);
    }

    private Vector searchFor(Class baseClass, Class mode) {
        this.actualizePlugins();
        Vector<String> returnValue = new Vector<String>();
        Iterator i = this.allPlugins.iterator();
        while (i.hasNext()) {
            String label = (String)i.next();
            HookDescriptor descriptor = this.getHookDescriptor(label);
            try {
                this.logger.finest("Loading: " + label);
                if (!baseClass.isAssignableFrom(Class.forName(descriptor.getBaseClass()))) continue;
                Iterator j = descriptor.getModes().iterator();
                while (j.hasNext()) {
                    String pmode = (String)j.next();
                    if (!pmode.equals(mode.getPackage().getName())) continue;
                    returnValue.add(label);
                }
            }
            catch (ClassNotFoundException e) {
                this.logger.severe("Class not found.");
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    private void actualizePlugins() {
        if (this.importWizard == null) {
            this.importWizard = new ImportWizard();
            this.importWizard.CLASS_LIST.clear();
            this.importWizard.buildClassList();
        }
        this.pluginInfo = new HashMap();
        this.allPlugins = new Vector();
        this.allRegistrations = new HashMap();
        Unmarshaller unmarshaller = JaxbTools.getInstance().createUnmarshaller();
        Iterator i = this.importWizard.CLASS_LIST.iterator();
        while (i.hasNext()) {
            String xmlPluginFile = (String)i.next();
            if (!xmlPluginFile.matches(pluginPrefixRegEx)) continue;
            xmlPluginFile = xmlPluginFile.replace('.', '/') + this.importWizard.lookFor;
            URL pluginURL = this.getClassLoader(Collections.EMPTY_LIST).getResource(xmlPluginFile);
            Plugin plugin = null;
            try {
                this.logger.finest("Reading: " + xmlPluginFile + " from " + pluginURL);
                InputStream in = pluginURL.openStream();
                unmarshaller.setValidating(true);
                plugin = (Plugin)unmarshaller.unmarshal(in);
            }
            catch (Exception e) {
                this.logger.severe(e.getLocalizedMessage());
                e.printStackTrace();
                continue;
            }
            Iterator j = plugin.getPluginAction().iterator();
            while (j.hasNext()) {
                PluginActionType action = (PluginActionType)j.next();
                this.pluginInfo.put(action.getLabel(), new HookDescriptor(this.frame, action, plugin));
                this.allPlugins.add(action.getLabel());
            }
            Iterator k = plugin.getPluginRegistration().iterator();
            while (k.hasNext()) {
                PluginRegistrationType registration = (PluginRegistrationType)k.next();
                this.allRegistrations.put(registration, plugin);
            }
        }
    }

    public ModeControllerHook createModeControllerHook(String hookName) {
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        return (ModeControllerHook)this.createJavaHook(hookName, descriptor);
    }

    private MindMapHook createJavaHook(String hookName, HookDescriptor descriptor) {
        try {
            List pluginClasspathList = descriptor.getPluginBase().getPluginClasspath();
            ClassLoader loader = this.getClassLoader(pluginClasspathList);
            Class<?> hookClass = Class.forName(descriptor.getClassName(), true, loader);
            MindMapHook hook = (MindMapHook)hookClass.newInstance();
            this.decorateHook(hookName, descriptor, hook);
            return hook;
        }
        catch (Exception e) {
            this.logger.severe("Error occurred loading hook: " + descriptor.getClassName() + "\nException:" + e.toString());
            return null;
        }
    }

    private ClassLoader getClassLoader(List pluginClasspathList) {
        String key = this.createPluginClasspathString(pluginClasspathList);
        if (this.classLoaderCache.containsKey(key)) {
            return (ClassLoader)this.classLoaderCache.get(key);
        }
        try {
            URL[] urls = new URL[pluginClasspathList.size() + 1];
            int j = 0;
            urls[j++] = new File(HookFactory.getFreemindBaseDir()).toURL();
            Iterator i = pluginClasspathList.iterator();
            while (i.hasNext()) {
                PluginClasspathType classPath = (PluginClasspathType)i.next();
                File file = new File(classPath.getJar());
                if (!file.isAbsolute()) {
                    file = new File(HookFactory.getFreemindBaseDir(), classPath.getJar());
                }
                this.logger.info("file " + file.toString() + " exists = " + file.exists());
                urls[j++] = file.toURL();
            }
            URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
            this.classLoaderCache.put(key, loader);
            return loader;
        }
        catch (MalformedURLException e) {
            this.logger.severe(e.getMessage());
            return this.getClass().getClassLoader();
        }
    }

    private String createPluginClasspathString(List pluginClasspathList) {
        String result = "";
        Iterator i = pluginClasspathList.iterator();
        while (i.hasNext()) {
            PluginClasspathType type = (PluginClasspathType)i.next();
            result = result + type.getJar() + ",";
        }
        return result;
    }

    public static String getFreemindBaseDir() {
        return System.getProperty("freemind.base.dir", ".");
    }

    public NodeHook createNodeHook(String hookName) {
        this.logger.finest("CreateNodeHook: " + hookName);
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        return (NodeHook)this.createJavaHook(hookName, descriptor);
    }

    public PermanentNodeHook getHookInNode(MindMapNode node, String hookName) {
        Iterator i = node.getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook otherHook = (PermanentNodeHook)i.next();
            if (!otherHook.getName().equals(hookName)) continue;
            return otherHook;
        }
        return null;
    }

    private void decorateHook(String hookName, HookDescriptor descriptor, MindMapHook hook) {
        hook.setProperties(descriptor.getProperties());
        hook.setName(hookName);
        Object baseClass = this.getPluginBaseClass(descriptor);
        hook.setPluginBaseClass(baseClass);
    }

    private Object getPluginBaseClass(HookDescriptor descriptor) {
        Object baseClass = null;
        if (this.allRegistrationInstances.containsKey(descriptor.getPluginBase())) {
            baseClass = this.allRegistrationInstances.get(descriptor.getPluginBase());
        }
        return baseClass;
    }

    protected FreeMindMain getFrame() {
        return this.frame;
    }

    public String getProperty(String hookName, String prop) {
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        return descriptor.getProperties().getProperty(prop);
    }

    public void decorateAction(String hookName, AbstractAction action) {
        String key;
        String icon;
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        String name = descriptor.getName();
        if (name != null) {
            action.putValue("Name", name);
        } else {
            action.putValue("Name", descriptor.getClassName());
        }
        String docu = descriptor.getDocumentation();
        if (docu != null) {
            action.putValue("ShortDescription", docu);
            action.putValue("LongDescription", docu);
        }
        if ((icon = descriptor.getIconPath()) != null) {
            ImageIcon imageIcon = new ImageIcon(this.getClassLoader(Collections.EMPTY_LIST).getResource(icon));
            action.putValue("SmallIcon", imageIcon);
        }
        if ((key = descriptor.getKeyStroke()) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key));
        }
    }

    public List getHookMenuPositions(String hookName) {
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        return descriptor.menuPositions;
    }

    public JMenuItem getHookMenuItem(String hookName, AbstractAction hookAction) {
        return new JMenuItem(hookAction);
    }

    public HookInstanciationMethod getInstanciationMethod(String hookName) {
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        return descriptor.getInstanciationMethod();
    }

    public List getRegistrations(Class mode) {
        this.actualizePlugins();
        Vector<RegistrationContainer> returnValue = new Vector<RegistrationContainer>();
        Iterator i = this.allRegistrations.keySet().iterator();
        while (i.hasNext()) {
            PluginRegistrationType registration = (PluginRegistrationType)i.next();
            boolean modeFound = false;
            Iterator j = registration.getPluginMode().iterator();
            while (j.hasNext()) {
                PluginModeType possibleMode = (PluginModeType)j.next();
                if (!mode.getPackage().getName().equals(possibleMode.getClassName())) continue;
                modeFound = true;
            }
            if (!modeFound) continue;
            try {
                Class<?> hookRegistrationClass;
                Plugin plugin = (Plugin)this.allRegistrations.get(registration);
                ClassLoader loader = this.getClassLoader(plugin.getPluginClasspath());
                RegistrationContainer container = new RegistrationContainer();
                container.hookRegistrationClass = hookRegistrationClass = Class.forName(registration.getClassName(), true, loader);
                container.correspondingPlugin = plugin;
                container.isPluginBase = registration.isIsPluginBase();
                returnValue.add(container);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public void registerRegistrationContainer(RegistrationContainer container, HookRegistration instanciatedRegistrationObject) {
        if (container.isPluginBase) {
            this.allRegistrationInstances.put(container.correspondingPlugin, instanciatedRegistrationObject);
        }
    }

    public Object getPluginBaseClass(String hookName) {
        this.logger.finest("getPluginBaseClass: " + hookName);
        HookDescriptor descriptor = this.getHookDescriptor(hookName);
        return this.getPluginBaseClass(descriptor);
    }

    private HookDescriptor getHookDescriptor(String hookName) {
        HookDescriptor descriptor = (HookDescriptor)this.pluginInfo.get(hookName);
        if (hookName == null || descriptor == null) {
            throw new IllegalArgumentException("Unknown hook name " + hookName);
        }
        return descriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RegistrationContainer {
        public Class hookRegistrationClass;
        public boolean isPluginBase;
        public Plugin correspondingPlugin;

        RegistrationContainer() {
        }
    }
}

