/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.controller.Controller;
import freemind.controller.MenuBar;
import freemind.extensions.HookFactory;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.view.mindmapview.MapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FreeMindApplet
extends JApplet
implements FreeMindMain {
    private HookFactory nodeHookFactory;
    public static final String version = "0.8.0";
    public URL defaultPropsURL;
    public static Properties defaultProps;
    public static Properties userProps;
    private JScrollPane scrollPane = new JScrollPane();
    private MenuBar menuBar;
    private PropertyResourceBundle resources;
    private JLabel status = new JLabel();
    Controller c;
    static int iMaxNodeWidth;

    public boolean isApplet() {
        return true;
    }

    public File getPatternsFile() {
        return null;
    }

    public Controller getController() {
        return this.c;
    }

    public MapView getView() {
        return this.c.getView();
    }

    public void setView(MapView view) {
        this.scrollPane.setViewportView(view);
    }

    public MenuBar getFreeMindMenuBar() {
        return this.menuBar;
    }

    public Container getViewport() {
        return this.scrollPane.getViewport();
    }

    public String getFreemindVersion() {
        return version;
    }

    public int getWinHeight() {
        return this.getRootPane().getHeight();
    }

    public int getWinWidth() {
        return this.getRootPane().getWidth();
    }

    public int getWinState() {
        return 6;
    }

    public ResourceBundle getResources() {
        if (this.resources == null) {
            String lang = userProps.getProperty("language");
            try {
                URL myurl = this.getResource("Resources_" + lang.trim() + ".properties");
                InputStream in = myurl.openStream();
                this.resources = new PropertyResourceBundle(in);
                in.close();
            }
            catch (Exception ex) {
                System.err.println("Error loading Resources");
                return null;
            }
        }
        return this.resources;
    }

    public String getResourceString(String resource) {
        try {
            return this.getResources().getString(resource);
        }
        catch (Exception ex) {
            System.err.println("Warning - resource string not found:" + resource);
            return resource;
        }
    }

    public String getProperty(String key) {
        return userProps.getProperty(key);
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public Properties getProperties() {
        return userProps;
    }

    public void setProperty(String key, String value) {
    }

    public String getFreemindDirectory() {
        return null;
    }

    public static int getMaxNodeWidth() {
        if (iMaxNodeWidth == 0) {
            try {
                iMaxNodeWidth = Integer.parseInt(userProps.getProperty("max_node_width"));
            }
            catch (NumberFormatException nfe) {
                iMaxNodeWidth = Integer.parseInt(userProps.getProperty("el__max_default_window_width"));
            }
        }
        return iMaxNodeWidth;
    }

    public void saveProperties() {
    }

    public void setTitle(String title) {
    }

    public void out(String msg) {
        this.status.setText(msg);
    }

    public void err(String msg) {
        this.status.setText("ERROR: " + msg);
    }

    public void openDocument(URL doc) throws Exception {
        this.getAppletContext().showDocument(doc, "_blank");
    }

    public void start() {
        try {
            if (this.getView() != null) {
                this.getView().moveToRoot();
            } else {
                System.err.println("View is null.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    public URL getResource(String name) {
        return this.getClass().getResource("/" + name);
    }

    public Logger getLogger(String forClass) {
        return Logger.getAnonymousLogger();
    }

    public void init() {
        JRootPane rootPane = this.createRootPane();
        this.defaultPropsURL = this.getResource("freemind.properties");
        try {
            defaultProps = new Properties();
            InputStream in = this.defaultPropsURL.openStream();
            defaultProps.load(in);
            in.close();
            userProps = defaultProps;
        }
        catch (Exception ex) {
            System.err.println("Could not load properties.");
        }
        Enumeration<?> allKeys = userProps.propertyNames();
        while (allKeys.hasMoreElements()) {
            String key = (String)allKeys.nextElement();
            String val = this.getParameter(key);
            if (val == null || val == "") continue;
            userProps.setProperty(key, val);
        }
        String lookAndFeel = "";
        try {
            lookAndFeel = userProps.getProperty("lookandfeel");
            if (lookAndFeel.equals("windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (lookAndFeel.equals("motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (lookAndFeel.equals("mac")) {
                UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
            } else if (lookAndFeel.equals("metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (lookAndFeel.equals("gtk")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (!lookAndFeel.equals("nothing")) {
                if (lookAndFeel.indexOf(46) != -1) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error while setting Look&Feel" + lookAndFeel);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.c = new Controller(this);
        if (Tools.safeEquals(this.getProperty("antialiasEdges"), "true")) {
            this.c.setAntialiasEdges(true);
        }
        if (Tools.safeEquals(this.getProperty("antialiasAll"), "true")) {
            this.c.setAntialiasAll(true);
        }
        this.menuBar = new MenuBar(this.c);
        this.setJMenuBar(this.menuBar);
        this.c.setToolbarVisible(false);
        this.c.setMenubarVisible(false);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.status, "South");
        SwingUtilities.updateComponentTreeUI(this);
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.c.changeToMode(this.getProperty("initial_mode"));
    }

    public HookFactory getHookFactory() {
        if (this.nodeHookFactory == null) {
            this.nodeHookFactory = new HookFactory(this);
        }
        return this.nodeHookFactory;
    }

    public JPanel getSouthPanel() {
        return null;
    }

    public JFrame getJFrame() {
        throw new IllegalArgumentException("The applet has no frames");
    }

    static {
        iMaxNodeWidth = 0;
    }
}

