/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.MindMapNodesSelection;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.MindMap;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class MapAdapter
implements MindMap {
    private MindMapNode root;
    private EventListenerList treeModelListeners = new EventListenerList();
    protected int changesPerformedSinceLastSave = 1;
    protected boolean readOnly = true;
    private Color backgroundColor;
    private File file;
    private FreeMindMain frame;
    protected static Logger logger;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public MapAdapter(FreeMindMain frame) {
        this.frame = frame;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
    }

    public abstract boolean save(File var1);

    public abstract void load(File var1) throws FileNotFoundException, IOException, XMLParseException;

    public String tryToLock(File file) throws Exception {
        return null;
    }

    public void destroy() {
        this.removeHooks((MindMapNode)this.getRoot());
    }

    private void removeHooks(MindMapNode node) {
        while (node.getHooks().size() > 0) {
            PermanentNodeHook hook = (PermanentNodeHook)node.getHooks().get(0);
            node.removeHook(hook);
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.removeHooks(child);
        }
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public boolean isSaved() {
        return this.changesPerformedSinceLastSave == 0;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setSaved(boolean saved) {
        this.changesPerformedSinceLastSave = saved ? 0 : ++this.changesPerformedSinceLastSave;
    }

    protected int getNumberOfChangesSinceLastSave() {
        return this.changesPerformedSinceLastSave;
    }

    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            return Tools.xmlToColor(this.getFrame().getProperty("standardbackgroundcolor"));
        }
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.nodeChanged((MindMapNode)this.getRoot());
    }

    public Object getRoot() {
        return this.root;
    }

    protected void setRoot(MindMapNode root) {
        this.root = root;
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() throws MalformedURLException {
        return this.getFile() != null ? this.getFile().toURL() : null;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    protected String getText(String textId) {
        return this.getFrame().getResourceString(textId);
    }

    public Object[] getPathToRoot(TreeNode node) {
        return ((MindMapNode)node).getPath().getPath();
    }

    public final Transferable cut(MindMapNode node) {
        Transferable t = this.copy(node);
        this.removeNodeFromParent(node);
        return t;
    }

    public Transferable copy(MindMapNode node) {
        return null;
    }

    public Transferable copy() {
        return this.copy(this.getFrame().getView().getSelectedNodesSortedByY(), null);
    }

    public Transferable copySingle() {
        MindMapNode selectedNode = this.getFrame().getView().getSelected().getModel();
        ArrayList<MindMapNode> selectedNodes = new ArrayList<MindMapNode>();
        selectedNodes.add(selectedNode.shallowCopy());
        return this.copy(selectedNodes, ((Object)selectedNode).toString());
    }

    public Transferable copy(List selectedNodes, String inPlainText) {
        try {
            String forNodesFlavor = "";
            boolean firstLoop = true;
            Iterator it = selectedNodes.iterator();
            while (it.hasNext()) {
                MindMapNode tmpNode = (MindMapNode)it.next();
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    forNodesFlavor = forNodesFlavor + "<nodeseparator>";
                }
                forNodesFlavor = forNodesFlavor + this.copy(tmpNode).getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
            }
            String plainText = inPlainText != null ? inPlainText : this.getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, plainText, this.getAsRTF(selectedNodes), null, null, null);
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getAsPlainText(List mindMapNodes) {
        return "";
    }

    public String getAsRTF(List mindMapNodes) {
        return "";
    }

    public String getRestoreable() {
        return null;
    }

    public MindMapLinkRegistry getLinkRegistry() {
        return null;
    }

    public void insertNodeIntoNoEvent(MindMapNode newChild, MindMapNode parent) {
        this.insertNodeIntoNoEvent(newChild, parent, false);
    }

    public void insertNodeIntoNoEvent(MindMapNode newChild, MindMapNode parent, boolean asSibling) {
        if (asSibling) {
            MindMapNode oldpa = parent.getParentNode();
            oldpa.insert(newChild, oldpa.getChildPosition(parent));
            this.recursiveCallAddChildren(oldpa, newChild);
        } else {
            parent.insert(newChild, parent.getChildCount());
            this.recursiveCallAddChildren(parent, newChild);
        }
    }

    public void insertNodeInto(MindMapNode newChild, MindMapNode parent) {
        this.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public void insertNodeInto(MindMapNode newChild, MindMapNode parent, int index) {
        this.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)parent, index);
        this.recursiveCallAddChildren(parent, newChild);
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        this.nodesWereInserted(parent, new int[]{index});
    }

    private void recursiveCallAddChildren(MindMapNode node, MindMapNode addedChild) {
        if (node instanceof MindMapNode) {
            Iterator i = node.getActivatedHooks().iterator();
            while (i.hasNext()) {
                PermanentNodeHook hook = (PermanentNodeHook)i.next();
                if (addedChild.getParentNode() == node) {
                    hook.onAddChild(addedChild);
                }
                hook.onAddChildren(addedChild);
            }
        }
        if (!node.isRoot() && node.getParentNode() != null) {
            this.recursiveCallAddChildren(node.getParentNode(), addedChild);
        }
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        this.removeNodeFromParent(node, true);
    }

    public void removeNodeFromParent(MutableTreeNode node, boolean notify) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(node);
        if (notify) {
            removedArray[0] = node;
            this.nodesWereRemoved(parent, childIndex, removedArray);
        }
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = MapAdapter.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = MapAdapter.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        ((MutableTreeNode)path.getLastPathComponent()).setUserObject(newValue);
    }

    protected void nodesWereRemoved(TreeNode parent, int[] childIndices, Object[] removedChildren) {
        this.setSaved(false);
        if (parent != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot((MindMapNode)parent), childIndices, removedChildren);
        }
    }

    protected void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.treeModelListeners != null && node != null && childIndices != null && childIndices.length > 0) {
            this.setSaved(false);
            Object[] newChildren = new Object[childIndices.length];
            for (int counter = 0; counter < childIndices.length; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot((MindMapNode)node), childIndices, newChildren);
        }
    }

    public void nodeChanged(TreeNode node) {
        this.frame.getController().getMode().getModeController().nodeChanged((MindMapNode)node);
    }

    public void nodeChangedMapInternal(TreeNode node) {
        if (this.treeModelListeners != null && node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (((MindMapNode)node).isRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    protected void nodesChanged(TreeNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                        logger.finest("Children array at " + counter + " = " + cChildren[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (((MindMapNode)node).isRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    protected void nodeStructureChanged(TreeNode node) {
        this.setSaved(false);
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    protected void reload(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    private void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    private void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    private void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

