/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MindIcon {
    private String name;
    private String description;
    private ImageIcon associatedIcon;
    private static Vector mAllIconNames;
    private static ImageIcon iconNotFound;
    private static HashMap createdIcons;

    private MindIcon(String name) {
        this.setName(name);
        this.associatedIcon = null;
    }

    public String toString() {
        return "Icon_name: " + this.name;
    }

    public String getName() {
        return this.name == null ? "notfound" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription(FreeMindMain frame) {
        String resource = new String("icon_" + this.getName());
        return frame.getResourceString(resource);
    }

    public String getIconFileName() {
        return MindIcon.getIconsPath() + this.getIconBaseFileName();
    }

    public String getIconBaseFileName() {
        return this.getName() + ".png";
    }

    public static String getIconsPath() {
        return "images/icons/";
    }

    public ImageIcon getIcon(FreeMindMain frame) {
        if (iconNotFound == null) {
            iconNotFound = new ImageIcon(frame.getResource("images/IconNotFound.png"));
        }
        if (this.associatedIcon != null) {
            return this.associatedIcon;
        }
        if (this.name != null) {
            URL imageURL = frame.getResource(this.getIconFileName());
            ImageIcon icon = imageURL == null ? iconNotFound : new ImageIcon(imageURL);
            this.setIcon(icon);
            return icon;
        }
        this.setIcon(iconNotFound);
        return iconNotFound;
    }

    protected void setIcon(ImageIcon _associatedIcon) {
        this.associatedIcon = _associatedIcon;
    }

    public static Vector getAllIconNames() {
        if (mAllIconNames != null) {
            return mAllIconNames;
        }
        Vector<String> mAllIconNames = new Vector<String>();
        mAllIconNames.add("help");
        mAllIconNames.add("messagebox_warning");
        mAllIconNames.add("idea");
        mAllIconNames.add("button_ok");
        mAllIconNames.add("button_cancel");
        mAllIconNames.add("full-1");
        mAllIconNames.add("full-2");
        mAllIconNames.add("full-3");
        mAllIconNames.add("full-4");
        mAllIconNames.add("full-5");
        mAllIconNames.add("full-6");
        mAllIconNames.add("full-7");
        mAllIconNames.add("back");
        mAllIconNames.add("forward");
        mAllIconNames.add("attach");
        mAllIconNames.add("ksmiletris");
        mAllIconNames.add("clanbomber");
        mAllIconNames.add("desktop_new");
        mAllIconNames.add("flag");
        mAllIconNames.add("gohome");
        mAllIconNames.add("kaddressbook");
        mAllIconNames.add("knotify");
        mAllIconNames.add("korn");
        mAllIconNames.add("Mail");
        mAllIconNames.add("password");
        mAllIconNames.add("pencil");
        mAllIconNames.add("stop");
        mAllIconNames.add("wizard");
        mAllIconNames.add("xmag");
        mAllIconNames.add("bell");
        mAllIconNames.add("bookmark");
        mAllIconNames.add("penguin");
        mAllIconNames.add("licq");
        return mAllIconNames;
    }

    public static MindIcon factory(String iconName) {
        if (createdIcons.containsKey(iconName)) {
            return (MindIcon)createdIcons.get(iconName);
        }
        MindIcon icon = new MindIcon(iconName);
        createdIcons.put(iconName, icon);
        return icon;
    }

    static {
        createdIcons = new HashMap();
    }
}

