/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.Controller;
import freemind.controller.MenuItemEnabledListener;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.CloudColorXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.xml.bind.JAXBException;

public class CloudColorAction
extends FreemindAction
implements ActorXml,
MenuItemEnabledListener {
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$CloudColorXmlAction;

    public CloudColorAction(ModeController controller) {
        super("cloud_color", "images/Colors24.gif", controller);
        this.controller = controller;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        Color color;
        Color selectedColor = null;
        if (this.controller.getSelected().getCloud() != null) {
            selectedColor = this.controller.getSelected().getCloud().getColor();
        }
        if ((color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_cloud_color"), selectedColor)) == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setCloudColor(selected, color);
        }
    }

    public void setCloudColor(MindMapNode node, Color color) {
        try {
            CloudColorXmlAction doAction = this.createCloudColorXmlAction(node, color);
            CloudColorXmlAction undoAction = this.createCloudColorXmlAction(node, node.getCloud() == null ? null : node.getCloud().getColor());
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public CloudColorXmlAction createCloudColorXmlAction(MindMapNode node, Color color) throws JAXBException {
        CloudColorXmlAction nodeAction = this.controller.getActionXmlFactory().createCloudColorXmlAction();
        nodeAction.setNode(node.getObjectId(this.controller));
        nodeAction.setColor(Tools.colorToXml(color));
        return nodeAction;
    }

    public void act(XmlAction action) {
        if (action instanceof CloudColorXmlAction) {
            CloudColorXmlAction nodeColorAction = (CloudColorXmlAction)action;
            Color color = Tools.xmlToColor(nodeColorAction.getColor());
            NodeAdapter node = this.controller.getNodeFromID(nodeColorAction.getNode());
            if (node.getCloud() == null) {
                this.controller.setCloud(node, true);
            }
            Color selectedColor = null;
            if (node.getCloud() != null) {
                selectedColor = node.getCloud().getColor();
            }
            if (!Tools.safeEquals(color, selectedColor)) {
                ((LineAdapter)((Object)node.getCloud())).setColor(color);
                this.controller.nodeChanged(node);
            }
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$CloudColorXmlAction == null ? (class$freemind$controller$actions$generated$instance$CloudColorXmlAction = CloudColorAction.class$("freemind.controller.actions.generated.instance.CloudColorXmlAction")) : class$freemind$controller$actions$generated$instance$CloudColorXmlAction;
    }

    public boolean isEnabled(JMenuItem item, Action action) {
        return this.controller != null && this.controller.getSelected() != null && this.controller.getSelected().getCloud() != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

