/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindIcon;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ListIterator;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.ImageIcon;

public class EncryptedMindMapNode
extends MindMapNodeModel {
    private boolean isVisible = true;
    private boolean isDecrypted = true;
    private StringBuffer password = null;
    private String encryptedContent;
    private static ImageIcon encryptedIcon;
    private static ImageIcon decryptedIcon;
    private boolean isShuttingDown = false;

    public EncryptedMindMapNode(Object userObject, FreeMindMain frame) {
        super(userObject, frame);
        if (encryptedIcon == null) {
            encryptedIcon = MindIcon.factory("encrypted").getIcon(frame);
        }
        if (decryptedIcon == null) {
            decryptedIcon = MindIcon.factory("decrypted").getIcon(frame);
        }
        this.updateIcon();
    }

    public boolean decrypt(StringBuffer givenPassword) {
        if (!this.checkPassword(givenPassword)) {
            return false;
        }
        if (!this.isDecrypted) {
            String childXml = this.decryptXml(this.encryptedContent, this.password);
            String[] childs = childXml.split("<nodeseparator>");
            for (int i = childs.length - 1; i >= 0; --i) {
                String string = childs[i];
                ((ControllerAdapter)this.getFrame().getController().getModeController()).paste.pasteXMLWithoutRedisplay(string, this, false);
            }
            this.isDecrypted = true;
        }
        this.setVisible(true);
        this.setFolded(false);
        return true;
    }

    public boolean checkPassword(StringBuffer givenPassword) {
        if (this.password != null) {
            if (!this.equals(givenPassword, this.password)) {
                logger.warning("Wrong password supplied (cached!=given).");
                return false;
            }
            return true;
        }
        String decryptedNode = this.decryptXml(this.encryptedContent, givenPassword);
        if (decryptedNode == null || !decryptedNode.startsWith("<node ")) {
            logger.warning("Wrong password supplied (stored!=given).");
            return false;
        }
        this.password = givenPassword;
        return true;
    }

    private boolean equals(StringBuffer givenPassword, StringBuffer password2) {
        if (givenPassword.length() != this.password.length()) {
            return false;
        }
        for (int i = 0; i < password2.length(); ++i) {
            char c2;
            char c1 = password2.charAt(i);
            if (c1 == (c2 = givenPassword.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void encrypt() {
        this.setFolded(true);
        this.setVisible(false);
    }

    public int getChildCount() {
        if (this.isVisible()) {
            return super.getChildCount();
        }
        return 0;
    }

    public ListIterator childrenFolded() {
        if (this.isVisible()) {
            return super.childrenFolded();
        }
        return new Vector().listIterator();
    }

    public ListIterator childrenUnfolded() {
        if (this.isVisible() || this.isShuttingDown) {
            return super.childrenUnfolded();
        }
        return new Vector().listIterator();
    }

    public boolean hasChildren() {
        if (this.isVisible()) {
            return super.hasChildren();
        }
        return false;
    }

    public void updateIcon() {
        this.setStateIcon("encryptedNode", this.isVisible() ? decryptedIcon : encryptedIcon);
    }

    public void setPassword(StringBuffer password) {
        this.password = password;
    }

    public boolean isFolded() {
        if (this.isVisible()) {
            return super.isFolded();
        }
        return true;
    }

    public void setFolded(boolean folded) {
        if (this.isVisible()) {
            super.setFolded(folded);
        } else {
            super.setFolded(true);
        }
    }

    public void setAdditionalInfo(String info) {
        this.encryptedContent = info;
        this.setVisible(false);
        this.isDecrypted = false;
    }

    public String getAdditionalInfo() {
        return this.encryptedContent;
    }

    public XMLElement save(Writer writer, MindMapLinkRegistry registry) throws IOException {
        if (this.isDecrypted) {
            this.generateEncryptedContent(registry);
        }
        boolean oldIsVisible = this.isVisible();
        this.setVisible(false);
        XMLElement ret = null;
        try {
            ret = super.save(writer, registry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(oldIsVisible);
        return ret;
    }

    private void generateEncryptedContent(MindMapLinkRegistry registry) throws IOException {
        StringWriter sWriter = new StringWriter();
        ListIterator i = super.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            child.save(sWriter, registry);
            if (!i.hasNext()) continue;
            sWriter.write("<nodeseparator>");
        }
        StringBuffer childXml = sWriter.getBuffer();
        this.encryptedContent = this.encryptXml(childXml);
    }

    private String encryptXml(StringBuffer childXml) {
        try {
            DesEncrypter encrypter = new DesEncrypter(this.password);
            String encrypted = encrypter.encrypt(childXml.toString());
            return encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Can't encrypt the node.");
        }
    }

    private String decryptXml(String encryptedString, StringBuffer pwd) {
        DesEncrypter encrypter = new DesEncrypter(pwd);
        String decrypted = encrypter.decrypt(encryptedString);
        return decrypted;
    }

    public void setShuttingDown(boolean isShuttingDown) {
        this.isShuttingDown = isShuttingDown;
    }

    private void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        this.updateIcon();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public class DesEncrypter {
        private static final String SALT_PRESENT_INDICATOR = " ";
        private static final int SALT_LENGTH = 8;
        Cipher ecipher;
        Cipher dcipher;
        byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
        int iterationCount = 19;
        private final char[] passPhrase;

        DesEncrypter(StringBuffer pPassPhrase) {
            this.passPhrase = new char[pPassPhrase.length()];
            pPassPhrase.getChars(0, this.passPhrase.length, this.passPhrase, 0);
        }

        private void init(byte[] mSalt) {
            if (mSalt != null) {
                this.salt = mSalt;
            }
            if (this.ecipher == null) {
                try {
                    PBEKeySpec keySpec = new PBEKeySpec(this.passPhrase, this.salt, this.iterationCount);
                    SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndTripleDES").generateSecret(keySpec);
                    this.ecipher = Cipher.getInstance(key.getAlgorithm());
                    this.dcipher = Cipher.getInstance(key.getAlgorithm());
                    PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
                    this.ecipher.init(1, (Key)key, paramSpec);
                    this.dcipher.init(2, (Key)key, paramSpec);
                }
                catch (InvalidAlgorithmParameterException e) {
                }
                catch (InvalidKeySpecException e) {
                }
                catch (NoSuchPaddingException e) {
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (InvalidKeyException invalidKeyException) {
                    // empty catch block
                }
            }
        }

        public String encrypt(String str) {
            try {
                byte[] utf8 = str.getBytes("UTF8");
                byte[] newSalt = new byte[8];
                for (int i = 0; i < newSalt.length; ++i) {
                    newSalt[i] = (byte)(Math.random() * 256.0 - 128.0);
                }
                this.init(newSalt);
                byte[] enc = this.ecipher.doFinal(utf8);
                return Tools.toBase64(newSalt) + SALT_PRESENT_INDICATOR + Tools.toBase64(enc);
            }
            catch (BadPaddingException e) {
            }
            catch (IllegalBlockSizeException e) {
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public String decrypt(String str) {
            if (str == null) {
                return null;
            }
            try {
                byte[] salt = null;
                int indexOfSaltIndicator = str.indexOf(SALT_PRESENT_INDICATOR);
                if (indexOfSaltIndicator >= 0) {
                    String saltString = str.substring(0, indexOfSaltIndicator);
                    str = str.substring(indexOfSaltIndicator + 1);
                    salt = Tools.fromBase64(saltString);
                }
                byte[] dec = Tools.fromBase64(str);
                this.init(salt);
                byte[] utf8 = this.dcipher.doFinal(dec);
                return new String(utf8, "UTF8");
            }
            catch (BadPaddingException e) {
            }
            catch (IllegalBlockSizeException e) {
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }
}

