/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.schememode;

import freemind.controller.StructuredMenuHolder;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.actions.EditAction;
import freemind.modes.actions.NewMapAction;
import freemind.modes.schememode.SchemeMapModel;
import freemind.modes.schememode.SchemeNodeModel;
import freemind.modes.schememode.SchemePopupMenu;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class SchemeController
extends ControllerAdapter {
    Action newMap = new NewMapAction(this, this);
    Action open = new ControllerAdapter.OpenAction(this);
    Action save = new ControllerAdapter.SaveAction(this);
    Action saveAs = new ControllerAdapter.SaveAsAction(this);
    Action evaluate = new EvaluateAction();
    Action edit = new EditAction(this);
    private JPopupMenu popupmenu = new SchemePopupMenu(this);

    public SchemeController(Mode mode) {
        super(mode);
    }

    public MapAdapter newModel() {
        return new SchemeMapModel(this.getFrame());
    }

    public MindMapNode newNode(Object userObject) {
        return new SchemeNodeModel(this.getFrame());
    }

    public boolean saveAs() {
        int returnVal;
        JFileChooser chooser = null;
        chooser = this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null ? new JFileChooser(this.getMap().getFile().getParentFile()) : new JFileChooser();
        if (this.getFileFilter() != null) {
            chooser.addChoosableFileFilter(this.getFileFilter());
        }
        if ((returnVal = chooser.showSaveDialog(this.getView())) == 0) {
            File f = chooser.getSelectedFile();
            this.save(f);
            this.updateMapModuleName();
            return true;
        }
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void updateMenus(StructuredMenuHolder holder) {
        holder.addAction(this.newMap, "menu_bar/file/open/new");
        holder.addAction(this.open, "menu_bar/file/open/open");
        holder.addAction(this.save, "menu_bar/file/open/save");
        holder.addAction(this.saveAs, "menu_bar/file/open/saveAs");
        JMenuItem editItem = holder.addAction(this.edit, "menu_bar/edit/edit/editItem");
        editItem.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getProperty("keystroke_edit")));
        holder.addAction(this.evaluate, "menu_bar/edit/edit/evaluate");
        holder.addAction(this.toggleFolded, "menu_bar/edit/edit/toggleFolded");
    }

    private class EvaluateAction
    extends AbstractAction {
        EvaluateAction() {
            super(SchemeController.this.getController().getResourceString("scheme_evaluate"));
        }

        public void actionPerformed(ActionEvent e) {
            String rawCode = ((SchemeMapModel)SchemeController.this.getMap()).getCode().trim();
            System.out.println(rawCode);
            StringTokenizer code = new StringTokenizer(rawCode, ",");
            String output = "Output: \n";
            JOptionPane.showMessageDialog(SchemeController.this.getView(), output);
        }
    }
}

