/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class EditNodeBase {
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_SPLIT = 2;
    private NodeView node;
    private EditControl editControl;
    private Clipboard clipboard;
    private ModeController controller;
    private String text;
    protected FocusListener textFieldListener = null;

    EditNodeBase(NodeView node, String text, ModeController controller, EditControl editControl) {
        this.controller = controller;
        this.editControl = editControl;
        this.node = node;
        this.text = text;
    }

    protected MapView getView() {
        return this.controller.getView();
    }

    protected ModeController getModeController() {
        return this.controller;
    }

    protected Controller getController() {
        return this.controller.getController();
    }

    protected String getText(String string) {
        return this.controller.getController().getResourceString(string);
    }

    protected FreeMindMain getFrame() {
        return this.controller.getFrame();
    }

    protected boolean binOptionIsTrue(String option) {
        return Tools.safeEquals("true", option);
    }

    public void closeEdit() {
        if (this.textFieldListener != null) {
            this.textFieldListener.focusLost(null);
        }
    }

    protected String getText() {
        return this.text;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public EditControl getEditControl() {
        return this.editControl;
    }

    public NodeView getNode() {
        return this.node;
    }

    public FocusListener getTextFieldListener() {
        return this.textFieldListener;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTextFieldListener(FocusListener listener) {
        this.textFieldListener = listener;
    }

    protected class EditPopupMenu
    extends JPopupMenu {
        public EditPopupMenu(JTextComponent textComponent) {
            this.add(new EditCopyAction(textComponent));
        }
    }

    protected class EditCopyAction
    extends AbstractAction {
        private JTextComponent textComponent;

        public EditCopyAction(JTextComponent textComponent) {
            super(EditNodeBase.this.getText("copy"));
            this.textComponent = textComponent;
        }

        public void actionPerformed(ActionEvent e) {
            String selection = this.textComponent.getSelectedText();
            if (selection != null) {
                EditNodeBase.this.clipboard.setContents(new StringSelection(selection), null);
            }
        }
    }

    public static interface EditControl {
        public void cancel();

        public void ok(String var1);

        public void split(String var1, int var2);
    }
}

