/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.controller.NodeKeyListener;
import freemind.controller.NodeMotionListener;
import freemind.controller.NodeMouseMotionListener;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.ArrowLinkView;
import freemind.view.mindmapview.CloudView;
import freemind.view.mindmapview.MindMapLayout;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.PathBBox;
import freemind.view.mindmapview.RootNodeView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class MapView
extends JPanel
implements Printable {
    private static Logger logger;
    private DelayedScroller m_delayedScroller = new DelayedScroller();
    private MindMap model;
    private NodeView rootView;
    private Selected selected = new Selected();
    private Controller controller;
    private float zoom = 1.0f;
    private boolean disableMoveCursor = true;
    private int siblingMaxLevel;
    private boolean isPrinting = false;
    private NodeView shiftSelectionOrigin = null;
    private int maxNodeWidth = 0;
    private Color background = null;
    private Rectangle boundingRectangle = null;
    private boolean fitToPage = true;
    private boolean isPreparedForPrinting = false;
    private Vector ArrowLinkViews;
    private int FOLDING_SYMBOL_WIDTH = -1;

    public MapView(MindMap model, Controller controller) {
        this.model = model;
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        this.setAutoscrolls(true);
        this.getModel().addTreeModelListener(new MapModelHandler());
        this.setLayout(new MindMapLayout(this));
        this.initRoot();
        this.setBackground(this.getModel().getBackgroundColor());
        this.addMouseListener(controller.getMapMouseMotionListener());
        this.addMouseMotionListener(controller.getMapMouseMotionListener());
        this.addMouseWheelListener(controller.getMapMouseWheelListener());
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.setFocusTraversalKeys(2, Collections.EMPTY_SET);
        this.disableMoveCursor = Tools.safeEquals(controller.getProperty("disable_cursor_move_paper"), "true");
    }

    public void initRoot() {
        this.rootView = NodeView.newNodeView((MindMapNode)this.getModel().getRoot(), this);
        this.rootView.insert();
        this.getMindMapLayout().updateTreeHeightsAndRelativeYOfWholeMap();
        this.revalidate();
    }

    public int getMaxNodeWidth() {
        if (this.maxNodeWidth == 0) {
            try {
                this.maxNodeWidth = Integer.parseInt(this.controller.getProperty("max_node_width"));
            }
            catch (NumberFormatException e) {
                this.maxNodeWidth = Integer.parseInt(this.controller.getProperty("el__max_default_window_width"));
            }
        }
        return this.maxNodeWidth;
    }

    public void centerNode(NodeView node) {
        JViewport viewPort = (JViewport)this.getParent();
        Dimension d = viewPort.getExtentSize();
        if (!this.isValid()) {
            Rectangle r0 = new Rectangle(0, 0, d.width, d.height);
            this.scrollRectToVisible(r0);
        }
        Rectangle rect = new Rectangle(node.getLocation().x + node.getPreferredSize().width / 2 - d.width / 2, node.getLocation().y + node.getPreferredSize().height / 2 - d.height / 2, d.width, d.height);
        this.scrollRectToVisible(rect);
    }

    public void scrollNodeToVisible(NodeView node) {
        this.scrollNodeToVisible(node, 0);
    }

    public void scrollNodeToVisible(NodeView node, int extraWidth) {
        if (!node.isValid()) {
            this.m_delayedScroller.scrollNodeToVisible(this, node, extraWidth);
            return;
        }
        this.m_delayedScroller.deactivate();
        int HORIZ_SPACE = 10;
        int HORIZ_SPACE2 = 20;
        int VERT_SPACE = 5;
        int VERT_SPACE2 = 10;
        int x = node.getX();
        int width = node.getWidth();
        if (extraWidth < 0) {
            x += extraWidth;
            width -= extraWidth;
        } else {
            width += extraWidth;
        }
        int y = node.getY();
        int height = node.getHeight();
        if (node != null) {
            JViewport mapViewport = (JViewport)this.getParent();
            int viewPortScrollMode = mapViewport.getScrollMode();
            mapViewport.setScrollMode(0);
            this.scrollRectToVisible(new Rectangle(x - 10, node.getLocation().y - 5, width + 20, node.getSize().height + 10));
            mapViewport.setScrollMode(viewPortScrollMode);
        }
    }

    public Dimension getViewportSize() {
        JViewport mapViewport = (JViewport)this.getParent();
        return mapViewport == null ? null : mapViewport.getExtentSize();
    }

    public void scrollBy(int x, int y, boolean repaint) {
        JViewport mapViewport = (JViewport)this.getParent();
        if (mapViewport != null) {
            Point currentPoint = mapViewport.getViewPosition();
            currentPoint.translate(x, y);
            if (currentPoint.getX() < 0.0) {
                currentPoint.setLocation(0.0, currentPoint.getY());
            }
            if (currentPoint.getY() < 0.0) {
                currentPoint.setLocation(currentPoint.getX(), 0.0);
            }
            double maxX = this.getSize().getWidth() - mapViewport.getExtentSize().getWidth();
            double maxY = this.getSize().getHeight() - mapViewport.getExtentSize().getHeight();
            if (currentPoint.getX() > maxX) {
                currentPoint.setLocation(maxX, currentPoint.getY());
            }
            if (currentPoint.getY() > maxY) {
                currentPoint.setLocation(currentPoint.getX(), maxY);
            }
            int oldScrollMode = mapViewport.getScrollMode();
            if (repaint) {
                mapViewport.setScrollMode(0);
            }
            mapViewport.setViewPosition(currentPoint);
            if (repaint) {
                mapViewport.setScrollMode(oldScrollMode);
            }
        }
    }

    private NodeView getNeighbour(int directionCode) {
        NodeView oldSelected = this.getSelected();
        NodeView newSelected = null;
        switch (directionCode) {
            case 37: {
                this.setSiblingMaxLevel(oldSelected.getModel().getNodeLevel());
                if (oldSelected.isRoot()) {
                    LinkedList left = ((RootNodeView)oldSelected).getLeft();
                    if (left.size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                    if (!left.contains(newSelected)) {
                        newSelected = (NodeView)left.getFirst();
                    }
                } else if (!oldSelected.isLeft()) {
                    newSelected = oldSelected.getParentView();
                } else {
                    if (oldSelected.getModel().isFolded()) {
                        this.getController().getModeController().setFolded(oldSelected.getModel(), false);
                        return null;
                    }
                    if (oldSelected.getChildrenViews().size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                }
                this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel());
                break;
            }
            case 39: {
                this.setSiblingMaxLevel(oldSelected.getModel().getNodeLevel());
                if (oldSelected.isRoot()) {
                    LinkedList right = ((RootNodeView)oldSelected).getRight();
                    if (right.size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                    if (!right.contains(newSelected)) {
                        newSelected = (NodeView)right.getFirst();
                    }
                } else if (oldSelected.isLeft()) {
                    newSelected = oldSelected.getParentView();
                } else {
                    if (oldSelected.getModel().isFolded()) {
                        this.getController().getModeController().setFolded(oldSelected.getModel(), false);
                        return null;
                    }
                    if (oldSelected.getChildrenViews().size() == 0) {
                        return null;
                    }
                    newSelected = oldSelected.getModel().getPreferredChild().getViewer();
                }
                this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel());
                break;
            }
            case 38: {
                newSelected = oldSelected.getPreviousSibling();
                break;
            }
            case 40: {
                newSelected = oldSelected.getNextSibling();
                break;
            }
            case 33: {
                newSelected = oldSelected.getPreviousPage();
                break;
            }
            case 34: {
                newSelected = oldSelected.getNextPage();
            }
        }
        return newSelected;
    }

    public void move(KeyEvent e) {
        NodeView newSelected = this.getNeighbour(e.getKeyCode());
        if (newSelected != null) {
            this.extendSelectionWithKeyMove(newSelected, e);
            this.scrollNodeToVisible(newSelected);
            e.consume();
        }
    }

    private void extendSelectionWithKeyMove(NodeView newlySelectedNodeView, KeyEvent e) {
        if (e.isShiftDown()) {
            boolean enlargingMove;
            if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                this.shiftSelectionOrigin = null;
                NodeView toBeNewSelected = newlySelectedNodeView.isParentOf(this.getSelected()) ? newlySelectedNodeView : this.getSelected();
                this.selectBranch(toBeNewSelected, false);
                this.makeTheSelected(toBeNewSelected);
                return;
            }
            if (this.shiftSelectionOrigin == null) {
                this.shiftSelectionOrigin = this.getSelected();
            }
            int deltaY = newlySelectedNodeView.getY() - this.shiftSelectionOrigin.getY();
            NodeView currentSelected = this.getSelected();
            if (e.getKeyCode() == 33) {
                while (true) {
                    if (currentSelected.getY() > this.shiftSelectionOrigin.getY()) {
                        this.deselect(currentSelected);
                    } else {
                        this.makeTheSelected(currentSelected);
                    }
                    if (currentSelected.getY() <= newlySelectedNodeView.getY()) break;
                    currentSelected = currentSelected.getPreviousSibling();
                }
                return;
            }
            if (e.getKeyCode() == 34) {
                while (true) {
                    if (currentSelected.getY() < this.shiftSelectionOrigin.getY()) {
                        this.deselect(currentSelected);
                    } else {
                        this.makeTheSelected(currentSelected);
                    }
                    if (currentSelected.getY() >= newlySelectedNodeView.getY()) break;
                    currentSelected = currentSelected.getNextSibling();
                }
                return;
            }
            boolean bl = enlargingMove = deltaY > 0 && e.getKeyCode() == 40 || deltaY < 0 && e.getKeyCode() == 38;
            if (enlargingMove) {
                this.toggleSelected(newlySelectedNodeView);
            } else {
                this.toggleSelected(this.getSelected());
                this.makeTheSelected(newlySelectedNodeView);
            }
        } else {
            this.shiftSelectionOrigin = null;
            this.selectAsTheOnlyOneSelected(newlySelectedNodeView);
        }
    }

    public void moveToRoot() {
        this.selectAsTheOnlyOneSelected(this.getRoot());
        this.centerNode(this.getRoot());
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected) {
        LinkedList oldSelecteds = this.getSelecteds();
        this.selected.clear();
        this.selected.add(newSelected);
        newSelected.requestFocus();
        if (newSelected.getModel().getParentNode() != null) {
            newSelected.getModel().getParentNode().setPreferredChild(newSelected.getModel());
        }
        this.scrollNodeToVisible(newSelected);
        newSelected.repaint();
        ListIterator e = oldSelecteds.listIterator();
        while (e.hasNext()) {
            NodeView oldSelected = (NodeView)e.next();
            if (oldSelected == null) continue;
            oldSelected.repaint();
        }
    }

    public void toggleSelected(NodeView newSelected) {
        NodeView oldSelected = this.getSelected();
        if (this.isSelected(newSelected)) {
            if (this.selected.size() > 1) {
                this.selected.remove(newSelected);
                oldSelected = newSelected;
            }
        } else {
            this.selected.add(newSelected);
        }
        this.getSelected().requestFocus();
        this.getSelected().repaint();
        if (oldSelected != null) {
            oldSelected.repaint();
        }
    }

    public void makeTheSelected(NodeView newSelected) {
        if (this.isSelected(newSelected)) {
            this.selected.moveToFirst(newSelected);
        } else {
            this.selected.add(newSelected);
        }
        this.getSelected().requestFocus();
        this.getSelected().repaint();
    }

    public void deselect(NodeView newSelected) {
        if (this.isSelected(newSelected)) {
            this.selected.remove(newSelected);
            newSelected.repaint();
        }
    }

    public void selectBranch(NodeView newlySelectedNodeView, boolean extend) {
        if (!extend) {
            this.selectAsTheOnlyOneSelected(newlySelectedNodeView);
        } else if (!this.isSelected(newlySelectedNodeView)) {
            this.toggleSelected(newlySelectedNodeView);
        }
        ListIterator e = newlySelectedNodeView.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.selectBranch(target, true);
        }
    }

    public boolean selectContinuous(NodeView newSelected) {
        NodeView nodeView;
        NodeView nodeView2;
        NodeView oldSelected = null;
        LinkedList selList = this.getSelecteds();
        ListIterator j = selList.listIterator();
        while (j.hasNext()) {
            NodeView selectedNode = (NodeView)j.next();
            if (selectedNode == newSelected || !newSelected.isSiblingOf(selectedNode)) continue;
            oldSelected = selectedNode;
            break;
        }
        if (oldSelected == null) {
            if (!this.isSelected(newSelected)) {
                this.toggleSelected(newSelected);
                return true;
            }
            return false;
        }
        boolean oldPositionLeft = oldSelected.isLeft();
        boolean newPositionLeft = newSelected.isLeft();
        ListIterator i = newSelected.getSiblingViews().listIterator();
        while (i.hasNext() && (nodeView2 = (NodeView)i.next()) != oldSelected) {
        }
        ListIterator i_backup = i;
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft) continue;
            if (!this.isSelected(nodeView)) break;
            this.deselect(nodeView);
        }
        if ((i = i_backup).hasPrevious()) {
            i.previous();
            while (i.hasPrevious()) {
                nodeView = (NodeView)i.previous();
                if (nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft) continue;
                if (!this.isSelected(nodeView)) break;
                this.deselect(nodeView);
            }
        }
        i = newSelected.getSiblingViews().listIterator();
        i = newSelected.getSiblingViews().listIterator();
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (nodeView != newSelected && nodeView != oldSelected) continue;
            if (this.isSelected(nodeView)) break;
            this.toggleSelected(nodeView);
            break;
        }
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (!(nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft || this.isSelected(nodeView))) {
                this.toggleSelected(nodeView);
            }
            if (nodeView != newSelected && nodeView != oldSelected) continue;
            break;
        }
        this.toggleSelected(oldSelected);
        this.toggleSelected(oldSelected);
        return true;
    }

    public MindMap getModel() {
        return this.model;
    }

    public void setMoveCursor(boolean isHand) {
        int requiredCursor;
        int n = requiredCursor = isHand && !this.disableMoveCursor ? 13 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(new Cursor(requiredCursor));
        }
    }

    NodeMouseMotionListener getNodeMouseMotionListener() {
        return this.getController().getNodeMouseMotionListener();
    }

    NodeMotionListener getNodeMotionListener() {
        return this.getController().getNodeMotionListener();
    }

    NodeKeyListener getNodeKeyListener() {
        return this.getController().getNodeKeyListener();
    }

    DragGestureListener getNodeDragListener() {
        return this.getController().getNodeDragListener();
    }

    DropTargetListener getNodeDropListener() {
        return this.getController().getNodeDropListener();
    }

    public NodeView getSelected() {
        if (this.selected.size() > 0) {
            return this.selected.get(0);
        }
        return null;
    }

    private NodeView getSelected(int i) {
        return this.selected.get(i);
    }

    public LinkedList getSelecteds() {
        LinkedList<NodeView> result = new LinkedList<NodeView>();
        for (int i = 0; i < this.selected.size(); ++i) {
            result.add(this.getSelected(i));
        }
        return result;
    }

    public ArrayList getSelectedsSortedByY() {
        TreeMap<Integer, NodeView> sortedNodes = new TreeMap<Integer, NodeView>();
        for (int i = 0; i < this.selected.size(); ++i) {
            sortedNodes.put(new Integer(this.getSelected(i).getY()), this.getSelected(i));
        }
        ArrayList selectedNodes = new ArrayList();
        Iterator it = sortedNodes.entrySet().iterator();
        while (it.hasNext()) {
            selectedNodes.add(it.next().getValue());
        }
        return selectedNodes;
    }

    public ArrayList getSelectedNodesSortedByY() {
        TreeMap<Integer, MindMapNode> sortedNodes = new TreeMap<Integer, MindMapNode>();
        for (int i = 0; i < this.selected.size(); ++i) {
            sortedNodes.put(new Integer(this.getSelected(i).getY()), this.getSelected(i).getModel());
        }
        ArrayList selectedNodes = new ArrayList();
        Iterator it = sortedNodes.entrySet().iterator();
        while (it.hasNext()) {
            selectedNodes.add(it.next().getValue());
        }
        return selectedNodes;
    }

    public boolean isSelected(NodeView n) {
        if (this.isPrinting) {
            return false;
        }
        return this.selected.contains(n);
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getZoomed(int number) {
        return (int)((float)number * this.zoom);
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.getRoot().updateAll();
        this.getMindMapLayout().updateTreeHeightsAndRelativeYOfWholeMap();
        this.getMindMapLayout().layout(true);
        this.repaint();
    }

    public void paintChildren(Graphics graphics) {
        this.paintClouds(this.rootView, graphics);
        HashMap labels = new HashMap();
        this.ArrowLinkViews = new Vector();
        this.collectLabels(this.rootView, labels);
        this.paintLinks(this.rootView, (Graphics2D)graphics, labels, null);
        super.paintChildren(graphics);
        this.paintEdges(this.rootView, (Graphics2D)graphics);
    }

    protected void paintClouds(NodeView source, Graphics graphics) {
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            if (target.getModel().getCloud() != null) {
                CloudView cloud = new CloudView(target.getModel().getCloud(), target);
                cloud.paint(graphics);
            }
            this.paintClouds(target, graphics);
        }
    }

    protected void collectLabels(NodeView source, HashMap labels) {
        if (this.getModel().getLinkRegistry() == null) {
            return;
        }
        String label = this.getModel().getLinkRegistry().getLabel(source.getModel());
        if (label != null) {
            labels.put(label, source);
        }
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.collectLabels(target, labels);
        }
    }

    protected void paintLinks(NodeView source, Graphics2D graphics, HashMap labels, HashSet LinkAlreadyVisited) {
        if (this.getModel().getLinkRegistry() == null) {
            return;
        }
        if (LinkAlreadyVisited == null) {
            LinkAlreadyVisited = new HashSet<MindMapLink>();
        }
        Vector vec = this.getModel().getLinkRegistry().getAllLinks(source.getModel());
        for (int i = 0; i < vec.size(); ++i) {
            MindMapLink ref = (MindMapLink)vec.get(i);
            if (!LinkAlreadyVisited.add(ref) || !(ref instanceof MindMapArrowLink)) continue;
            ArrowLinkView arrowLink = new ArrowLinkView((MindMapArrowLink)ref, ref.getSource().getViewer(), ref.getTarget().getViewer());
            arrowLink.paint(graphics);
            this.ArrowLinkViews.add(arrowLink);
            Rectangle rec = arrowLink.getBounds();
        }
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.paintLinks(target, graphics, labels, LinkAlreadyVisited);
        }
    }

    public MindMapArrowLink detectCollision(Point p) {
        if (this.ArrowLinkViews == null) {
            return null;
        }
        for (int i = 0; i < this.ArrowLinkViews.size(); ++i) {
            ArrowLinkView arrowView = (ArrowLinkView)this.ArrowLinkViews.get(i);
            if (!arrowView.detectCollision(p)) continue;
            return arrowView.getModel();
        }
        return null;
    }

    public void preparePrinting() {
        this._preparePrinting();
        this.isPreparedForPrinting = true;
    }

    private void _preparePrinting() {
        if (!this.isPreparedForPrinting) {
            this.isPrinting = true;
            this.setZoom(this.getZoom());
            this.background = this.getBackground();
            this.boundingRectangle = this.getInnerBounds(this.rootView);
        }
    }

    public void endPrinting() {
        this.isPreparedForPrinting = false;
        this._endPrinting();
    }

    private void _endPrinting() {
        if (!this.isPreparedForPrinting) {
            this.setBackground(this.background);
            this.isPrinting = false;
            this.setZoom(this.getZoom());
            this.fitToPage = Tools.safeEquals(this.controller.getProperty("fit_to_page"), "true");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double userZoomFactor = 1.0;
        try {
            userZoomFactor = Double.parseDouble(this.controller.getProperty("user_zoom"));
        }
        catch (Exception e) {
            // empty catch block
        }
        userZoomFactor = Math.max(0.0, userZoomFactor);
        userZoomFactor = Math.min(2.0, userZoomFactor);
        if (this.fitToPage && pageIndex > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this._preparePrinting();
        double zoomFactor = 1.0;
        if (this.fitToPage) {
            double zoomFactorX = pageFormat.getImageableWidth() / this.boundingRectangle.getWidth();
            double zoomFactorY = pageFormat.getImageableHeight() / this.boundingRectangle.getHeight();
            zoomFactor = Math.min(zoomFactorX, zoomFactorY);
        } else {
            int nrPagesInHeight;
            zoomFactor = userZoomFactor;
            int nrPagesInWidth = (int)Math.ceil(zoomFactor * this.boundingRectangle.getWidth() / pageFormat.getImageableWidth());
            if (pageIndex >= nrPagesInWidth * (nrPagesInHeight = (int)Math.ceil(zoomFactor * this.boundingRectangle.getHeight() / pageFormat.getImageableHeight()))) {
                return 1;
            }
            int yPageCoord = (int)Math.floor(pageIndex / nrPagesInWidth);
            int xPageCoord = pageIndex - yPageCoord * nrPagesInWidth;
            graphics2D.translate(-pageFormat.getImageableWidth() * (double)xPageCoord, -pageFormat.getImageableHeight() * (double)yPageCoord);
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.scale(zoomFactor, zoomFactor);
        graphics2D.translate(-this.boundingRectangle.getX(), -this.boundingRectangle.getY());
        this.print(graphics2D);
        this._endPrinting();
        return 0;
    }

    public boolean isCurrentlyPrinting() {
        return this.isPrinting;
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public Rectangle getInnerBounds(NodeView source) {
        Rectangle innerBounds = source.getBounds();
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            innerBounds.add(this.getInnerBounds(target));
        }
        int additionalCloudHeigth = (source.getAdditionalCloudHeigth() + 1) / 2;
        if (additionalCloudHeigth != 0) {
            innerBounds.grow(additionalCloudHeigth, additionalCloudHeigth);
        }
        if (source.getModel().isRoot()) {
            for (int i = 0; i < this.ArrowLinkViews.size(); ++i) {
                ArrowLinkView arrowView = (ArrowLinkView)this.ArrowLinkViews.get(i);
                Rectangle arrowViewBigBounds = arrowView.arrowLinkCurve.getBounds();
                if (innerBounds.contains(arrowViewBigBounds)) continue;
                Rectangle arrowViewBounds = PathBBox.getBBox(arrowView.arrowLinkCurve).getBounds();
                innerBounds.add(arrowViewBounds);
            }
        }
        return innerBounds;
    }

    private void paintEdges(NodeView source, Graphics2D g) {
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            target.getEdge().paint(g);
            this.paintEdges(target, g);
        }
    }

    protected NodeView getRoot() {
        return this.rootView;
    }

    private MindMapLayout getMindMapLayout() {
        return (MindMapLayout)this.getLayout();
    }

    private MapView getMap() {
        return this;
    }

    public Controller getController() {
        return this.controller;
    }

    public int getSiblingMaxLevel() {
        return this.siblingMaxLevel;
    }

    public void setSiblingMaxLevel(int level) {
        this.siblingMaxLevel = level;
    }

    public int getZoomedFoldingSymbolHalfWidth() {
        if (this.FOLDING_SYMBOL_WIDTH == -1) {
            this.FOLDING_SYMBOL_WIDTH = this.getController().getIntProperty("foldingsymbolwidth", 8);
        }
        return (int)((float)this.FOLDING_SYMBOL_WIDTH * this.getZoom() / 2.0f);
    }

    private class MapModelHandler
    implements TreeModelListener {
        private MapModelHandler() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            NodeView nodeView;
            MapView.this.setBackground(MapView.this.getModel().getBackgroundColor());
            try {
                nodeView = ((MindMapNode)e.getChildren()[0]).getViewer();
            }
            catch (Exception ex) {
                nodeView = ((MindMapNode)e.getTreePath().getLastPathComponent()).getViewer();
            }
            if (nodeView != null) {
                logger.finest("The update node is " + nodeView + " with treemodelevent=" + e);
                nodeView.update();
                MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(nodeView);
                MapView.this.getMindMapLayout().layout(true);
                MapView.this.repaint();
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
            MindMapNode parent = (MindMapNode)e.getTreePath().getLastPathComponent();
            NodeView parentView = parent.getViewer();
            MindMapNode child = (MindMapNode)e.getChildren()[0];
            if (child != null) {
                parentView.insert(child);
                MapView.this.getMindMapLayout().updateTreeGeometry(child.getViewer());
            }
            MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfAncestors(parentView);
            MapView.this.getMindMapLayout().layout(false);
            child.getViewer().requestFocus();
            MapView.this.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            NodeView node = ((MindMapNode)e.getChildren()[0]).getViewer();
            NodeView parent = ((MindMapNode)e.getTreePath().getLastPathComponent()).getViewer();
            if (node == null) {
                System.err.println("MapView.treeNodesRemoved tried to delete null as node.");
                return;
            }
            node.remove();
            MindMapNode preferred = parent.getModel().getPreferredChild();
            if (preferred != null) {
                MapView.this.selectAsTheOnlyOneSelected(preferred.getViewer());
            } else {
                MapView.this.selectAsTheOnlyOneSelected(parent);
            }
            MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfAncestors(parent);
            MapView.this.getMindMapLayout().layout(false);
            MapView.this.getSelected().requestFocus();
            MapView.this.repaint();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            MindMapNode subtreeRoot;
            ArrayList<MindMapNode> selectedNodes = new ArrayList<MindMapNode>();
            ListIterator it = MapView.this.getSelecteds().listIterator();
            while (it.hasNext()) {
                NodeView nodeView = (NodeView)it.next();
                if (nodeView == null) continue;
                selectedNodes.add(nodeView.getModel());
            }
            MindMapNode focussedNode = null;
            if (MapView.this.getSelected() != null) {
                focussedNode = MapView.this.getSelected().getModel();
            }
            if ((subtreeRoot = (MindMapNode)e.getTreePath().getLastPathComponent()) != null && subtreeRoot.getViewer() != null) {
                boolean nodeIsLeft = subtreeRoot.getViewer().isLeft();
                NodeView oldNodeView = subtreeRoot.getViewer();
                int x = oldNodeView.getX();
                int y = oldNodeView.getY();
                subtreeRoot.getViewer().remove();
                NodeView nodeView = null;
                if (subtreeRoot.isRoot()) {
                    nodeView = NodeView.newNodeView(MapView.this.getRoot().getModel(), MapView.this.getMap());
                    MapView.this.rootView = nodeView;
                } else {
                    nodeView = NodeView.newNodeView(subtreeRoot, MapView.this.getMap());
                }
                nodeView.setLocation(x, y);
                nodeView.setLeft(nodeIsLeft);
                nodeView.insert();
                MapView.this.getMindMapLayout().updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(subtreeRoot.getViewer());
            }
            MapView.this.selected.clear();
            ListIterator it2 = selectedNodes.listIterator();
            while (it2.hasNext()) {
                MindMapNode mindMapNode = (MindMapNode)it2.next();
                if (mindMapNode.getViewer() == null) continue;
                MapView.this.selected.add(mindMapNode.getViewer());
            }
            if (focussedNode == null) {
                focussedNode = MapView.this.getRoot().getModel();
            }
            while (focussedNode.getParentNode() != null && focussedNode.getViewer() == null) {
                focussedNode = focussedNode.getParentNode();
            }
            if (focussedNode.getParentNode() == null && !focussedNode.equals(MapView.this.getRoot().getModel())) {
                focussedNode = MapView.this.getRoot().getModel();
            }
            focussedNode.getViewer().requestFocus();
            MapView.this.repaint();
        }
    }

    private class DelayedScroller
    extends ComponentAdapter {
        MapView m_map = null;
        NodeView m_node = null;
        int m_extraWidth = 0;

        private DelayedScroller() {
        }

        public void componentMoved(ComponentEvent e) {
            if (this.m_map != null) {
                this.m_map.scrollNodeToVisible(this.m_node, this.m_extraWidth);
            }
            this.m_map = null;
            this.m_node = null;
        }

        public void scrollNodeToVisible(MapView map, NodeView node, int extraWidth) {
            this.deactivate();
            this.m_map = map;
            this.m_node = node;
            this.m_extraWidth = extraWidth;
            node.addComponentListener(this);
        }

        public void deactivate() {
            if (this.m_node != null) {
                this.m_node.removeComponentListener(this);
            }
        }
    }

    private class Selected {
        private Vector mySelected = new Vector();

        public void clear() {
            if (this.size() > 0) {
                this.removeSelectionForHooks(this.get(0));
            }
            this.mySelected.clear();
            logger.finest("Cleared selected.");
        }

        public int size() {
            return this.mySelected.size();
        }

        public void remove(NodeView node) {
            if (this.mySelected.indexOf(node) == 0) {
                this.removeSelectionForHooks(node);
            }
            this.mySelected.remove(node);
            logger.finest("Removed selected " + node);
        }

        public void add(NodeView node) {
            if (this.size() > 0) {
                this.removeSelectionForHooks(this.get(0));
            }
            this.mySelected.add(0, node);
            this.addSelectionForHooks(node);
            logger.finest("Added selected " + node + "\nAll=" + this.mySelected);
        }

        private void removeSelectionForHooks(NodeView node) {
            if (node.getModel() == null) {
                return;
            }
            Iterator i = node.getModel().getActivatedHooks().iterator();
            while (i.hasNext()) {
                PermanentNodeHook hook = (PermanentNodeHook)i.next();
                hook.onLooseFocusHook();
            }
        }

        private void addSelectionForHooks(NodeView node) {
            Iterator i = node.getModel().getActivatedHooks().iterator();
            while (i.hasNext()) {
                PermanentNodeHook hook = (PermanentNodeHook)i.next();
                hook.onReceiveFocusHook();
            }
        }

        public NodeView get(int i) {
            return (NodeView)this.mySelected.get(i);
        }

        public boolean contains(NodeView node) {
            return this.mySelected.contains(node);
        }

        public void moveToFirst(NodeView newSelected) {
            if (this.contains(newSelected)) {
                int pos = this.mySelected.indexOf(newSelected);
                if (pos > 0) {
                    if (this.size() > 0) {
                        this.removeSelectionForHooks(this.get(0));
                    }
                    this.mySelected.remove(newSelected);
                    this.mySelected.add(0, newSelected);
                }
            } else {
                this.add(newSelected);
            }
            this.addSelectionForHooks(newSelected);
            logger.finest("MovedToFront selected " + newSelected + "\nAll=" + this.mySelected);
        }
    }
}

