/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.FreeMindMain;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.RootNodeView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.JLabel;

public class MindMapLayout
implements LayoutManager {
    private static final int BORDER = 30;
    public static final int MINIMAL_LEAF_WIDTH = 150;
    public static final int MINIMAL_WIDTH = 50;
    private MapView map;
    private int ySize;
    private int xSize;
    private int rootX = 0;
    private int rootY = 0;

    public MindMapLayout(MapView map) {
        this.map = map;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void layoutContainer(Container parent) {
        this.layout(true);
    }

    public void layout(boolean holdSelected) {
        NodeView selected = this.map.getSelected();
        holdSelected = holdSelected && selected != null && selected.getX() != 0 && selected.getY() != 0;
        int oldRootX = this.getRoot().getX();
        int oldRootY = holdSelected ? selected.getY() : this.getRoot().getY();
        this.resizeMap(this.getRoot().getTreeWidth(), this.getRoot().getTreeHeight());
        this.layout(this.map.getRoot());
        try {
            int rootX = this.getRoot().getX();
            int rootY = holdSelected ? selected.getY() : this.getRoot().getY();
            this.getMapView().scrollBy(rootX - oldRootX, rootY - oldRootY, true);
        }
        catch (IllegalComponentStateException e) {
            // empty catch block
        }
    }

    private void layout(NodeView node) {
        int x = 0;
        int hgap = node.getHGap();
        x = node.isRoot() ? 0 : (node.isLeft() ? -hgap - node.getPreferredSize().width : node.getParentView().getPreferredSize().width + hgap);
        this.placeNode(node, x, node.relYPos);
        ListIterator e = node.getChildrenViews().listIterator();
        while (e.hasNext()) {
            this.layout((NodeView)e.next());
        }
    }

    private void placeNode(NodeView node, int relativeX, int relativeY) {
        if (node.isRoot()) {
            node.setBounds(this.getRootX(), this.getRootY());
        } else {
            Point start;
            int x = node.getParentView().getX() + relativeX;
            int y = node.getParentView().getY() + relativeY;
            node.setBounds(x, y);
            JLabel label = node.getEdge().getLabel();
            Point end = node.getInPoint();
            node.getEdge().start = start = node.getParentView().getOutPoint(end, node.isLeft());
            node.getEdge().end = end;
            int relX = (start.x - end.x) / 2;
            int absX = start.x - relX;
            int relY = (start.y - end.y) / 2;
            int absY = start.y - relY;
            label.setBounds(absX - label.getPreferredSize().width / 2, absY - label.getPreferredSize().height / 2, label.getPreferredSize().width, label.getPreferredSize().height);
        }
    }

    private int getRootY() {
        return this.calcYBorderSize() / 2 + this.getRoot().getUpperChildShift();
    }

    private int getRootX() {
        return this.calcXBorderSize() / 2 + this.getRoot().getLeftTreeWidth();
    }

    private void resizeMap(int width, int height) {
        boolean bResized = false;
        int oldXSize = this.getXSize();
        int oldYSize = this.getYSize();
        int minXSize = width + this.calcXBorderSize();
        int minYSize = height + this.calcYBorderSize();
        if (minXSize != this.getXSize()) {
            this.setXSize(minXSize);
            bResized = true;
        }
        if (minYSize != this.getYSize()) {
            this.setYSize(minYSize);
            bResized = true;
        }
        if (bResized) {
            this.getMapView().setSize(this.getXSize(), this.getYSize());
        }
    }

    private int calcYBorderSize() {
        Dimension visibleSize = this.map.getViewportSize();
        int yBorderSize = visibleSize != null ? 2 * Math.max(visibleSize.height, 30) : 60;
        return yBorderSize;
    }

    private int calcXBorderSize() {
        Dimension visibleSize = this.map.getViewportSize();
        int xBorderSize = visibleSize != null ? Math.max(visibleSize.width, 360) : 360;
        return xBorderSize;
    }

    void updateTreeHeightsAndRelativeYOfDescendantsAndAncestors(NodeView node) {
        this.updateTreeHeightsAndRelativeYOfDescendants(node);
        if (!node.isRoot()) {
            this.updateTreeHeightsAndRelativeYOfAncestors(node.getParentView());
        }
    }

    void updateTreeHeightsAndRelativeYOfAncestors(NodeView node) {
        this.updateTreeGeometry(node);
        if (!node.isRoot()) {
            this.updateTreeHeightsAndRelativeYOfAncestors(node.getParentView());
        }
    }

    void updateTreeHeightsAndRelativeYOfWholeMap() {
        this.updateTreeHeightsAndRelativeYOfDescendants(this.getRoot());
        this.layout(false);
    }

    void updateTreeHeightsAndRelativeYOfDescendants(NodeView node) {
        ListIterator e = node.getChildrenViews().listIterator();
        while (e.hasNext()) {
            this.updateTreeHeightsAndRelativeYOfDescendants((NodeView)e.next());
        }
        this.updateTreeGeometry(node);
    }

    private void updateRelativeYOfChildren(NodeView node, LinkedList childrenViews) {
        ListIterator e = childrenViews.listIterator();
        if (!e.hasNext()) {
            return;
        }
        int vgap = node.getVGap();
        NodeView child = (NodeView)childrenViews.getFirst();
        int pointer = 0;
        int upperShift = 0;
        while (e.hasNext()) {
            child = (NodeView)e.next();
            int shiftUp = this.getShiftUp(child);
            int shiftDown = this.getShiftDown(child);
            int iAdditionalCloudHeigth = child.getAdditionalCloudHeigth();
            int upperChildShift = child.getUpperChildShift();
            child.relYPos = pointer + upperChildShift + iAdditionalCloudHeigth / 2 + shiftDown;
            upperShift += upperChildShift + shiftUp;
            pointer += child.getTreeHeight() + shiftUp + shiftDown + iAdditionalCloudHeigth + vgap;
        }
        upperShift += this.calcStandardTreeShift(node, childrenViews);
        while (e.hasPrevious()) {
            child = (NodeView)e.previous();
            child.relYPos -= upperShift;
        }
    }

    protected int getShiftUp(NodeView node) {
        int shift = node.getShift();
        if (shift < 0) {
            return -shift;
        }
        return 0;
    }

    protected int getShiftDown(NodeView node) {
        int shift = node.getShift();
        if (shift > 0) {
            return shift;
        }
        return 0;
    }

    protected void updateTreeGeometry(NodeView node) {
        if (node.isRoot()) {
            LinkedList leftNodeViews = this.getRoot().getLeft();
            LinkedList rightNodeViews = this.getRoot().getRight();
            int leftWidth = this.calcTreeWidth(node, leftNodeViews);
            int rightWidth = this.calcTreeWidth(node, rightNodeViews);
            this.getRoot().setRootTreeWidths(leftWidth, rightWidth);
            this.updateRelativeYOfChildren(node, leftNodeViews);
            this.updateRelativeYOfChildren(node, rightNodeViews);
            int leftTreeShift = this.calcUpperChildShift(node, leftNodeViews);
            int rightTreeShift = this.calcUpperChildShift(node, rightNodeViews);
            this.getRoot().setRootUpperChildShift(leftTreeShift, rightTreeShift);
            int leftTreeHeight = this.calcTreeHeight(node, leftTreeShift, leftNodeViews);
            int rightTreeHeight = this.calcTreeHeight(node, rightTreeShift, rightNodeViews);
            this.getRoot().setRootTreeHeights(leftTreeHeight, rightTreeHeight);
        } else {
            LinkedList childrenViews = node.getChildrenViews();
            int treeWidth = this.calcTreeWidth(node, childrenViews);
            node.setTreeWidth(treeWidth);
            this.updateRelativeYOfChildren(node, childrenViews);
            int treeShift = this.calcUpperChildShift(node, childrenViews);
            node.setUpperChildShift(treeShift);
            int treeHeight = this.calcTreeHeight(node, treeShift, childrenViews);
            node.setTreeHeight(treeHeight);
        }
    }

    private int calcUpperChildShift(NodeView node, LinkedList childrenViews) {
        try {
            NodeView firstChild = (NodeView)childrenViews.getFirst();
            int childShift = -firstChild.relYPos + firstChild.getAdditionalCloudHeigth() / 2 + firstChild.getUpperChildShift();
            return childShift > 0 ? childShift : 0;
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    private int calcStandardTreeShift(NodeView parent, LinkedList childrenViews) {
        int parentHeight = parent.getPreferredSize().height;
        if (childrenViews == null || childrenViews.size() == 0) {
            return 0;
        }
        int height = 0;
        int vgap = parent.getVGap();
        ListIterator e = childrenViews.listIterator();
        while (e.hasNext()) {
            NodeView node = (NodeView)e.next();
            if (node == null) continue;
            height += node.getPreferredSize().height + vgap + node.getAdditionalCloudHeigth();
        }
        return Math.max(height - vgap - parentHeight, 0) / 2;
    }

    private int calcTreeHeight(NodeView parent, int treeShift, LinkedList childrenViews) {
        int parentHeight = parent.getPreferredSize().height;
        try {
            NodeView firstChild = (NodeView)childrenViews.getFirst();
            NodeView lastChild = (NodeView)childrenViews.getLast();
            int minY = Math.min(firstChild.relYPos - firstChild.getUpperChildShift() - firstChild.getAdditionalCloudHeigth() / 2, 0);
            int maxY = Math.max(lastChild.relYPos - lastChild.getUpperChildShift() + lastChild.getTreeHeight() + lastChild.getAdditionalCloudHeigth() / 2, parentHeight);
            return maxY - minY;
        }
        catch (NoSuchElementException e) {
            return parentHeight;
        }
    }

    private int calcTreeWidth(NodeView parent, LinkedList childrenViews) {
        int treeWidth = 0;
        ListIterator e = childrenViews.listIterator();
        while (e.hasNext()) {
            int childWidth;
            NodeView childNode = (NodeView)e.next();
            if (childNode == null || (childWidth = childNode.getTreeWidth() + childNode.getHGap()) <= treeWidth) continue;
            treeWidth = childWidth;
        }
        return parent.getPreferredSize().width + 2 * parent.getAdditionalCloudHeigth() + treeWidth;
    }

    private RootNodeView getRoot() {
        return (RootNodeView)this.map.getRoot();
    }

    private MapView getMapView() {
        return this.map;
    }

    private FreeMindMain getFrame() {
        return this.map.getController().getFrame();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(200, 200);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.getXSize(), this.getYSize());
    }

    private int getXSize() {
        return this.xSize;
    }

    private int getYSize() {
        return this.ySize;
    }

    private void setXSize(int i) {
        this.xSize = i;
    }

    private void setYSize(int i) {
        this.ySize = i;
    }
}

