/*
 * Decompiled with CFR 0.152.
 */
package plugins.time;

import freemind.extensions.PermanentNodeHook;
import freemind.extensions.PermanentNodeHookAdapter;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ReminderHook
extends PermanentNodeHookAdapter {
    private static final int CLOCK_INVISIBLE = 0;
    private static final int CLOCK_VISIBLE = 1;
    private static final int REMOVE_CLOCK = -1;
    private static final String REMINDUSERAT = "REMINDUSERAT";
    private long remindUserAt = 0L;
    private Timer timer;
    private static ImageIcon clockIcon = null;
    private static ImageIcon bellIcon;
    private static ImageIcon flagIcon;
    private final String STATE_TOOLTIP = (class$plugins$time$ReminderHook$TimerBlinkTask == null ? (class$plugins$time$ReminderHook$TimerBlinkTask = ReminderHook.class$("plugins.time.ReminderHook$TimerBlinkTask")) : class$plugins$time$ReminderHook$TimerBlinkTask).getName() + "_STATE_";
    static /* synthetic */ Class class$plugins$time$ReminderHook$TimerBlinkTask;

    public void loadFrom(XMLElement child) {
        super.loadFrom(child);
        HashMap hash = this.loadNameValuePairs(child);
        if (hash.containsKey(REMINDUSERAT)) {
            String remindAt = (String)hash.get(REMINDUSERAT);
            this.setRemindUserAt(new Long(remindAt));
        }
    }

    public void save(XMLElement xml) {
        super.save(xml);
        HashMap<String, Long> nameValuePairs = new HashMap<String, Long>();
        nameValuePairs.put(REMINDUSERAT, new Long(this.remindUserAt));
        this.saveNameValuePairs(nameValuePairs, xml);
    }

    public void shutdownMapHook() {
        this.getController().setToolTip(this.getNode(), this.getName(), null);
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.displayState(-1, this.getNode(), true);
        super.shutdownMapHook();
    }

    public void invoke(MindMapNode node) {
        super.invoke(node);
        if (this.remindUserAt == 0L) {
            return;
        }
        if (this.timer == null) {
            this.scheduleTimer(node);
        }
    }

    private void scheduleTimer(MindMapNode node) {
        this.scheduleTimer(node, new TimerBlinkTask(false));
    }

    private void scheduleTimer(MindMapNode node, TimerTask task) {
        this.timer = new Timer();
        Date date = new Date(this.remindUserAt);
        this.timer.schedule(task, date);
        Object[] messageArguments = new Object[]{date};
        MessageFormat formatter = new MessageFormat(this.getResourceString("plugins/TimeManagement.xml_reminderNode_tooltip"));
        String message = formatter.format(messageArguments);
        this.getController().setToolTip(node, this.getName(), message);
        this.displayState(1, this.getNode(), false);
    }

    private ImageIcon getClockIcon() {
        if (clockIcon == null) {
            clockIcon = MindIcon.factory((String)"clock").getIcon(this.getController().getFrame());
        }
        return clockIcon;
    }

    private ImageIcon getBellIcon() {
        if (bellIcon == null) {
            bellIcon = MindIcon.factory((String)"bell").getIcon(this.getController().getFrame());
        }
        return bellIcon;
    }

    private ImageIcon getFlagIcon() {
        if (flagIcon == null) {
            flagIcon = MindIcon.factory((String)"flag").getIcon(this.getController().getFrame());
        }
        return flagIcon;
    }

    public String getStateKey() {
        return this.STATE_TOOLTIP + this.getNode().getObjectId(this.getController());
    }

    public void displayState(int stateAdded, MindMapNode node, boolean recurse) {
        ImageIcon icon = null;
        if (stateAdded == 1) {
            icon = this.getClockIcon();
        } else if (stateAdded == 0) {
            icon = node == this.getNode() ? this.getBellIcon() : this.getFlagIcon();
        }
        node.setStateIcon(this.getStateKey(), icon);
        this.getController().nodeRefresh(node);
        if (recurse && !node.isRoot()) {
            this.displayState(stateAdded, node.getParentNode(), recurse);
        }
    }

    public long getRemindUserAt() {
        return this.remindUserAt;
    }

    public void setRemindUserAt(long remindUserAt) {
        this.remindUserAt = remindUserAt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TimerBlinkTask
    extends TimerTask {
        private boolean stateAdded = false;

        public TimerBlinkTask(boolean stateAdded) {
            this.stateAdded = stateAdded;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TimerBlinkTask.this.stateAdded = !TimerBlinkTask.this.stateAdded;
                    ReminderHook.this.setRemindUserAt(System.currentTimeMillis() + 3000L);
                    ReminderHook.this.scheduleTimer(ReminderHook.this.getNode(), new TimerBlinkTask(TimerBlinkTask.this.stateAdded));
                    ReminderHook.this.displayState(TimerBlinkTask.this.stateAdded ? 1 : 0, ReminderHook.this.getNode(), true);
                }
            });
        }
    }

    protected class CheckReminder
    extends TimerTask {
        CheckReminder() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ReminderHook.this.getController().centerNode(ReminderHook.this.getNode());
                    Object[] messageArguments = new Object[]{ReminderHook.this.getNode().getShortText(ReminderHook.this.getController())};
                    MessageFormat formatter = new MessageFormat(ReminderHook.this.getResourceString("plugins/TimeManagement.xml_reminderNode_showNode"));
                    String message = formatter.format(messageArguments);
                    int result = JOptionPane.showConfirmDialog(ReminderHook.this.getController().getFrame().getJFrame(), message, "Freemind", 0);
                    if (result == 0) {
                        ReminderHook.this.setRemindUserAt(System.currentTimeMillis() + 600000L);
                        ReminderHook.this.scheduleTimer(ReminderHook.this.getNode());
                        return;
                    }
                    ReminderHook.this.nodeChanged(ReminderHook.this.getNode());
                    ReminderHook.this.getNode().removeHook((PermanentNodeHook)ReminderHook.this);
                }
            });
        }
    }
}

