#!/usr/bin/perl -w

# This script counts on the mailto: having a somewhat reasonable format...
#  it is likely that a sneaky user could do shell injection tricks here,
#  and we don't stop them. Send patches.

# This needs to be in your prefs.js file in firefox:
#user_pref("network.protocol-handler.expose.mailto", true);
#user_pref("network.protocol-handler.app.mailto", "/where/i/copied/mailto-balsa.pl");

use warnings;
use strict;

sub find_in_path {
    my $bin = shift;

    # If binary has absolute or relative path, don't search $PATH...
    if ($bin =~ /\//) {
        if (-x $bin) {
            return $bin;
        } else {
            return undef;
        }
    }

    # Search the $PATH...
    my @paths = split /:/,$ENV{'PATH'};
    foreach (@paths) {
        my $full = "$_/$bin";
        return $full if (-x $full);
    }

    return undef;  # not in $PATH.
}

sub find_installed_name {
    my $product = shift;
    my @names = @_;
    foreach (@names) {
        my $fname = find_in_path($_);
        return $fname if defined $fname;
    }

    print STDERR "Can't find $product in \$PATH. Giving up.\n";
    exit 1
}

sub cleanup_arg {
    my $prearg = shift;
    my $arg = shift;

    # Trim whitespace.
    $arg =~ s/\A\s*?//;
    $arg =~ s/\s*?\Z//;

    return '' if (($prearg eq '') and ($arg eq ''));

    # Prevent shell injection, I hope.
    $arg =~ s/\\/\\\\/g;
    $arg =~ s/\'/\\'/g;

    $prearg .= ' ' if ($prearg ne '');

    return " $prearg'$arg'";
}


# Mainline ...

die("USAGE: $0 <mailto:url>\n") if (scalar @ARGV != 1);
my $mailexe = find_installed_name('Balsa', 'balsa');
my $mailto = $ARGV[0];
$mailto =~ s/\Amailto\://;

my $to = '';
my $args = '';

if ( $mailto =~ /\A(.*?)\?(.*)\Z/ ) {
    $to = $1;
    $args = $2;
} else {
    # assume whole thing is the To: address.
    $to = $mailto;
}

my $comma = '';
my $cmdline = "$mailexe --compose '$to" . '?';

my $andstr = '';
my @attachments;
my @pairs = split /\&/, $args;
foreach my $pair (@pairs) {
   if($pair=~m/([^=]+)=(.*)/) {
      my $field = $1;
      my $value = $2;
      $field =~ tr/A-Z/a-z/;

      if ($field eq 'attach') {
        $value =~ s#\Afile://##;
        push @attachments, $value;
      } else {
        $cmdline .= "${andstr}${field}=${value}";
        $andstr = '&';
      }
   }
}

$cmdline .= "'";

if (@attachments) {
    foreach my $attach (@attachments) {
        $cmdline .= cleanup_arg('--attach', $attach);
    }
}


$cmdline .= ' &';  # background it.

print $cmdline . "\n";

# and maybe send the mailto:
system($cmdline);

# end of mailto-sylpheed.pl ...

