# remove-links - delete a shadow-tree of symlinks
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

bug_mail="lord@emf.net"


################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) printf "remove-links 2002-1 from regexps.com\\n"
		    printf "\\n"
		    printf "Copyright 2002, Tom Lord\\n"
		    printf "\\n"
		    printf "This is free software; see the source for copying conditions.\\n"
		    printf "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\\n"
		    printf "PARTICULAR PURPOSE.\\n"
		    printf "\\n"
		    printf "Report bugs to $bug_mail.\n"
		    printf "\\n"
		    exit 0
		    ;;

      --help|-h)
		printf "remove a shadow tree of symbolic links\\n"
		printf "usage: remove-links [options] from-dir to-dir\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -n                            print a list of links, but\\n"
		printf "                               don't actually remove them\\n"
		printf "\\n"
		printf " -q                            don't print the list of links\\n"
		printf "\\n"
		printf "Remove symbolink links in TO-DIR to all files in\\n"
		printf "FROM-DIR.\\n"
		printf "\\n"
		printf "The link targets must be absolute path names which have\\n"
		printf "a prefix identical to the output of 'pwd' in FROM-DIR.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

no_remove=
quiet=

while test $# -ne 0 ; do

  case "$1" in 

    -n)		shift
    		no_remove=-n
		;;

    -q)		shift
    		quiet=-q
		;;

    --)			shift
    			break
			;;
			
    -*)			printf "remove-links: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 2 ; then
  printf "usage: remove-links [options] from-dir to-dir\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

from_dir="$1"
shift

to_dir="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

here="`pwd`"

cd "$here"
cd "$from_dir"
from_dir="`pwd`"

cd "$here"
cd "$to_dir"
to_dir="`pwd`"

################################################################
# Do It
# 

list_of_links()
{
  cd "$to_dir"
  find . -type l \
  | xargs -n 1 ls -l \
  | awk -vfrom_dir="$from_dir/" \
       '{
	  pair = $0;
	  left = pair;
	  right = pair;
	  sub("[ \t]->.*", "", left);
	  sub(".*[ \t]", "", left);
	  sub(".*[ \t]->[ \t]", "", right);
          if (substr(right, 0, length(from_dir)) == from_dir)
	    {
	      print left;
	    }
        }'
        
}

if test ! -z "$no_remove" ; then
  if test ! -z "$quiet" ; then
    exit 0
  fi
  list_of_links
  exit 0
fi

# Really do it
# 

cd "$to_dir"

list_of_links \
| awk -vquiet="$quiet" \
  '{
     if (quiet == "")
       {
         print "printf \"%s\\\\n\" \"" $0 "\"";
       }
     print "rm \"" $0 "\"";
   }' \
| sh -e 


# arch-tag: Tom Lord Fri Apr  5 08:36:26 2002 (links/remove-links.sh.in)
#
