import getopt, sys, os.path
import MenuMaker


error = '*** MenuMaker ERROR : '


output = None
verbose = 0
active = 0
cached = 0
reduce = 0


def _Usage ():
	print '\n\nMenuMaker %s - 100%s Python menu generator for X window managers' % (MenuMaker.version, '%')
	print '\n%s\n%s %s <%s>' % (MenuMaker.homepage, MenuMaker.copyright, MenuMaker.author, MenuMaker.email)
	print """

Usage:
  mmaker [-hvcrA] [-o out_file] window_manager {window_manager ...}

  -h prints this usage information
  -v turns on verbosity
  -c enables cache usage (quick regeneration without rescanning)
  -r omits directory parts from executables where possible
  -o specifies file to write menu to instead of WM specific place in user's home
  -A enables Active Menus feature (EXPERIMENTAL)

window_manager is WM to generate menu for

WMs supported (case insensitive): Deskmenu, FluxBox, IceWM, OpenBox, OpenBox3, (WindowMaker | WMaker), (XFce | XFwm), (XFce4 | XFdesktop4)
"""


def _Write (name):
	global output, verbose, active, cached
	exec 'from MenuMaker.%s import Toplevel' % name
	Toplevel ().Write (output,cached = cached,active = active,verbose = verbose,reduce = reduce)
	del Toplevel


try:
	opts, args = getopt.getopt (sys.argv[1:],'Ahvcro:')
except:
	_Usage ()
	print error + 'Invalid command line parameters!'
	sys.exit (2)

for o, a in opts:
	if   o == '-h':
		_Usage ()
		sys.exit ()
	elif o == '-v':
		verbose = 1
	elif o == '-o':
		output = os.path.expanduser (a)
	elif o == '-A':
		active = 1
	elif o == '-c':
		cached = 1
	elif o == '-r':
		reduce = 1
wms = []
for a in args:
	wms.append (a.lower ())


if not len (wms):
	print error + 'Nothing to do -- no WM(s) given!'
	_Usage ()
	sys.exit (2)


if len (wms) > 1 and output:
	print error + 'Option -o may be used with single WM only!'
	sys.exit (2)


for wm in wms:
	d = MenuMaker.GetDriverName (wm)
	if d:
		_Write (d)
	else:
		print error + 'Unknown window manager specified : %s!' % (wm)
		sys.exit (2)
