from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu
from MenuMaker import Separator as _Separator


class Command (_Command):
	def AsList (self,toplevel):
		return ['menuitem=%s:%s' % (
			self.name,
			toplevel.CommandLine (self)
		)]


class Separator (_Separator):
	def AsList (self,toplevel):
		if toplevel.active:
			return ['divider=', '']
		else:
			return []


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		indent = toplevel.Indent (self)
		if not self.Empty ():
			result.append ('submenu=%s' % (
				self.name
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
			result.append ('endmenu=')
			result.append ('')
		return result


class Toplevel (_Toplevel):
	cachefile = 'menu-Deskmenu'
	name = 'Deskmenu'
	menudir = '~'
	menufile = '.deskmenurc'
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewSeparator (self):
		return Separator ()
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		result = _Toplevel.AsList (self)
		result.append ('windowlist=Window List')
		result.append ('workspaces=Workspaces')
		result.append ('keycode=Control+Escape')
		return result
