from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu
from MenuMaker import Separator as _Separator


class Command (_Command):
	def AsList (self,toplevel):
		return ['%sprog \"%s\" - %s' % (
			toplevel.Indent (self),
			self.name,
			toplevel.CommandLine (self)
		)]


class Separator (_Separator):
	def AsList (self,toplevel):
		if toplevel.active:
			return ['%sseparator' % toplevel.Indent (self)]
		else:
			return []


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		indent = toplevel.Indent (self)
		if not self.Empty ():
			result.append ('%smenu \"%s\" folder {' % (
				indent,
				self.name
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
			result.append ('%s}' % indent)
		return result


class Toplevel (_Toplevel):
	cachefile = 'menu-IceWM'
	name = 'IceWM'
	menudir = '~/.icewm'
	menufile = 'menu'
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewSeparator (self):
		return Separator ()
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		result = _Toplevel.AsList (self)
		result.append ('menufile Toolbar toolbar toolbar')
		return result
	def Indent (self,entry):
		result = ''
		for i in range (1,entry.Level ()):
			result = result + '\t'
		return result
#	def Generate (self):
#		_Toplevel.Generate (self)
#		import Prophet
#		import os.path
#		icepref = Prophet.Program.X.Utility.icepref ()()
#		if icepref:
#			self.menu.Insert (self._Commands ([icepref]))
