import sys, time, os.path, cPickle, getopt, math


logdir = os.path.expanduser ('~/.mmaker')
logfile = os.path.join (logdir, 'launch-stats')


def Warn (msg):
	sys.stderr.write ('=== mmaker-launch : %s\n' % msg)


def Err (msg):
	sys.stderr.write ('*** mmaker-launch : %s\n' % msg)
	sys.exit (1)


def RatingCompare (a, b):
	if a[1] < b[1]:
		return +1
	elif a[1] > b[1]:
		return -1
	else:
		return 0


if len (sys.argv) < 2:
	Err ('wrong # of arguments; this script is not for manual execution!')


try:
	opts, args = getopt.getopt (sys.argv[1:],'c:m:T')
except:
	Err ('wrong command-line option; this script is not for manual execution!')


entry = None
wm = None
term = 0


for o,a in opts:
	if   o == '-c':
		entry = a
	elif o == '-m':
		wm = a
	elif o == '-T':
		term = 1


if not os.path.isdir (logdir):
	Warn ('directory %s does not exist, try to create it' % logdir)
	try:
		os.makedirs (logdir)
	except:
		Err ('failed to create %s' % logdir)


nowT = time.time ()
NN = 1
epochT = nowT


try:
	id = open (logfile, 'rb')
	try:
		# (entry, rating, N, firstT, lastT)
		orgstats = cPickle.load (id)
		try:
			(NN, epochT) = cPickle.load (id)
			NN = NN + 1
		except:
			pass
	finally:
		id.close ()
except:
	Warn ('failed to restore stats')
	orgstats = []


found = 0
newstats = []
FF = NN / (nowT - epochT + 1.)
sigma = 86400.
k = 1
avgF = 0.
for s in orgstats:
	firstT = s[3]
	if s[0] == entry:
		N = s[2] + 1
		lastT = nowT
		found = 1
	else:
		N = s[2]
		lastT = s[4]
	inactT = nowT - lastT
	F = N / (nowT - firstT + 1.)
	avgF = avgF + F
	k = k + 1
	r = F / FF
	rating = r + (1. - r)*math.exp (- inactT/sigma)
	newstats.append (( s[0], rating, N, firstT, lastT ))
avgF = avgF / k
if avgF == 0.:
	avgF = 1.
if not found:
	N = 1
	lastT = nowT
	firstT = lastT + 1. - N / avgF
#	inactT = 0.
#	F = N / (nowT - firstT + 1.)
#	rating = F / FF + math.exp (- inactT/sigma)
	rating = 1.
	newstats.append (( entry, rating, N, firstT, lastT ))


newstats.sort (RatingCompare)


try:
	id = open (logfile, 'wb')
	try:
		cPickle.dump (newstats[:99], id, 1)
		cPickle.dump ((NN, epochT), id, 1)
	finally:
		id.close ()
except:
	Warn ('stats write failed')


if entry and wm:
	try:
		exec 'from MenuMaker.%s import Toplevel' % wm
		Toplevel (newstats).Write (cached = 1, active = 1, verbose = 0)
	except:
		Warn ('failed to regenerate menu')



if term:
	# FIXME : terminal should be taken from preferences/most used ones.
	shell = '/usr/X11R6/bin/xterm'
	cmd = '-e'
else:
	try:
		shell = os.environ['SHELL']
	except:
		shell = '/bin/sh'
		Warn ('SHELL environment variable is not set, using %s' % shell)
	cmd = '-c'


try:
	os.execv (shell,[shell,cmd] + args)
except:
	Err ('failed to execute %s' % args[0])
