from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu
from MenuMaker import Entry as _Entry
from MenuMaker import Separator as _Separator


class Command (_Command):
	def AsList (self,toplevel):
		indent = toplevel.Indent (self)
		return [
			'%s<item label=\"%s\">' % (indent, self.name),
			'%s\t<action name=\"execute\"><execute>%s</execute></action>' % (indent, toplevel.CommandLine (self)),
			'%s</item>' % indent
		]


class Specific (_Entry):
	def __init__ (self,tag,name,arg = ''):
		_Entry.__init__ (self)
		self.tag = tag
		self.name = name
		self.arg = arg
	def AsList (self,toplevel):
		return ['%s<item label=\"%s\"><action name=\"%s\">%s</action></item>' %
			(toplevel.Indent (self), self.name, self.tag, self.arg)]


class MenuWithID (_Entry):
	def __init__ (self,id):
		_Entry.__init__ (self)
		self.id = id
	def AsList (self,toplevel):
			return ['%s<menu id=\"%s\"/>' % (
				toplevel.Indent (self),
				self.id
			)]


class Separator (_Separator):
	def AsList (self,toplevel):
		if toplevel.active:
			return ['%s<separator/>' % toplevel.Indent (self)]
		else:
			return []


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		indent = toplevel.Indent (self)
		if not self.Empty ():
			result.append ('%s<menu id=\"%s\" label=\"%s\">' % (
				indent,
				toplevel.ID (),
				self.name
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
			result.append ('%s</menu>' % indent)
		return result


class Toplevel (_Toplevel):
	cachefile = 'menu-OpenBox3'
	name = 'OpenBox3'
	menudir = '~/.config/openbox'
	menufile = 'menu.xml'
	id = 1
	def ID (self):
		result = self.id
		self.id = result + 1
		return result
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewSeparator (self):
		return Separator ()
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		result = [
			'<?xml version=\"1.0\" encoding=\"UTF-8\"?>'
			'<openbox_menu>',
			'<menu id=\"root-menu\" label=\"OpenBox 3\">',
		]
		result = result + _Toplevel.AsList (self)
		result = result + [
			'</menu>',
			'</openbox_menu>'
		]
		return result
	def Indent (self,entry):
		result = ''
		for i in range (0,entry.Level ()):
			result = result + '\t'
		return result
	def Generate (self):
		_Toplevel.Generate (self)
		system = self.NewMenu ('%s system' % self.name)
		system.Insert ([
			MenuWithID ('client-list-menu'),
			Separator (),
			Specific ('reconfigure', 'Reconfigure'),
			Specific ('restart', 'Restart'),
			Specific ('exit', 'Exit')
		])
		self.menu.Insert ([
			Separator (),
			system
		])
