import os.path
from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu
from MenuMaker import Entry as _Entry


class Command (_Command):
	def AsList (self,toplevel):
		if self.Last ():
			tail = ''
		else:
			tail = ','
		return ['%s(\"%s\", EXEC, \"%s\")%s' % (
			toplevel.Indent (self),
			self.name,
			toplevel.CommandLine (self),
			tail
		)]


class Specific (_Entry):
	def __init__ (self,tag,name,arg = None):
		_Entry.__init__ (self)
		self.tag = tag
		self.name = name
		self.arg = arg
	def AsList (self,toplevel):
		if self.Last ():
			tail = ''
		else:
			tail = ','
		s = '%s(\"%s\", %s' % (toplevel.Indent (self),self.tag,self.name)
		if self.arg:
			s = s + ', \"%s\")%s' % (self.arg,tail)
		else:
			s = s + ')%s' % tail
		return [s]


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		if not self.Empty ():
			indent = toplevel.Indent (self)
			result.append ('%s(\"%s\",' % (
				indent,
				self.name,
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
			if self.Last ():
				tail = ''
			else:
				tail = ','
			result.append ('%s)%s' % (indent,tail))
		return result


class Toplevel (_Toplevel):
	cachefile = 'menu-WindowMaker'
	name = 'WindowMaker'
	menudir = '~/GNUstep/Defaults'
	menufile = 'WMRootMenu'
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		result = ['("WindowMaker",']
		result = result + _Toplevel.AsList (self)
		result.append (')')
		return result
	def Generate (self):
		_Toplevel.Generate (self)
		system = self.NewMenu ('WindowMaker system')
		commands = self.NewMenu ('Commands')
		commands.Insert ([
			Specific ('Hide Others','HIDE_OTHERS'),
			Specific ('Show All','SHOW_ALL'),
			Specific ('Arrange Icons','ARRANGE_ICONS'),
			Specific ('Refresh','REFRESH'),
			# TODO : Lock
			Specific ('Save Session','SAVE_SESSION'),
			Specific ('Clear Session','CLEAR_SESSION')
		])
		appearance = self.NewMenu ('Appearance')
		import Prophet
		wmaker = Prophet.Program.X.WM.wmaker ()()
		if wmaker:
			wmthsdir = os.path.join (wmaker.prefix,'share/WindowMaker/Themes')
			wmssdir = os.path.join (wmaker.prefix,'share/WindowMaker/Styles')
			wmisdir = os.path.join (wmaker.prefix,'share/WindowMaker/IconSets')
		else:
			wmthsdir = ''
			wmssdir = ''
			wmisdir = ''
		appearance.Insert ([
			Specific ('Themes','OPEN_MENU','-noext %s $HOME/GNUstep/Library/WindowMaker/Themes WITH setstyle' % wmthsdir),
			Specific ('Styles','OPEN_MENU','-noext %s $HOME/GNUstep/Library/WindowMaker/Styles WITH setstyle' % wmssdir),
			Specific ('IconSets','OPEN_MENU','-noext %s $HOME/GNUstep/Library/WindowMaker/IconSets WITH seticons' % wmisdir)
		])
		system.Insert ([
			commands,
			appearance,
			Specific ('Restart','RESTART')
		])
		self.menu.Insert ([
			system,
			Specific ('Exit','EXIT')
		])
