from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu
from MenuMaker import Separator as _Separator


class Command (_Command):
	def AsList (self,toplevel):
		return ['%s<app name=\"%s\" cmd=\"%s\"/>' % (
			toplevel.Indent (self),
			self.name,
			toplevel.CommandLine (self)
		)]


class Separator (_Separator):
	def AsList (self,toplevel):
		if toplevel.active:
			return ['%s<separator/>' % toplevel.Indent (self)]
		else:
			return []


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		indent = toplevel.Indent (self)
		if not self.Empty ():
			result.append ('%s<menu name=\"%s\" visible=\"yes\">' % (
				indent,
				self.name
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
			result.append ('%s</menu>' % indent)
		return result


class Toplevel (_Toplevel):
	cachefile = 'menu-XFdesktop4'
	name = 'XFdesktop4'
	menudir = '~/.xfce4'
	menufile = 'menu.xml'
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewSeparator (self):
		return Separator ()
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		result = [
			'<?xml version=\"1.0\" encoding=\"UTF-8\"?>',
			'<!DOCTYPE xfdesktop-menu []>',
			'<xfdesktop-menu>',
			'<title name=\"Desktop Menu\" visible=\"yes\"/>',
			'<separator/>'
		]
		result = result + _Toplevel.AsList (self)
		result = result + [
			'</xfdesktop-menu>'
		]
		return result
	def Indent (self,entry):
		result = ''
		for i in range (1,entry.Level ()):
			result = result + '\t'
		return result
