from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu


class Command (_Command):
	def AsList (self,toplevel):
		if self.parent and self.parent.Level () > 0:
			pid = self.parent.id
		else:
			pid = 'user_menu'
		return ['%sAddToMenu \"%s\" \"%s\" Exec %s' % (
			toplevel.Indent (self),
			pid,
			self.name,
			toplevel.CommandLine (self)
		)]


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		if not self.Empty ():
			if self.parent and self.parent.Level () > 0:
				pid = self.parent.id
			else:
				pid = 'user_menu'
			result.append ('%sAddToMenu \"%s\" \"%s\" PopUp \"%s\"' % (
				toplevel.Indent (self),
				pid,
				self.name,
				self.id
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
		return result
	def _DesignateIDs (self,toplevel):
		self.id = toplevel.UID ()
		for e in self.entries:
			if issubclass (e.__class__,_Menu):
				e._DesignateIDs (toplevel)


class Toplevel (_Toplevel):
	cachefile = 'menu-XFwm'
	name = 'XFwm'
	menudir = '~/.xfce'
	menufile = 'xfwm.user_menu'
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		self.id = 0
		self.menu._DesignateIDs (self)
		return _Toplevel.AsList (self)
	def UID (self):
		id = self.id
		self.id = self.id + 1
		return id
	def Indent (self,entry):
		result = ''
		for i in range (1,entry.Level ()):
			result = result + '\t'
		return result
