import os.path
from MenuMaker import Toplevel as _Toplevel
from MenuMaker import Command as _Command
from MenuMaker import Menu as _Menu
from MenuMaker import Entry as _Entry


class Command (_Command):
	def AsList (self,toplevel):
		return ['%s[exec] (%s) {%s}' % (
			toplevel.Indent (self),
			self.name,
			toplevel.CommandLine (self)
		)]


class Specific (_Entry):
	def __init__ (self,tag,name,arg = None):
		_Entry.__init__ (self)
		self.tag = tag
		self.name = name
		self.arg = arg
	def AsList (self,toplevel):
		s = '%s[%s] (%s)' % (toplevel.Indent (self),self.tag,self.name)
		if self.arg:
			s = s + ' {%s}' % self.arg
		return [s]


class Menu (_Menu):
	def AsList (self,toplevel):
		result = []
		if not self.Empty ():
			indent = toplevel.Indent (self)
			result.append ('%s[submenu] (%s)' % (
				indent,
				self.name,
			))
			for e in self.entries:
				result = result + e.AsList (toplevel)
			result.append ('%s[end]' % indent)
		return result


class Toplevel (_Toplevel):
	def NewCommand (self,type,name,cmd):
		return Command (type,name,cmd)
	def NewMenu (self,name):
		return Menu (name)
	def AsList (self):
		result = ['[begin] (%s)' % self.name]
		result = result + _Toplevel.AsList (self)
		result.append ('[end]')
		return result
	def Generate (self):
		_Toplevel.Generate (self)
		system = self.NewMenu ('%s system' % self.name)
		styles = self.NewMenu ('Styles')
		import Prophet
		exec 'box = Prophet.Program.X.WM.%s ()()' % self.wmname
		if box:
			stylesdir = os.path.join (box.prefix,self.sysstylessfx)
			if os.path.isdir (stylesdir):
				styles.Insert (Specific ('stylesmenu','%s styles' % self.name,stylesdir))
		if os.path.isdir (os.path.expanduser (self.usrstylesdir)):
			styles.Insert (Specific ('stylesdir',self.usrstylesdir))
		system.Insert ([
			Specific ('workspaces','Workspaces'),
			styles,
			Specific ('config','Configure'),
			Specific ('reconfig','Reload configuration'),
			Specific ('restart','Restart')
		])
		self.menu.Insert ([
			system,
			Specific ('exit','Exit')
		])
