version = '0.17'


copyright = '(c) 2002-2004'
author = 'Oleg A. Khlybov'
email = 'fougas@mail.ru'
homepage = 'http://menumaker.sourceforge.net'


import cPickle, os.path, sys, copy, types


Prophet = None


__drivers = {
	'Deskmenu'		: ('deskmenu',),
	'FluxBox'		: ('fluxbox',),
	'IceWM'			: ('icewm',),
	'OpenBox'		: ('openbox',),
	'OpenBox3'		: ('openbox3',),
	'XFwm'			: ('xfce', 'xfwm'),
	'XFdesktop4'	: ('xfce4', 'xfdesktop4'),
	'WindowMaker'	: ('wmaker', 'windowmaker')
}


__terminals = {
	'rxvt'	: ('rxvt',),
	'xterm' : ('xterm',)
}


def GetDriverName (s):
	global __drivers
	z = s.lower ()
	for k in __drivers.keys ():
		if z in __drivers[k]:
			return k
	return None


def GetDriverList ():
	global __drivers
	z = __drivers.keys ()
	z.sort ()
	return z


def GetTerminal (s):
	global __terminals
	z = s.lower ()
	for k in __terminals.keys ():
		if z in __terminals[k]:
			return k
	return None


class Entry:
	def __init__ (self):
		self.parent = None
		self.level = 0
	def Level (self):
		if self.parent:
			return self.parent.Level() + 1
		else:
			return 0
	def First (self):
		if self.parent:
			return self == self.parent.entries[0]
		else:
			return 1
	def Last (self):
		if self.parent:
			return self == self.parent.entries[len (self.parent.entries) - 1]
		else:
			return 1


class Separator (Entry):
	def AsList (self,toplevel):
		return []


class Command (Entry):
	def __init__ (self,type,name,cmd):
		Entry.__init__ (self)
		self.type = type
		self.name = name
		self.cmd = cmd


class TopN (Entry):
	def __init__ (self,capacity):
		Entry.__init__ (self)
		self.capacity = capacity
	def AsList (self,toplevel):
		if not toplevel.active:
			return []
		result = []
		s = 1
		mu = toplevel.mu
		owned = self.parent.OwnedCommands ()
		for i in range (0,len (mu) - 1):
			type = mu[i][0]
			for o in owned:
				if o.type == type:
					e = copy.copy (o)
					e.parent = self.parent
					result = result + e.AsList (toplevel)
					s = s + 1
					if s > self.capacity:
						return result
					break
		return result


class Menu (Entry):
	def __init__ (self,name):
		Entry.__init__ (self)
		self.name = name
		self.entries = []
	def Empty (self):
		# An empty menu contains zero or more empty submenus and does not
		# contain command entries at all. Separators and TopN entries are omitted as
		# well.
		n = 0
		for e in self.entries:
			if issubclass (e.__class__,Separator) or issubclass (e.__class__,TopN):
				continue
			if issubclass (e.__class__,Menu):
				if e.Empty ():
					continue
			n = n + 1
		return n == 0
	def Detach (self,entry):
		if entry.parent:
			try:
				entry.parent.remove (e)
			except:
				pass
			entry.parent = None
	def Insert (self,entries,tail = 1):
		# tail == 1 -> append; tail == 0 -> prepend
		# Empty menus will normally be omitted.
		if type (entries) == types.ListType:
			if not tail:
				entries.reverse ()
			for e in entries:
				#if issubclass (e.__class__,Menu) and e.Empty ():
				if isinstance (e,Menu) and e.Empty ():
					continue
				self.Detach (e)
				if tail:
					self.entries.append (e)
				else:
					self.entries.insert (0,e)
				e.parent = self
		else:
			#if not (issubclass (entries.__class__,Menu) and entries.Empty ()):
			if not (isinstance (entries,Menu) and entries.Empty ()):
				self.Detach (entries)
				self.entries.append (entries)
				entries.parent = self
	def OwnedCommands (self):
		result = []
		for e in self.entries:
			if   issubclass (e.__class__,Command):
				result.append (e)
			elif issubclass (e.__class__,Menu):
				result = result + e.OwnedCommands ()
		return result


class Toplevel:
	cachedir = '~/.mmaker'
	def __init__ (self,mu = None):
		self.menu = None
		self.capacity = 6
		if mu:
			self.mu = mu
		else:
			try:
				id = open (os.path.join (os.path.expanduser (self.cachedir),'launch-stats'),'rb')
				self.mu = cPickle.load (id)
				id.close ()
			except:
				self.mu = []
	def Indent (self,entry):
		result = ''
		for i in range (0,entry.Level ()):
			result = result + '\t'
		return result
	def Save (self):
		exdir = os.path.expanduser (self.cachedir)
		try:
			os.makedirs (exdir)
		except:
			pass
		id = open (os.path.join (exdir,self.cachefile),'wb')
		cPickle.dump (self.menu,id,1)
		id.close ()
	def Load (self):
		id = open (os.path.join (os.path.expanduser (self.cachedir),self.cachefile),'rb')
		self.menu = cPickle.load (id)
		id.close ()
	def AsList (self):
		result = []
		for e in self.menu.entries:
			result = result + e.AsList (self)
		return result
	def NewSeparator (self):
		return Separator ()
	def NewTopN (self,capacity):
		return TopN (capacity)
	def CommandLine (self,entry):
		if self.reduce and Prophet.Executable._reducable (entry.cmd):
			_cmd = os.path.basename (entry.cmd)
		else:
			_cmd = entry.cmd
		if self.active:
			if entry.trm:
				cmd = '-T ' + _cmd
			else:
				cmd = _cmd
			return 'mmaker-launch -m %s -c %s %s' % (self.name,entry.type,cmd)
		else:
			# FIXME : this is temporary solution !!!
			if entry.trm:
				if self.reduce:
					cmd = 'xterm -e ' + _cmd
				else:
					cmd = '/usr/X11R6/bin/xterm -e ' + _cmd
			else:
				cmd = _cmd
			return cmd
	def Generate (self):
		global Prophet
		if not Prophet:
			Prophet = __import__ ('Prophet')
		__nc = [
			Prophet.Program.X,
			Prophet.Program.KDE,
			Prophet.Program.GNOME,
			Prophet.Program.XFce,
			Prophet.Program.XFce4
		]
		self.menu = self.NewMenu ('<NULL>')
		self.menu.Insert ([
			self.NewTopN (self.capacity),
			self.NewSeparator (),
			self._FullMenu (Prophet.Program.KDE,[],1),
			self._FullMenu (Prophet.Program.GNOME,[],1),
			self._FullMenu (Prophet.Program.XFce4,[],0),
			self._FullMenu (Prophet.Program.XFce,[],0),
			self._FullMenu (Prophet.Program,__nc,1),
			self.NewSeparator ()
		])
		X = self._FullMenu (Prophet.Program.X,[],0,0)
		stdX = self.NewMenu (self._GetMenuName (Prophet.Program.X))
		stdX.Insert (self._GetModuleEntries ([Prophet.Program.X]))
		X.Insert (stdX)
		self.menu.Insert (X.entries)
	def Write (self,file = None,active = 1,cached = 0,verbose = 0,reduce = 0):
		self.active = active
		self.verbose = verbose
		self.reduce = reduce
		if cached:
			if verbose:
				sys.stdout.write ('* Loading cached menus...')
				sys.stdout.flush ()
			regenerate = 0
			try:
				self.Load ()
				if verbose:
					sys.stdout.write ('done\n')
			except:
				regenerate = 1
				if verbose:
					sys.stdout.write ('FAILED, will have to do a rescan\n')
		else:
			regenerate = 1
		if regenerate:
			if verbose:
				sys.stdout.write ('* Rescanning & saving cached menus...')
				sys.stdout.flush ()
			self.Generate ()
			self.Save ()
			if verbose:
				sys.stdout.write ('done\n')
		if not file:
			dir = os.path.expanduser (self.menudir)
			try:
				os.makedirs (dir)
			except:
				pass
			file = os.path.join (dir,self.menufile)
		if verbose:
			sys.stdout.write ('* Saving %s menu to %s...' % (self.name,file))
			sys.stdout.flush ()
		try:
			out = open (file,'wt+')
			for t in self.AsList ():
				out.write (t + '\n')
			out.close ()
		except:
			if verbose:
				sys.stdout.write ('FAILED, bailing out!\n')
			raise
		if verbose:
			sys.stdout.write ('done\n')
	def _FullMenu (self,module,excmods,withtopn = 0,withtopentries = 1):
		global Prophet
		m = self.NewMenu (self._GetMenuName (module))
		if withtopn:
			m.Insert ([
				self.NewTopN (self.capacity),
				self.NewSeparator ()
			])
		for s in Prophet.GetSubmodules ([module],excmods,0):
			if s:
				m.Insert (self._FullMenu (s,excmods))
		if withtopentries:
			m.Insert (self._GetModuleEntries ([module]))
		return m
	def _GetModuleEntries (self,modules):
		global Prophet
		result = []
		for e in Prophet.Scan (modules,[],0):
			if not e.interactive:
				continue
			c = self.NewCommand (
				str (e.__class__),
				e.name,
				os.path.join (e.bindir,e.executable)
			)
			c.trm = (e.ui == Prophet.Executable.TUI)
			result.append (c)
		return result
	def _GetMenuName (self,module):
		try:
			return module.name
		except:
			s = module.__name__
			try:
				i = s.rindex ('.') + 1
			except ValueError:
				i = 0
			return s[i:]
