import os.path, stat, glob
from Prophet import _Cacheable
import Prophet.Support
import string


CLI	= 0 # Non-interactive programs that indifferent to output device type.
TUI = 1 # Interactive programs that require text console (Curses or Slang -based, for instance).
FBI = 2 # Programs that make use of framebuffer output device. These are usually not compatible with X11.
XUI = 3 # X11-aware interactive programs.


def _isexecutable (file):
	try:
		return (stat.S_IMODE(os.stat (file)[stat.ST_MODE]) & 0100) and \
			not os.path.isdir (file) # Since directories may have x-bit set too
	except:
		return 0


def _reducable (fullpath):
	"""Check whether the executable can be accessed without specifying its
		full pathname."""
	e = os.path.basename (fullpath)
	d = os.path.dirname (fullpath)
	for b in string.split (os.environ['PATH'], ':'): # FIXME : cache this
		f = os.path.join (b, e)
		if _isexecutable (f):
			if os.path.samefile (d, b):
				return 1
			else:
				return 0
	return 0


class _Executable (_Cacheable):
	_bindirs = ['bin', 'sbin', ''] # Directories that usually contain executables
	_requireX = ['X11', 'GNOME', 'KDE', '*Step', 'XFce']
	def __init__ (self):
		_Cacheable.__init__ (self)
	def _Valid (self):
		"""Request for validation of newly found executable. Overrided method
			gets usual public fields such as `executable', `bindir' etc and must
			return true if the guess is considered good enough and the search is
			complete, and false otherwise. In the latter case scan will continue."""
		return 1
	def _Prefixes (self):
		"""Return valid prefixes to scan in. This version simply returns
			standard ones, but it may be overriden to get additional, specific to
			particular entry, prefixes."""
		try:
			self._prefixes
		except:
			self._prefixes = Prophet.Support.Prefixes ()()
		return self._prefixes
	def _Scan (self):
		# Try to guess some properties by looking into keywords
		try:
			# Bool interactive determines whether a program should not be
			# run unattended - if it is console mode one, it should be started
			# from terminal emulator when using X. (Ex. MC, info or vi).
			# Non-interactive program may run in background (Ex. gzip, sh)
			# Normally they won't appear in menu
			self.interactive
		except:
			# If interactive is not set in base class' constructor...
			if self.AnyOf (['console'] + self._requireX):
				self.interactive = 1
			else:
				self.interactive = 0
		try:
			# ui determines kind of output produced by a program
			self.ui
		except:
			if   self.AnyOf (['FB']):
				self.ui = FBI
			elif self.NoneOf (self._requireX):
				self.ui = TUI
			else:
				self.ui = XUI
				



class _Multiname (_Executable):
	"""The class is intended for finding an executable that may have several
		names, for example Midnight Commander has executable `mc' on most
		platforms, but `midc' on BSDs.
		Required fields:
			_executables -- list of executables to search in order of decreasing
				preference"""
	def __init__ (self):
		_Executable.__init__ (self)
	def _Scan (self):
		_Executable._Scan (self)
		# FIXME : what's preferred - real executable or link pointing to it?
		prefixes = self._Prefixes ().prefix # Prefixes in which to perform scan.
		for e in self._executables:
			for p in prefixes:
				for b in self._bindirs:
					file = os.path.join (p,b,e)
					try:
						if _isexecutable (file):
							# file is an executable.
							self.prefix = p
							self.bindir = os.path.join (p,b)
							self.executable = e
							if self._Valid ():
								self._success = 1
								return
					except:
						pass


class _Versioned (_Executable):
	"""Search for executable that may have version number as a suffix, for
		example `python2.1' and return the latest one (that with the highest
		version) or, if there is a hard/symlink pointing to that executable,
		return it.
		Say, Python usually has hardlink `python' pointing to `pythonXXX'. But
		if a site has several Python versions installed in different prefixes,
		there may be several `python's there and we need to pick the right
		one.
		Required field:
			_basenames -- list if program prefixes"""
	def __init__ (self):
		_Executable.__init__ (self)
	def __cmpitems (self,item1,item2):
		a = item1[2]; b = item2[2]
		if a == b:
			return 0
		elif a > b:
			return -1
		else:
			return 1
	def _Scan (self):
		_Executable._Scan (self)
		prefixes = self._Prefixes ().prefix
		for e in self._basenames:
			raw = []
			for p in prefixes:
				for b in self._bindirs:
					pfx = os.path.join (p,b,e)
					globs = glob.glob (pfx) + glob.glob (pfx + '[._0-9]*') + glob.glob (pfx + '-[0-9]*')
					for g in globs:
						# Fill in the raw list of executables matching specified prefix.
						if _isexecutable (g):
							raw.append ((p,b,os.path.split (g)[1]))
			# First off, find an executable with the highest version number.
			unnumbered = []
			versioned = []
			for r in raw:
				suffix = r[2][len (e):]
				if not suffix:
					# These entries contain executables that lack version suffixes.
					unnumbered.append (r)
				else:
					versioned.append (r)
				versioned.sort (self.__cmpitems)
			found = None
			if versioned:
				found = versioned[0]
				for i in unnumbered:
					# Now traverse the list of unnumbereds to determine
					# whether a link to that versioned executable exists.
					u = os.path.join (i[0],i[1],i[2])
					v = os.path.join (found[0],found[1],found[2])
					if os.path.samefile (v,u):
						found = i
						break
			elif unnumbered:
				found = unnumbered[0]
			if found:
				self.prefix = found[0]
				self.bindir = os.path.join (found[0],found[1])
				self.executable = found[2]
				if self._Valid ():
					self._success = 1
					return
