import os.path, stat, glob
import Prophet.Support
from Prophet import _Cacheable
from Prophet.Executable import _Multiname
from Prophet.Support import _Extras
from Prophet.Executable import _isexecutable


def _Container__CmpFunc (a, b):
	if   a[1] == '':
		return +1
	elif b[1] == '':
		return -1
	if   a[1] < b[1]:
		return +1
	elif a[1] > b[1]:
		return -1
	else:
		return 0


class _Container (_Cacheable):
	"""Base class for the packages that do not follow standard *NIX
	conventions regarding their directory and file layouts (e.g. excecutables
	in <prefix>/bin, libraries in <prefix>/lib etc.), but place all their files
	in single, often versioned, directory (for instance, OpenOffice is usially
	installed in ``/usr/local/OpenOffice.org.x.Y.Z''). This is usual practice
	for very large (or) commercial packages."""
	def __init__ (self):
		_Cacheable.__init__ (self)
	def _Valid (self):
		"""See Prophet._Executable._Valid() for explanation."""
		return 1
	def _Scan (self):
		for b in self._basenames:
			found = []
			# First collect the directories found in all prefixes with
			# specified base name and, optionally, version number.
			for p in Prophet.Support.Prefixes ()().prefix:
				pfx = os.path.join (p,b)
				for g in glob.glob (pfx) + glob.glob (pfx + '[._0-9]*') + glob.glob (pfx + '-[0-9]*'):
					if os.path.isdir (g):
						v = g[len(pfx):]
						try:
							if v[0] == '-':
								v = v[1:]
						except:
							pass
						found.append ( (g,v) )
			# Sort the directories by their version number.
			# We need a directory with the highest version number; unnumbered
			# directories (if any) will be used at the last resort.
			found.sort (__CmpFunc)
			# Now will try to find the suitable one.
			for f in found:
				self.prefix = f[0]
				if self._Valid ():
					self._success = 1
					return


class _SOOffice (_Container):
	def __init__ (self):
		_Container.__init__ (self)
		self._bindirs = ['program', '']
		self._executables = ['soffice', 'ooffice']
	def _Valid (self):
		ok = 0
		for b in self._bindirs:
			for e in self._executables:
				try:
					if _isexecutable (os.path.join (self.prefix, b, e)):
						ok = 1
						break
				except:
					pass
			if ok:
				break
		if ok:
			self._bindir = b
			return 1
		else:
			return 0
	def _Scan (self):
		_Container._Scan (self)
		if self._success:
			self.bindir = os.path.join (self.prefix, self._bindir)


class AbiSuite (_Cacheable):
	# FIXME : make use of _Container instead.
	def __init__ (self):
		_Cacheable.__init__ (self)
		self.name = 'AbiSuite'
		self.comment = 'Abi Office Suite'
		self.keywords = ['Abi', 'AbiWord', 'X11', 'office', 'productivity', 'suite',
			'environment']
	def _Scan (self):
		prefixes = Prophet.Support.Prefixes ()()
		if prefixes == None:
			return
		try:
			abisuite_home = os.environ['ABISUITE_HOME']
			if os.path.isdir (abisuite_home):
				abisuite_home = None
		except:
			abisuite_home = None
		if abisuite_home:
			abisuite = [abisuite_home]
		else:
			abisuite = []
		# FIXME : replace mess below with _Extras._SpecificPrefix call.
		for p in prefixes.prefix:
			path = os.path.join (p,'AbiSuite')
			if os.path.isdir (path):
				abisuite.append (path)
		for a in abisuite:
			abibins = glob.glob (os.path.join (a,'bin','Abi*'))
			if len (abibins):
				# If bin directory contains Abi executables, consider
				# directory is valid.
				self.prefix = a
				self.bindir = os.path.join (a,'bin')
				self._success = 1
				return


class Acrobat (_Container):
	def __init__ (self):
		_Container.__init__ (self)
		self.name = 'Acrobat'
		self.comment = 'Adobe\'s PDF processing system'
		self.keywords = ['X11', 'commercial', 'PDF', 'document', 'view', 'create', 'manage']
		self._basenames = ['Acrobat']
	def _Valid (self):
		bindir = os.path.join (self.prefix, 'bin')
		if os.path.isdir (bindir):
			# Check whether there are some executables.
			if len (glob.glob (os.path.join (bindir, '*'))):
				return 1
			else:
				return 0
	def _Scan (self):
		_Container._Scan (self)
		if self._success:
			self.bindir = os.path.join (self.prefix, 'bin')
		

class GNOME (_Cacheable):
	def __init__ (self):
		_Cacheable.__init__ (self)
		self.name = 'GNOME Desktop Environment'
		self.comment = 'Advanced X desktop environment'
		self.keywords = ['X11', 'desktop', 'environment']
	def _Scan (self):
		# Only the basic scan algorithm at the moment.
		e = _Multiname ()
		e._executables = ['gnome-session']
		e._Scan ()
		if e:
			self.prefix = e.prefix
			self.bindir = e.bindir
			self._success = 1


# TODO : GNUstep


class KDE (_Cacheable, _Extras):
	def __init__ (self):
		_Cacheable.__init__ (self)
		self.name = 'K Desktop Environment'
		self.comment = 'Advanced X desktop environment'
		self.keywords = ['X11', 'desktop', 'environment']
	def _Scan (self):
		try:
			kdedir = os.environ['KDEDIR']
			if not Prophet.Executable._isexecutable (os.path.join (kdedir,'bin','startkde')):
				kdedir = None
		except:
			kdedir = None
		if kdedir:
			self.prefix = kdedir
			self.bindir = os.path.join (kdedir,'bin')
			self._success = 1
		else:
			# `KDEDIR' is not set or invalid, perform full search in all
			# available prefixes.
			e = _Multiname ()
			e._executables = ['startkde']
			e._Scan ()
			if e:
				self.prefix = e.prefix
				self.bindir = e.bindir
				self._success = 1
		if self._success:
			self._WallpaperDirs (['share/wallpapers'])


# TODO : Mozilla


class OpenOffice (_SOOffice):
	def __init__ (self):
		_SOOffice.__init__ (self)
		self.name = 'OpenOffice'
		self.comment = 'Open-source derivative of Sun\'s StarOffice'
		self.keywords = ['X11', 'office', 'suite', 'environment']
		self._basenames = ['OpenOffice.org']


class StarOffice (_SOOffice):
	def __init__ (self):
		_SOOffice.__init__ (self)
		self.name = 'StarOffice'
		self.comment = 'Complete office suite from Sun'
		self.keywords = ['X11', 'commercial', 'office', 'suite', 'environment']
		self._basenames = ['staroffice', 'office']


class XFce (_Cacheable, _Extras):
	def __init__ (self):
		_Cacheable.__init__ (self)
		self.name = 'XFce Desktop Environment'
		self.comment = 'Light X desktop environment resembling CDE'
		self.keywords = ['X11', 'CDE', 'clone', 'desktop', 'environment']
	def _Scan (self):
		e = _Multiname ()
		e._executables = ['startxfce']
		e._Scan ()
		if e:
			self.prefix = e.prefix
			self.bindir = e.bindir
			self._success = 1
			self._WallpaperDirs (['share/xfce/backdrops', 'share/xfce/textures'])


# Since XFce versions 3 and 4 are essentially different systems, they can be
# installed and used concurrently and thus fall into different categories.
class XFce4 (_Cacheable,_Extras):
	def __init__ (self):
		_Cacheable.__init__ (self)
		self.name = 'XFce Desktop Environment'
		self.comment = 'Light X desktop environment resembling CDE, 4th release'
		self.keywords = ['X11', 'CDE', 'XFce', 'clone', 'desktop', 'environment']
	def _Scan (self):
		e = _Multiname ()
		e._executables = ['startxfce4']
		e._Scan ()
		if e:
			self.prefix = e.prefix
			self.bindir = e.bindir
			self._success = 1
			self._WallpaperDirs (['share/xfce4/backdrops'])


