name = 'Editors'


import os.path
from Prophet.Executable import _Multiname


class ee (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Easy Editor'
		self.comment = 'Standard FreeBSD text editor'
		self.keywords = ['standard', '*BSD', 'console', 'text', 'edit']
		self._executables = ['ee']
	def _Valid (self):
		if os.path.isfile (os.path.join (self.prefix,'share/misc/init.ee')):
			return 1
		else:
			return 0


class elvis (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Elvis'
		self.comment = 'VI compatible editor'
		self.keywords = ['console', 'vi', 'clone', 'text', 'edit']
		self._executables = ['elvis']



from Prophet.Program.X.Editor import emacs


class jed (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Jed'
		self.comment = 'Simple text editor'
		self.keywords = ['console', 'text', 'edit']
		self._executables = ['xjed', 'jed']
		# FIXME : should we create new entry for `xjed'?


class joe (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Joe'
		self.comment = 'Simple text editor'
		self.keywords = ['console', 'text', 'edit']
		self._executables = ['joe']


class pico (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Pico'
		self.comment = 'Simple text editor'
		self.keywords = ['console', 'text', 'edit']
		self._executables = ['pico']


class vi (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'VI'
		self.comment = 'Standard UNIX editor'
		self.keywords = ['console', 'standard', 'text', 'edit']
		self._executables = ['vi', 'vim']
	def _Scan (self):
		# First try to find vim - if it exists, we basically don't need real
		# vi as it is superceeded by vim.
		# FIXME : does this behaviour appear to be useful???
		if not vim ()():
			_Multiname._Scan (self)


class vile (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Vile'
		self.comment = 'VI compatible editor'
		self.keywords = ['console', 'vi', 'clone', 'text', 'edit']
		self._executables = ['vile']


class vim (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'VIM'
		self.comment = 'Improved VI editor'
		self.keywords = ['console', 'vi', 'clone', 'text', 'edit']
		self._executables = ['vim']


class we (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'WE'
		self.comment = 'Console version of Xwpe text editor'
		self.keywords = ['console', 'Xwpe', 'text', 'edit']
		self._executables = ['we'] # FIXME : possible name clash


from Prophet.Program.X.Editor import xemacs
