from Prophet.Executable import _Multiname
from Prophet.Executable import _Versioned
import os.path


class clara (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Clara'
		self.comment = 'Optical Character Recognition system'
		self.keywords = ['console', 'OCR']
		self._executables = ['clara']


class gphoto (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Gphoto'
		self.comment = 'Digital still camera control program'
		self.keywords = ['console', 'image', 'edit', 'digital', 'photo']
		self._basenames = ['gphoto']


class _xn (_Multiname):
	def _Valid (self):
		dir = os.path.join (self.prefix, 'doc', 'XnView')
		if os.path.isdir (dir):
			return 1
		else:
			return 0


class nconvert (_xn):
	def __init__ (self):
		_xn.__init__ (self)
		self.name = 'NConvert'
		self.comment = 'Command-line image converter'
		self.keywords = ['picture', 'image', 'convert']
		self._executables = ['nconvert']


class nview (_xn):
	def __init__ (self):
		_xn.__init__ (self)
		self.name = 'NView'
		self.comment = 'Command-line image viewer'
		self.keywords = ['picture', 'image', 'view']
		self._executables = ['nview']
