from Prophet.Executable import _Multiname


class alsamixer (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'ALSA mixer'
		self.comment = 'CLI interactive ALSA audio mixer'
		self.keywords = ['console', 'ALSA', 'Linux', 'audio', 'mix']
		self._executables = ['alsamixer']


class amixer (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Amixer'
		self.comment = 'Console ALSA audio mixer'
		self.keywords = ['ALSA', 'Linux', 'audio', 'mix']
		self._executables = ['amixer'] # FIXME : possible name clash


class aplay (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'ALSA sound player'
		self.comment = 'Sound player from ALSA package'
		self.keywords = ['ALSA', 'Linux', 'audio', 'play', 'utility']
		self._executables = ['aplay'] # FIXME : possible name clash


class arecord (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'ALSA sound recorder'
		self.comment = 'Sound recorder from ALSA package'
		self.keywords = ['ALSA', 'Linux', 'audio', 'record', 'utility']
		self._executables = ['arecord']


class aumix (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Aumix'
		self.comment = 'Console audio mixer'
		self.keywords = ['console', 'audio', 'mix']
		self._executables = ['aumix']


class bladeenc (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'BladeEnc'
		self.comment = 'MP3 encoder'
		self.keywords = ['audio', 'mp3', 'encode', 'utility']
		self._executables = ['bladeenc']


class cdp (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'CD play'
		self.comment = 'Console CD player'
		self.keywords = ['console', 'CD', 'play', 'control']
		self._executables = ['cdp'] # FIXME : possible name clash


class cdrdao (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'CDrdao'
		self.comment = 'Audio CD burner'
		self.keywords = ['audio', 'CD', 'burn']
		self._executables = ['cdrdao']


# TODO : cdrecord suite


class dagrab (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Dagrab'
		self.comment = 'Audio CD grabber'
		self.keywords = ['audio', 'CD', 'grab']
		self._executables = ['dagrab']


class fbtv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'FbTV'
		self.comment = 'Linux framebuffer TV tuner'
		self.keywords = ['console', 'fb', 'FrameBuffer', 'video', 'TV', 'watch', 'tune']
		self._executables = ['fbtv']


class flac (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'FLaC'
		self.comment = 'FLaC looseless audio encoder/decoder'
		self.keywords = ['audio', 'looseless', 'flac', 'encode',
			'decode', 'utility']
		self._executables = ['flac']


class lame (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Lame'
		self.comment = 'MP3 encoder'
		self.keywords = ['audio', 'mp3', 'encode', 'utility']
		self._executables = ['lame']


class mikmod (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'MikMod'
		self.comment = 'MOD/STM/S3M/.. player'
		self.keywords = ['audio', 'MOD', 'STM', 'S3M', 'play', 'utility']
		self._executables = ['mikmod']


class mpg123 (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Mpg123 player'
		self.comment = 'MP3 player'
		self.keywords = ['audio', 'mp3', 'play', 'decode', 'utility']
		self._executables = ['mpg123']


class mplayer (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'M video player'
		self.comment = 'Command line video player'
		self.keywords = ['X11', 'console', 'video', 'mpeg', 'avi', 'DivX',
			'play', 'utility']
		self._executables = ['mplayer']
		self.interactive = 0


class ogg123 (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Ogg123 player'
		self.comment = 'Ogg player'
		self.keywords = ['audio', 'ogg', 'play', 'decode', 'utility']
		self._executables = ['ogg123']


class oggenc (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'OggEnc'
		self.comment = 'Ogg encoder'
		self.keywords = ['standard', 'audio', 'ogg', 'encode', 'utility']
		self._executables = ['oggenc']


class pcdview (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'PhotoCDview'
		self.comment = 'PhotoCD image viewer'
		self.keywords = ['console', 'SVGAlib', 'PhotoCD', 'image', 'view']
		self._executables = ['pcdview']


class playmidi (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'PlayMIDI'
		self.comment = 'Console MIDI audio player'
		self.keywords = ['audio', 'MIDI', 'play', 'utility']
		self._executables = ['playmidi']


class radio (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Radio'
		self.comment = 'Console radio control utility'
		self.keywords = ['console', 'audio', 'radio', 'play', 'control', 'utility']
		self._executables = ['radio']


class rexima (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Rexima'
		self.comment = 'Console audio mixer'
		self.keywords = ['console', 'audio', 'mix']
		self._executables = ['rexima']


class sox (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'SoX'
		self.comment = 'Sound converter/translator'
		self.keywords = ['audio', 'convert', 'utility']
		self._executables = ['sox']


class soxmix (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sound mixer'
		self.comment = 'Sound mixer from SoX package'
		self.keywords = ['audio', 'convert', 'mix', 'utility']
		self._executables = ['soxmix']


class soxplay (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sound player'
		self.comment = 'Sound player from SoX package'
		self.keywords = ['SoX', 'audio', 'play', 'utility']
		self._executables = ['play']
	def _Scan (self):
		self.__sox = sox ()()
		if self.__sox:
			_Multiname._Scan (self)
		del self.__sox
	def _Valid (self):
		# play and sox must be in the same directory.
		if self.__sox.bindir == self.bindir:
			return 1
		else:
			return 0


class soxrec (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sound recorder'
		self.comment = 'Sound recorder from SoX package'
		self.keywords = ['SoX', 'audio', 'record', 'utility']
		self._executables = ['rec']
	def _Scan (self):
		self.__sox = sox ()()
		if self.__sox:
			_Multiname._Scan (self)
		del self.__sox
	def _Valid (self):
		# rec and sox must be in the same directory.
		if self.__sox.bindir == self.bindir:
			return 1
		else:
			return 0


class timidity (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Timidity'
		self.comment = 'MIDI to WAVE converter'
		self.keywords = ['X11', 'audio', 'MIDI', 'WAVE', 'wav', 'convert']
		self._executables = ['timidity']
		self.interactive = 0


class xanim (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xanim'
		self.comment = 'Command line-driven video player'
		self.keywords = ['X11', 'video', 'mpeg', 'avi', 'fli', 'flc'
			'play', 'utility']
		self._executables = ['xanim']
		self.interactive = 0
