name = 'Shells'


from Prophet.Executable import _Multiname
from Prophet.Executable import _Versioned


class bash (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Bash'
		self.comment = 'Advanced Born shell'
		self.keywords = ['standard', 'Linux', 'shell']
		self._executables = ['bash']


class cint (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'CINT'
		self.comment = 'C/C++ interpreter'
		self.keywords = ['C', 'C++', 'shell']
		self._executables = ['cint']


class clisp (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'CLisp'
		self.comment = 'Lisp interpreter'
		self.keywords = ['Lisp', 'execute'] # FIXME : is it interactive?
		self._executables = ['clisp']


class csh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Csh'
		self.comment = 'C shell'
		self.keywords = ['standard', 'BSD', 'shell']
		self._executables = ['csh', 'tcsh']


class esh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Esh'
		self.comment = 'Lightweight UNIX shell'
		self.keywords = ['shell']
		self._executables = ['esh']


class expect (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Expect shell'
		self.comment = 'Tcl based interactive dialogue program'
		self.keywords = ['console', 'shell', 'Tcl', 'control']
		self._basenames = ['expect']


class git (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GIT'
		self.comment = 'GNU Interactive Tools'
		self.keywords = ['console', 'shell', 'file', 'manage']
		self._executables = ['git']


class guile (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Guile'
		self.comment = 'A Scheme-like interpreter'
		self.keywords = ['console', 'Scheme', 'Lisp', 'shell']
		self._executables = ['guile']


from Prophet.Program.X.Graphics import gs


class ilrun (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'ILrun'
		self.comment = 'Portable.Net ECMA CIL executor'
		self.keywords = ['CIL', 'Portable.Net', '.NET', 'JIT', 'shell']
		self._executables = ['ilrun']


class irb (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Ruby'
		self.comment = 'Ruby interactive shell'
		self.keywords = ['console', 'Ruby', 'shell']
		self._executables = ['irb']


# TODO : return more information on the interpreter!
class java (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'JAVA'
		self.comment = 'Java interpreter'
		self.keywords = ['shell', 'JAVA']
		self._executables = ['java']


class ksh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Ksh'
		self.comment = 'Korn shell'
		self.keywords = ['Ksh', 'Pdksh', 'shell']
		self._executables = ['pdksh', 'ksh']


class lua (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Lua'
		self.comment = 'Lua shell'
		self.keywords = ['console', 'Lua', 'shell']
		self._executables = ['lua']


class mc (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Midnight Commander'
		self.comment = 'UNIX clone of Norton Commander'
		self.keywords = ['console', 'shell', 'file', 'manage', 'NC', 'clone']
		self._executables = ['midc', 'mc']


class mint (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Mint'
		self.comment = 'Mono ECMA CIL interpreter'
		self.keywords = ['CIL', 'Mono', '.NET', 'shell']
		self._executables = ['mint']


class mono (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Mono'
		self.comment = 'Mono ECMA CIL executor'
		self.keywords = ['CIL', 'Mono', '.NET', 'JIT', 'shell']
		self._executables = ['mono']


from Prophet.Program.Science import octave


class perl (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'PERL'
		self.comment = 'PERL interpreter'
		self.keywords = ['PERL', 'shell']
		self._basenames = ['perl']


class python (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Python'
		self.comment = 'Python interpreter'
		self.keywords = ['console', 'Python', 'shell']
		self._basenames = ['python']


class rep (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'REP'
		self.comment = 'REP shell'
		self.keywords = ['console', 'shell', 'Sawfish', 'Lisp', 'clone']
		self._executables = ['rep']


class ruby (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Ruby'
		self.comment = 'Ruby interpreter'
		self.keywords = ['shell']
		self._executables = ['ruby']


class sash (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sash'
		self.comment = 'Static Bourne-compatible shell'
		self.keywords = ['shell']
		self._executables = ['sash']


class scsh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Scsh'
		self.comment = 'A shell with Scheme-like syntax'
		self.keywords = ['console', 'Scheme', 'Lisp', 'shell']
		self._executables = ['scsh']


class sh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sh'
		self.comment = 'Standard POSIX shell'
		self.keywords = ['standard', 'POSIX', 'shell']
		self._executables = ['sh']


class ssh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Ssh'
		self.comment = 'Secure shell, replacement for rsh and rlogin'
		self.keywords = ['OpenSSH', 'SSH', 'sequre', 'shell']
		self._executables = ['ssh']


class tclsh (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Tclsh'
		self.comment = 'Console Tcl shell'
		self.keywords = ['console', 'Tcl', 'shell']
		self._basenames = ['tclsh']


class tclx (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'TclX'
		self.comment = 'Console extended Tcl shell'
		self.keywords = ['console', 'TclX', 'Tcl', 'shell']
		self._basenames = ['tcl']


class tcsh (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Tcsh'
		self.comment = 'Advanced C shell'
		self.keywords = ['BSD', 'shell']
		self._executables = ['tcsh']


class tinycc (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'TinyCC'
		self.comment = 'C interpreter, implemented as JIT compiler'
		self.keywords = ['C', 'shell', 'execute']
		self._executables = ['tinycc']


from Prophet.Program.X.Shell import wish


class zsh (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Zsh'
		self.comment = 'Advanced Born/Korn family compatible shell'
		self.keywords = ['shell', 'sh', 'bash', 'ksh', 'pdksh']
		self._basenames = ['zsh']


