from Prophet.Executable import _Multiname
from Prophet.Executable import _Executable
from Prophet.Executable import _isexecutable
from Prophet.Package import _Container


import Prophet.Executable


import os.path


class cforge (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'C-Forge'
		self.comment = 'Code Forge - IDE for X'
		self.keywords = ['X11', 'Motif', 'Lesstif', 'commercial', 'IDE']
		self._executables = ['cforge']


class ddd (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DDD'
		self.comment = 'Display Data Debugger - GDB frontend for X'
		self.keywords = ['X11', 'Motif', 'Lesstif', 'debug', 'gdb', 'frontend']
		self._executables = ['ddd']


class eric (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Eric'
		self.comment = 'Python IDE'
		self.keywords = ['X11', 'Python', 'Qt', 'QScintilla', 'IDE']
		self._executables = ['eric3']


class estudio (_Executable):
	def __init__ (self):
		_Executable.__init__ (self)
		self.name = 'EiffelStudio'
		self.comment = 'Eiffel Development Environment from ISE'
		self.keywords = ['X11', 'Eiffel', 'IDE', 'commercial']
		self.ui = Prophet.Executable.TUI
		# TODO : make estudio start from terminal as it is needed to show C
		# compilation phase.
	def _Scan (self):
		_Executable._Scan (self)
		try:
			eiffel   = os.environ['ISE_EIFFEL']
			platform = os.environ['ISE_PLATFORM']
		except:
			return
		self.prefix = os.path.join (eiffel, 'studio/spec', platform)
		self.bindir = os.path.join (self.prefix, 'bin')
		self.executable = 'estudio'
		try:
			if not _isexecutable (os.path.join (self.bindir, self.executable)):
				return
		except:
			return
		self._success = 1


class fluid (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Fluid'
		self.comment = 'FLTK interface builder'
		self.keywords = ['X11', 'FLTK', 'interface', 'design', 'build']
		self._executables = ['fluid']


class jbuilder (_Container):
	def __init__ (self):
		_Container.__init__ (self)
		self.name = 'JBuilder'
		self.comment = 'Java RAD environment from Borland'
		self.keywords = ['X11', 'java', 'commercial', 'IDE']
		self._basenames = ['JBuilder']
		self.interactive = 1
		self.ui = Prophet.Executable.XUI
	def _Valid (self):
		if _isexecutable (os.path.join (self.prefix, 'bin/jbuilder')):
			self.bindir = os.path.join (self.prefix, 'bin')
			self.executable = 'jbuilder'
			return 1
		else:
			return 0


class komodo (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Komodo'
		self.comment = 'Mozilla-based PERL/XSLT/Tcl/Python IDE'
		self.keywords = ['X11', 'commercial', 'PERL', 'Python', 'Tcl', 'Tk',
			'XML', 'XSLT', 'Mozilla', 'IDE']
		self._executables = ['komodo']
		# FIXME : search for prefixes like `${prefix}/Komodo-*/' as well


class kylix (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Kylix'
		self.comment = 'Borland Delphi for UNIX'
		self.keywords = ['X11', 'Borland', 'Delphi', 'commercial', 'IDE']
		self._executables = ['startdelphi', 'startkylix']
		# TODO : check for Kylix-specific prefix too.


class netbeans (_Container):
	def __init__ (self):
		_Container.__init__ (self)
		self.name = 'NetBeans'
		self.comment = 'Java RAD environment'
		self.keywords = ['X11', 'java', 'IDE']
		self._basenames = ['netbeans']
		self.interactive = 1
		self.ui = Prophet.Executable.XUI
	def _Valid (self):
		if _isexecutable (os.path.join (self.prefix, 'bin/runide.sh')):
			self.bindir = os.path.join (self.prefix, 'bin')
			self.executable = 'runide.sh'
			return 1
		else:
			return 0


class ups (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'UPS debugger'
		self.comment = 'Powerful native debugger for X'
		self.keywords = ['X11', 'debug']
		self._executables = ['ups']


class tkcvs (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'TkCVS'
		self.comment = 'CVS frontend for X'
		self.keywords = ['X11', 'CVS', 'frontend', 'version', 'control']
		self._executables = ['tkcvs']


from Prophet.Program.XFce import xfdiff


from Prophet.Program.XFce4 import xfdiff as xfdiff4


class xwpe (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xwpe'
		self.comment = 'X IDE with Borland C++ IDE\'s look\'n\'feel'
		self.keywords = ['X11', 'Xwpe', 'IDE']
		self._executables = ['xwpe']


class xxgdb (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XXGDB'
		self.comment = 'Simple GDB frontend for X'
		self.keywords = ['X11', 'debug', 'gdb', 'frontend']
		self._executables = ['xxgdb']
