name = 'Emulators'


from Prophet.Executable import _Multiname
from Prophet.Executable import TUI


class BasiliskII (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Basilisk II'
		self.comment = 'Apple Mac emulator'
		self.keywords = ['X11', '68k', 'Mac', 'Macintosh', 'architecture', 'emulate']
		self._executables = ['BasiliskII']


class bochs (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Bochs'
		self.comment = 'X86 architecture emulator'
		self.keywords = ['X11', 'console', 'x86', 'architecture', 'emulate']
		self._executables = ['bochs']
		self.ui = TUI # Despite Bochs is X11-aware program, currently it has text mode interface.


class dosemu (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DosEmu'
		self.comment = 'MS-DOS system emulator'
		self.keywords = ['X11', 'console', 'MS-DOS', 'system', 'emulate']
		self._executables = ['xdosemu', 'dosemu'] # FIXME : probably more work


# TODO : Frodo


class fuse (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Fuse'
		self.comment = 'ZX Spectrum family architecture emulator'
		self.keywords = ['X11', 'Sinclair', 'ZX', 'Spectrum', 'architecture', 'emulate']
		self._executables = ['fuse']


class generator (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Generator'
		self.comment = 'SEGA Megadrive architecture emulator'
		self.keywords = ['X11', 'SEGA', 'architecture', 'emulate']
		self._executables = ['generator'] # FIXME : not sure


class snes9x (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'SNES9x'
		self.comment = 'Super Nintendo SNES architecture emulator'
		self.keywords = ['X11', 'SNES', 'super', 'Nintendo', 'architecture', 'emulate']
		self._executables = ['snes9x']
		# FIXME : snes9x also may be compiled with other graphical backends


# TODO : VICE


class vmware (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'VMWare'
		self.comment = 'x86 virtualization software'
		self.keywords = ['commercial', 'X11', 'x86', 'Intel', 'system', 'virtualize']
		self._executables = ['vmware']


class wine (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'WINE'
		self.comment = 'Win32 emulator'
		self.keywords = ['X11', 'console', 'Win32', 'system', 'emulate']
		self._executables = ['wine']
		self.interactive = 0


class winex (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'WINE-X'
		self.comment = 'Win32 emulator with DirectX support'
		self.keywords = ['X11', 'console', 'Win32', 'DirectX', 'system', 'emulate']
		self._executables = ['winex']
		self.interactive = 0


# TODO : xmame/xmess


class xz80 (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xz80'
		self.comment = 'ZX Spectrum architecture emulator'
		self.keywords = ['X11', 'console', 'Sinclair', 'ZX', 'Spectrum', 'architecture', 'emulate']
		self._executables = ['xz80']


class xzx (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XZX'
		self.comment = 'ZX Spectrum architecture emulator'
		self.keywords = ['X11', 'console', 'Sinclair', 'ZX', 'Spectrum', 'architecture', 'emulate']
		self._executables = ['xzx']


class zsnes (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'zSNES'
		self.comment = 'Super Nintendo SNES architecture emulator'
		self.keywords = ['X11', 'SNES', 'super', 'Nintendo', 'architecture', 'emulate']
		self._executables = ['zsnes'] # FIXME : is this right?
