import os.path
from Prophet.Executable import _Executable
from Prophet.Executable import _Multiname
from Prophet.Executable import _Versioned
from Prophet.Executable import _isexecutable
import Prophet.Package


class acroread (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Acroread'
		self.comment = 'Adobe Acrobat Reader for PDF files'
		self.keywords = ['X11', '.pdf', 'PDF', 'view']
		self._name = 'acroread'
		self._basenames = [self._name]
	def _Scan (self):
		acrobat = Prophet.Package.Acrobat ()()
		if acrobat:
			e = os.path.join (acrobat.bindir, self._name)
			if _isexecutable (e):
				_Executable._Scan (self) # FIXME : WARNING!!! this is against of all OOP rules!!! Reimplement!!!
				self.prefix = acrobat.prefix
				self.bindir = acrobat.bindir
				self.executable = self._name
				self._success = 1
				return
		_Versioned._Scan (self) # As a fallback.


class chbg (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'ChBg'
		self.comment = 'Background changer'
		self.keywords = ['X11', 'screensaver', 'background', 'change', 'utility']
		self._executables = ['chbg']


# TODO : Electric Eyes


class gimp (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'The GIMP'
		self.comment = 'GNU Image Manipulation Program'
		self.keywords = ['X11', 'image', 'edit', 'PhotoShop', 'clone']
		self._basenames = ['gimp']


class gqcam (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GQcam'
		self.comment = 'Web camera control tool'
		self.keywords = ['X11', 'www', 'web', 'camera', 'view', 'control']
		self._executables = ['gqcam']


class gqview (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GQview'
		self.comment = 'Image viewer for X'
		self.keywords = ['X11', 'image', 'view']
		self._executables = ['gqview']


class gtkam (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Gtkam'
		self.comment = 'X frontend for Gphoto, a digital camera controller'
		self.keywords = ['X11', 'image', 'digital', 'photo', 'gphoto',
			'frontend']
		self._executables = ['gtkam']


class gtkfig (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GTKfig'
		self.comment = 'Vector-based drawing program, a replacement for Xfig'
		self.keywords = ['X11', 'graphics', 'draw', 'Xfig']
		self._executables = ['gtkfig']


class gs (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GhostScript'
		self.comment = 'Aladdin PostScript interpreter'
		self.keywords = ['console', 'X11', 'ps', 'PostScript', 'shell']
		self._executables = ['gs']
		self.interactive = 0


class gv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GhostView'
		self.comment = 'PostScript and PDF viewer'
		self.keywords = ['X11', 'ps', 'PostScript', 'PDF', 'view']
		self._executables = ['gv']


class mgv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'MGV'
		self.comment = 'PostScript  viewer'
		self.keywords = ['X11', 'ps', 'PostScript', 'Motif', 'view']
		self._executables = ['mgv']


class mxp (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'MXP'
		self.comment = 'Mandelbrot set fractal explorer'
		self.keywords = ['X11', 'Mandelbrot', 'fractal', 'explore', 'view']
		self._executables = ['mxp']


class opendx (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'openDX'
		self.comment = 'IBM\'s Open Data Explorer'
		self.keywords = ['X11', 'data', 'function', 'graph', 'plot', 'explore', 'view']
		self._executables = ['dx'] # FIXME : possible data clash


class qcad (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'QCAD'
		self.comment = 'Professional CAD system'
		self.keywords = ['X11', 'CAD', 'engineering', 'technics', 'draw']
		self._executables = ['qcad']


class qiv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'QIV'
		self.comment = 'Multiformat image viewer'
		self.keywords = ['X11', 'image', 'JPEG', 'GIF', 'PNG', 'PCX', 'TGA', 'view']
		self._executables = ['qiv']


class sketch (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sketch'
		self.comment = 'Simple drawing program'
		self.keywords = ['X11', 'image', 'draw']
		self._executables = ['sketch']


class xaos (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XaoS'
		self.comment = 'Fractal explorer'
		self.keywords = ['X11', 'fractal', 'explore', 'view']
		self._executables = ['xaos']


class xchm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XCHM'
		self.comment = 'CHM viewer'
		self.keywords = ['X11', '.chm', 'view']
		self._executables = ['xchm']


class xdvi (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XDVI'
		self.comment = 'TeX DVI viewer'
		self.keywords = ['standard', 'X11', 'TeX', 'LaTeX', '.dvi', 'DVI', 'view']
		self._executables = ['xdvi']


class xfig (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xfig'
		self.comment = 'Vector-based drawing program'
		self.keywords = ['X11', 'graphics', 'draw']
		self._executables = ['xfig']


class xli (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XLI'
		self.comment = 'Utility to set desktop wallpaper'
		self.keywords = ['X11', 'wallpaper', 'background', 'manage', 'draw']
		self._executables = ['xli']
		self.interactive = 0


class xmorph (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xmorph'
		self.comment = 'Image morphing program'
		self.keywords = ['X11', 'image', 'morph', 'process']
		self._executables = ['gtkmorph', 'xmorph']


class xpdf (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XPDF'
		self.comment = 'PDF viewer'
		self.keywords = ['X11', '.pdf', 'PDF', 'view']
		self._executables = ['xpdf']


class xsane (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XSane'
		self.comment = 'Scanner/Digital Camera control program'
		self.keywords = ['X11', 'image', 'digital', 'camera', 'scan', 'control']
		self._executables = ['xsane']


class xv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xv'
		self.comment = 'Image viewer for X'
		self.keywords = ['X11', 'image', 'view']
		self._executables = ['xv']


from Prophet.Program.Graphics import _xn


class xnview (_xn):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XnView'
		self.comment = 'Image viewer/converter for X'
		self.keywords = ['X11', 'image', 'picture', 'view', 'convert']
		self._executables = ['xnview']


class xwpick (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XWpick'
		self.comment = 'Screen grabber'
		self.keywords = ['X11', 'image', 'screen', 'screenshot', 'grab', 'convert']
		self._executables = ['xwpick']


class zgv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'ZGV'
		self.comment = 'Multiformat image viewer'
		self.keywords = ['X11', 'image', 'JPEG', 'GIF', 'PNG', 'PCX', 'TGA', 'view']
		self._executables = ['zgv']


