import os.path
from Prophet.Executable import _Executable
from Prophet.Executable import _Cacheable
from Prophet.Executable import _Multiname
from Prophet.Executable import _isexecutable
import Prophet.Package


class _SOApp (_Executable):
	def __init__ (self):
		_Executable.__init__ (self)
		self.keywords = ['X11', 'office', 'suite', 'environment']
	def _Scan (self):
		_Executable._Scan (self)
		p = self._package ()()
		if p:
			for e in self._executables:
				try:
					if _isexecutable (os.path.join (p.bindir, e)):
						self.prefix = p.prefix
						self.bindir = p.bindir
						self.executable = e
						self._success = 1
						return
				except:
					pass


class abiword (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'AbiWord'
		self.comment = 'AbiSuite word processor'
		self.keywords = ['X11', 'AbiSuite', 'text', 'edit', 'word', 'process']
		self._executables = ['AbiWord-2.0', 'AbiWord', 'abiword']
		# FIXME : should the Abiword2 be the separate entry?
	def _Scan (self):
		_Multiname._Scan (self)
		if not self._success:
			abi = Prophet.Package.AbiSuite ()()
			if abi:
				try:
					if _isexecutable (os.path.join (abi.bindir,'AbiWord')):
						# FIXME : ^ is generally a bad idea, replace it with
						# something more appropriate!
						self.prefix = abi.prefix
						self.bindir = abi.bindir
						self.executable = 'AbiWord'
						self._success = 1
				except:
					pass


class dia (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Dia'
		self.comment = 'Diagram drawing program'
		self.keywords = ['X11', 'diagram', 'draw']
		self._executables = ['dia'] # FIXME : possible filename clash


class gnucash (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GnuCash'
		self.comment = 'Personal finance manager'
		self.keywords = ['X11', 'finance', 'manage'] # FIXME : be more descriptive
		self._executables = ['gnucash']


# TODO : HylaFAX package


class lyx (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'LyX'
		self.comment = 'TeX based document publishing system'
		self.keywords = ['X11', 'TeX', 'edit', 'publish', 'WYSIWYM']
		self._executables = ['lyx']


class scribus (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Scribus'
		self.comment = 'Document publishing system'
		self.keywords = ['X11', 'document', 'edit', 'publish']
		self._executables = ['scribus']


class soffice (_SOApp):
	def __init__ (self):
		_SOApp.__init__ (self)
		self.name = 'StarOffice'
		self.comment = 'Complete office suite from Sun Microsystems'
		self.keywords += ['commercial', 'shell', 'workplace', 'suite']
		self._package = Prophet.Package.StarOffice
		self._executables = ['soffice']
