name = 'System utils'


from Prophet.Executable import _Multiname


class drakconf (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DrakConf'
		self.comment = 'Mandrake control center'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'configure', 'control', 'center']
		self._executables = ['DrakConf', 'drakconf']


class drakcronat (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DrakCronAT'
		self.comment = 'Mandrake program scheduler'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'cron', 'at', 'frontend']
		self._executables = ['drakcronat']


class drakfloppy (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DrakFloppy'
		self.comment = 'Mandrake floppy formatter'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'system', 'floppy', 'utility']
		self._executables = ['drakfloppy']


class drakfw (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DrakFirstTime'
		self.comment = 'Mandrake user configuration wizard'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'configure', 'wizard']
		self._executables = ['drakfw']


class drakopt (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DrakOptimize'
		self.comment = 'Mandrake IDE drive problem detector/optimizer'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'file', 'utility']
		self._executables = ['drakopt']


class draksync (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'DrakSync'
		self.comment = 'Mandrake file syncronize utility'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'file', 'utility']
		self._executables = ['draksync']


class gdrivetweak (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GDriveTweaker'
		self.comment = 'X version of DriveTweaker'
		self.keywords = ['X11', 'system', 'utility']
		self._executables = ['drivetweak-gtk']


class gfcc (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GFCC'
		self.comment = 'GNU firewall control utility'
		self.keywords = ['X11', 'firewall', 'control', 'utility']
		self._executables = ['gfcc']


class gkrellm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GKrellM'
		self.comment = 'System monitor'
		self.keywords = ['X11', 'system', 'monitor', 'utility']
		self._executables = ['gkrellm']


class gps (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'gPS'
		self.comment = 'Process monitor'
		self.keywords = ['X11', 'process', 'monitor', 'utility']
		self._executables = ['gps'] # FIXME : possible name clash


class grpmi (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GRPMI'
		self.comment = 'RPM manager'
		self.keywords = ['X11', 'RPM', 'package', 'manage', 'utility']
		self._executables = ['grpmi']


class gurpmi (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'GURPMI'
		self.comment = 'RPM manager for ordinary user'
		self.keywords = ['X11', 'RPM', 'package', 'manage', 'utility']
		self._executables = ['gurpmi']


class harddrake (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'HardDrake'
		self.comment = 'Mandrake hardware configuration utility'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'hardware', 'control', 'utility']
		self._executables = ['harddrake']


class menudrake (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'MenuDrake'
		self.comment = 'Mandrake menu maintaining utility'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'menu', 'control', 'utility']
		self._executables = ['menudrake']


class rpmdrake (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'RPMDrake'
		self.comment = 'Mandrake RPM manager'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'RPM', 'package', 'manage', 'utility']
		self._executables = ['rpmdrake']


class tksysv (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'TkSYSV'
		self.comment = 'System V style runlevel configurator'
		self.keywords = ['X11', 'system', 'utility']
		self._executables = ['tkcvs']


class usbview (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'USBview'
		self.comment = 'USB monitor'
		self.keywords = ['X11', 'system', 'USB', 'view', 'utility']
		self._executables = ['usbview']


class userdrake (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'UserDrake'
		self.comment = 'Mandrake user manager'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'system', 'manage', 'utility']
		self._executables = ['userdrake']


# TODO : webmin FIXME : mark this (as well as SWAT) as web browser software


class wizdrake (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'WizDrake'
		self.comment = 'Mandrake wizard collection'
		self.keywords = ['X11', 'Linux', 'Mandrake', 'system', 'manage', 'wizard', 'utility']
		self._executables = ['drakwizard', 'wizdrake'] # CHECKME : are	drakwizard and wizdrake the same?


class xapm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XAPM'
		self.comment = 'A frontend to APM control utility'
		self.keywords = ['X11', 'system', 'power', 'manage', 'control', 'utility']
		self._executables = ['xapm']


class xcpustate (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'XCPUstate'
		self.comment = 'CPU state monitor'
		self.keywords = ['X11', 'system', 'CPU', 'monitor', 'utility']
		self._executables = ['xcpustate']


from Prophet.Program.XFce import xflock


from Prophet.Program.XFce import xfsamba


class xsysinfo (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xsysinfo'
		self.comment = 'System monitor'
		self.keywords = ['X11', 'system', 'monitor', 'utility']
		self._executables = ['xsysinfo']


