name = 'Terminals'


from Prophet.Executable import _Multiname
from Prophet.Executable import _Versioned
from Prophet.Support import _Extras


class aterm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Aterm'
		self.comment = 'A X terminal emulator'
		self.keywords = ['X11', 'terminal', 'emulate']
		self._executables = ['aterm']


from Prophet.Program.Utility import c3270


class Eterm (_Multiname, _Extras):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Eterm'
		self.comment = 'Enlightenment X terminal emulator'
		self.keywords = ['Enlightenment', 'X11', 'terminal', 'emulate']
		self._executables = ['Eterm']
	def _Scan (self):
		_Multiname._Scan (self)
		if self._success:
			self._WallpaperDirs (['share/Eterm/pix'])


from Prophet.Program.GNOME.System import gterminal


from Prophet.Program.KDE.System import konsole


class kterm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Japanese Xterm'
		self.comment = 'Kanji X terminal emulator'
		self.keywords = ['Kanji', 'X11', 'Japan', 'terminal', 'emulate']
		self._executables = ['kterm']


class rdesktop (_Multiname): # FIXME : add it into some other categories?
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Rdesktop'
		self.comment = 'M$ Windows NT/2000/XP/+ terminal client'
		self.keywords = ['X11', 'Windows', 'terminal', 'emulate', 'client']
		self._executables = ['rdesktop']


class wterm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Wterm'
		self.comment = 'X terminal emulator for Window Maker'
		self.keywords = ['WindowMaker', 'X11', 'terminal', 'emulate']
		self._executables = ['wterm']


class x3270 (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'x3270'
		self.comment = 'IBM 3278/3279 terminal emulator'
		self.keywords = ['X11', 'IBM', 'terminal', 'emulate']
		self._executables = ['x3270']


class xvt (_Versioned):
	def __init__ (self):
		_Versioned.__init__ (self)
		self.name = 'Xvt'
		self.comment = 'Light X terminal emulator'
		self.keywords = ['X11', 'terminal', 'emulate']
		self._basenames = ['rxvt', 'xvt']


from Prophet.Program.XFce import xfterm


from Prophet.Program.XFce4 import xfterm as xfterm4


class xterm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Xterm'
		self.comment = 'Standard X terminal emulator'
		self.keywords = ['standard', 'X11', 'terminal', 'emulate']
		self._executables = ['xterm']
