name = 'X window managers'


from Prophet.Executable import _Multiname as _Multiname_
from Prophet.Support import _Extras


# Base class for all window managers which are non-interactive by definition.
# TODO : make this parent for any WM !
class _Multiname (_Multiname_):
	def __init__ (self):
		_Multiname_.__init__ (self)
		self.interactive = 0


class afterstep (_Multiname, _Extras):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'AfterStep'
		self.comment = '*Step-like X window manager'
		self.keywords = ['X11', 'NeXTStep', 'OpenStep', 'GNUstep', 'window', 'manage']
		self._executables = ['afterstep']
	def _Scan (self):
		_Multiname._Scan (self)
		if self._success:
			self._WallpaperDirs (['share/afterstep/backgrounds'])


class blackbox (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'BlackBox'
		self.comment = 'Light X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['blackbox']
		# FIXME : does it have backgrounds elsewhere as FluxBox has?


class enlightenment (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Enlightenment'
		self.comment = 'Eye-candy X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['enlightenment']


class fluxbox (_Multiname,_Extras):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'FluxBox'
		self.comment = 'Light X window manager, based on BlackBox'
		self.keywords = ['X11', 'BB', 'BlackBox', 'window', 'manage']
		self._executables = ['fluxbox']
	def _Scan (self):
		_Multiname._Scan (self)
		if self._success:
			self._WallpaperDirs (['~/.fluxbox/backgrounds'])


class flwm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'FLWM'
		self.comment = 'Fast Light X window manager based on FLTK toolkit'
		self.keywords = ['X11', 'window', 'manage', 'FLTK']
		self._executables = ['flwm']


class fvwm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'FVWM'
		self.comment = 'X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['fvwm2', 'fvwm']


class golem (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Golem'
		self.comment = 'X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['golem']


class icewm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'IceWM'
		self.comment = 'Light X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['icewm', 'icewm-gnome']


class kahakai (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Kahakai'
		self.comment = 'Scriptable X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['kahakai']


class metacity (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'MetaCity'
		self.comment = 'X window manager for GNOME'
		self.keywords = ['X11', 'window', 'manage', 'GNOME']
		self._executables = ['metacity']


class mwm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'MWM'
		self.comment = 'Motif/X window manager'
		self.keywords = ['standard', 'Motif', 'Lesstif', 'X11', 'window', 'manage']
		self._executables = ['mwm']


class openbox (_Multiname,_Extras):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'OpenBox'
		self.comment = 'Light X window manager, based on BlackBox'
		self.keywords = ['X11', 'BB', 'BlackBox', 'window', 'manage']
		self._executables = ['openbox']
	def _Scan (self):
		_Multiname._Scan (self)
		if self._success:
			self._WallpaperDirs (['~/.openbox/backgrounds']) # FIXME : is this true?


class oroborus (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Oroborus'
		self.comment = 'X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['oroborus']


class pekwm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'P.K.WM'
		self.comment = 'X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['pekwm']


class sawfish (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Sawfish'
		self.comment = 'Extensible X window manager'
		self.keywords = ['X11', 'GNOME', 'window', 'manage']
		self._executables = ['sawfish']


class twm (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'TWM'
		self.comment = 'Standard X window manager'
		self.keywords = ['standard', 'X11', 'window', 'manage']
		self._executables = ['twm']


class waimea (_Multiname):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Waimea'
		self.comment = 'Scriptable X window manager'
		self.keywords = ['X11', 'window', 'manage']
		self._executables = ['waimea']


class wmaker (_Multiname, _Extras):
	def __init__ (self):
		_Multiname.__init__ (self)
		self.name = 'Window Maker'
		self.comment = '*Step-like X window manager'
		self.keywords = ['X11', 'NeXTStep', 'OpenStep', 'GNUstep', 'window', 'manage']
		self._executables = ['wmaker']
	def _Scan (self):
		_Multiname._Scan (self)
		if self._success:
			self._WallpaperDirs (['share/WindowMaker/Backgrounds',
				'~/GNUstep/Library/WindowMaker/Backgrounds'])


from Prophet.Program.XFce import xfwm


from Prophet.Program.XFce4 import xfwm as xfwm4
